<?php
/* 	OpenDb - Open Media Lending Database
	Copyright (C) 2001,2002 by Jason Pell

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

// This must be first - includes config.php
require_once("./include/begin.inc.php");

include_once("./functions/database.php");
include_once("./functions/auth.php");
include_once("./functions/logging.php");

include_once("./functions/http.php");
include_once("./functions/user.php");
include_once("./functions/email.php");
include_once("./functions/language.php");
include_once("./functions/item.php");
include_once("./functions/review.php");
include_once("./functions/theme.php");
include_once("./functions/status_type.php");
include_once("./functions/borrowed_item.php");
include_once("./functions/last_items_list.php");

function login_last_items_list($update_on, $user_id)
{
	global $HTTP_SESSION_VARS;
	global $CONFIG_VARS;
	global $LANG_VARS;
	
	if($CONFIG_VARS['login.last_items_list.exclude_current_user']===FALSE)
		$user_id = NULL;
		
	if($CONFIG_VARS['login.last_items_list.restrict_last_login']===FALSE)
		$update_on = NULL;
				
	// You have to change the $owner_id, $s_item_type and number of items parameters.
	$list_item_rs = get_last_num_items_rs(
				$CONFIG_VARS['last_items_list.total_num_items'],// number of items to return
				NULL, //owner_id 
				NULL, // s_item_type
				$update_on, //update_on
				$user_id); // not_owner_id

	if(is_not_empty_array($list_item_rs))
	{
		$tableBlock = get_last_num_items_block(
						$list_item_rs, 
						NULL, // guest user account userid to access item_display
						NULL, // guest user account passwd to access item_display
						TRUE, //$use_opendb_table_classes
						FALSE,//$item_display_popup
						$CONFIG_VARS['last_items_list.items_per_column'], //$columns
						NULL); //$site_url_prefix
						
		return $tableBlock;
	}
	else
	{
		return NULL;
	}
}

function login_whats_new($update_on, $user_id=NULL)
{
	global $LANG_VARS;
	global $CONFIG_VARS;
	global $HTTP_SESSION_VARS;
	
	// Get the list of valid status_types, which we can display in this whatsnew page.
	$results = fetch_whatsnew_status_type_rs();
    if($results)
	{
		$search_vars_r['update_on'] = $update_on;
				
		if($CONFIG_VARS['whatsnew.exclude_current_user']!==FALSE)
			$search_vars_r['not_owner_id'] = $user_id;

		$header[] = $LANG_VARS['status_stats'];
		$block = '';
        while ($status_type_r = mysql_fetch_array($results, MYSQL_ASSOC))
		{
			$search_vars_r['s_status_type'] = $status_type_r['s_status_type'];
				
			$status_items_updated = fetch_item_listing_cnt($search_vars_r);
			$status_title = replace_lang_vars(array('count'=>$status_items_updated,'s_status_type_desc'=>$status_type_r['description']), $LANG_VARS['cnt_item(s)_added_updated']);
			if($status_items_updated>0)// No sense providing a link if nothing updated...
			{
				$block .= _theme_image('tick.gif', '', NULL, 'absmiddle')
							.'&nbsp;&nbsp;'
							.'<a class="whatsnew" href="listings.php?'.(strlen($user_id)>0?'not_owner_id='.$user_id.'&s_status_type='.$status_type_r['s_status_type']:'').'&update_on='.urlencode($update_on).'">'
							.$status_title
							.'</a><br>';
			}
			else
			{
				$block .= _theme_image('cross.gif', '', NULL, 'absmiddle')
						.'&nbsp;&nbsp;'
						.$status_title
						.'<br>';
			}
		}
        mysql_free_result($results);
		
		$row[] = $block;
    }
	
	if($CONFIG_VARS['borrow.enable']!==FALSE && $CONFIG_VARS['whatsnew.borrow_stats']!==FALSE)
	{
		$header[] = $LANG_VARS['borrow_stats'];
		$block = '';
		
		$returned_cnt = fetch_borrowed_item_status_atdate_cnt('C', $update_on);
		if($returned_cnt > 0)
			$block .= _theme_image('tick.gif', '', NULL, 'absmiddle').'&nbsp;&nbsp;';
		else
			$block .= _theme_image('cross.gif', '', NULL, 'absmiddle').'&nbsp;&nbsp;';
		$block .= replace_lang_var("count", $returned_cnt, $LANG_VARS['cnt_item(s)_returned']).'<br>';
		
		$borrowed_cnt = fetch_borrowed_item_status_atdate_cnt('B', $update_on);
		if($returned_cnt > 0)
			$block .= _theme_image('tick.gif', '', NULL, 'absmiddle').'&nbsp;&nbsp;';
		else
			$block .= _theme_image('cross.gif', '', NULL, 'absmiddle').'&nbsp;&nbsp;';
		$block .= replace_lang_var("count", $borrowed_cnt, $LANG_VARS['cnt_item(s)_borrowed']).'<br>';
		
		$reserved_cnt = fetch_borrowed_item_status_atdate_cnt('R', $update_on);
		if($returned_cnt > 0)
			$block .= _theme_image('tick.gif', '', NULL, 'absmiddle').'&nbsp;&nbsp;';
		else
			$block .= _theme_image('cross.gif', '', NULL, 'absmiddle').'&nbsp;&nbsp;';
		$block .= replace_lang_var("count", $reserved_cnt, $LANG_VARS['cnt_item(s)_reserved']).'<br>';
		
		$row[] = $block;
	}
	
	if($CONFIG_VARS['whatsnew.review_stats']!==FALSE)
	{
		$header[] = $LANG_VARS['review(s)'];
		$block = '';
		
		$review_cnt = fetch_review_atdate_cnt($update_on);
		if($review_cnt > 0)
			$block .= _theme_image('tick.gif', '', NULL, 'absmiddle').'&nbsp;&nbsp;';
		else
			$block .= _theme_image('cross.gif', '', NULL, 'absmiddle').'&nbsp;&nbsp;';
		$block .= replace_lang_var("count", $review_cnt, $LANG_VARS['cnt_review(s)']).'<br>';
		
		$row[] = $block;
	}

	if(is_not_empty_array($header))
	{
		//$page.= _theme_image("whatsnew.gif", "", NULL, "absmiddle");
		$tableBlock = '<table width=100%>';
		for($i=0; $i<count($header); $i++)
		{
			$tableBlock .= '<th class="prompt">'.$header[$i].'</th>';
		}
		$tableBlock .= '</tr><tr>';
		for($i=0; $i<count($row); $i++)
		{
			$tableBlock .= '<td class="data" valign=top>'.$row[$i].'</td>';
		}
		
		$tableBlock .= '</tr></table>';
		
		return $tableBlock;
	}
	else
	{
		return NULL;
	}
}

if($CONFIG_VARS['site.enable']!==FALSE)
{
	session_start();

	// Backwards compatibility!
	if(strlen($HTTP_VARS['from'])>0)
	{
		$HTTP_VARS['redirect'] = $HTTP_VARS['from'];
	}

	// We do not want the login page to display as long as the user is valid!
	if(is_opendb_valid_session() && 
		(($HTTP_VARS['op'] != 'newpassword' && $HTTP_VARS['op'] != 'login' && $HTTP_VARS['op'] != 'change-user') ||
			( ($HTTP_VARS['op'] == 'login' || $HTTP_VARS['op'] == 'newpassword') && 
			$CONFIG_VARS['site.public_access.enable']===TRUE && 
			$CONFIG_VARS['site.public_access.allow_login']!==TRUE)))
	{
		if(strlen($HTTP_VARS['redirect'])>0)
		{
			// Redirect to requested page, as already logged in.
			header('Location: ' . urldecode($HTTP_VARS['redirect']));
		}
		else
		{
			include_once("./include/language.php");
			include_once("./include/theme.php");
		
			echo(_theme_header(replace_lang_var("site", $CONFIG_VARS['site.title'], $LANG_VARS['site_login'])));
			
			echo('<p>'
				.replace_lang_vars(array('site'=>$CONFIG_VARS['site.title'], 'version'=>$CONFIG_VARS['site.version']),
											ifempty($LANG_VARS['logged_in_welcome'], $LANG_VARS['login_welcome']))
				.'</p>');
			
			echo(_theme_footer());
		}
	}
	else if(is_opendb_valid_session() && $HTTP_VARS['op'] == 'change-user')
	{
		if($CONFIG_VARS['login.enable_change_user']!==FALSE)
		{
			if(is_user_admin($HTTP_SESSION_VARS['user_id'], $HTTP_SESSION_VARS['user_type']))
			{
				if(strlen($HTTP_VARS['uid'])>0 && 
						is_user_active($HTTP_VARS['uid']) && 
						is_user_changeuser($HTTP_VARS['uid']))
				{
					// save existing user_id so we can restore it.
					$HTTP_SESSION_VARS['admin_user_id'] = $HTTP_SESSION_VARS['user_id'];
					
					$user_r = fetch_user_r($HTTP_VARS['uid']);
					$HTTP_SESSION_VARS['user_id'] = $HTTP_VARS['uid'];
					$HTTP_SESSION_VARS['user_theme'] = $user_r['theme'];
					$HTTP_SESSION_VARS['user_language'] = $user_r['language'];
					$HTTP_SESSION_VARS['user_type'] = $user_r['type'];
	
					if(is_register_globals_enabled())
					{
						session_register("admin_user_id");
						session_register("user_id");
						session_register("user_theme");
						session_register("user_language");
						session_register("user_type");
					
						$admin_user_id = $HTTP_SESSION_VARS['admin_user_id'];
						$user_id = $HTTP_SESSION_VARS['user_id'];
						$user_theme = $HTTP_SESSION_VARS['user_theme'];
						$user_language = $HTTP_SESSION_VARS['user_language'];
						$user_type = $HTTP_SESSION_VARS['user_type'];
					}
					
					opendb_log("Administrator changed user (admin_user_id=".$HTTP_SESSION_VARS['admin_user_id'].", user_id=".$HTTP_SESSION_VARS['user_id'].")");
					
					include_once("./include/language.php");
					include_once("./include/theme.php");
					
					echo _theme_header($LANG_VARS['change_user']);
					echo("<h2>".$LANG_VARS['change_user_successful']."</h2>");
					echo(_theme_footer());
				}
				else
				{
					include_once("./include/language.php");
					include_once("./include/theme.php");
					
					// display owner_id input field.
					echo _theme_header($LANG_VARS['change_user']);
					echo("<h2>".$LANG_VARS['change_user']."</h2>");
		
					echo("\n<table cellspacing=1 border=0>");
					echo("\n<form action=\"login.php\" method=\"get\">");
					echo("\n<input type=\"hidden\" name=\"op\" value=\"change-user\">");
							
					$results = fetch_user_rs(get_changeuser_user_types_r(), "fullname", "ASC", FALSE, $HTTP_SESSION_VARS['user_id']);
					if($results)
					{
						echo(
							format_field($LANG_VARS['userid'], 
										NULL, 
										custom_select('uid', $results, '%fullname% (%user_id%)', 1, NULL, 'user_id')
									)
							);
					}
					else
					{
						echo(
							format_field(
									$LANG_VARS['userid'],
									NULL,
									$LANG_VARS['no_records_found'])
						);
					}
					
					echo("<tr><td colspan=2 align=left><input type=submit value=\"".$LANG_VARS['submit']."\"></td></tr>");
					echo("</form>");
					echo("</table>");
					echo(_theme_footer());
				}
			}
			else //not an administrator or own user.
			{
				include_once("./include/language.php");
				include_once("./include/theme.php");
					
				echo _theme_header($LANG_VARS['change_user']);
				echo _theme_error($LANG_VARS['not_authorized_to_page']);
				echo(_theme_footer());
			}
		}//if($CONFIG_VARS['login.enable_change_user']!==FALSE)
		else
		{
			include_once("./include/language.php");
			include_once("./include/theme.php");
					
			echo(_theme_header($LANG_VARS['change_user']));
			echo(_theme_error($LANG_VARS['operation_not_available']));
			echo(_theme_footer());
		}
	}
	else // session invalid OR $HTTP_VARS['op'] == 'login' / 'newpassword' / 'change-user'
	{
		// Specifies that we should show the login section.
		$show_form = TRUE;
		$show_welcome = TRUE;
		$refresh_menu = FALSE;
		$show_signup_link = FALSE;
		
		$error_header = NULL;
		$error_detail = NULL;
		$message_header = NULL;
		$message_detail = NULL;
		
		// if a user is logged in, the previous lastvisit will be recorded before updating for current login.
		$login_lastvisit = NULL;

		// User has requested a new password and email
		if($HTTP_VARS['op'] == 'newpassword' && strlen($HTTP_VARS['uid'])>0 && $CONFIG_VARS['login.enable_new_pwd_gen']!==FALSE)
		{
			include_once("./include/language.php");
		
			opendb_log("User requested to be emailed a new password. (user_id=".$HTTP_VARS['uid'].")");
		
			// Do not allow new password operation for 'deactivated' user.
			if(is_user_valid($HTTP_VARS['uid']) && !is_user_active($HTTP_VARS['uid']))
			{
				// Make deactivated username look valid!
				$email_result = TRUE;
				$pass_result = TRUE;

				opendb_log("New password request failure: User is not active. (user_id=".$HTTP_VARS['uid'].")");
			}
			else if(is_user_guest($HTTP_VARS['uid']))
			{
				$email_result = TRUE;
				$pass_result = TRUE;

				opendb_log("New password request failure: User is a guest. (user_id=".$HTTP_VARS['uid'].")");
			}
			else
			{
				// lookup email for this username
				$user_name  = fetch_user_name($HTTP_VARS['uid']);
				$user_email = fetch_user_email($HTTP_VARS['uid']);
				$user_passwd  = generate_password(8);

				// Only check email if the user actually exists.
				if($user_name===FALSE)
				{
					// Make bad usernames look right!
					$email_result = TRUE;
					$pass_result = TRUE;

					opendb_log("New password request failure: User does not exist. (user_id=".$HTTP_VARS['uid'].")");
				}
				else
				{
					// only send if valid user (email)
					if(strlen($user_email)>0)
					{
						$pass_result = update_user_passwd($HTTP_VARS['uid'], $user_passwd);
						if($pass_result===TRUE)
						{
							$from       = $CONFIG_VARS['site.admin_email'];
							$from_name  = $CONFIG_VARS['site.title'];
							$subject    = $LANG_VARS['lost_password'];
							$message    = replace_lang_var("fullname", $user_name, expand_langvar_newlines($LANG_VARS['to_user_email_intro'])).
										"\n\n".
										expand_langvar_newlines($LANG_VARS['new_passwd_email']).
										  "\n\n".
						        	      $LANG_VARS['userid'].": ".$HTTP_VARS['uid']."\n".
					    	        	  $LANG_VARS['password'].": ".$user_passwd;

							$email_result = opendb_email(
												$user_email, 
												$user_name, 
												$from, 
												$from_name, 
												$subject, 
												$message);
						}
					}
					else
					{
						$email_result[] = "User '".$HTTP_VARS['uid']."' does not have a valid email address.";
					}
				}
			}
		
			if($pass_result===TRUE && $email_result===TRUE)
			{
				$message_detail = $LANG_VARS['new_passwd_sent'];
			}
			else //if($pass_result!==TRUE || $email_result!==TRUE)
			{
				if($email_result!==TRUE)
				{
					$error_header = $LANG_VARS['error_sending_email'];

					// Process all errors in variable.
					while(list(,$result) = @each($email_result))
					{
						$errors .= $result;
					}
					opendb_log("New password request failure: ".$errors);
				}
				else// $pass_result!==TRUE
				{
					$error_header = $LANG_VARS['error_updating_pwd'];				
				}

				$url = "email.php?op=send_to_site_admin&subject=".urlencode($LANG_VARS['lost_pwd_request_problem'])."&redirect_link=".urlencode($LANG_VARS['return_to_login_page'])."&redirect_url=login.php";
				$error_detail = replace_lang_vars(array('url'=>$url,'site'=>$CONFIG_VARS['site.title']), $LANG_VARS['if_problem_persists_contact_your_administrator']);
			}
		}
		else if($HTTP_VARS['op'] == 'login' && strlen($HTTP_VARS['uid'])>0 && strlen($HTTP_VARS['passwd'])>0)
		{
			$HTTP_VARS['uid'] = strtolower($HTTP_VARS['uid']);// make lowercase
			if(is_user_active($HTTP_VARS['uid']) && validate_user_passwd($HTTP_VARS['uid'], $HTTP_VARS['passwd']))
			{
				// Explicitly set to null here so things like themes can be set back to default!
				$HTTP_SESSION_VARS['user_id'] = NULL;
				$HTTP_SESSION_VARS['user_theme'] = NULL;
				$HTTP_SESSION_VARS['user_language'] = NULL;
				$HTTP_SESSION_VARS['user_type'] = NULL;
				$HTTP_SESSION_VARS['hash_check'] = NULL;
				$HTTP_SESSION_VARS['login_time'] = NULL;
				$HTTP_SESSION_VARS['last_access_time'] = NULL;
			
				$HTTP_SESSION_VARS['login_time'] = time();
				$HTTP_SESSION_VARS['last_access_time'] = $HTTP_SESSION_VARS['login_time'];
			
				$user_r = fetch_user_r($HTTP_VARS['uid']);
				$HTTP_SESSION_VARS['user_id'] = $HTTP_VARS['uid'];
				$HTTP_SESSION_VARS['user_theme'] = $user_r['theme'];
				$HTTP_SESSION_VARS['user_language'] = $user_r['language'];
				$HTTP_SESSION_VARS['user_type'] = $user_r['type'];

				// Now register security hash, so we can compare.
				$HTTP_SESSION_VARS['hash_check'] = $CONFIG_VARS['site.security_hash'];
			
				if(is_register_globals_enabled())
				{
					session_register("login_time");
					session_register("last_access_time");
					session_register("user_id");
					session_register("user_theme");
					session_register("user_language");
					session_register("user_type");
					session_register("hash_check");
				
					$hash_check = $HTTP_SESSION_VARS['hash_check'];
					$login_time = $HTTP_SESSION_VARS['login_time'];
					$last_access_time = $HTTP_SESSION_VARS['login_time'];
					$user_id = $HTTP_SESSION_VARS['user_id'];
					$user_theme = $HTTP_SESSION_VARS['user_theme'];
					$user_language = $HTTP_SESSION_VARS['user_language'];
					$user_type = $HTTP_SESSION_VARS['user_type'];
				}

				opendb_log("User logged in (user_id=".$HTTP_VARS['uid'].")"); // log "user login"

				// Get the previous last visit so we can use in whats new page.
				$login_lastvisit = fetch_user_lastvisit($HTTP_VARS['uid']);
				
				// Not much we can do if it does not update.
				update_user_lastvisit($HTTP_VARS['uid']);
			
				// Note: We will enable this again once we work out what has been happening
				// for some users, where the login page redirects back to root!!!
				if(strlen($HTTP_VARS['redirect'])>0)
				{
					// User tried to get in with an invalid session.
					// We've just given her a valid one, so log it
					// appropriately and send a redirect to where she
					// really wanted to go.
					header('Location: ' . urldecode($HTTP_VARS['redirect']));
				}
				else
				{
					include_once("./include/language.php");
				
					$show_form = FALSE;
					
					$message_header = $LANG_VARS['login_successful'];

					// In some cases this will cause menu frame to be refreshed.
					$refresh_menu = TRUE;
			
					// If no logged_in_welcome variable defined, the login_welcome
					// will automatically be used anyway.
					$lang_login_welcome = $LANG_VARS['logged_in_welcome'];
				}
			}//if(is_user_active($HTTP_VARS['uid']) && validate_user_passwd($HTTP_VARS['uid'], $HTTP_VARS['passwd']))
			else
			{
				include_once("./include/language.php");
			
				// If uid specified, then user has attempted to login.
				$error_header = $LANG_VARS['login_failure'];
				$error_detail = $LANG_VARS['double_check_info'];
					
				opendb_log("User tried to log in [login failure] (user_id=".$HTTP_VARS['uid'].")");
			}
		}//if($HTTP_VARS['op'] == 'login' && strlen($HTTP_VARS['uid'])>0 && strlen($HTTP_VARS['passwd'])>0)
		else if(is_user_valid($HTTP_SESSION_VARS['user_id'])) // no current session
		{
			//
			// We have an invalid session, so lets destroy it!
			//
			if(is_register_globals_enabled())
			{
				session_unregister("user_id");
				session_unregister("user_theme");
				session_unregister("user_language");
				session_unregister("user_type");
				session_unregister("hash_check");
				session_unregister("login_time");
				session_unregister("last_access_time");
			}
		
			// Explicitly set to null here so things like themes can be set back to default!
			$HTTP_SESSION_VARS['user_id'] = NULL;
			$HTTP_SESSION_VARS['user_theme'] = NULL;
			$HTTP_SESSION_VARS['user_language'] = NULL;
			$HTTP_SESSION_VARS['user_type'] = NULL;
			$HTTP_SESSION_VARS['hash_check'] = NULL;
			$HTTP_SESSION_VARS['login_time'] = NULL;
			$HTTP_SESSION_VARS['last_access_time'] = NULL;
	
			// close session - required for PHP_SESSION handler, which otherwise
			// leaves records in the session table.
			session_destroy();
				
			// In some cases this will cause menu frame to be refreshed.
			$refresh_menu = TRUE;
			
			if($CONFIG_VARS['site.public_access.enable']!==TRUE)
			{
				include_once("./include/language.php");
					
				$error_header = $LANG_VARS['session_invalid'];
				$error_detail = $LANG_VARS['session_has_expired'];
			}
		}
		
		// Now include theme stuff here, so we can force the theme to change for new user.
		include_once("./include/theme.php");
		include_once("./include/language.php");
		
		echo(_theme_header(
			replace_lang_var("site", $CONFIG_VARS['site.title'], $LANG_VARS['site_login']),
			!$show_form || $CONFIG_VARS['login.show_menu']!==FALSE));
		
		if($show_welcome)
		{
			echo("<p>".replace_lang_vars(array('site'=>$CONFIG_VARS['site.title'],
									'version'=>$CONFIG_VARS['site.version']),
									ifempty($lang_login_welcome, $LANG_VARS['login_welcome'])).
				"</p>");
		}
		
		if(strlen($error_header)>0 || strlen($error_detail)>0)
		{
			if(strlen($error_header)>0)
				echo("<h2>".$error_header."</h2>");
			if(strlen($error_detail)>0)
				echo("<div class=\"error\">".$error_detail."</div>");
		}
		else if(strlen($message_header)>0 || strlen($message_detail)>0)
		{
			if(strlen($message_header)>0)
				echo("<h2>".$message_header."</h2>");
			if(strlen($message_detail)>0)
				echo("<div class=\"success\">".$message_detail."</div>");
		}
		
		// Should we display login page?
		if($show_form)
		{
			echo("<br>".
				"\n<form action=\"login.php\" method=\"post\">".
				"\n<input type=hidden name=\"op\" value=\"login\">".
				"\n<table border=0>".
				"\n<tr>".
				"\n<td align=right class=\"prompt\">".$LANG_VARS['userid'].":&nbsp;</td>".
				"\n<td class=\"data\"><input type=\"text\" name=\"uid\" value=\"".$HTTP_VARS['uid']."\"></td>".
				"\n</tr>".
				"\n<tr>".
				"\n<td align=right class=\"prompt\">".$LANG_VARS['password'].":&nbsp;</td>".
				"\n<td class=\"data\"><input type=\"password\" name=\"passwd\"></td>".
				"\n</tr>".
				"\n<tr>".
				"\n<td colspan=2 align=right><input type=\"submit\" value=\"".replace_lang_var("site", $CONFIG_VARS['site.title'], $LANG_VARS['site_login'])."\"></td>".
				"\n</tr>");
	
			// The user tried to go straight to a menu item with an invalid session.  
			// Set a "from" variable here so that after we give them a full session
			// we can redirect them back to the page they really wanted.
			if(strlen($HTTP_VARS['redirect'])==0)
			{
				// Do not include a $redirect link if we are starting at login.php
				if(substr($PHP_SELF, -9) != "login.php") // 9="login.php"
				{
					$url = get_url_string($HTTP_VARS, NULL, array('invalidsession')); // don't include invalidsession variable!
					$redirect = urlencode($PHP_SELF . (strlen($url)>0?"?$url":""));
				}
			}
			else // otherwise repass $from variable in case of incorrect login attempt...
			{
				$redirect = $HTTP_VARS['redirect'];
			}
			
			if(strlen($redirect)>0)
			{
				echo("<input type=\"hidden\" name=\"redirect\" value=\"".$redirect."\">");
			}
		
			// if configuration permits PHP email, allow email new password
			if($CONFIG_VARS['email.use_php_mail']!==FALSE && strlen($HTTP_VARS['uid'])>0 && $CONFIG_VARS['login.enable_new_pwd_gen']!==FALSE)
			{
				echo("<tr><td colspan=2 align=right class=\"footer\">".
					"<a href=\"".$PHP_SELF."?op=newpassword&uid=".urlencode($HTTP_VARS['uid'])."\">".$LANG_VARS['forgot_your_pwd']."</a>".
					"</td></tr>");
			}
		
		   echo("\n</table>".
				"\n</form>".
				"\n<br><p>");
		
			// Indicate we should show the signup link.
			if($CONFIG_VARS['newuser.signup_enable']!==FALSE)
			{
				echo("<div class=\"footer\"><a href=\"user_admin.php?op=signup\">"._theme_image("email.gif","",NULL,"absmiddle")."</a>".
						"<a href=\"user_admin.php?op=signup\">".$LANG_VARS['sign_me_up']."</a>".
						"\n</div></p>");
			}
		}//if($show_form)
		else
		{	
			echo('<br>');
			
			// Now display the whats new page
			if($CONFIG_VARS['login.show_whats_new']!==FALSE)
			{
				if(isset($login_lastvisit))
				{
					if($CONFIG_VARS['login.show_whats_new_heading']!==FALSE)
					{
						echo('<h3>'.$LANG_VARS['whats_new'].'</h3>');
					}
					
					echo('<p><table width=100% cellspacing=1 cellpadding=1 border=0 frameborder=0>'.
						'<tr><td>'.
						login_whats_new($login_lastvisit, $HTTP_SESSION_VARS['user_id']).
						'</td></tr></table>'.
						'</p>');
				}
			}
			
			if($CONFIG_VARS['login.show_last_items_list']!==FALSE)
			{
				$last_item_list = login_last_items_list($login_lastvisit, $HTTP_SESSION_VARS['user_id']);
				if($last_item_list != NULL)
				{
					if($CONFIG_VARS['login.show_last_items_list_heading']!==FALSE)
					{
						echo('<h3>'.$LANG_VARS['last_items_list'].'</h3>');
					}
					
					echo('<p>'.
						'<table width=100% cellspacing=1 cellpadding=1 border=0 frameborder=0>'.
						'<tr><td>'.
						$last_item_list.
						'</td></tr></table>'.
						'</p>');
				}
			}
			
			// many themes will ignore this call, but we make it for those that do need to refresh
			// their separate menu frame.  The original 'default' theme is one which must do this!
			if($refresh_menu)
			{
				echo(_theme_refresh_menu());
			}
		}
		
		echo(_theme_footer());
	}
}//if($CONFIG_VARS['site.enable']!==FALSE)
else
{
	// Now include theme stuff here, so we can force the theme to change for new user.
	include_once("./include/theme.php");
	include_once("./include/language.php");
		
	echo _theme_header($LANG_VARS['site_is_disabled'], FALSE);
	echo _theme_error($LANG_VARS['site_is_disabled']);
	echo _theme_footer();
}

// Cleanup after begin.inc.php
require_once("./include/end.inc.php");
?>