<?php
/* 	OpenDb - Open Media Lending Database
	Copyright (C) 2001,2002 by Jason Pell

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

// This must be first - includes config.php
require_once("./include/begin.inc.php");

include_once("./include/language.php");
include_once("./include/theme.php");

include_once("./functions/database.php");
include_once("./functions/auth.php");
include_once("./functions/logging.php");

include_once("./functions/http.php");
include_once("./functions/patchutils.php");
include_once("./functions/SniffBrowser.php");

function get_patch_title($from, $type, $title = NULL)
{
	global $CONFIG_VARS;

	if($type == "install")
		return "Install";
	else if($type == "optional")
		return "Optional Update";
	else//($type == "patch")
	{
		if(strlen($title)>0)
			return "Upgrade";
		else
	    	return "Upgrade ($from to ".$CONFIG_VARS['site.version'].")";
	}
}

function print_header($from, $type)
{
	global $CONFIG_VARS;

	echo("<html>");
	echo("\n<head>");
	echo("\n<title>".$CONFIG_VARS['site.title']." ".$CONFIG_VARS['site.version']." ".get_patch_title($from, $type)."</title>");

	if(file_exists('./theme/default/style.css'))	
		echo("\n<link rel=stylesheet type=\"text/css\" href=\"./theme/default/style.css\">");
	echo("\n<style type=\"text/css\">");
	echo ("\n.upgrade_success { background-color:#99FF99 }".
		"\n.upgrade_failure { background-color:#FF6666; font-weight: bold; font-family: courier,sans-serif }".
		"\n.upgrade_warning { background-color:orange; font-weight: bold; font-family: courier,sans-serif }".
		"\n.querytitle 		{ color: #6D78AB; font-family:Verdana, Arial; font-weight:bold  }".
		"\n.code 			{ color: black; font-family:Courier; font-weight:normal }");
	echo("\n</style>");
	echo("\n</head>");
}

/**
* The $disabled option is so confusing, I am creating a new
* function called build_patch_button, just so I can reverse
* the intention of the $disabled parameter, to an enabled
* one.
*/
function print_button($name, $value, $disabled=FALSE)
{
	print_patch_button($name, $value, !$disabled);
}

/**
	@param $disabled	- if TRUE, button will be disabled.
*/
function print_patch_button($name, $value, $isEnabled=TRUE)
{
	// Is get_browser array.
	global $browser;

	if($browser && $browser['type'] == "Netscape" && substr($browser['version'],0,1) == "4")
	{
		if($isEnabled)
			echo("<input type=\"submit\" name=\"$name\" value=\"$value\">");
		else
			echo("<input type=\"button\" name=\"$name\" value=\"$value (DISABLED)\">");
	}
	else// For now this is all we are supporting.
	{
		echo("<input type=\"submit\" name=\"$name\" value=\"$value\"".($isEnabled?"":" DISABLED").">");
	}
}

if($CONFIG_VARS['site.enable']!==FALSE || $CONFIG_VARS['patch.enable']===TRUE)
{
	session_start();
	
	// Override the patch.enable value, if a admin user is logged in.
	if($CONFIG_VARS['patch.enable']!==TRUE && 
				$CONFIG_VARS['patch.allow_admin_override']===TRUE && 
				is_user_admin($HTTP_SESSION_VARS['user_id'], $HTTP_SESSION_VARS['user_type']))
	{
		$CONFIG_VARS['patch.enable'] = TRUE;
	}
	
	if($CONFIG_VARS['patch.enable']===TRUE)
	{
		if(strlen($HTTP_VARS['from'])>0)
		{
			// no operation specified - set up frames.
			if(strlen($HTTP_VARS['op'])==0)
			{
				print_header($HTTP_VARS['from'], $HTTP_VARS['type']);
	
				// Notice no $op defined!
				$url = get_url_string($HTTP_VARS);
				?>	
	
				<frameset scrolling="yes" rows="50%,*" border="1" frameborder="1">
					<frame name="menu" src="<?php echo("$PHP_SELF?$url&op=menu"); ?>">
					<frame name="main" src="<?php echo("$PHP_SELF?$url&op=main"); ?>">
	
				   <noframes>
						<body>
	        				<p>This page uses frames, but your browser doesn't support them.
							Please upgrade your browser to one that does!</p>
						</body>
					</noframes>
				</frameset>
	
				<?php
			}
			else//op specified.
			{
				print_header($HTTP_VARS['from'], $HTTP_VARS['type']);
	
				if($HTTP_VARS['op'] == "menu")
				{
					echo("<div align=right><h1>".$CONFIG_VARS['site.title']." ".$CONFIG_VARS['site.version']."</h1>");
					echo ("<font class=\"footer\">Finish applying the patch? [<a href=\"$PHP_SELF\" target=\"_parent\">Apply another patch</a>]");
					if($CONFIG_VARS['site.enable']!==FALSE)
					{
						 echo(" or [<a href=\"index.php\" target=\"_parent\">Login to OpenDb</a>]");
					}
					echo("</font></div>");
					
			    	echo ("<h2>OpenDb Patch facility ".get_patch_title($HTTP_VARS['from'], $HTTP_VARS['type'], $HTTP_VARS['title'])."</h2>");
					echo("<h3>".$HTTP_VARS['title']."</h3>");
				}
				else if($HTTP_VARS['op'] == "result")
				{
					echo ("<h3>Results...</h3>");	
				}
	
				// Ignore any errors.
				$browser = @SniffBrowser();
	
				// Set a time limit of a good value, because some of the patches do a lot of work.
				@set_time_limit(600);
	
				if(file_exists("./patch/".$HTTP_VARS['from']."/index.php"))
				{
					include("./patch/".$HTTP_VARS['from']."/index.php");
				}
				else//Default
				{
					if($HTTP_VARS['op'] == "menu")
					{
						echo("<div align=\"center\">");
						$files = get_patch_file_list($HTTP_VARS['from'],"sql");
						if(is_not_empty_array($files))
						{
							echo("<form action=\"$PHP_SELF\" method=\"get\" target=\"main\">");
							while (list(,$file) = each($files))
							{
								print_button("sqlfile", "$file", FALSE);
								echo("&nbsp;");
							}
							echo("<br>");
							echo("Preview SQL only<input type=\"checkbox\" name=\"preview\" value=\"true\">");
							echo("<input type=\"hidden\" name=\"op\" value=\"result\">");
							echo("<input type=\"hidden\" name=\"from\" value=\"".$HTTP_VARS['from']."\">");
							echo("</form>");
						}
						else
						{
							echo("<div class=\"error\">- No Files Found -</div>");
						}
						echo("</div>");
					}
					else
					{
						if($HTTP_VARS['preview'] == 'true')
							echo_patch_sql_file($HTTP_VARS['from'], $HTTP_VARS['sqlfile']);
						else if(isset($HTTP_VARS['sqlfile']))
							exec_patch_sql_file($HTTP_VARS['from'], $HTTP_VARS['sqlfile']);
					}
				}
				
				if ($HTTP_VARS['op'] == 'result' && $HTTP_VARS['standalone']!='Y')//refresh menu for result.
					echo( "<script language=\"javascript\"><!-- //hide\nparent.frames[0].location.reload();\n// -->\n</script>");
	
				echo("</body>");
			}
		}
		else
		{
			print_header($HTTP_VARS['from'], $HTTP_VARS['type']);
			echo("<div align=right><h1>".$CONFIG_VARS['site.title']." ".$CONFIG_VARS['site.version']."</h1>");
			if($CONFIG_VARS['site.enable']!==FALSE)
			{
				echo ("<font class=\"footer\">[<a href=\"index.php\" target=\"_parent\">Login to OpenDb</a>]</font>");
			}
			echo("</div>");
			?>
			<h2>OpenDb Patch facility</h2>

		<h3>New Install:</h3>
		<ul>
	    <li><a href="<?php echo $PHP_SELF; ?>?from=install&type=install">New <?php echo $CONFIG_VARS['site.version']; ?> Installation</a></li>
		</ul>
		
		<h3>Upgrade:</h3>
	
	    <!-------------------------------------Custom Section -------------------------------->
		<ul>
		<li><a href="<?php echo $PHP_SELF; ?>?from=0.80&type=patch">Upgrade from OpenDb 0.80 to <?php echo $CONFIG_VARS['site.version']; ?></a></li>
		<li><a href="<?php echo $PHP_SELF; ?>?from=0.62&type=patch">Upgrade from OpenDb 0.62 to 0.80</a></li>
		<li><a href="<?php echo $PHP_SELF; ?>?from=0.61&type=patch&title=Upgrade+from+0.61+to+0.62">Upgrade from OpenDb 0.61 to 0.62</a></li>
		<li><a href="<?php echo $PHP_SELF; ?>?from=0.60&type=patch&title=Upgrade+from+0.60+to+0.62">Upgrade from OpenDb 0.60 to 0.62</a></li>
		<li><a href="<?php echo $PHP_SELF; ?>?from=0.54&type=patch&title=Upgrade+from+0.54+to+0.62">Upgrade from OpenDb 0.54 to 0.62</a></li>
		<li><a href="<?php echo $PHP_SELF; ?>?from=0.50&type=patch&title=Upgrade+from+OpenDb+0.50,+0.51,+0.52+or+0.53+to+0.54">Upgrade from OpenDb 0.50, 0.51, 0.52 or 0.53 to 0.54</a></li>
		</ul>
		
		<p><div class="help">
	    <h4>Upgrade Notes: </h4>
	    <ul>
		<li>Upgrades from DVDDbp are no longer supported.  If you are upgrading from DVDDBp, you will have to download and install OpenDb 0.62 first, and 'Upgrade from DVDDBp 1.45 to 0.62'.  Then you will need to install 
		OpenDb <?php echo $CONFIG_VARS['site.version']; ?>, and then you will need to run the 'Upgrade from OpenDb 0.62 to <?php echo $CONFIG_VARS['site.version']; ?>' patch.</li>
	   	<li>Upgrades from versions of OpenDb prior to 0.50 are no longer supported.  You will have to upgrade to OpenDb 0.62 and then upgrade to this version.</li>
		<li>If you are upgrading from OpenDb 0.61, you will need to run the 'Upgrade from OpenDb 0.60 to 0.62' patch, followed by the 'Upgrade from OpenDb 0.62 to 
		0.80' and 'Upgrade from OpenDb 0.80 to <?php echo $CONFIG_VARS['site.version']; ?>' patches.</li>
		<li>If you are upgrading from OpenDb 0.60, you will need to run the 'Upgrade from OpenDb 0.60 to 0.62' patch, followed by the 'Upgrade from OpenDb 0.62 to 
		0.80' and 'Upgrade from OpenDb 0.80 to <?php echo $CONFIG_VARS['site.version']; ?>' patches.</li>
		<li>If you are upgrading from OpenDb 0.54, you will need to run the 'Upgrade from OpenDb 0.54 to 0.62' patch, followed by the 'Upgrade from OpenDb 0.62 to 
		0.80' and 'Upgrade from OpenDb 0.80 to <?php echo $CONFIG_VARS['site.version']; ?>' patches.</li>
	    <li>If you are upgrading from OpenDb versions between 0.50 and 0.53, you will need to run the <i>' 0.50, 0.51, 0.52 or 0.53 to 0.54'</i> patch prior to
		running the <i>'0.54 to <?php echo $CONFIG_VARS['site.version']; ?>'</i> patch.</li>
	    </ul>
	    </div></p>
	 	
		<div class="help">
		<h4>Upgrade / Install Notes:</h4>
		<ul>
		<li>Please make sure that the MySQL user has sufficient permissions to perform the necessary update
		operations.  The permissions should include {Select, Insert, Update, Delete, Create, Drop, Index, Alter, Lock Tables}
		for the current database.</li>
		</ul>
		</div>
	
	    <!-------------------------------------Custom Section -------------------------------->
		<h3>Optional:</h3>
		<ul>
			<li>
				<a href="<?php echo $PHP_SELF; ?>?from=prefix&type=optional&title=Prefix+Tables">Prefix tables</a>
				<br>Add/Remove OpenDb table prefixes.  The $CONFIG_VARS['db_server.table_prefix'] variable must be set to
				the correct value (Especially important for removing the prefix!)
			</li>
			
			<li>
				<a href="<?php echo $PHP_SELF; ?>?from=session&type=optional&title=Database+Session+Handler">Database Session Handler</a>
				<br>Add/Remove Session table.  You should have the $CONFIG_VARS['session_handler.?????'] options configured correctly,
				to ensure the table is inserted into the correct database, with the right name.  As a minimum you should define
				a $CONFIG_VARS['session_handler.session_table'], otherwise <b><i>php_session</i></b> will be used for the table name.
			</li>
	
			<li><a href="<?php echo $PHP_SELF; ?>?from=extras&type=optional&title=Extra+Stuff">Extra stuff</a>
				<br>Extras such as Alternate title configuration, Extra Subtitles, etc.
			</li>
	
			<li><a href="<?php echo $PHP_SELF; ?>?from=lang&type=optional&title=International+Language+Support">International Language</a>
				<br>Configure OpenDb for a particular language.  You will still have to modify the
				include/config.php $CONFIG_VARS['site.language'] variable.
			</li>
	
			<li><a href="<?php echo $PHP_SELF; ?>?from=country&type=optional&title=Customise+for+Country">Customise for Country</a>
				<br>Age Recommendations, DVD Region, etc.
			</li>
		</ul>
		<!------------------------------------------------------------------------------------------->
		</body>
		<?php
		}
	}//if($CONFIG_VARS['patch.enable']===TRUE)
	else
	{
		echo _theme_header("Patch facility is not available.");
		echo _theme_error("Patch facility is not available.");
		echo _theme_footer();
	}
}//if($CONFIG_VARS['site.enable']!==FALSE)
else
{
	echo _theme_header($LANG_VARS['site_is_disabled'], FALSE);
	echo _theme_error($LANG_VARS['site_is_disabled']);
	echo _theme_footer();
}

// Cleanup after begin.inc.php
require_once("./include/end.inc.php");
?>
</html>
