<?php
/* 	OpenDb - Open Media Lending Database
	Copyright (C) 2001,2002 by Jason Pell

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
	
	-- CHANGLOG --
		
	Version		Comments
	-------		--------
	0.81		initial 0.81 release
	0.81p7		Fix to remove debug info.
	0.81p8		Fix to parse audio_lang correctly.
*/
include_once("./functions/SitePlugin.class.inc");

function parse_music_tracks($pageBuffer, $title, $disc_no)
{
	$tracks = NULL;
	//<b><font face="verdana, arial, helvetica" color="#CC6600">Track Listings</font></b></font>
	if(preg_match("!<b><font[^>]*>".preg_quote($title, "!")."</font></b>(.*)<hr noshade size=1>!Usi", $pageBuffer, $regs))
	{
		// Only parse for the disc number if disc_no specified
		if(!is_numeric($disc_no) || preg_match("!<b>Disc: $disc_no</b>(.*)</table>!Usi", $regs[1], $regs2))
		{
			if(preg_match_all("![0-9]+\.[\s]+(.*)<br>!Usi", is_numeric($disc_no)?$regs2[1]:$regs[1], $matches))
			{
				for ($i = 0; $i < count($matches[1]); $i++)
				{
					if(preg_match("!<a href=[^>]*>([^<]*)<img!i", $matches[1][$i], $regs3))
						$track = $regs3[1];
					else
						$track = $matches[1][$i];

					if(strlen($track)>0)
					{
						$track = convert_html_numeric_codes(strip_tags($track));
						$track = unhtmlentities($track);

						$tracks[] = $track;
					}
				}
			}
		}
	}
	return $tracks;
}//function parse_music_tracks($pageBuffer, $title, $disc_no)
		
class amazonuk extends SitePlugin
{
	var $_pageBuffer;
	
	function amazonuk($site_type)
	{
		parent::SitePlugin($site_type);
	}
	
	function queryListing($page_no, $items_per_page, $offset, $s_item_type, $search_vars_r)
	{
		if(strlen($search_vars_r['amazukasin'])>0)
		{
			$this->addListingRow(NULL, NULL, NULL, array('amazukasin'=>$search_vars_r['amazukasin']));
			return TRUE;
		}
		else
		{
			// Get the mapped AMAZON index type
			$index_type = ifempty($this->getConfigValue('item_type_to_index_map', $s_item_type), strtolower($s_item_type));
			
			$queryUrl = 'http://www.amazon.co.uk/exec/obidos/external-search?url='.rawurlencode('index='.$index_type).'&keyword='.rawurlencode($search_vars_r['title']).'&sz='.$items_per_page.'&pg='.$page_no;
			
			$this->_pageBuffer = $this->fetchURI($queryUrl);
		}
		
		if(strlen($this->_pageBuffer)>0)
		{
			$amazukasin = FALSE;
			
			// check for an exact match, but not if this is second page of listings or more
			if(!$this->isPreviousPage())
			{
				if (preg_match("/ASIN: <font>(\w{10})<\/font>/", $this->_pageBuffer, $regs))
				{
					$amazukasin = trim($regs[1]);
				}
				else if (preg_match("/ASIN: (\w{10})/", strip_tags($this->_pageBuffer), $regs))
				{
					$amazukasin = trim($regs[1]);
				}
				else if (preg_match ("/ISBN: ([^;]+);/", strip_tags($this->_pageBuffer), $regs)) // for books, ASIN is the same as ISBN
				{
					$amazukasin = trim ($regs[1]);
				} 
			}
			
			// exact match
			if($amazukasin!==FALSE)
			{
				// single record returned
				$this->addListingRow(NULL, NULL, NULL, array('amazukasin'=>$amazukasin));
				
				return TRUE;
			}
			else
			{
				
				if(preg_match("/All[\s]*([0-9]+)[\s]*results for/i", $this->_pageBuffer, $regs))
				{
					// store total count here.
					$this->setTotalCount($regs[1]);
					
					$start_of_block = strpos($this->_pageBuffer, "results for", $start_of_block);
					if($start_of_block!==FALSE)
					{
						$parseblock = substr($this->_pageBuffer, $start_of_block);
						if(preg_match_all(":<a href=/exec/obidos/ASIN/([^/]+)/[^>]+><b>([^<]*)</b></a>$:m", $parseblock, $matches))
						{
							for ($i = 0; $i < count($matches[1]); $i++)
							{
								$thumbimg = NULL;
								
								if(preg_match("!<img src=\"(http://.*".$matches[1][$i].".*jpg\")[^<]*>!U", $parseblock, $regs))
									$thumbimg = $regs[1];
								
								// get rid of new lines.
								$title = preg_replace("/[ \t\r\n]+/", " ", $matches[2][$i]);
								
								$this->addListingRow($title, $thumbimg, NULL, array('amazukasin'=>$matches[1][$i]));
							}
							
							return TRUE;
						}
					}
				}
			}
			
			//default
			return TRUE;
		}
		else
		{
			return FALSE;
		}
	}
	
	/**
	* 
	*/
	function queryItem($search_attributes_r, $s_item_type)
	{
		$this->_pageBuffer = $this->fetchURI("http://www.amazon.co.uk/exec/obidos/ASIN/".$search_attributes_r['amazukasin']);
		
		// no sense going any further here.
		if(strlen($this->_pageBuffer)==0)
			return FALSE;
		
		//Amazon.co.uk: Rambo: First Blood [1982]: DVD
		
		// The location of the title is the same for all formats.
		if(preg_match("/<title>.*Amazon\.co\.uk:(.*)<\/title>/s", $this->_pageBuffer, $regs))
		{
			// If extra year appended, remove it and just get the title.
			if(preg_match("/(.*)\[[0-9]+\]:(.*)$/m", trim($regs[1]), $regs2))
				$title = $regs2[1];
			else if(preg_match("/(.*)\([0-9]+\)$/m", trim($regs[1]), $regs2))
				$title = $regs2[1];
			else
				$title = $regs[1];
			
			$this->addItemAttribute('title', convert_html_numeric_codes(strip_tags(trim(str_replace("\"", "", $title)))));
		}
		
		// Image src extraction block
		//http://images-eu.amazon.com/images/P/B000050YLW.02._PE68_SCMZZZZZZZ_.jpg
		if (preg_match_all("!\"(http://images-eu.amazon.com/[^\"]+".$search_attributes_r['amazukasin']."[^\"]+)\"!", $this->_pageBuffer, $regs))
		{
			$imageurl = NULL;
			$timageurl = NULL;
			
			// try for a big image first, otherwise get the smaller one.			
			for($i = 0; $i < count($regs[1]); $i++)
			{
				if(strpos($regs[1][$i], "LZZZZZZ") !== FALSE)
				{
					$imageurl = $regs[1][$i];
					break;
				}
				
				if(strpos($regs[1][$i], "ZZZZZZZ") !== FALSE)
				{
					$timageurl = $regs[1][$i];
				}
			}
			
			if($imageurl == NULL && timageurl != NULL)
				$imageurl = $timageurl;
						
			// If still null!
			if($imageurl == NULL)
			{
				// If first image has 'THUM' in it, we have matched a thumbnail,
				// get the next one instead.
				// 'Breath Fire III' (GAME) is such a case.
				if(count($regs[1])>1 && strpos($regs[1][0],"THUM")!==FALSE)
					$imageurl = $regs[1][1];
				else
					$imageurl = $regs[1][0];
			}
			
			if(strlen($imageurl))
			{
				$this->addItemAttribute('imageurl', $imageurl);
			}
		}
		
		// The list price, will be on all Amazon item detail pages, so parse it
		// once here.  In the switch statement below, we can massage the coverprice
		// data, into a type specific attribute if required.
		//<b>List Price: </b><span class=listprice>&pound;16.99</span><br>
		if (preg_match("/<b>List Price: <\/b><span class=listprice>&pound;([^<]*)<\/span>/i", $this->_pageBuffer, $regs))
		{
			$this->addItemAttribute('listprice', $regs[1]);
		}
		//<b>Our Price: <font color=#990000>&pound;12.99</font>
		else if (preg_match("/<b>Our Price: <font[^>]*>&pound;([^<]*)<\/font>/", $this->_pageBuffer, $regs))
		{
			$this->addItemAttribute('listprice', $regs[1]);
		}
		
		// Get the mapped AMAZON index type
		$index_type = ifempty($this->getConfigValue('item_type_to_index_map', $s_item_type), strtolower($s_item_type));
				
		switch($index_type)
		{
			case 'dvd-uk':
			case 'vhs-uk':
				$this->parse_amazon_video_data($search_attributes_r, $s_item_type);
				break;
			
			case 'video-games-uk':
				$this->parse_amazon_game_data($search_attributes_r);
				break;
				
			case 'books-uk':
				$this->parse_amazon_books_data($search_attributes_r);
				break;
				
			case 'music':
				$this->parse_amazon_music_data($search_attributes_r);
				break;
			
			default://Not much here, but what else can we do?
				break;
		}
		
		return TRUE;
	}
	
	function parse_amazon_game_data($search_attributes_r)
	{
		// Publisher extraction block
		if (preg_match("/<a.*>Other products by (.*)<\/a><br>/i", $this->_pageBuffer, $regs))
		{
			$this->addItemAttribute('gamepblshr', $regs[1]);
		}
			
		// Platform extraction block
		//<b>Platform:</b> Windows 95.Windows 98.Windows 2000.Windows Me.Windows XP<br>
		if(preg_match("/<b>Platform:[\s]*<\/b>(.*)<br>/i", $this->_pageBuffer, $regs))
		{
			$platform = $regs[1];
			if(strpos($platform, ".") !== FALSE)
			{
				// Different combo's of windows, lets treat them all as windows.
				if(strpos($platform, "Windows")!==FALSE)
					$platform = "Windows";
			}
			$this->addItemAttribute('gamesystem', $platform);
		}
	
		//ELSPA</a> Minimum Age:</b> 15 <br>
		// Rating extraction block - For more information see:
		//  http://www.amazon.co.uk/exec/obidos/tg/browse/-/502556/202-1345170-2851025/202-1345170-2851025
		if (preg_match("/ELSPA<\/a> Minimum Age:<\/b> (.*) <br>/i", $this->_pageBuffer, $regs))
		{
			$this->addItemAttribute('elsparated', $regs[1].'+'); // the '+' is required
		}
		
		if(preg_match("!PEGI</a> Minimum Age:</b>([^<]*)<br>!sU", $this->_pageBuffer, $regs))
		{
			$this->addItemAttribute('pegirated', $regs[1]);
		}
		
		if ( ( $indexOf = strpos($this->_pageBuffer, "<b>Features</b></font>")) !== FALSE && 
				($indexOf2 = strpos($this->_pageBuffer, "</ul>", $indexOf)) !== FALSE)
		{
			if(preg_match_all("/<li>([^<]+)<\/li>/si", substr($this->_pageBuffer, $indexOf, $indexOf2-$indexOf), $matches))
			{
				// generate a list of features
				for($i = 0; $i < count($matches[1]); $i++)
				{
					$features .= trim(unhtmlentities(convert_html_numeric_codes(strip_tags($matches[1][$i]))))."\n";
				}
				
				if(strlen($features)>0)
				{
					$this->addItemAttribute('features', $features);
				}
			}
		}
	}
	
	function parse_amazon_music_data($search_attributes_r)
	{
		//<META name="description" content="Come on Over, Shania Twain, Mercury">
		if(preg_match("!<meta name=\"description\" content=\"([^\"]*)\">!i", $this->_pageBuffer, $regs))
		{
			$contents = trim_explode(",", $regs[1]);
			if(is_array($contents) & count($contents)>=2)
			{
				// the artist is the second entry in the description.
				$this->addItemAttribute('artist', $contents[1]);
			}
		}
		
		if( ($sqidx = strpos($this->getItemAttribute('title'), "["))!==FALSE)
		{
			$this->addItemAttribute('comments', str_replaces(array('[',']'), array("\n",''), substr($this->getItemAttribute('title'),$sqidx)));
			$this->replaceItemAttribute('title', substr($this->getItemAttribute('title'),0,$sqidx));
		}
		
		//<b>Label:</b> <a HREF="/exec/obidos/search-handle-url/size=20&store-name=music&index=music&field-label=Mercury/026-5027435-0842841">Mercury</a><br>
		if(preg_match("!<b>Label:</b>[\s]*<a href=\"[^\"]+\">([^<]+)<\/a>!i", $this->_pageBuffer, $regs))
		{
			$this->addItemAttribute('musiclabel', $regs[1]);
		}
		
		//<B> Audio CD </B>
		//(November 18, 2002)<br>
		if(preg_match("!<b>[\s]*Audio CD[\s]*</b>.*\(([^\)]+)\)<br>!sUi", $this->_pageBuffer, $regs))
		{
			$this->addItemAttribute('release_dt', $regs[1]);
			if(preg_match("!([0-9]+)$!", $this->getItemAttribute('release_dt'), $regs2))
			{
				$this->addItemAttribute('year', $regs2[1]);
			}
		}
		
		if(preg_match("!<b>Number of Discs:[\s]*</b>([0-9]+)!", $this->_pageBuffer, $regs))
		{
			$this->addItemAttribute('no_discs', $regs[1]);
		}
		
		if(is_numeric($this->getItemAttribute('no_discs')) && $this->getItemAttribute('no_discs') > 1)
		{
			for($i=0; $i<$this->getItemAttribute('no_discs'); $i++)
			{
				$cdtracks[$i] = parse_music_tracks($this->_pageBuffer, "Track Listings", $i+1);
				if($cdtracks[$i] == NULL)
					$cdtracks[$i] = parse_music_tracks($this->_pageBuffer, "Listen to Samples", $i+1);
			}
			
			// Now coalesce into single cdtracks array
			if(is_not_empty_array($cdtracks))
			{
				for($i=0; $i<count($cdtracks); $i++)
				{
					if(is_not_empty_array($cdtracks[$i]))
					{
						for($j=0; $j<count($cdtracks[$i]); $j++)
						{
							$this->addItemAttribute('cdtrack', $cdtracks[$i][$j]);
						}
					}
				}
			}
		}
		else
		{ 
			// one disc
			$this->addItemAttribute('cdtrack', parse_music_tracks($this->_pageBuffer, "Track Listings", NULL));
			if($this->getItemAttribute('cdtrack') === FALSE)
				$this->addItemAttribute('cdtrack', parse_music_tracks($this->_pageBuffer, "Listen to Samples", NULL));
		}			
	}
	
	function parse_amazon_books_data($search_attributes_r)
	{
		//<META name="description" content="The 21st Century Beauty Bible, Sarah Stacey, Josephine Fairley, Kyle Cathie Ltd">
		//<META name="description" content="Property Ladder: The Developer's Bible, Sarah Beeny, Cassell Illustrated">
		if(preg_match("!<meta name=\"description\" content=\"([^\"]*)\">!i", $this->_pageBuffer, $regs))
		{
			$contents = trim_explode(",", $regs[1]);
			
			// title is first, author(s) second, publisher last
			if(is_array($contents) && count($contents)>2)
			{
				for($i=1; $i<count($contents)-1; $i++)
				{
					$this->addItemAttribute('author', initcap($contents[$i]));
				}
			}
		}
	
		if( ( $startIndex = strpos($this->_pageBuffer, "<b>Search for books by subject:</b>") ) !== FALSE &&
				($endIndex = strpos($this->_pageBuffer, "</form>", $startIndex) ) !== FALSE )
		{
			$subjectform = substr($this->_pageBuffer, $startIndex, $endIndex-$startIndex);
			if(preg_match_all("/<input type=checkbox name=\"field\+subject\" value=\"([^\"]+)\">/", $subjectform, $matches))
			{
				for ($i = 0; $i < count($matches[1]); $i++)
				{
					$this->addItemAttribute('genre', $matches[1][$i]);
				}
			}
		}
		
		$startIndex = strpos($this->_pageBuffer, '<a name="product-details">');
		if($startIndex !== FALSE)
		{
			$startIndex += strlen('<a name="product-details">');
			
			$endIndex = strpos($this->_pageBuffer, '<p>', $startIndex);
			if($endIndex !== FALSE)
			{
				$productDetails = unhtmlentities(trim(substr($this->_pageBuffer, $startIndex, $endIndex-$startIndex)));
				
				if(preg_match("/([0-9]+) pages/", $productDetails, $regs2))
				{
	
					$this->addItemAttribute('nb_pages', $regs2[1]);
				}
	
				if(preg_match("/\(([^\)]*[0-9]+)\)/", $productDetails, $regs2))
				{
					// All we want is the year here.
					if (preg_match("/([0-9]+)$/", $regs2[1], $regs3))
					{
						$this->addItemAttribute('pub_date', $regs3[1]);		
					}
				}
				
				//<b>Publisher:</b> Kyle Cathie Ltd
				if(preg_match("!<b>Publisher:</b>[\s]+([^$]+)$!mU", $productDetails, $regs2) || 
						preg_match("!<b>Publisher:</b>[\s]+([^;]+);!U", $productDetails, $regs2))
				{
					$this->addItemAttribute('publisher', $regs2[1]);
				}
				
				if(preg_match("!<b>ISBN:</b>$([^$]+)$!mU", $productDetails, $regs2) || 
						preg_match("!; ISBN: ([^$]+)$!mU", $productDetails, $regs2))
				{
					$this->addItemAttribute('isbn', $regs2[1]);
				}
			}
		}
		
		// Editorial reviews
		//<a href=/exec/obidos/tg/stores/detail/-/books/0747551006/reviews/202-1345170-2851025><font face="verdana, arial, helvetica" size="-1"><b>See all reviews...</b></font><br></a>
		if(preg_match("!<a href=/exec/obidos/tg/stores/detail/-/books/".$search_attributes_r['amazukasin']."/reviews/!", $this->_pageBuffer, $regs))
		{
			$reviewPage = $this->fetchURI("http://www.amazon.co.uk/exec/obidos/tg/stores/detail/-/books/".$search_attributes_r['amazukasin']."/reviews/");
			if(strlen($reviewPage)>0)
			{
				//<b><font face="verdana, arial, helvetica" color="#CC6600">Reviews</font></b><br>
				$start = strpos($reviewPage, "Reviews</font></b><br>");
				if($start !== FALSE)
				{
					$start += strlen("Reviews</font></b><br>");
					
					$end = strpos($reviewPage, "Look for similar books by subject:", $start);
					if($end !== FALSE)
						$reviewPage = substr($reviewPage,$start,$end-$start);
					else
						$reviewPage = substr($reviewPage,$start);
					
					// If still something to parse.
					if(strlen($reviewPage)>0)
					{
						//<b>The Times of London</b><br />
						if(preg_match_all("!<b>(.*?)</b><br>(.*?)<br>!um", $reviewPage, $matches))
						{
							for($i=0; $i<count($matches[0]); $i++)
							{
								// The author, is the first match, the actual review the second one.
								$author = trim(unhtmlentities(strip_tags($matches[1][$i])));
									
								if($author != 'About the Author') // a hack!
								{
									// trim copyright notice.
									if(($copyidx = strpos($matches[2][$i], "-- <I>Copyright"))!==FALSE)
									{
										$matches[2][$i] = trim(substr($matches[2][$i],0,$copyidx));
									}
									
									$review = $matches[2][$i];
										
									// some specific fucked up review formatting to deal with!!!
									$review = preg_replace("/<p>/i", "\n\n", $review);
									$review = preg_replace("/<br>/i", "\n", $review);
									$review = str_replace("&#149;", "*", $review);
									$review = str_replace("&ndash;", "-", $review);
										
									$review = trim(unhtmlentities(convert_html_numeric_codes(strip_tags($review))));
										
									// some extra processing to try and remove as many duplicate reviews as possible
									$review = str_replace("\"", "", $review);
									$review = preg_replace("/[ \t]+/i", " ", $review);
									$review = str_replace("\n ", "\n", $review);
											
									if(strlen($author)>0 && 
											$author != 'Amazon.com' && 
											$author != 'Amazon.co.uk' && 
											$author != 'Book Info' && 
											$author != 'Product Description:')
									{
										$review .= "\n-- $author";
									}
										
									$this->addItemAttribute('blurb', $review);
								}				 
							}
						}
					}
				}
			}
		}
	}
	
	function parse_amazon_video_data($search_attributes_r, $s_item_type)
	{
		//<b>Rambo - First Blood [1982]</b>
		// Need to escape any (, ), [, ], :, ., 
		if(preg_match("/<b>".preg_quote($this->getItemAttribute('title'), "/")."[\s]*\[([0-9]*)\]<\/b>/s", $this->_pageBuffer, $regs))
		{
			$this->addItemAttribute('year', $regs[1]);
		}
		else if(preg_match("/<b>".preg_quote($this->getItemAttribute('title'), "/")."[\s]*\(([0-9]*)\)<\/b>/s", $this->_pageBuffer, $regs))
		{
			$this->addItemAttribute('year', $regs[1]);
		}
	
		//	<li><b>Rated:</b> <img src="http://g-images.amazon.co.uk/images/G/01/detail/pg-13.gif" width=35 height=11 width=35 height=11 alt="PG-13 \">
		// Rating extraction block
		if (preg_match("/<b>Classification:<\/b>[\s]*(.*)$/mi", $this->_pageBuffer, $regs))
		{
			if(preg_match("/<img src=.* alt=\"(.*)\">/", $regs[1], $regs2))
			{
				$this->addItemAttribute('age_rating', $regs2[1]);
			}
			else
			{
				$this->addItemAttribute('age_rating', $regs[1]);
			}
		}
		
		// Actor extraction block
		if (preg_match("/<b>Starring:&nbsp;<\/b>(.*)$/m", $this->_pageBuffer, $regs))
		{
			$actors = str_replace(",&nbsp;et al.", "", $regs[1]);
			$actors = str_replace(", (more)", "", $actors);
			$actors = trim(str_replace("&nbsp;", " ", strip_tags($actors)));
			
			$this->addItemAttribute('actors', $actors);
		}
	
		// Director extraction block
		if (preg_match("/<b>Director:&nbsp;<\/b><a.*>(.*)<\/a>/i", $this->_pageBuffer, $regs))
		{
			$this->addItemAttribute('director', $regs[1]);
		}
		
		if (preg_match("/<b>Studio:<\/b>(.*)/", $this->_pageBuffer, $regs))
		{
			$this->addItemAttribute('studio', $regs[1]);
		}
		
		if ( ( $index = strpos($this->_pageBuffer, '<b>Edition Details:</b>') ) !== FALSE && 
					($index2 = strpos($this->_pageBuffer, '<p>', $index) ) !== FALSE)
		{
			$editionDetails = substr($this->_pageBuffer, $index, $index2-$index);
				
			if(preg_match("/Number of discs: ([0-9]*)<br>$/m", $editionDetails, $regs2))
			{
				$this->addItemAttribute('no_discs', $regs2[1]);
			}
			
			// Region extraction block
			if (preg_match("/Region ([0-6]+) encoding/", $this->_pageBuffer, $regs))
			{
				$this->addItemAttribute('dvd_region', $regs[1]);
			}
			
			if (preg_match("/NTSC/", $this->_pageBuffer, $regs))
				$this->addItemAttribute('vid_format', 'NTSC');
			else
				$this->addItemAttribute('vid_format', 'PAL');
		}
		
		if ( ($start = strpos($this->_pageBuffer, "<b>Sub Titles:</b>"))!==FALSE && 
				($end = strpos($this->_pageBuffer, "</font>", $start))!==FALSE)
		{
			$start += strlen("<b>Sub Titles:</b>");
			$this->addItemAttribute('subtitles', trim_explode(",", substr($this->_pageBuffer, $start, $end-$start)));
		}
		
		if ( ($start = strpos($this->_pageBuffer, "<b>Available Audio Tracks:</b>"))!==FALSE && 
				($end = strpos($this->_pageBuffer, "</font>", $start))!==FALSE)
		{
			$start += strlen("<b>Available Audio Tracks:</b>");
			
			$audio_tracks_r = trim_explode(",", substr($this->_pageBuffer, $start, $end-$start));
			for ($i = 0; $i < count($audio_tracks_r); $i++)
			{
				$this->addItemAttribute('audio_lang', $audio_tracks_r[$i]);
			}
		}
				
		// IMDB ID block
		if(preg_match(":<a href=\"http\://amazon-uk.imdb.com/Title/ASIN=".$search_attributes_r['amazukasin']."\?([^\"]+)\">:is", $this->_pageBuffer, $regs))
		{
			$this->addItemAttribute('imdb_id', $regs[1]);
		}
		
		// If possible, fetch additional (technical) info from the site
		if(preg_match("/<b><a href=([^>]+)>Click here for more technical details about this edition\.\.\.<\/a><\/b><br>$/m", $this->_pageBuffer, $regs))
		{
			$detailPage = $this->fetchURI("http://www.amazon.co.uk" . $regs[1]);
	
			// Fetch the information if page not empty
			if(strlen($detailPage)>0)
			{
				//Production Company: Artisan Entertainment<BR>
				if (preg_match("/Studio:(.*)<br>$/m", $detailPage, $regs))
				{
					$this->addItemAttribute('studio', $regs[1]);
				}
				
				//DVD Release Date: January 1, 2001
				if(preg_match("/Theatrical Release Date:(.*)<br>[\s]*$/m", $detailPage, $regs))
				{
					// Get year only, for now.  In the future we may add ability to
					// convert date to local date format.
					if(preg_match("/([0-9]+)$/m", $regs[1], $regs2))
					{
						$this->addItemAttribute('orig_rel_dt', $regs2[1]);
					}
				}
				
				//DVD Release Date: January 1, 2001
				if(preg_match("/DVD Release Date:(.*)<br>$/m", $detailPage, $regs))
				{
					// Get year only, for now.  In the future we may add ability to
					// convert date to local date format.
					if(preg_match("/([0-9]+)$/m", $regs[1], $regs2))
					{
						$this->addItemAttribute('dvd_rel_dt', $regs2[1]);
					}
				}
			
				// Duration extraction block
				if (preg_match("/Run Time: ([0-9]+)/i", $detailPage, $regs))
				{
					$this->addItemAttribute('run_time', $regs[1]);
				}
			}
		}
		
		if(preg_match("!<a href=/exec/obidos/tg/stores/detail/-/dvd/".$search_attributes_r['amazukasin']."/reviews/[^>]*>Reviews</a>!", $this->_pageBuffer, $regs))
		{
			$reviewPage = $this->fetchURI("http://www.amazon.co.uk/exec/obidos/tg/stores/detail/-/dvd/".$search_attributes_r['amazukasin']."/reviews/");
			
			if(preg_match("/<b>Amazon.co.uk Review<\/b><br>(.*)$/m", $reviewPage, $regs))
			{
				if(preg_match_all("/(.*)<p>/U", trim($regs[1]), $matches))
				{
					// save the review first.
					$this->addItemAttribute('blurb', unhtmlentities(convert_html_numeric_codes(strip_tags($matches[1][0]))));
					
					for($i=1; $i<count($matches[1]); $i++)
					{
						if(preg_match("!<b>Synopsis</b><br>(.*)$!m", trim($matches[1][$i]), $regs2))
						{
							$this->addItemAttribute('synopsis', unhtmlentities(convert_html_numeric_codes(strip_tags($regs2[1]))));
						}
						else if(preg_match("!<b>Special Features</b><br>(.*)$!m", trim($matches[1][$i]), $regs2))
						{
							// now we must process the special features.
							if(preg_match_all("/<li>([^<]*)</iU", trim($regs2[1]), $matches2) || 
									preg_match_all("/(.*)<br>/iU", trim($regs2[1]), $matches2))
							{
								$dvd_extras = "";
								
								for($j=0; $j<count($matches2[1]); $j++)
								{
									$feature = trim(unhtmlentities(convert_html_numeric_codes(strip_tags($matches2[1][$j]))));
									if(strpos($feature, "Region")===FALSE)
									{
										if(strpos($feature, "Wide Screen")!==FALSE)
										{
											if(strpos($feature, "Anamorphic")!==FALSE)
											{
												$this->addItemAttribute('anamorphic', 'Y');
											}
											
											if(preg_match("/([0-9.]*)/", $feature, $regs2))
											{
												$this->addItemAttribute('ratio', $regs2[1]);
											}
										}
										else if(strpos($feature, "Dolby")!==FALSE)
										{
											// process audio langs - ignore for now
										}
										else if(strpos($feature, "English")!==FALSE || strpos($feature, "\\")!==FALSE)
										{
											// probably subtitles stuff, but we cannot be sure, so ignore for now.
										}
										else
										{
											$dvd_extras .= $feature."\n";
										}
									}
								}
								
								if(strlen($dvd_extras)>0)
								{
									$this->addItemAttribute('dvd_extras', $dvd_extras);
								}
							}
						}
						else if(preg_match("!<b>From the Back Cover</b><br>(.*)$!m", trim($matches[1][$i]), $regs2))
						{
							$this->addItemAttribute('blurb', unhtmlentities(convert_html_numeric_codes(strip_tags($regs2[1]))));
						}
						else if(preg_match("!<b>DVD Description</b><br>(.*)$!m", trim($matches[1][$i]), $regs2))
						{
							$this->addItemAttribute('blurb', unhtmlentities(convert_html_numeric_codes(strip_tags($regs2[1]))));
						}
					}
				}
			}
		}
		
		// Attempt to include data from IMDB if available - but only for DVD, VHS, etc
		// as IMDB does not work with BOOKS or CD's.
		if(is_numeric($this->getItemAttribute('imdb_id')))
		{
			$sitePlugin =& get_site_plugin_instance('imdb');
			if($sitePlugin !== FALSE)
			{
				if($sitePlugin->queryItem(array('imdb_id'=>$this->getItemAttribute('imdb_id')), $s_item_type))
				{
					// no mapping process is performed here, as no $s_item_type was provided.
					$itemData = $sitePlugin->getItemData();
					if(is_array($itemData))
	      			{
						// merge data in here.
						while(list($key,$value) = each($itemData))
						{
							if($key == 'actors')
								$this->replaceItemAttribute('actors', $value);
							else if($key == 'director')
								$this->replaceItemAttribute('director', $value);
							else if($key == 'year')
								$this->replaceItemAttribute('year', $value);
							else if($key == 'actors')
								$this->replaceItemAttribute('actors', $value);
							else if($key == 'genre')
								$this->replaceItemAttribute('genre', $value);
							else if($key == 'plot') //have to map from imdb to amazon attribute type.
								$this->addItemAttribute('blurb', $value);
							else if($key != 'age_rating' && $key != 'run_time')
								$this->addItemAttribute($key, $value);
						}
					}
				}
			}
		}
	}
}
?>
