<?php
/* 	OpenDb - Open Media Lending Database
	Copyright (C) 2001,2002 by Jason Pell

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
	
	-- CHANGLOG --
		
	Version		Comments
	-------		--------
	0.81		re-release using 0.81 site plugin architecture
	0.81p14		revisions for page format changes
*/
include_once("./functions/SitePlugin.class.inc");

function get_page_block($blockid, $buffer)
{
	$index = strpos($buffer, "<b>".$blockid."</b>");
	if($index!==FALSE)
	{
		$i = 0;
		// get table just before $blockid match
		$start = strpos($buffer, '<table', $index);
		if($start!==FALSE)
		{
			$depth = 1;
			$startindex = $start+6; 
			while( $depth > 0 )
			{
				// we need to get the next open or close table, so we
				// can keep track of the depth.
				$openidx = strpos($buffer, "<table", $startindex);
				$closeidx = strpos($buffer, "</table>", $startindex);

				if($openidx===FALSE)
				{
					if($closeidx === FALSE)
					{
						$startindex = strlen($buffer);
						$depth = 0;
					}
					else
					{
						$depth--;
						$startindex = $closeidx+8;//8=</table>
					}
				}
				else if($openidx===FALSE)
				{
					$endindex = strlen($buffer);
					$depth = 0;
				}
				else if($closeidx < $openidx)
				{
					$depth--;
					$startindex = $closeidx+8;//8=</table>
				}
				else if($openidx < $closeidx)// open tag
				{
					$depth++;
					$startindex = $openidx+6;//6=<table
				}
			}//while

			return substr($buffer, $start, $startindex-$start);
		}
	}
}

function parse_page_block($blockid, $block)
{
	$index = strpos($block, "<b>$blockid:</b>");
	if($index!==FALSE)
	{
		$start = strpos($block, "<td", $index);
		if($start!==FALSE)
		{
			$end = strpos($block, "</td>", $start);
			if($end!==FALSE)
			{
				return convert_html_numeric_codes(strip_tags(substr($block, $start, $end-($start))));
			}
		}
	}

	// else
	return NULL;
}

function parse_film_info_block($blockid, $block)
{
	$term = array('Actors', 'Directors', 'Producers', 'Writers');

	$start = strpos($block, "<b>$blockid:</b>");
	if($start!==FALSE)
	{
	  	$start += strlen("<b>$blockid:</b>");
	  	
	  	$end = strlen($block);
	  	
	  	reset($term);
	  	while(list(,$value) = each($term))
	  	{
			$idx = strpos($block, "<b>$value:</b>", $start);
			
			if($idx!==FALSE && $idx < $end)
			{
				$end = $idx;
			}
		}
		
		$block = substr($block, $start, $end - $start);
		$block = str_replace("&#149;", ",", $block);
		$block = str_replace("&nbsp;", " ", $block);
		$block = unhtmlentities(convert_html_numeric_codes(strip_tags($block)));
		$block = str_replace(" , ", ",", $block);
		
		if($block{0} == ',')
			$block = substr($block, 1);
		
		return $block;
	}
}
				
class dvdempire extends SitePlugin
{
	function dvdempire($site_type)
	{
		parent::SitePlugin($site_type);
	}
	
	function queryListing($page_no, $items_per_page, $offset, $s_item_type, $search_vars_r)
	{
		// standard block of code to cater for refresh option, where item already has
		// reference to site item unique ID.
		if(strlen($search_vars_r['dvdempr_id'])>0)
		{
			$this->addListingRow(NULL, NULL, NULL, array('dvdempr_id'=>$search_vars_r['dvdempr_id']));
			return TRUE;
		}
		
		$item_type_url_options = $this->getConfigValue('item_type_url_config', $s_item_type);
		
		$pageBuffer = $this->fetchURI('http://www.dvdempire.com/exec/v5_search_item.asp?display_pic=1&page='.$page_no.'&string='.urlencode($search_vars_r['title']).'&'.$item_type_url_options);
		if(strlen($pageBuffer)>0)
		{
			if(preg_match_all('!<b><a href=[\'|"]/Exec/v4_item.asp\?userid=[0-9]+&amp;item_id=([0-9]+)&amp;searchID=[0-9]+[^\'|^"]*[\'|"]>(.*?)</a>[\s]*</b>*!mi', $pageBuffer, $matches))
			{
				for ($i = 0; $i < count($matches[1]); $i++)
				{
					// Ensure an image is found for the specified item, before trying to include it in the listing.
					if(preg_match('!<img src=[\'|"](http://images.dvdempire.com/gen/movies/'.$matches[1][$i].'t.jpg)[\'|"]!', $pageBuffer, $regs))
						$thumbimg = $regs[1];
					else
						$thumbimg = NULL;
					
//					if(strlen(trim($matches[3][$i]))>0)
//						$title = $matches[2][$i]." ".trim($matches[3][$i]);
//					else
						$title = $matches[2][$i];
					
					$this->addListingRow($title, $thumbimg, NULL, array('dvdempr_id'=>$matches[1][$i]));
				}
				
				if(preg_match("/<b>([0-9]+)<\/b> Matches Found/i", $pageBuffer, $regs))
					$this->setTotalCount($regs[1]);
				else
					$this->setTotalCount(count($matches[1]));
					
				return TRUE;
			}
			else if(preg_match("/item_id=([]0-9]+)/", $this->getFetchedURILocation(), $matches))
			{
				$this->addListingRow(NULL, NULL, NULL, array('dvdempr_id'=>$matches[1]));
				return TRUE;
			}
			else
			{
			  	// no matches
				return TRUE;
			}
		}
		else
		{
			return FALSE;
		}		
	}
	
	function queryItem($search_attributes_r, $s_item_type)
	{
		$buffer = $this->fetchURI("http://www.dvdempire.com/Exec/v4_item.asp?item_id=".$search_attributes_r['dvdempr_id']);
		if(strlen($buffer)>0)
		{
			//<b>LIST:</b> $29.95<br /> 
			if(preg_match("/<b>LIST:<\/b>[\s]\\$([0-9.]*)/mi", $buffer, $regs))
			{
				$listprice = trim($regs[1]);
		
				if(is_numeric($listprice) && preg_match("/<b>SAVE:<\/b>[\s]\\$([0-9.]*)/mi", $buffer, $regs))
				{
					$saveprice = trim($regs[1]);
					if(is_numeric($saveprice))
						$saleprice = $listprice - $saveprice;
					else
						$saleprice = $listprice;
				}
				else
				{
					$saleprice = $listprice;
				}
				
				$this->addItemAttribute('listprice', $saleprice);
			}
			
			// plot
			$index = strpos($buffer, "<b>Synopsis</b>");
			if($index!==FALSE)
			{
				$start = strpos($buffer, "<table", $index);
				if($start!==FALSE)
				{
					$end = strpos($buffer, "</table>", $start);
					if($end!==FALSE)
					{
					  	$plot = substr($buffer, $start, $end - $start);
					  	$plot = str_replace(">", "> ", $plot); // workaround for lack of spaces between HZML tags
						$plot = trim(preg_replace("/[\s]+/", " ", convert_html_numeric_codes(strip_tags($plot))));
						$this->addItemAttribute('blurb', $plot);
					}
				}
			}
			
			$this->parse_dvdempire_video_data($search_attributes_r, $s_item_type, $buffer);
			
		//	echo("<pre>");
		//	print_r($this->getItemData());
		//	echo("</pre>");
			
			// indicate everything was ok
			return TRUE;
		}
		else
		{
			return FALSE;
		}
	}
	
	function parse_dvdempire_video_data($search_attributes_r, $s_item_type, $buffer)
	{			
		//<title>DVD Empire - Item - Rambo III: Ultimate Edition  /  DVD-Video</title>
		if(preg_match("!<title>DVD Empire - Item - (.*)/[\s]*DVD-Video<\/title>!m", $buffer, $regs))
		{
			$this->addItemAttribute('title', str_replace("\"", "", convert_html_numeric_codes(strip_tags($regs[1]))));
		}

// Category is no longer available
				
	/*	$index = strpos($buffer, "<b>&nbsp;Category Information</b>");
		if($index!==FALSE)
		{
			$index2 = strpos($buffer, "<font face=\"verdana, arial, sans-serif\" size=\"-1\">", $index+45);//45=<font face="verdana, arial, sans-serif" size="-1">
			if($index2!==FALSE)
			{
				$index3 = strpos($buffer, "</td>", $index2+50);//50="<font face="verdana, arial, sans-serif" size="-1">"
				if($index3!==FALSE)
				{
					// this is the complete list of supported DVDEmpire categories.
					$category_list = array(
						'Comedy', 'Action / Adventure', 'Anime', 'Cine Latino', 'Classics', 
						'Cult Classics', 'Documentary', 'Drama', 'Family Viewing', 'Gay/Lesbian Cinema', 
						'Horror', 'Interactive', 'International / Avant Garde', 'Mature / Adult', 
						'Popular Music / Performing Arts', 'Sci-Fi / Fantasy','Special Interest', 'Sports', 
						'Suspense / Mystery', 'Television');
					
					// for documentary purposes only.
					//$not_supported_category_list = array(
					//	'Discounted DVDs', 'Deluxe Editions', 'DTS', 'Box Sets', 'Subtitles');
						
					$category_lines = explode_lines(strip_tags(preg_replace("/<br>/i", "\n", substr($buffer, $index2+50, $index3-($index2+50)))));
					if(is_array($category_lines))
					{
						// Get rid of all category lines, which are not Genre lines.
						for($i=0; $i<count($category_lines); $i++)
						{
							if(starts_with(trim($category_lines[$i]), 'Genres > '))
							{
								$index = strpos($category_lines[$i], 'Genres > ');
								$category_lines[$i] = trim(substr($category_lines[$i],$index+9));
						
								// Now get the first genre entry only.
								$index = strpos($category_lines[$i], ">");
								if($index!==FALSE)
								{
									$category = trim(substr($category_lines[$i], 0, $index));
									if(strlen($category)>0 && in_array($category, $category_list))
									{
										$this->addItemAttribute('genre', $category);
									}
								}
							}
						}
					}
				}
			}
		}//$index = strpos($buffer, "<b>&nbsp;Category Information</b>");
		*/
			
		if(preg_match("/Region ([0-9]+)/i", $buffer, $regs))
		{
			$this->addItemAttribute('dvd_region', $regs[1]);
		}
		else
		{
			$this->addItemAttribute('dvd_region', '1'); // otherwise assume US region
		}
	
		$product_info = get_page_block('Product Information', $buffer);
		
		$this->addItemAttribute('dvd_extras',
					preg_replace(
						array("'[\n|\r]+'","'[\t ]+'"), 
						array("\n"," "),
						convert_html_numeric_codes(
							strip_tags(
								str_replace(
									"<br>", 
									"\n",
									parse_page_block(
										'Features',
										$product_info)
								)
							)
						)
					)
				);
	
		$this->addItemAttribute('vid_format', 'NTSC'); // An American site, so most likely NTSC
		
		$video = parse_page_block('Video', $product_info);
		if(strlen($video)>0)
		{
			if(strpos($video, 'Anamorphic')!==FALSE)
			{
				$this->addItemAttribute('anamorphic', 'Y');
			}
			
			$ratio_list_r = array('1.33', '1.66', '1.78', '1.85', '2.35', '2.78');
			while(list(,$ratio) = @each($ratio_list_r))
			{
				if (preg_match('/' . $ratio . ':1/', $video))
				{
					$this->addItemAttribute('ratio', $ratio);
				}
			}
		}
	
		$audio = parse_page_block('Audio', $product_info);
		if(strlen($audio)>0)
		{
			$audio_r = explode_lines(strip_tags(preg_replace("/<br>/i", "\n", $audio)));
			if(is_not_empty_array($audio_r))
			{
				//ENGLISH: Dolby Digital 5.1 [CC]
				for($i=0; $i<count($audio_r); $i++)
				{
					if(preg_match("/([A-Z]+): ([^$]+)$/Ui", $audio_r[$i], $matches))
					{
						if(ends_with($matches[0], "[CC]"))
							$audio_lang = trim(substr($matches[0],0, -5));
						else
							$audio_lang = trim($matches[0]);

						$this->addItemAttribute('audio_lang', $audio_lang);
					}
				}
			}
		}
		
		$subtitles = parse_page_block('Subtitles', $product_info);
		if(strpos($subtitles, 'None')===FALSE)
			$this->addItemAttribute('subtitles', trim_explode(",", $subtitles));
		
		if(preg_match("/<b>Packaging:<\/b>(.*?)<br \/>/i", $product_info, $regs))
		{
			$this->addItemAttribute('dvd_packge', $regs[1]);
		}
	
		if(preg_match("/<b>Disc:<\/b>(.*?)<br \/>/i", $product_info, $regs))
		{
			$this->addItemAttribute('dvd_disc', $regs[1]);
		}
	
		if(preg_match("/<b>Chapters:<\/b>(.*?)<br \/>/i", $product_info, $regs))
		{
			$this->addItemAttribute('dvd_chptrs', $regs[1]);
		}
		
		if(preg_match("/<b>UPC Code:<\/b>(.*?)<br \/>/i", $product_info, $regs))
		{
			$this->addItemAttribute('upc_id', $regs[1]);
		}
		
		if(preg_match("/<b>Studio:<\/b>([^<]*)<br \/>/i", $product_info, $regs))
		{
			$this->addItemAttribute('studio', $regs[1]);
		}
	
		if(preg_match("/<b>Production Year:<\/b>(.*?)<br \/>/i", $product_info, $regs))
		{
			$this->addItemAttribute('year', $regs[1]);
		}
	
		if(preg_match("/<b>DVD Year:<\/b>(.*?)<br>/i", $product_info, $regs))
		{
			$this->addItemAttribute('dvd_rel_dt', $regs[1]);
		}
	
		if(preg_match("/<b>Length:<\/b>[\s]([0-9]*)/i", $product_info, $regs))
		{
			$this->addItemAttribute('run_time', $regs[1]);
		}
	
		if(preg_match("/<b>Rating:<\/b>(.*?)<br>/i", $product_info, $regs))
		{
			$age_rating = trim($regs[1]);
			
			global $usa_age_certification_map;
			if(strlen($age_rating)>0)
			{
				if(is_array($usa_age_certification_map) && strlen($usa_age_certification_map[$age_rating])>0)
					$this->addItemAttribute('age_rating', $usa_age_certification_map[$age_rating]);
				else
					$this->addItemAttribute('age_rating', $age_rating);
			}
		}
		
		//<b>Cast & Crew</b>
		$film_info = get_page_block('Cast & Crew', $buffer);
		if(strlen($film_info)>0)
		{
			$this->addItemAttribute('actors', parse_film_info_block('Actors', $film_info));
			$this->addItemAttribute('director', parse_film_info_block('Directors', $film_info));
			$this->addItemAttribute('producers', parse_film_info_block('Producers', $film_info));
			$this->addItemAttribute('writers', parse_film_info_block('Writers', $film_info));
		}
		
		$index = strpos($buffer, "<b>Reviews</b>");
		if($index!==FALSE)
		{
		  	$index += strlen("<b>Reviews</b>");
			$reviews = get_page_block('Reviews', substr($buffer, $index));
			if(strlen($reviews)>0)
			{
			  	// <b>Overall Rating:</b> <img src="/Graphics/Running/v4_rating0.gif" border='0' vspace='0' hspace='1'><img src="/Graphics/Running/v4_rating0.gif" border='0' vspace='0' hspace='1'><img src="/Graphics/Running/v4_rating0.gif" border='0' vspace='0' hspace='1'><img src="/Graphics/Running/v4_rating0.gif" border='0' vspace='0' hspace='1'><img src="/Graphics/Running/v4_rating1.gif" border='0' vspace='0' hspace='1'><span class='fontsmall'>&nbsp;<b>4.45</b> out of <b>5</b>, including <b>41</b> reviews<br>
			  	
			}
		}
		
		// ----------------------------
		// Now the Cover images
		// ----------------------------
		if(preg_match('!<img src=\"(http://images.dvdempire.com/gen/movies/'.$search_attributes_r['dvdempr_id'].'.jpg)\"!', $buffer, $regs))
		{
			$this->addItemAttribute('thumbimg', $regs[1]);
		}
		
		// Now we need to get the cover images
		$buffer = $this->fetchURI('http://www.dvdempire.com/Exec/v4_item.asp?item_id='.$search_attributes_r['dvdempr_id'].'&tab=5');
		if(strlen($buffer)>0)
		{
			if(preg_match('!<img src=\"(http://images.dvdempire.com/gen/movies/'.$search_attributes_r['dvdempr_id'].'h.jpg)\"!', $buffer, $regs))
			{
				$this->addItemAttribute('imageurl', $regs[1]);
				$this->addItemAttribute('fimageurl', $regs[1]);
			}		
		}
		
		$buffer = $this->fetchURI('http://www.dvdempire.com/Exec/v4_item.asp?item_id='.$search_attributes_r['dvdempr_id'].'&tab=5&back=1');
		if(strlen($buffer)>0)
		{
			if(preg_match('!<img src=\"(http://images.dvdempire.com/gen/movies/'.$search_attributes_r['dvdempr_id'].'bh.jpg)\"!', $buffer, $regs))
			{
				$this->addItemAttribute('bimageurl', $regs[1]);
			}		
		}
	}
}
?>
