<?php
/* 	OpenDb - Open Media Lending Database
	Copyright (C) 2001,2002 by Jason Pell

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

	-- CHANGLOG --
		
	Version		Comments
	-------		--------
	0.81		0.81p14 release
	
*/
include_once("./functions/SitePlugin.class.inc");


function parse_mobygames_release_date($date)
{
  	$months = array('jan', 'feb', 'mar', 'apr', 'may', 'jun', 'jul', 'aug', 'sep', 'oct', 'nov', 'dec');
	if(preg_match("/([0-9]*)[\s]*([a-zA-Z]+), ([0-9]*)/", $date, $matches))
	{
	  print_r($matches);
	  	$day = $matches[1];
	  	if(!is_numeric($day))
	  		$day = 1; // first day of the month
	  	
		$key = array_search2(strtolower($matches[2]), $months);
		if($key !== FALSE)
		{
			$month = $key + 1;
		}
		else
		{
		  	$month = 1; // first month of the year,
		}
	
		$year = $matches[3];
	
		return mktime(0, 0, 0, $month, $day, $year);
	}
	
	//else
	return FALSE;
}

// Maps MobyGames ratings - document for future use

//		ELSPA Ratings
//		290	=> 18+
//		291	=> 15+
//		292	=> 11+
//		293	=> 3+

//		OFLC Ratings
//		416	=> G
//		417	=> G8+
//		418	=> M15+
//		419	=> MA15+

//		USK Ratings
//		432	=> Free for all
//		433	=> 6+
//		434	=> 12+
//		435	=> 16+
//		436	=> Not free for minors

/* get_moby_cover_url
 * Return the URL of the cover art image for the game with the given
 * MobyGames ID and (optional) platform.
 * Returns NULL if it can't find anything.
 *
 * Actually, this is a rather difficult problem, since MobyGames has
 * many images: cover art, back cover art, CD art, for each release
 * country.
 * To do this properly, we could allow the user to choose the release
 * country in the same way as he chooses a movie plot. But for now, we
 * just take the first image and use that.
 */
/* XXX - D'oh! The main description page has a link to the cover art.
 * Better to use that link, rather than trying to parse the all-images
 * page: it's more likely to be the right image. See "Half Life
 * (Windows)" for a game where the "pick the first image" heuristic
 * breaks.
 */
function get_moby_cover_url($moby_id, $mgpltfrmid = NULL)
{
	// Get the cover art page
	$queryUrl = "http://www.mobygames.com/game/covers" .
			($mgpltfrmid == NULL? "" : "/p,$mgpltfrmid") .
			"/gameId,$moby_id/";
	$cover_page = open_url($queryUrl);
	if (strlen($cover_page) == 0)
		return NULL;			// Network error, or something

	// We have the cover art page. Find the first plausible-looking
	// image url:
	// <span class="coverImage" style="width: 120px;"><div style="height: 159px;"><a href="/game/covers/gameCoverId,8146/gameId,4529/"><img alt="Windows Inside Cover  Left Flap" border="0" hspace="0" vspace="0" src="http://www.mobygames.com/images/covers/small/996092023-00.jpg" height="147" width="120" ></a></div><p>Inside Cover<br>Left Flap</p></span>
	if (!preg_match(";<span class=\\\"coverImage\\\".*?" .
					"<a href=\"(/game/covers/[^\"]+)\">" .
					"\s*<img" .
					";si",
					$cover_page,
					$matches))
	{					
		return NULL;			// Nothing found
	}
	
	// Found a match.
	$cover_url = "http://www.mobygames.com" . $matches[1];

	// We have the URL for the page containing the cover image that we
	// want. Now read that page and find the URL to the actual image.
	$cover_page = open_url($cover_url);
	if (strlen($cover_page) == 0)
		return NULL;			// Network error or something
	if (!preg_match(";<img[^<>]*?src=\"([^\"]*?/images/covers/large/[^\"]+?)\";si",
					$cover_page,
					$matches))
		return NULL;			// Not found (this shouldn't happen) 

	$image_url = $matches[1];
	if (!preg_match(";^[^:/]+:;si", $image_url))
	{
		// URL doesn't have a "http:" prefix
		if (!preg_match(";^/;", $image_url))
		{
			// Image URL is relative
			$image_url = "/" . $image_url;
		}
		$image_url = "http://www.mobygames.com" . $image_url;
	}

	return $image_url;
}

/* get_moby_rating
 * Get the ESRB and other ratings for a game
 */
function get_moby_techinfo($moby_id, $mgpltfrmid = NULL)
{
	$ratings = array();

	// Get the page that lists the technical specs
	$rating_url = "http://www.mobygames.com/game/techinfo" .
			(isset($mgpltfrmid) ? "/p,$mgpltfrmid" : "") .
			"/gameId,$moby_id/";
	$rating_page = open_url($rating_url);
	if (strlen($rating_page) == 0)
		return NULL;			// Network error or something

	if (!preg_match(":<table class=\"techInfo\".*?</table>:si", $rating_page, $matches))
		return NULL;			// Couldn't find table

	$rating_page = $matches[0];

	// Look through each row in the table
	$nmatches = preg_match_all(";<tr.*?</tr>" .
							   ";si",
							   $rating_page,
							   $matches,
							   PREG_PATTERN_ORDER);
	for ($i = 0; $i < $nmatches; $i++)
	{
		unset($rating_name);
		unset($rating);
		$row = $matches[0][$i];
		if (!preg_match(";<td.*?>(.*?)</td.*?<td.*?>(.*?)</td;si", $row, $row_matches))
			continue;			// Couldn't find two <td> elements :-(
		
		$field = $row_matches[1];
		$value = $row_matches[2];

		// Some interesting fields:
		//	Number of Players Supported: Offline (Not sure how this works)
		//	ESRB Rating
		//	USK Rating
		//	ELSPA Rating
		//	OFLC Rating
		if (preg_match("/rating$/i", $field))
		{
			$field = trim($field);
			$field = preg_replace("/[^a-z]+/i", "_", $field);
			$rating_name = strtolower($field);
			
			// <a href="/attribute/sheet/p,3/attributeId,90/">Everyone</a>
			if (preg_match(";<a href=\"/attribute/sheet/(p,\d+/)?attributeid,(\d+)/;si",
						   $value,
						   $rating_matches))
			{
				$rating = $rating_matches[2];
			}
		}

		if ($rating_name != '' && $rating != '')
			$ratings[$rating_name] = $rating;
	}

	if (!isset($ratings['esrb_rating']))
		$ratings['esrb_rating'] = 'Unknown';

	return $ratings;
}

class mobygames extends SitePlugin
{
  	var // Map MobyGames platform IDs to printable names
$moby_platform_to_name =
	array(
		 'linux' => "Linux",
		 'dos' => "DOS",
		 'windows' => "Windows",
		 'pc-booster' => "PC Booster",
		 'win3x' => "Windows 3.x",
		 'playstation' => "PlayStation",
		 'ps2' => "PlayStation 2",
		 'dreamcast' => "Dreamcast",
		 'n64' => "Nintendo 64",
		'gameboy' => "Game Boy",
		'gameboy-color' => "Game Boy Color",
		'gameboy-advance' => "Game Boy Advance",
		'xbox' => "Xbox",
		'gamecube' => "GaneCube",
		'snes' => "SNES",
		'genesis' => "Genesis",
		'jaguar' => "Jaguar",
		'lynx' => "Lynx",
		'amiga' => "Amiga",
		'sega-cd' => "Sega CD",
		'sega-32x' => "Sega 32X",
		'nes' => "NES",
		'saturn' => "Saturn",
		'atari-st' => "Atari ST",
		'game-gear' => "Game Gear",
		'sega-master-system' => "Sega Master System",
		'c64' => "Commodore 64",
		'atari-2600' => "Atari 2600",
		'colecovision' => "ColecoVision",
		'intellivision' => "Intellivision",
		'apple2' => "Apple II",
		'ngage' => "N-Gage",
		'atari-5200' => "Atari 5200",
		'atari-7800' => "Atari 7800",
		'3do' => "3DO",
		'vectrex' => "Vectrex",
		);
		
	function mobygames($site_type)
	{
		parent::SitePlugin($site_type);
	}
	
	function queryListing($page_no, $items_per_page, $offset, $s_item_type, $search_vars_r)
	{
		// standard block of code to cater for refresh option, where item already has
		// reference to site item unique ID.
		if(strlen($search_vars_r['mobygameid'])>0 && strlen($search_vars_r['mgpltfrmid'])>0)
		{
			$this->addListingRow(NULL, NULL, NULL, array('mobygameid'=>$search_vars_r['mobygameid'], 'mgpltfrmid'=>$search_vars_r['mgpltfrmid']));
			return TRUE;
		}

		$pageBuffer = $this->fetchURI('http://www.mobygames.com/search/quick?s=Search&q='.urlencode($search_vars_r['title']));
		if(strlen($pageBuffer)>0)
		{
		  	//<a href="/game/win3x/3x3-eyes-kyuusei-koushu-"><img alt="Windows 3.x Front Cover" border="0" src="/images/i/39/36/24686.jpeg" height="60" width="42" ></a>
			// Look up all thumbnails; they are of the form:
			$nmatches = preg_match_all(
				";<a href=\"/game/([^/]+)/([^\"]+)\"><img [^>]*?" .
					"src=\"([^\"<>]*?)\"" .
					";is",
				$pageBuffer,
				$matches,
				PREG_PATTERN_ORDER);
			
			// Enter all of the thumbnails into $games[]
			for ($i = 0; $i < $nmatches; $i++)
			{
				// 1 -> Platform ID
				// 2 -> Game ID
				// 3 -> Thumbnail image URL (relative)
				$games[$matches[1][$i]][$matches[2][$i]]['thumb'] = $matches[3][$i];
			}
		
			// Find all of the links to games
			$nmatches = preg_match_all(
				";<a href=\"/game/([^/]+)/([^\"]+)\">([^\"<>]*)</a>;i",
				$pageBuffer,
				$matches,
				PREG_PATTERN_ORDER);
			
			if($nmatches > 0)
			{	
				for ($i = 0; $i < $nmatches; $i++)
				{
					// 1 -> Platform ID
					// 2 -> Game ID
					// 3 -> Name
					$games[$matches[1][$i]][$matches[2][$i]]['title'] = $matches[3][$i];
				}

				while(list($mgpltfrmid, $entries) = each($games))
				{
				  	while(list($game_id, $game) = each($entries))
				  	{
				  		$platform = $this->moby_platform_to_name[$mgpltfrmid];
					  
					  	$thumburl = NULL;
					  	if(strlen($game['thumb'])>0)
						{
						  	$thumburl = 'http://www.mobygames.com'.$game['thumb'];
						}
					  	
						$this->addListingRow($game[title], $thumburl, $platform, array('mgpltfrmid'=>$mgpltfrmid, 'mobygameid'=>$game_id));
					}
				}
			}
					  	
			return TRUE;
		}
		else
		{
		  return FALSE;
		}
	}


	/* parse_moby_data
	 * Return $attributes[], an array of attributes describing the game
	 * with the given ID.
	 * Attributes include:
	 *	title			Game title
	 *	release_date	Year when game was released
	 *	publisher		Who published the game
	 *	developer		Who wrote the game
	 *	score			MobyGames popularity score: 0(1?) to 5, in .5 increments
	 *	genre			Game genre: adventure, puzzle, etc.
	 */
	function queryItem($search_attributes_r, $s_item_type)
	{
		$pageBuffer = $this->fetchURI("http://www.mobygames.com/game/".$search_attributes_r['mgpltfrmid']."/".$search_attributes_r['mobygameid']);
		
		// no sense going any further here.
		if(strlen($pageBuffer)>0)
		{
		  	// already done in parent class, but if we later work out a way to parse platorm here, we should do it.
			//$this->addItemAttribute('moby_platform_id', $search_attributes_r['platformid']);
		
			// Find the title:
			// 
			if (preg_match(
					":<h1 class=\"m5\">([^<>]+)</h1>:i",
					$pageBuffer,
					$matches))
			{
				$this->addItemAttribute('title', $matches[1]);
			}
			
			// Split the page on "<table". Some of the tables don't have a
			// corresponding "</table>"; splitting avoids all sorts of
			// problems. We use preg_split() instead of explode() because HTML
			// is case-insensitive.
			$tables = preg_split(":<table:is", $pageBuffer, -1);
			
			while(list(,$table) = each($tables))
			{
				// The only table we're interested in is the one that contains
				// the string "Published By".
				if (preg_match("/published by/i", $table))
				{
					$nrows = preg_match_all(
							"%<td[^>]*>([^<>]*?):</td.*?<td[^>]*>(.*?)</td.*?</tr%is",
							$table,
							$row_matches,
							PREG_PATTERN_ORDER);
					
					for ($row = 0; $row < $nrows; $row++)
					{
						$key   = trim($row_matches[1][$row]);
						$value = trim($row_matches[2][$row]);
						
						echo '<br>key:'.$key.' = '.$value;
						
						if (strtolower($key) == 'released')
						{
							preg_match("/([^<]*)/", $value, $value_matches);
							
							$date_format_cfg = 'DD/MM/YYYY'; // $this->getConfigValue('released_datetime_mask');
							
							$timestamp = parse_mobygames_release_date($value_matches[1]);
							
							$this->addItemAttribute('release_date', 
										get_localised_timestamp(
											$date_format_cfg, 
											$timestamp));
						}
						else if (strtolower($key) == 'published by')
						{
							if (preg_match(":<a [^>]*>(.*?)</a>:i", $value, $value_matches))
								$this->addItemAttribute('publisher', $value_matches[1]);
						}
						else if (strtolower($key) == 'perspective')
						{
							if (preg_match_all(":<li>(.*?)</li>:i", $value, $value_matches))
							{
							  	$perspective = '';
							  	
							  	print_r($value_matches);
							  	
								while(list(,$value) = each($value_matches[1]))
								{
								  	
									$perspective = convert_html_numeric_codes(strip_tags($value));
									if(ends_with($perspective, ','))
										$perspective = substr($perspective, 0, strlen($perspective)-1);
									$this->addItemAttribute('perspective', $perspective);
								} 
								
							}
						}
						else if (strtolower($key) == 'non-sport')
						{
							if (preg_match_all(":<li>(.*?)</li>:i", $value, $value_matches))
							{
							  	$comments = '';
							  	
							  	print_r($value_matches);
							  	
								while(list(,$value) = each($value_matches[1]))
								{
									if(strlen($comments)>0)
										$comments .= ' ';
									
									$comments .= convert_html_numeric_codes(strip_tags($value));
								} 
								$this->addItemAttribute('non-sport', $comments);
							}
						}
						else if (strtolower($key) == 'developed by')
						{
							if (preg_match(":<a [^>]*>(.*?)</a>:i", $value, $value_matches))
								$this->addItemAttribute('developer', $value_matches[1]);
						}
						else if (strtolower($key) == 'mobyscore')
						{
							if (preg_match(":<a [^>]*>(\d+\.\d+).*</a>:i", $value, $value_matches))
								$this->addItemAttribute('score', $value_matches[1]);
						}
						else if (strtolower($key) == 'genre')
						{
							if (preg_match(":<a [^>]*>(.*?)</a>:i", $value, $value_matches))
								$this->addItemAttribute('genre', $value_matches[1]);
						}
					}
				}
			}
		
			// Get Description
			if (preg_match(";<h2 class=\"m5\">Description</h2>" .
						   "(.*?)<div" .
						   ";si",
						   $pageBuffer, $matches))
			{
				$description = $matches[1];
				$description = preg_replace(":\s*<br>\s*$:si", "", $description);
				$description = preg_replace(":\s*<br>\s*:si", "\n", $description);
				$description = preg_replace(":<p>\s*(.*?)\s*</p>:si",
											"\\1\n",
											$description);
				$description = preg_replace(":\s*<p>\s*:si", "\n", $description);
				$description = trim($description);

				$this->addItemAttribute('description', $description); 
			}
		
			// Get cover art
			$cover_url = get_moby_cover_url($id, $platform);
			if (isset($cover_url))
				$this->addItemAttribute('imageurl', $cover_url);
		
			// Get ESRB rating (and others)
			$ratings = get_moby_techinfo($id, $platform);
			if (is_not_empty_array($ratings))
			{
				foreach ($ratings as $key => $value)
				{
					$this->addItemAttribute($key, $value);
				}
			}

	echo("<pre>");
	print_r($this->getItemData());
	echo("</pre>");
			
			return TRUE;
		}
		else
		{
			return FALSE;
		}
	}
}
?>