/*
 * decoder-adpcm.cc --
 *
 *      FIXME: This file needs a description here.
 *
 * Copyright (c) 1995-2002 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * A. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * B. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * C. Neither the names of the copyright holders nor the names of its
 *    contributors may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS
 * IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

static const char rcsid[] =
    "@(#) $Header: /usr/mash/src/repository/mash/mash-1/audio/decoder-adpcm.cc,v 1.8 2002/02/03 03:10:46 lim Exp $";

#include "decoder.h"
#include "controller.h"
extern "C" {
#include "adpcm.h"
}

class ADPCMDecoder : public PCM_Decoder {
    public:
	ADPCMDecoder();
	virtual void recv(pktbuf*);
    protected:
	adpcm_state rstate_;

};

static class ADPCMDecoderClass : public TclClass {
    public:
	ADPCMDecoderClass() : TclClass("Module/AudioDecoder/ADPCM") {}
	TclObject* create(int /* argc */, const char*const* /* argv */) {
		return (new ADPCMDecoder);
	};
} adpcm_decoder_class;

ADPCMDecoder::ADPCMDecoder()
{
	memset(&rstate_, 0, sizeof(rstate_));
}

void ADPCMDecoder::recv(pktbuf* pb)
{
	if (active()) {
		const struct rtphdr* rh = (rtphdr*)pb->dp;
		const u_int8_t* frame = (u_int8_t*)(rh + 1);
		int cc = pb->len - sizeof(*rh);
		u_char wrkbuf[AUDIO_FRAMESIZE*8];
		if ((cc = (cc - sizeof(struct adpcm_state)) << 1) > 0 &&
		    cc <= int(sizeof(wrkbuf))) {

			NTOHS(((struct adpcm_state*)frame)->valprev);
			adpcm_decoder(frame + sizeof(struct adpcm_state),
				      wrkbuf, cc, (struct adpcm_state*)frame);
			consume_samples(rh, wrkbuf, cc);
		}
	}
	pb->release();
}
