#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>

#include "inet.h"
#include "net.h"
#include "rtp.h"
#include "dct.h"
#include "bsd-endian.h"
//#include "Tcl.h"
#include "tclcl.h"
#include "crdef.h"
//#include "transmitter.h"
#include "pktbuf-rtp.h"
#include "module.h"

//#include "h263coder.h"
#include "h263+coder.h"

#define HLEN (sizeof(rtphdr) + 4)
#define SUBQCIF_WIDTH   128
#define SUBQCIF_HEIGHT  96
#define	CIF_WIDTH	352
#define	CIF_HEIGHT	288
#define	QCIF_WIDTH	176
#define	QCIF_HEIGHT	144
#define CIF4_WIDTH      704
#define CIF4_HEIGHT     576
#define CIF16_WIDTH     1408
#define CIF16_HEIGHT    1152

unsigned char *h263_frame;          /* encoder input */

int            h263_streamcount;    /* encoder output */
char          *h263_bitstream;

int QP,QPI;


class H263PEncoder : public EncoderModule {
public:
    void setq(int q);

    H263PEncoder();
    ~H263PEncoder();
    int command(int argc, const char*const* argv);
    
    void size(int w, int h);
    void recv(Buffer* bp);
    int  encode(const VideoFrame*);

protected:
    struct ENCODER_STATE *state;
    int    i, qp, start_ts, last_iframe, sed_pels, sed_lines, base_sed_pels, base_sed_lines;
  u_char* bs_;
};


static class H263PEncoderClass : public TclClass {
public:
  //	H263EncoderMatcher() : Matcher("module") {}
  H263PEncoderClass() : TclClass("Module/VideoEncoder/Pixel/H263+") { /*printf("h263-constructor");*/}
  TclObject* create(int, const char*const*) {
    return (new H263PEncoder);
  }
} h263P_encoder_class;
/*
	TclObject* match(const char* fmt) {
		if (strcasecmp(fmt, "h263") == 0)
			return (new H263Encoder);
		return (0);
	}
} encoder_matcher_h263;
*/

H263PEncoder::H263PEncoder() : EncoderModule() //: TransmitterModule(FT_YUV_CIF)
{
    fprintf(stderr,"send-h263: constructor\n");
    state = NULL;
    start_ts = 0;
    qp = 10;
}

H263PEncoder::~H263PEncoder()
{
    fprintf(stderr,"send-h263: destructor\n");
    //Temp    h263_cleanup(state);
    //    free(h263_bitstream);
}

void
H263PEncoder::size(int w, int h)
{
    fprintf(stderr,"send-h263: new frame size: %dx%d\n",w,h);
    FrameModule::size(w, h);

    sed_pels = w;
    sed_lines = h;
    base_sed_pels = w;
    base_sed_lines = h;
    if (w == CIF_WIDTH && h == CIF_HEIGHT) {
	state->pic->source_format = 3;
    } else if (w == QCIF_WIDTH && h == QCIF_HEIGHT) {
	state->pic->source_format = 2;
    } else if (w == SUBQCIF_WIDTH && h == SUBQCIF_HEIGHT) {
        state->pic->source_format = 1;
    } else if (w == CIF4_WIDTH && h == CIF4_HEIGHT) {
        state->pic->source_format = 4;
    } else if (w == CIF16_WIDTH && h == CIF16_HEIGHT) {
        state->pic->source_format = 5;
    } else {
	fprintf(stderr,"send-h263: unsupported format\n");
	exit(1);
    }
}

int
H263PEncoder::command(int argc, const char*const* argv)
{
    fprintf(stderr,"send-h263: command: %s\n",argv[1]);

    if (argc == 3 && strcmp(argv[1], "q") == 0) {
	qp = QP = QPI = atoi(argv[2]);
	return (TCL_OK);
    }
    return (EncoderModule::command(argc, argv));
}

void
dump_paket(const unsigned char *data, int len)
{
    int x,y;

    for (y = 0; y < len; y += 16) {
	fprintf(stderr,"\t");
	for (x = y; x < y+16; x++) {
	    if (x < len)
		fprintf(stderr,"%02x ",data[x]);
	    else
		fprintf(stderr,"   ");
	}
	fprintf(stderr," ");
	for (x = y; x < y+16; x++) {
	    if (x < len)
		fprintf(stderr,"%c", ((data[x] & 0x7f) < 32) ? '.' : data[x]);
	    else
		fprintf(stderr," ");
	}
	fprintf(stderr,"\n");
    }
}

void
H263PEncoder::recv(Buffer* bp)
{
  YuvFrame* vf = (YuvFrame*)bp;
  /*  if (!samesize(vf))
    size(vf->width_, vf->height_);
    */
  encode(vf);
}

int H263PEncoder::encode(const VideoFrame *vf)
{
  //    Transmitter::pktbuf* pb;
  pktbuf* pb = pool_->alloc(vf->ts_, RTP_PT_H263P);
    rtphdr* rh;
    int n,ps,send_psize = mtu_ - 14;      /* 12 RTP + 2 Payload */
    //  bs_=&pb->data[HLEN];
    
    if (!samesize(vf) && state) {
      //temp	h263_cleanup(state);
        //	free(h263_bitstream);
	state = NULL;
    }
    
    if (!state) {
	if (!start_ts)
	    start_ts = vf->ts_;
        //	h263_bitstream = (char*)malloc(65536);
	//temp	state = h263_init_encoder();
	size(vf->width_, vf->height_);
	/* set other encoding options here */
        state->pic->target_frame_rate = 30;
        state->pic->src_frame_rate = 30;
        state->pic->bit_rate = 1048576;
	//temp        state->curr_recon = InitImage(vf->width_*vf->height_);
	//temp        state->prev_recon = InitImage(vf->width_*vf->height_);
        //	QP = QPI = qp;
        //	h263_init_encoder_2(state);
	last_iframe = vf->ts_;
	i = 0;
    }
    h263_frame = vf->bp_;
    h263_streamcount = 0;

    /*
    if (vf->ts_ - last_iframe > 10 * 90000) {
//	one I-Frame every 10 sec
	last_iframe = vf->ts_;
	i = 0;
    }
    */
    i = 0;
    /* XXX: ts wraparound */
    //temp    h263_encode_one_frame(state,i++,((vf->ts_ - start_ts)/3000) & 0xff);

    for (n = 2; n < h263_streamcount; n += ps) {
	pb = pool_->alloc(vf->ts_, RTP_PT_H263P);
	rh = (rtphdr*)pb->data; //(rtphdr*)pb->iov[0].iov_base;
	
	*(u_int*)(rh + 1) = 0;
	if (2 == n)
	    *(u_int*)(rh + 1) |= htonl(0x04000000); /* set P bit */
	
	ps = (h263_streamcount) - n;
	if (ps > send_psize) {
	    if (ps > send_psize + 64)
		ps = send_psize;
	    else
		ps = send_psize-64;
	} else
	    rh->rh_flags |= htons(RTP_M);

        //	memcpy((u_char*)(((u_int8_t*)(rh+1))+2), h263_bitstream+n, ps);
        bs_=(u_char*)(((u_int8_t*)(rh+1))+2);
#if 0
	dump_paket((const unsigned char *)pb->data,16);
      	dump_paket((const unsigned char *)bs_,16);
        //	dump_paket((const unsigned char *)&pb->data[HLEN],16);
#endif
        //	pb->iov[0].iov_len = 14;
	pb->len = ps + 14;
        //	pb->iov[1].iov_len = ps;
	target_->recv(pb);
    }

    return n;
}
