/*
 * mash-tclinit.cc --
 *
 *      FIXME: This file needs a description here.
 *
 * Copyright (c) 1997-2002 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * A. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * B. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * C. Neither the names of the copyright holders nor the names of its
 *    contributors may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS
 * IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * @(#) $Header: /usr/mash/src/repository/mash/mash-1/mash-tclinit.cc,v 1.21 2002/02/03 04:41:07 lim Exp $
 */

#include <tclcl.h>
#include <rate-variable.h>
#include "mash-init.h"
#ifdef HAVE_SRMV2_API_H
#include "srmv2-api.h"
#endif
#ifdef HAVE_JPEGWC_H
#include "jpegwc.h"
#endif

#ifdef __PSVP_ENABLED__
extern int Psvp_Init(Tcl_Interp *interp);
#endif

/*
 * The following variable is a special hack that is needed in order for
 * Sun shared libraries to be used for Tcl.
 */

#ifndef WIN32
extern "C"  {
	extern int matherr();
	int *tclDummyMathPtr = (int *) matherr;
}
#endif

#ifdef ENABLE_SCHEDULING
int Mash_RunCmd (ClientData, Tcl_Interp*, int, char *[]);
#endif

int
Mash_TclInit(Tcl_Interp *interp)
{
#ifdef WIN32
	WORD wVersionRequested;
	WSADATA wsaData;
	int err;
	wVersionRequested = MAKEWORD( 1, 1 );
	err = WSAStartup( wVersionRequested, &wsaData );
	if ( err != 0 ) {
	        WIN32_OutputErr(interp, "Winsock initialization failed!");
		return TCL_ERROR;
	}
#endif

	Tcl_Preserve(interp);

#ifdef ENABLE_SCHEDULING
	Tcl_CreateCommand(interp, "run", Mash_RunCmd, NULL, NULL);
#endif

	Tcl::init(interp, "mash");
	Tcl_SetVar2(interp, "mash", "version", version, TCL_GLOBAL_ONLY);
	Tcl::instance().tkmain(NULL);
	init_misc();
	RateVariable::init();
	if (Mash_TclPlatformInit(interp)==TCL_ERROR) return TCL_ERROR;

#ifdef __PSVP_ENABLED__
	if (Psvp_Init(interp) == TCL_ERROR) {
	        WIN32_OutputErr(interp, "Psvp_Init failed!");
	        return TCL_ERROR;
	}
#endif

#ifdef HAVE_SRMV2_API_H
	if (SRMv2_Init(interp) == TCL_ERROR) {
	        WIN32_OutputErr(interp, "SRMv2_Init failed!");
	        return TCL_ERROR;
	}
#endif

#ifdef HAVE_JPEGWC_H
	if (JPEGWC_Init(interp) == TCL_ERROR) {
	        WIN32_OutputErr(interp, "JPEGWC_Init failed!");
	        return TCL_ERROR;
	}
#endif

	/*
	 * Specify a user-specific startup file to invoke if the application
	 * is run interactively.  Typically the startup file is "~/.apprc"
	 * where "app" is the name of the application.  If this line is deleted
	 * then no user-specific startup file will be run under any conditions.
	 */

	Tcl_SetVar(interp, "tcl_rcFileName", "~/.mashrc", TCL_GLOBAL_ONLY);
	Tcl_SetVar2(interp, "mash", "environ", "smash", TCL_GLOBAL_ONLY);
	return TCL_OK;
}
