/*
 * mbv2-tkcanv.cc --
 *
 *      FIXME: This file needs a description here.
 *
 * Copyright (c) 1998-2002 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * A. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * B. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * C. Neither the names of the copyright holders nor the names of its
 *    contributors may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS
 * IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef lint
static const char rcsid[] = "@(#) $Header: /usr/mash/src/repository/mash/mash-1/mbv2/mbv2-tkcanv.cc,v 1.16 2002/02/03 03:17:08 lim Exp $";
#endif


#include "mbv2-canv.h"
#include "mbv2-item.h"
#include "mtrace.h"
#include <assert.h>
#include <tk.h>


DEFINE_OTCL_CLASS(MBv2TkCanvas, "MBv2TkCanvas") {
	INSTPROC_PUBLIC(get_scale);
	INSTPROC_PUBLIC(rescale);
	INSTPROC_PUBLIC(rescale_to_fit);
	INSTPROC_PUBLIC(scale_image);
}


char *MBv2TkCanvas::itemType2CanvItemType_[] = {
	"nop",
	"line",
	"text",
	"rectangle",
	"oval",
	"image",
	"pscript"
};


MBv2CanvId
MBv2TkCanvas::create_item(MBv2Item *item, Bool isLocal)
{
#define ERR(x) \
	if ( (x) == TCL_ERROR ) { \
		MTrace(trcMB, ("tcl error: %s", Tcl_GetStringResult(interp)));\
		Tcl_DecrRefCount(cmd); \
		return MBv2InvalidCanvId; \
	}

	Tcl_Obj *cmd;
	Tcl_Interp *interp = Tcl::instance().interp();
	cmd = Tcl_NewObj();
	Tcl_IncrRefCount(cmd);
	MBv2ItemType itemType = item->type();
	if (itemType <= MBv2NoItem || itemType >= MBv2InvalidItem) {
		MTrace(trcMB, ("invalid item type %d", itemType));
		Tcl_DecrRefCount(cmd);
		return MBv2InvalidCanvId;
	}

	const char *name = item_name(itemType);
	if (!name) {
		MTrace(trcMB, ("invalid item type %d", itemType));
		Tcl_DecrRefCount(cmd);
		return MBv2InvalidCanvId;
	}

	ERR(Tcl_ListObjAppendElement(interp, cmd, Tcl_NewStringObj(path_,-1)));
	ERR(Tcl_ListObjAppendElement(interp, cmd,
				     Tcl_NewStringObj("create",-1)));
	ERR(Tcl_ListObjAppendElement(interp, cmd,
				     Tcl_NewStringObj((char*)name, -1)));

	// append the coordinates
	// first convert the coordinates to the current scaling factor
	MBv2Point *p = item->points();
	double x, y;
	int numPoints = item->num_points();
	for (int i=0; i < numPoints; i++, p++) {
		x = p->x; y = p->y;
		matrix_.map(x, y);
		ERR(Tcl_ListObjAppendElement(interp, cmd,Tcl_NewDoubleObj(x)));
		ERR(Tcl_ListObjAppendElement(interp, cmd,Tcl_NewDoubleObj(y)));
	}

	// append any extra arguments
	if (isLocal) {
		ERR(Tcl_ListObjAppendList(interp, cmd,Tcl_NewStringObj(
			"-tag local", -1)));
	}

	// append the item's properties
	Tcl_Obj *props = item->get_properties(interp);
	if (!props) {
		MTrace(trcMB, ("error retrieving item properties"));
		Tcl_DecrRefCount(cmd);
		return MBv2InvalidCanvId;
	}
	if (item->type()==MBv2Text) {
		// replace the font with a "virtual" font name
		Tcl_Obj **objv;
		int objc, i;
		Tcl_ListObjGetElements(interp, props, &objc, &objv);
		for (i=0; i < objc; i++, objv++) {
			if (strcmp(Tcl_GetStringFromObj(*objv, NULL),
				   "-font") == 0) {
				const char *newfont = interpret_font(
					Tcl_GetStringFromObj(*(objv+1), NULL));
				Tcl_SetStringObj(*(objv+1), (char*)newfont,
						 strlen(newfont));
				break;
			}
		}
	}

	ERR(Tcl_ListObjAppendList(interp, cmd, props));

	// evaluate the command
	ERR(Tcl_GlobalEvalObj(interp, cmd));
        // the command succeeded; let's retrieve the canv id
	Tcl_Obj *result = Tcl_GetObjResult(interp);
	int canvIdInt;
	ERR(Tcl_GetIntFromObj(interp, result, &canvIdInt));

	if (item->type()==MBv2Image) {
		// we may have to scale this image
		double scale, dummy;
		matrix_.map(1.0, 1.0, scale, dummy);
		ERR(Invokef("rescale_image %g %d", scale, canvIdInt))
	}

	Tcl_DecrRefCount(cmd);
	return (MBv2CanvId) canvIdInt;

#undef ERR
}


Bool
MBv2TkCanvas::delete_item(MBv2CanvId canvId)
{
#define ERR(x) \
	if ( (x) == TCL_ERROR ) { \
		MTrace(trcMB, ("tcl error: %s", Tcl_GetStringResult(interp)));\
		Tcl_DecrRefCount(cmd); \
		return FALSE; \
	}

	Tcl_Obj *cmd;
	Tcl_Interp *interp = Tcl::instance().interp();
	cmd = Tcl_NewObj();
	Tcl_IncrRefCount(cmd);
	ERR(Tcl_ListObjAppendElement(interp, cmd, Tcl_NewStringObj(path_,-1)));
	ERR(Tcl_ListObjAppendElement(interp, cmd,
				     Tcl_NewStringObj("delete",-1)));
	ERR(Tcl_ListObjAppendElement(interp, cmd, Tcl_NewIntObj(canvId)));

	// evaluate the command
	ERR(Tcl_GlobalEvalObj(interp, cmd));

	// the command succeeded
	Tcl_DecrRefCount(cmd);
	return TRUE;

#undef ERR
}


Bool
MBv2TkCanvas::move_item(MBv2CanvId canvId, int dx, int dy)
{
#define ERR(x) \
	if ( (x) == TCL_ERROR ) { \
		MTrace(trcMB, ("tcl error: %s", Tcl_GetStringResult(interp)));\
		Tcl_DecrRefCount(cmd); \
		return FALSE; \
	}

	double x=dx, y=dy;
	matrix_.map(x, y);

	Tcl_Obj *cmd;
	Tcl_Interp *interp = Tcl::instance().interp();
	cmd = Tcl_NewObj();
	Tcl_IncrRefCount(cmd);
	ERR(Tcl_ListObjAppendElement(interp, cmd, Tcl_NewStringObj(path_,-1)));
	ERR(Tcl_ListObjAppendElement(interp, cmd,
				     Tcl_NewStringObj("move",-1)));
	ERR(Tcl_ListObjAppendElement(interp, cmd, Tcl_NewIntObj(canvId)));
	ERR(Tcl_ListObjAppendElement(interp, cmd, Tcl_NewDoubleObj(x)));
	ERR(Tcl_ListObjAppendElement(interp, cmd, Tcl_NewDoubleObj(y)));

	// evaluate the command
	ERR(Tcl_GlobalEvalObj(interp, cmd));

	// the command succeeded
	Tcl_DecrRefCount(cmd);
	return TRUE;

#undef ERR
}


Bool
MBv2TkCanvas::raise_after(MBv2CanvId canvId, MBv2CanvId targetId)
{
#define ERR(x) \
	if ( (x) == TCL_ERROR ) { \
		MTrace(trcMB, ("tcl error: %s", Tcl_GetStringResult(interp)));\
		Tcl_DecrRefCount(cmd); \
		return FALSE; \
	}

	Tcl_Obj *cmd;
	Tcl_Interp *interp = Tcl::instance().interp();
	cmd = Tcl_NewObj();
	Tcl_IncrRefCount(cmd);
	ERR(Tcl_ListObjAppendElement(interp, cmd, Tcl_NewStringObj(path_,-1)));
	// the (char*) cast is necessary for some compilers because of the use
	//   of the ? statement
	ERR(Tcl_ListObjAppendElement(interp, cmd, Tcl_NewStringObj(
		(canvId==MBv2InvalidCanvId ? (char*)"lower" : (char*)"raise"),-1)));
	ERR(Tcl_ListObjAppendElement(interp, cmd, Tcl_NewIntObj(targetId)));
	if (canvId!=MBv2InvalidCanvId) {
		ERR(Tcl_ListObjAppendElement(interp, cmd,
					     Tcl_NewIntObj(canvId)));
	}

	// evaluate the command
	ERR(Tcl_GlobalEvalObj(interp, cmd));

	// the command succeeded
	Tcl_DecrRefCount(cmd);
	return TRUE;

#undef ERR
}


const char *
MBv2TkCanvas::interpret_font(const char *font)
{
	char scale[32];
	double oldscaleX, oldscaleY;
	matrix_.map(1.0, 1.0, oldscaleX, oldscaleY);
	sprintf(scale, "%g", oldscaleX);

	if (Invoke("interpret_font", font, scale, NULL)==TCL_ERROR) {
		MTrace(trcMB, ("tcl error: %s",
			       Tcl_GetStringResult(Tcl::instance().interp())));
		return font;
	}

	return Tcl::instance().result();
}


char *
MBv2TkCanvas::get_text(MBv2CanvId canvId, int minlen, int extra)
{
#define ERR(x) \
	if ( (x) == TCL_ERROR ) { \
		MTrace(trcMB, ("tcl error: %s", Tcl_GetStringResult(interp)));\
		Tcl_DecrRefCount(cmd); \
		return NULL; \
	}

	Tcl_Obj *cmd;
	Tcl_Interp *interp = Tcl::instance().interp();
	cmd = Tcl_NewObj();
	Tcl_IncrRefCount(cmd);
	ERR(Tcl_ListObjAppendElement(interp, cmd, Tcl_NewStringObj(path_,-1)));
	ERR(Tcl_ListObjAppendElement(interp, cmd,
				     Tcl_NewStringObj("itemcget", -1)));
	ERR(Tcl_ListObjAppendElement(interp, cmd, Tcl_NewIntObj(canvId)));
	ERR(Tcl_ListObjAppendElement(interp, cmd,
				     Tcl_NewStringObj("-text", -1)));

	// evaluate the command
	ERR(Tcl_GlobalEvalObj(interp, cmd));

	// the command succeeded; retrieve the text string
	char *text = Tcl_GetStringResult(interp), *copy;
	int tlen = strlen(text);
	if (minlen < tlen) minlen = tlen;
	copy = new char [minlen + extra + 1];
	strcpy(copy, text);
	Tcl_DecrRefCount(cmd);
	return copy;

#undef ERR
}


Bool
MBv2TkCanvas::set_text(MBv2CanvId canvId, const char *text)
{
#define ERR(x) \
	if ( (x) == TCL_ERROR ) { \
		MTrace(trcMB, ("tcl error: %s", Tcl_GetStringResult(interp)));\
		Tcl_DecrRefCount(cmd); \
		return FALSE; \
	}

	Tcl_Obj *cmd;
	Tcl_Interp *interp = Tcl::instance().interp();
	cmd = Tcl_NewObj();
	Tcl_IncrRefCount(cmd);
	ERR(Tcl_ListObjAppendElement(interp, cmd, Tcl_NewStringObj(path_,-1)));
	ERR(Tcl_ListObjAppendElement(interp, cmd,
				     Tcl_NewStringObj("itemconfigure", -1)));
	ERR(Tcl_ListObjAppendElement(interp, cmd, Tcl_NewIntObj(canvId)));
	ERR(Tcl_ListObjAppendElement(interp, cmd,
				     Tcl_NewStringObj("-text", -1)));
	ERR(Tcl_ListObjAppendElement(interp, cmd,
				     Tcl_NewStringObj((char*)text, -1)));

	// evaluate the command
	ERR(Tcl_GlobalEvalObj(interp, cmd));

	// the command succeeded
	Tcl_DecrRefCount(cmd);
	return TRUE;

#undef ERR
}


int
MBv2TkCanvas::get_scale(int argc, const char * const *argv)
{
	double oldscaleX, oldscaleY;
	BEGIN_PARSE_ARGS(argc, argv);
	END_PARSE_ARGS;

	matrix_.map(1.0, 1.0, oldscaleX, oldscaleY);

	assert(oldscaleX == oldscaleY ||
	       !"should not happen: diff x and y scales");

	Tcl::instance().resultf("%g", oldscaleX);
	return TCL_OK;
}


int
MBv2TkCanvas::rescale(int argc, const char * const *argv)
{
	double scale, oldscaleX, oldscaleY;
	BEGIN_PARSE_ARGS(argc, argv);
	ARG(scale);
	END_PARSE_ARGS;

	matrix_.map(1.0, 1.0, oldscaleX, oldscaleY);

	assert(oldscaleX == oldscaleY ||
	       !"should not happen: diff x and y scales");

	if (int((scale*100.0) + 0.5) == int((oldscaleX*100.0) + 0.5))
		return TCL_OK;

	double newscale = scale/oldscaleX; /* = s1 / s */
	matrix_.clear();
	matrix_.scale(scale, scale);

	return Invokef("rescale_objects %g %g", scale, newscale);
}


int
MBv2TkCanvas::rescale_to_fit(int argc, const char * const *argv)
{
	double width, height, dw, dh, sx=0.0, sy=0.0, oldscaleX, oldscaleY;
	BEGIN_PARSE_ARGS(argc, argv);
	ARG(width);
	ARG(height);
	ARG(dw);
	ARG(dh);
	END_PARSE_ARGS;

	matrix_.map(1.0, 1.0, oldscaleX, oldscaleY);

	assert(oldscaleX == oldscaleY ||
	       !"should not happen: diff x and y scales");

	if (width != 0) sx = dw/width;
	if (height!= 0) sy = dh/height;
	if (sx == 0.0 || (sy != 0.0 && sx > sy)) sx = sy;

	if ( int((sx * 100.0) + 0.5) == 100) {
		Tcl::instance().resultf("%d", int((oldscaleX * 100.0) + 0.5));
		return TCL_OK;
	}

	double newscale = sx * oldscaleX;
	matrix_.clear();
	matrix_.scale(newscale, newscale);

	if (Invokef("rescale_objects %g %g 1", newscale, sx)!=TCL_OK)
		return TCL_ERROR;
	Tcl::instance().resultf("%d", int((newscale * 100.0) + 0.5));
	return TCL_OK;
}


#define PIXELPTR(b, x, y, clr) (((b).pixelPtr) + ((y) * (b).pitch) + \
				((x) * (b).pixelSize) + ((b).offset[(clr)]))


int
MBv2TkCanvas::scale_image(int argc, const char * const *argv)
{
	const char *origImageName, *newImageName;
	BEGIN_PARSE_ARGS(argc, argv);
	ARG(origImageName);
	ARG(newImageName);
	END_PARSE_ARGS;

	Tk_PhotoHandle origImage, newImage;
	origImage= Tk_FindPhoto(Tcl::instance().interp(),(char*)origImageName);
	newImage = Tk_FindPhoto(Tcl::instance().interp(),(char*)newImageName);

	double scale, dummy;
	matrix_.map(1.0, 1.0, scale, dummy);
	int width, height, nw, nh;

	Tk_PhotoImageBlock origBlock, newBlock;
	Tk_PhotoGetSize(origImage, &width, &height);
	nw = (int)(width*scale);
	nh = (int)(height*scale);
	Tk_PhotoSetSize(newImage, nw, nh);
	Tk_PhotoBlank(newImage);

	Tk_PhotoGetImage(origImage, &origBlock);
	Tk_PhotoGetImage(newImage, &newBlock);

	int nx, ny, ox, oy;
	if (scale < 1.0) {
		for (ny=0; ny<nh; ny++) {
			oy = (int) (ny/scale);
			for (nx=0; nx<nw; nx++) {
				ox = (int) (nx/scale);
				*(PIXELPTR(newBlock, nx, ny, 0)) =
					*(PIXELPTR(origBlock, ox, oy, 0));
				*(PIXELPTR(newBlock, nx, ny, 1)) =
					*(PIXELPTR(origBlock, ox, oy, 1));
				*(PIXELPTR(newBlock, nx, ny, 2)) =
					*(PIXELPTR(origBlock, ox, oy, 2));
			}
		}
	} else {
		int nx0, nx1, ny0, ny1;
		unsigned char r, g, b;

		for (oy=0; oy<height; oy++) {
			ny0 = (int) (oy*scale);
			ny1 = (int) ((oy+1) * scale) - 1;
			if (ny1 >= nh) ny1 = nh-1;

			for (ox=0; ox<width; ox++) {
				nx0 = (int) (ox*scale);
				nx1 = (int) ((ox+1) * scale) - 1;
				if (nx1 >= nw) nx1 = nw-1;
				r = *(PIXELPTR(origBlock, ox, oy, 0));
				g = *(PIXELPTR(origBlock, ox, oy, 1));
				b = *(PIXELPTR(origBlock, ox, oy, 2));

				for (ny=ny0; ny<=ny1; ny++) {
					for (nx=nx0; nx<=nx1; nx++) {
						*(PIXELPTR(newBlock, nx, ny,
							   0)) = r;
						*(PIXELPTR(newBlock, nx, ny,
							   1)) = g;
						*(PIXELPTR(newBlock, nx, ny,
							   2)) = b;
					}
				}
			}
		}
	}

	Tk_PhotoPutBlock(newImage, &newBlock, 0, 0, nw, nh);
	return TCL_OK;
}
