/*
 * observe.cc --
 *
 *      FIXME: This file needs a description here.
 *
 * This code derived from InterViews library which is covered
 * by the copyright below.
 */

/*
 * Copyright (c) 1992 Stanford University
 * Copyright (c) 1992 Silicon Graphics, Inc.
 *
 * Permission to use, copy, modify, distribute, and sell this software and
 * its documentation for any purpose is hereby granted without fee, provided
 * that (i) the above copyright notices and this permission notice appear in
 * all copies of the software and related documentation, and (ii) the names of
 * Stanford and Silicon Graphics may not be used in any advertising or
 * publicity relating to the software without the specific, prior written
 * permission of Stanford and Silicon Graphics.
 *
 * THE SOFTWARE IS PROVIDED "AS-IS" AND WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS, IMPLIED OR OTHERWISE, INCLUDING WITHOUT LIMITATION, ANY
 * WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.
 *
 * IN NO EVENT SHALL STANFORD OR SILICON GRAPHICS BE LIABLE FOR
 * ANY SPECIAL, INCIDENTAL, INDIRECT OR CONSEQUENTIAL DAMAGES OF ANY KIND,
 * OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER OR NOT ADVISED OF THE POSSIBILITY OF DAMAGE, AND ON ANY THEORY OF
 * LIABILITY, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE
 * OF THIS SOFTWARE.
 */

/*
 * Observable - object to observe
 */

#include <stdlib.h>
#include "observe.h"

Observable::Observable() : nobservers_(0)
{
}

Observable::~Observable()
{
	for (int i = nobservers_; --i >= 0; )
		observers_[i]->disconnect(this);
}

void Observable::attach(Observer* o)
{
	if (nobservers_ >= MAXOBSERVERS)
		abort();
	observers_[nobservers_++] = o;
}

void Observable::detach(Observer* o)
{
	int i;
	for (i = 0; observers_[i] != o; ++i)
		if (i >= nobservers_)
			return;
	while (++i < nobservers_)
		observers_[i - 1] = observers_[i];
	--nobservers_;
}

void Observable::notify()
{
	for (int i = nobservers_; --i >= 0; )
		observers_[i]->update(this);
}

Observer::Observer() { }
Observer::~Observer() { }
void Observer::update(Observable*) { }
void Observer::disconnect(Observable*) { }
