/*
 * transmitter.cc --
 *
 *      FIXME: This file needs a description here.
 *
 * Copyright (c) 1993-2002 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * A. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * B. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * C. Neither the names of the copyright holders nor the names of its
 *    contributors may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS
 * IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

static const char rcsid[] =
    "@(#) $Header: /usr/mash/src/repository/mash/mash-1/net/transmitter.cc,v 1.17 2002/02/03 04:13:45 lim Exp $";

#include <stdio.h>
#include <stdlib.h>
#ifndef WIN32
#include <unistd.h>
#endif
#include <errno.h>
#include <string.h>
#ifdef WIN32
#include <winsock.h>
#include <io.h>
#include <sys/stat.h>
#else
#include <sys/param.h>
#include <sys/uio.h>
#include <netinet/in.h>
#include <sys/file.h>
#include <sys/stat.h>
#endif
#include "ntp-time.h"
#include "transmitter.h"
#include "net.h"
#include "tclcl.h"

#if defined(sun) && !defined(__svr4__) || (defined(_AIX) && !defined(_AIX41))
extern "C" writev(int, iovec*, int);
#endif

Transmitter::Transmitter() :
	mtu_(1024),
	nb_(0),
	nf_(0),
	np_(0),
	bps_(128000),
	nextpkttime_(0.),
	busy_(0),
	head_(0),
	tail_(0),
	loopback_(1),
	loop_layer_(1000)
{
	bind("nf_", (int*)&nf_);
	bind("np_", (int*)&np_);
	bind("nb_", (int*)&nb_);
	bind("loopback_", (int*)&loopback_);
	bind("loopbackLayer_", (int*)&loop_layer_);
}

void Transmitter::idle()
{
}

inline double Transmitter::gettimeofday() const
{
	timeval tv;
	::gettimeofday(&tv, 0);
	return (tv.tv_sec + 1e-6 * tv.tv_usec);
}

void Transmitter::loopback(pktbuf* pb)
{
	pb->release();
}

void Transmitter::update_stats(pktbuf* pb)
{
	int layer = pb->layer;
	if (layer >= loop_layer_)
		/*FIXME*/
		return;
	int cc = pb->len;
	nb_ += cc;
	++np_;
}

int Transmitter::dumpfd_ = -1;
void Transmitter::dump(int fd)
{
	dumpfd_ = fd;
#define MAGIC "RTPCLIP 1.0"
	(void)write(fd, MAGIC, sizeof(MAGIC));
}

/*FIXME*/
#ifdef WIN32
int writev(int fd, iovec* iov, int iovlen)
{
	int len = 0, n;
	for (int i = 0; i < iovlen; i++) {
		if ((n = write(fd, iov[i].iov_base, iov[i].iov_len)) == -1) {
			perror("writev");
			exit(1);
		}
		len += n;
	}
	return(len);
}
#endif

void Transmitter::dump(int fd, const pktbuf* pb) const
{
	char cliphdr[4];
	*(u_int16_t*)cliphdr = htons(pb->len);
	cliphdr[2] = 0; /* data packet (i.e., not an rtcp packet) */
	cliphdr[3] = 0; /* ? */

	/*FIXME use stdio? */
	(void)write(fd, cliphdr, 4);
	(void)write(fd, pb->data, pb->len);
}

/*
 * Time it takes in seconds to send this
 * packet at the configured bandwidth.
 */
double Transmitter::txtime(pktbuf* pb)
{
	return (8 * pb->len / double(bps_));
}

void Transmitter::recv(pktbuf* pb)
{
	if (!busy_) {
		double delay = txtime(pb);
		nextpkttime_ = gettimeofday() + delay;
		output(pb);
		/*
		 * emulate a transmit interrupt --
		 * assume we will have more to send.
		 */
		msched(int(delay * 1e-3));
		busy_ = 1;
	} else {
		if (head_ != 0) {
			tail_->next = pb;
			tail_ = pb;
		} else
			tail_ = head_ = pb;
		pb->next = 0;
	}
}

void Transmitter::timeout()
{
        /* new code per Hank Magnuski 10/25/2000 */
        double now = gettimeofday();
        for (;;) {
                pktbuf* p = head_;
                if (p != 0) {
                        head_ = p->next;
                        nextpkttime_ += txtime(p);
                        output(p);
                        int ms = int(1e-3 * (nextpkttime_ - now) * 0.80 );
                        /* make sure we will wait more than 80 ms */
                        /* allow 20% margin for error and catchup */
                        if (ms > 80) {
                                msched(ms);
                                return;
                        }
                } else {
                        busy_ = 0;
                        break;
                }
        }
}

void Transmitter::flush()
{
	if (busy_) {
		busy_ = 0;
		cancel();
	}

	pktbuf* p = head_;
	while (p != 0) {
		pktbuf* n = p->next;
		output(p);
		p = n;
	}
	head_ = 0;
}

void Transmitter::output(pktbuf* pb)
{
	if (dumpfd_ >= 0)
		dump(dumpfd_, pb);
	transmit(pb);
	update_stats(pb);
	/*
	 * Always loop back the packet from here.
	 * The subclass is responsible for releasing
	 * the packet buffer (and checking the loopback_ flag).
	 */
	loopback(pb);
}

int Transmitter::command(int argc, const char*const* argv)
{
	if (argc == 3) {
		/*FIXME*/
		if (strcmp(argv[1], "loopback-layer") == 0) {
			loop_layer_ = atoi(argv[2]);
			return (TCL_OK);
		}
	}
	return (TclObject::command(argc, argv));
}
