/*
 * rep-decoder-sc2semicompressed.cc --
 *
 *      FIXME: This file needs a description here.
 *
 * Copyright (c) 1998-2002 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * A. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * B. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * C. Neither the names of the copyright holders nor the names of its
 *    contributors may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS
 * IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#ifdef WIN32
#else
#include <sys/time.h>
#endif
#include <assert.h>
#include "inet.h"
#include "rtp.h"
#include "rep-decoder.h"
#include "bsd-endian.h"
#include "tclcl.h"
#include "renderer.h"
#include "pktbuf.h"
#include "vidreps.h"


class ScToSemicompressedDecoder : public RepDecoder {

public:
  ScToSemicompressedDecoder();
  virtual ~ScToSemicompressedDecoder();
  virtual int command(int argc, const char*const* argv);

protected:
  u_int32_t last_ts_;
  int first_flag_;
  int sent_flag_;

  int in_true_w_;
  int in_true_h_;
  int in_xoff_;
  int in_yoff_;
  int in_hsub_;
  int in_vsub_;

  virtual void post_delay_recv(pktbuf*);
  virtual void set_frame_buffer(VidRep *fb) {
    output_ = (Semicompressed *) fb;
  };

  void configure();

  ScBlock *translate(u_int32_t block_addr);

  Semicompressed *output_;
};

static class ScToSemicompressedDecoderClass : public TclClass {
public:
  ScToSemicompressedDecoderClass() : TclClass("Module/VideoDecoder/SCToSemicompressed") {}
  TclObject* create(int argc, const char*const* argv) {
    return (new ScToSemicompressedDecoder());
  }
} swd_sc_to_semicompressed_;

#define SC_HDR_SIZE 18

ScToSemicompressedDecoder::ScToSemicompressedDecoder()
  : RepDecoder(SC_HDR_SIZE)
{
  first_flag_ = 1;
  sent_flag_ = 0;

  in_xoff_ = in_true_w_ = 0;
  in_yoff_ = in_true_h_ = 0;
  in_hsub_ = in_vsub_ = 1;

  output_ = 0;
}

ScToSemicompressedDecoder::~ScToSemicompressedDecoder()
{
}

int
ScToSemicompressedDecoder::command(int argc, const char*const* argv)
{
  return (RepDecoder::command(argc,argv));
}

void ScToSemicompressedDecoder::configure()
{
  /*
   * If we have been given name of Semicompressed object
   * to put result in, set up ScImages correctly.
   */
  if (output_ != 0) {
    output_->set(inw_, inh_, in_hsub_, in_vsub_, in_true_w_, in_true_h_,
		 in_xoff_, in_yoff_);
  }
}

void ScToSemicompressedDecoder::post_delay_recv(pktbuf* pb)
{
  rtphdr* rh = (rtphdr*)pb->dp;

  if (first_flag_) {
    first_flag_ = 0;
    sent_flag_ = 0;
    last_ts_ = ntohl(rh->rh_ts);
  }

  if ((ntohl(rh->rh_ts) < last_ts_) ||
      ((ntohl(rh->rh_ts) == last_ts_) && sent_flag_)) {
    /* Late packet. Throw it away. */
    pb->release();
    return;
  }
  if ((ntohl(rh->rh_ts) > last_ts_) && (!sent_flag_)) {
    sent_flag_ = 1;
    if (output_ != 0) {
      if (callback_ != 0) {
	Tcl& tcl = Tcl::instance();
	tcl.eval(callback_);
      }
    }
  }

  /* Timing stuff
  struct timeval tv1, tv2;
  ::gettimeofday(&tv1, 0);
  */

  u_int16_t* h = (u_int16_t *) (rh+1);

  int inw = ntohs(h[0]);
  int inh = ntohs(h[1]);
  int in_tw = ntohs(h[2]);
  int in_th = ntohs(h[3]);
  int in_xoff = ntohs(h[4]);
  int in_yoff = ntohs(h[5]);
  int in_hsub = ((ntohs(h[6]) >> 8) & 0xff);
  int in_vsub = (ntohs(h[6]) & 0xff);

  u_int32_t first_block = (((u_int32_t) (ntohs(h[7]))) << 16) | (((u_int32_t) (ntohs(h[8]))) & 0x0000ffff);

  if ((inw_ != inw) || (inh_ != inh) || (in_true_w_ != in_tw) ||
      (in_true_h_ != in_th) || (in_xoff_ != in_xoff) || (in_yoff_ != in_yoff)
      || (in_hsub_ != in_hsub) || (in_vsub_ != in_vsub)) {
    resize(inw, inh);
    in_true_w_ = in_tw;
    in_true_h_ = in_th;
    in_xoff_ = in_xoff;
    in_yoff_ = in_yoff;
    in_hsub_ = in_hsub;
    in_vsub_ = in_vsub;
    configure();
  }

  int16_t* dp = (int16_t *) &(h[9]);

  if (output_ != 0) {
    u_int32_t block_addr;
    int num_ac, last_pos;
    u_int16_t run;
    int16_t value;

    output_->ts_ = ntohl(rh->rh_ts);
    output_->ssrc_ = ntohl(rh->rh_ssrc);

    block_addr = first_block;

    int lum_block_range = (in_true_w_ / 8) * (in_true_h_ / 8);
    int cr_block_range = (lum_block_range / (in_hsub_ * in_vsub_)) + lum_block_range;
    int cb_block_range = cr_block_range + (cr_block_range - lum_block_range);
    int lum_block_width = in_true_w_ / 8;
    int chr_block_width = (in_true_w_ / (8 * in_hsub_));
    int lum_xblock_off = (in_xoff_ / 8);
    int lum_yblock_off = ((in_yoff_ / 8) * lum_block_width);
    int chr_xblock_off = (in_xoff_ / (8 * in_hsub_));
    int chr_yblock_off = ((in_yoff_ / (8 * in_vsub_)) * chr_block_width);

    while (((unsigned char *) dp) - pb->data < pb->len) {
      int tbaddr, bcol, brow;
      ScBlock *scb;


      /*      scb = translate(block_addr); */

      if (block_addr < lum_block_range) {
	tbaddr = block_addr - lum_xblock_off - lum_yblock_off;
	brow = tbaddr / lum_block_width;
	bcol = tbaddr % lum_block_width;
	scb = &(output_->lum_->firstBlock[(brow*output_->lum_->width)+bcol]);
      } else if (block_addr < cr_block_range) {
	tbaddr = block_addr - lum_block_range - chr_xblock_off - chr_yblock_off;
	brow = tbaddr / chr_block_width;
	bcol = tbaddr % chr_block_width;
	scb = &(output_->cr_->firstBlock[(brow*output_->cr_->width)+bcol]);
      } else {
	tbaddr = block_addr - cr_block_range - chr_xblock_off - chr_yblock_off;
	brow = tbaddr / chr_block_width;
	bcol = tbaddr % chr_block_width;
	scb = &(output_->cb_->firstBlock[(brow*output_->cb_->width)+bcol]);
      }

      scb->dc = ntohs(*dp++);

      num_ac = 0;
      last_pos = 0;

      while((ntohs(*dp) & 0xf800) != 0xf800) {
	if (num_ac >= 63) {
	  fprintf(stderr, "Real problems\n");
	}

	if ((ntohs(*dp) & 0xf000) == 0xf000) {
	  run = (ntohs(*dp++) & 0x00ff)+1;
	  value = ntohs(*dp);
	} else {
	  run = ((ntohs(*dp) >> 12) & 0x000f) + 1;
	  value = ntohs(*dp) & 0x0fff;
	  if (value & 0x0800) {
	    /* Be sure to sign extend the AC coefficients */
	    value = value | 0xf000;
	  }
	}
	last_pos += run;

	/*	assert(last_pos > -1);
		assert(last_post < 64);
		*/

	scb->index[num_ac] = last_pos;
	scb->value[num_ac] = value;

	num_ac++;
	dp++;
      }

      u_int32_t baddr_incr;

      scb->numOfAC = num_ac;
      if ((ntohs(*dp) & 0xfc00) == 0xfc00) {
	baddr_incr = ((u_int32_t) (ntohs(*dp++) & 0x00ff)) << 16;
	baddr_incr |= ntohs(*dp);
      } else {
	baddr_incr = (ntohs(*dp) & 0x03ff);
      }
      dp++;
      block_addr += baddr_incr + 1;
    }


    /* Timing stuff
       ::gettimeofday(&tv2, 0);
       fprintf(stderr, "%u sec + %u usec to %u sec + %u usec\n",
       tv1.tv_sec, tv1.tv_usec, tv2.tv_sec, tv2.tv_usec);
       */

    last_ts_ = ntohl(rh->rh_ts);

    if (ntohs(rh->rh_flags) & RTP_M) {
      sent_flag_ = 1;
      if (callback_ != 0) {
	Tcl& tcl = Tcl::instance();
	tcl.eval(callback_);
      }
    } else {
      sent_flag_ = 0;
    }
  }

  pb->release();

}

ScBlock *
ScToSemicompressedDecoder::translate(u_int32_t block_addr)
{
  int block_width, brow, bcol;

  /* First figure out which plane */

  int lum_block_range = (in_true_w_ / 8) * (in_true_h_ / 8);
  int cr_block_range = (lum_block_range / (in_hsub_ * in_vsub_)) + lum_block_range;
  int cb_block_range = cr_block_range + (cr_block_range - lum_block_range);

  if (block_addr < lum_block_range) {
    /* In lum. */

    block_width = in_true_w_ / 8;

    block_addr -= (in_xoff_ / 8);
    block_addr -= ((in_yoff_ / 8) * block_width);

    brow = block_addr / block_width;
    bcol = block_addr % block_width;

    return &(output_->lum_->firstBlock[(brow*output_->lum_->width)+bcol]);

  } else if (block_addr < cr_block_range) {
    /* In cr. */

    block_addr -= lum_block_range;

    block_width = (in_true_w_ / (8 * in_hsub_));

    block_addr -= (in_xoff_ / (8 * in_hsub_));
    block_addr -= ((in_yoff_ / (8 * in_vsub_)) * block_width);

    brow = block_addr / block_width;
    bcol = block_addr % block_width;

    return &(output_->cr_->firstBlock[(brow*output_->cr_->width)+bcol]);

  } else if (block_addr < cb_block_range) {
    /* In cb */

    block_addr -= cr_block_range;

    block_width = (in_true_w_ / (8 * in_hsub_));

    block_addr -= (in_xoff_ / (8 * in_hsub_));
    block_addr -= ((in_yoff_ / (8 * in_vsub_)) * block_width);

    brow = block_addr / block_width;
    bcol = block_addr % block_width;

    return &(output_->cb_->firstBlock[(brow*output_->cb_->width)+bcol]);

  } else {
    return 0;
    /* Illegal */
  }
  return 0;
}

