/*
 * synch-buffer.h --
 *
 *      FIXME: This file needs a description here.
 *
 * Copyright (c) 1999-2002 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * A. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * B. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * C. Neither the names of the copyright holders nor the names of its
 *    contributors may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS
 * IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#include "module.h"
#include "pktbuf.h"
#include "media-timer.h"
#include "rtp.h"
#include "archive/lts.h"
#include "archive/timeval.h"

class SynchLTS : public LTS, public LTSTrigger {
public:
  SynchLTS() : LTSTrigger(LTS_SPEED | LTS_REFERENCE) {
    clock_speed_ = 90000.0;
  };
  void set_reference_by_mts(u_int32_t log_ts) {
    NowLogical(ftotv(((double) log_ts)/clock_speed_));
  }
  void callback(u_int32_t triggerType) {
    ActivateTriggers(triggerType);
  };
  virtual int command(int argc, const char*const* argv);
  virtual timeval NowSystem() {
    if (LTS_() != 0) {
      return LTS_()->NowLogical();
    } else {
      return LTS::NowSystem();
    }
  };
  double clock_speed() { return clock_speed_;};
  void clock_speed(double new_speed) {clock_speed_ = new_speed;};

protected:
  double clock_speed_;
};

#define SYNCH_BUFFER_MAX_QSIZE 100

class PktQueue {
public:
  PktQueue() {
    size_ = SYNCH_BUFFER_MAX_QSIZE;
    qarray_ = (pktbuf **) malloc(sizeof(pktbuf *) * size_);
    head_ = tail_ = -1;
    head_loss_ = 0;
  };

  int insert(pktbuf *pb) {
    if (head_ == -1) {
      head_ = tail_ = 0;
      qarray_[head_] = pb;
      return 1;
    } else {
      tail_ = (tail_ + 1) % size_;
      if (tail_ == head_) {
	head_ = (head_ + 1) % size_;
	head_loss_ = 1;
      }
      qarray_[tail_] = pb;
      return 0;
    }
    return 0;
  };

  int head_loss() {
    int old_head_loss = head_loss_;
    head_loss_ = 0;
    return old_head_loss;
  };

  void flush() {
    if (head_ == -1) {
      return;
    }

    int cntr = head_;
    while (cntr != tail_) {
      pktbuf *pb = qarray_[cntr];
      if (pb != 0) {
	pb->release();
      }
      qarray_[cntr] = 0;
      cntr = (cntr + 1) % size_;
    }
    head_ = tail_ = -1;
  };

  pktbuf *pop() {
    pktbuf *pb;

    if (head_ == -1) {
      return 0;
    }
    pb = qarray_[head_];
    qarray_[head_] = 0;

    if (head_ == tail_) {
      head_ = tail_ = -1;
    } else {
      head_ = (head_+1)%size_;
    }

    return pb;
  };

  int empty() {
    if (head_ == -1) {
      return 1;
    }
    return 0;
  };

  u_int32_t head_ts() {
    if (head_ == -1) {
      return 0;
    }
    pktbuf *pb = qarray_[head_];
    if (pb != 0) {
      rtphdr *rh = (rtphdr *) pb->dp;
      return rh->rh_ts;
    } else {
      return 0;
    }
  };

  u_int32_t tail_ts() {
    if (tail_ == -1) {
      return 0;
    }
    pktbuf *pb = qarray_[tail_];
    if (pb != 0) {
      rtphdr *rh = (rtphdr *) pb->dp;
      return rh->rh_ts;
    } else {
      return 0;
    }
  };

  pktbuf **qarray_;
  int head_;
  int tail_;
  int size_;
  int head_loss_;
};

class SynchBuffer : public PacketModule, public LTSTimer, public LTSTrigger {
public:
  SynchBuffer() : LTSTrigger(LTS_SPEED | LTS_REFERENCE) {
    lts_ = 0;
    reset_flag_ = 0;
    last_out_delta_ = 0.0;
    num_frames_ = 0;
  };
  ~SynchBuffer() {
    if (lts_ != 0) {
      lts_->UnsetTrigger((LTSTrigger *)this);
    }
  }
  virtual void recv(pktbuf *pb);
  virtual int command(int argc, const char*const* argv);
protected:
  int num_frames_;
  double last_out_delta_;
  virtual void callback(u_int32_t triggerType);
  int reset_flag_;
  virtual void timeout();
  PktQueue q_;
  SynchLTS *lts_;
  void send();
  void reschedule();
};

