/*
 * vidreps.h --
 *
 *      Video frame memory representation class definitions.
 *
 *      Defined in this file:
 *
 *      VidRep - base class for all video representations.
 *      Uncompressed - YUV uncompressed representation.
 *      Semicompressed - YUV representation at DCT coefficient level.
 *      JPEGCompressed - Fully compressed JPEG frame.
 *
 * Copyright (c) 1998-2002 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * A. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * B. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * C. Neither the names of the copyright holders nor the names of its
 *    contributors may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS
 * IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef VIDREP_H
#define VIDREP_H

#include "config.h"
#include "tclcl.h"
#include "module.h"
#include "tclDvmBasic.h"

class VidRep : public TclObject, public Buffer {
public:
  VidRep();
  virtual ~VidRep();

  int w_;
  int h_;
  int h_subsample_;
  int v_subsample_;
  int true_w_;
  int true_h_;
  int xoff_;
  int yoff_;
  int resized_;
  u_int32_t ssrc_;
  u_int32_t ts_;
  char *source_id_;

  virtual void copy_geometry(VidRep *temp);
  virtual int command(int argc, const char*const* argv);
  virtual Buffer *copy() {
    /* FIXME This needs to be changed, but we'll do that later. */
    return 0;
  };
};

class Uncompressed : public VidRep {
public:
  Uncompressed();
  virtual ~Uncompressed();

  int self_allocated_;

  ByteImage *lum_;
  ByteImage *cr_;
  ByteImage *cb_;

  int lum_id_;
  int cr_id_;
  int cb_id_;

  void dealloc();
  void init(int w, int h, int h_subsample, int v_subsample, int true_w,
	    int true_h, int xoff, int yoff, u_char *ldata, u_char *crdata,
	    u_char *cbdata);
  virtual int command(int argc, const char*const* argv);

  u_char *bp_;
};

class JPEGCompressed : public VidRep {
public:
  JPEGCompressed();
  virtual ~JPEGCompressed();

  int self_allocated_;
  int q_;
  int len_;

  u_char *bp_;

  void set(int w, int h, int decimation, int q, int len,
	   u_int32_t ssrc, u_int32_t ts, u_char *bp);
  void dealloc();
  virtual int command(int argc, const char*const* argv);
};

class Semicompressed : public VidRep {
public:
  Semicompressed();
  virtual ~Semicompressed();

  int self_allocated_;

  ScImage *lum_;
  ScImage *cr_;
  ScImage *cb_;

  int lum_id_;
  int cr_id_;
  int cb_id_;

  void allocate();
  void dealloc();

  void print();
  void print(int x, int y);

  virtual int command(int argc, const char*const* argv);

  void set(int w, int h, int h_subsample, int v_subsample,
	   int tw, int th, int xoff, int yoff);
};
#endif
