# al-client-aries.tcl --
#
#       FIXME: This file needs a description here.
#
# Copyright (c) 1998-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
#  @(#) $Header: /usr/mash/src/repository/mash/mash-1/tcl/applications/aries/al-client-aries.tcl,v 1.5 2002/02/03 04:21:08 lim Exp $


import AnnounceListenManager/AS/Client


# AnnounceListenManager for Aries client.  This object currently created by
# the Pathfinder web interface.
# Author: Angela Schuett  Status: pre-alpha

Class AnnounceListenManager/AS/Client/Aries -superclass \
		AnnounceListenManager/AS/Client


#
AnnounceListenManager/AS/Client/Aries instproc init {platform bw atype program} {
	$self instvar program_ service_instance_ platform_

	set program_ $program
	set platform_ $platform
	$self next $platform $bw $atype

	set service_instance_ "[pid]:[localaddr]:aries"
}

AnnounceListenManager/AS/Client/Aries private recv_msg { atype aspec addr srv_name srv_loc srv_inst ssg_port msg } {
	$self instvar ssd_

	set ssd_ $msg
}



# Called by pathfinder to retrieve the recording quality of sessions.
# Response includes list of platforms currently recording the session,
# Average quality for each, and current quality snapshot (?)
AnnounceListenManager/AS/Client/Aries public get_status {} {
	$self instvar ssd_

	if [info exists ssd_] {
		return $ssd_
	} else {
		return "Pending"
	}

}

AnnounceListenManager/AS/Client/Aries public get_platform {} {
	$self instvar platform_

	return $platform_

}
#
AnnounceListenManager/AS/Client/Aries instproc service_name {} {
	return Aries
}

#
AnnounceListenManager/AS/Client/Aries instproc service_instance {} {
	$self instvar service_instance_
	return $service_instance_
}

#
AnnounceListenManager/AS/Client/Aries instproc agent_data {} {
	$self instvar program_

	return $program_

}

#
AnnounceListenManager/AS/Client/Aries instproc register { atype aspec addr \
		srv_name srv_inst msg } {
}

#
AnnounceListenManager/AS/Client/Aries instproc unregister { atype aspec addr \
		srv_name srv_inst msg } {
}

