# ui-import.tcl --
#
#       FIXME: This file needs a description here.
#
# Copyright (c) 1998-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
#  @(#) $Header: /usr/mash/src/repository/mash/mash-1/tcl/applications/mbv2/ui-import.tcl,v 1.4 2002/02/03 04:21:59 lim Exp $


import Dialog FileBox


# --
#  FileDialog combo for selecting files to import
#    result values are:
#               1) "" if cancel pressed
#               2) a list of files selected if "import all" pressed
#               3) a list of one file if "import" pressed or double click
# --

WidgetClass Dialog/MBv2Import -superclass Dialog -configspec {
        {-directory directory Directory "" config_directory cget_directory }
} -default {
	{ *background WidgetDefault }
	{ *Button.borderWidth 1 }
	{ *Menubutton.borderWidth 1 }
	{ *Menubutton.highlightThickness 1 }
	{ *Menubutton.anchor w }
	{ *Menubutton.padX 5 }
	{ *Menubutton*font WidgetDefault }
	{ *Label*font WidgetDefault }
}


Dialog/MBv2Import private config_filetypes { args } {
        return [eval [$self subwidget filebox] config_filetypes $args]
}


Dialog/MBv2Import private cget_filetypes { args } {
        return [eval [$self subwidget filebox] cget_filetypes $args]
}


Dialog/MBv2Import private config_directory { args } {
        return [eval [$self subwidget filebox] config_directory $args]
}


Dialog/MBv2Import private cget_directory { args } {
        return [eval [$self subwidget filebox] cget_directory $args]
}


Dialog/MBv2Import private build_widget { path } {
	$self next $path

        $self instvar filetypes_
	set filetypes_(image) { {Image Files} {.gif .GIF} }
	set filetypes_(text)  { {Text Files} {.txt} }
	set filetypes_(all)   { {All Files} {*} }

	set filetypes ""
	foreach n [list image text all] {
		lappend filetypes $filetypes_($n)
	}

        set filebox [FileBox $path.filebox -filetypes $filetypes \
			-command "$self import; $self ignore_args" \
			-browsecmd "$self ignore_args"]

	frame $path.import_as_frame
	label $path.import_as_label -text "Import as:" -anchor e -width 14
	DropDown $path.import_as -variable [$self tkvarname import_as_]
	$path.import_as insert end "Image" "Text"
	$self tkvar import_as_
	trace variable import_as_ w "$self import_as_changed"
	set import_as_ Image

	pack $path.import_as_label -side left -padx 4 -in $path.import_as_frame
	pack $path.import_as -expand yes -fill x -side right \
			 -in $path.import_as_frame

        frame $path.buttons
        button $path.import -underline 0 -text "Import" \
                        -command "$self import"
        button $path.all -underline 8 -text "Import all" \
			-command "$self import_all"
        button $path.cancel -underline 0 -text "Cancel" \
                        -command "$self cancel"

        bind $path <KeyPress-Escape> "$self cancel"
        pack $path.import $path.all $path.cancel -side left -padx 5 -pady 2 \
			-in $path.buttons
        pack $path.buttons -side bottom -anchor e -pady 3
	pack $path.filebox -side top -fill both -expand 1
	pack $path.import_as_frame -side top -fill x
}


Dialog/MBv2Import private import_as_changed {args} {
	$self tkvar import_as_
	$self instvar filetypes_
	$self subwidget filebox configure -current_filetype \
			$filetypes_([string tolower $import_as_])
}


Dialog/MBv2Import public import_as { what } {
	$self tkvar import_as_
	set import_as_ [string toupper [string index $what 0]][string tolower\
			[string range $what 1 end]]
}


Dialog/MBv2Import private import {} {
        set filebox [$self subwidget filebox]
        set file [$filebox cget -filename]
        if { $file=="" } return
        set path [file join [$filebox cget -directory] $file]
        if {![file exists $path]} {
                Dialog transient MessageBox -image Icons(warning) -type ok \
				-text "File \"$path\" does not exist."
                return
        }
	$self tkvar import_as_
	$self config -result [list [string tolower $import_as_] [list $path]]
}


# used to compare strings that have a number at the end
# this is dead slow, but presumably we don't do this often
Dialog/MBv2Import private alphanumeric_cmp {str1 str2} {
        if {$str1==$str2} { return 0 }
	if {$str1> $str2} { return 1 }
	return -1

#        if {[ regexp {[a-zA-Z]*0*([0-9]*)\.[a-zA-Z0-9]*} $str1 {} n1 ] && \
#                        [ regexp {[a-zA-Z]*0*([0-9]*)\.[a-zA-Z0-9]*} $str2 \
#			{} n2]} {
#                return [expr {$n1 - $n2}]
#        }
}


Dialog/MBv2Import private import_all {} {
        set filebox [$self subwidget filebox]
        set dir [$filebox cget -directory]
        set filter [$filebox current_filter]
        set files [lsort -command "$self alphanumeric_cmp" \
			[eval glob -nocomplain [file join $dir $filter]]]
	if {0==[llength $files]} {
		# there are no satisfactory files
 		Dialog transient MessageBox -type ok -text \
				"Could not find any appropriate files in\
				\n\"$dir\"" -image Icons(warning)
		return
	}
        # The glob pattern might result in multiple matches, esp. if the
        #  file system is case insensitive, like win95
        #  make sure each file is listed only once

        set prevFile ""
	set tmplist ""
        foreach f $files {
                if {$f!=$prevFile} {
                        lappend tmplist $f
                }
                set prevFile $f
        }
	$self tkvar import_as_
	$self config -result [list [string tolower $import_as_] \
			$tmplist]
}


Dialog/MBv2Import instproc cancel { } {
	$self tkvar result_
	$self config -result ""
}

