# play_agent.tcl --
#
#       FIXME: This file needs a description here.
#
# Copyright (c) 1997-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
# @(#) $Header: /usr/mash/src/repository/mash/mash-1/tcl/applications/pathfinder/play_agent.tcl,v 1.10 2002/02/03 04:22:06 lim Exp $


Class Play_Agent

Play_Agent public init { } {

    $self instvar archive_ archive_dir_ play_list_

    # Initialize the archive and schedule directories.
    #set o [$self options]
    #$o load_preferences "mserver"
    set archive_ [$self get_option archive_root]
    set archive_dir_ [$self get_option archive_dir]
    append archive_ $archive_dir_

    # Initialize the list of sessions that can be played.
    set play_list_ {}
}


Play_Agent private update_playlist { } {

	$self instvar archive_ play_list_

	cd $archive_
        if {[string toupper [$self get_option hierarchy]] == "YES"} {
puts "hier"
	    set ctgfiles [glob -nocomplain -- */*/*.ctg]
	} else {
puts "no hier"
	    set ctgfiles [glob -nocomplain -- */*.ctg]
	}
	mtrace trcNet "-> Files received: $ctgfiles"

	# Update the play_list_ with the new catalog files.
	set new_play_list ""
	foreach f $ctgfiles {
		set elt [lsearch $play_list_ $f]
		if { $elt == -1 } {
			if { [string match *START_STREAM* [read_file $f]] } {

				set catalog [new SessionCatalog]
				$catalog open $f
				lappend new_play_list $f $catalog
				$catalog close
			}
		}  else {
			lappend new_play_list [lindex $play_list_ $elt] [lindex $play_list_ [incr elt]]
		}
	}
	set play_list_ $new_play_list
}



Play_Agent public return_progs { } {

    $self instvar play_list_
    $self update_playlist
    return $play_list_
}


Play_Agent public return_program { filename } {

    $self instvar archive_ play_list_

    set catalog [new SessionCatalog]
    cd $archive_
    if [catch {$catalog open $filename}] {
	return ""
    }
    $catalog read

    set msg [lindex [ [new SDPParser 0] parse [$catalog get_sdp]] 0]
    set program [new Program $msg]

    $catalog destroy

    return $program
}


Play_Agent public return_file_contents { filename } {

    $self instvar archive_

    cd $archive_
    return [read_file $filename]
}


Play_Agent public return_full_path { filename } {

    $self instvar archive_

    append path $archive_ $filename
    return $path
}


Play_Agent public return_rel_path { filename } {

    $self instvar archive_dir_

    append path $archive_dir_ $filename
    return $path
}

# -=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=


import HTTP_Agent

#
# The HTTP_Agent/Play_Agent class in an HTTP-aware agent that can be
# used in the MASH_Server.
#
Class HTTP_Agent/Play_Agent -superclass HTTP_Agent


HTTP_Agent/Play_Agent public init { } {

    $self next
    $self instvar agent_ play_server_

    set agent_ [new Play_Agent]

    #set o [$self options]
    #$o load_preferences "mserver"
    set play_server_ [$self get_option play_server_addr]
}


HTTP_Agent/Play_Agent instproc handle_request {url filename source reply_var} {
    upvar $reply_var reply
    $self instvar agent_ play_server_

    mtrace trcNet "-> Play_Agent::handle_request called"
    set page ""
    set status 200
    set type "text/html"

    # Check for the "magic" URLs.
    if { $url == "/playback-list.html" } {
	mtrace trcNet "-> Request for the playback list received."
	set page [$self get_page playback_list]

    } elseif { $url == "/playback-desc" } {
	mtrace trcNet "-> SDP Description requested"
	# Since the key contains the filename of the catalog file,
	# extract the SDP message to obtain the Program object.
	set program [$agent_ return_program $filename]
	if { $program == "" } {
	    set msg "No session information available."
	    set page [$self get_error_page $msg]

	} else {
	    set page [$self get_desc_page $filename playback]
	}

    } elseif { $url == "/playback" } {
	    mtrace trcNet "-> Request to playback session received."
	    set header "START_DESCR\n"
	    append header "file: [$agent_ return_full_path $filename]\n"
	    append header "server: $play_server_\n"
	    append header "END_DESCR\n"

	    set catalog "$header [$agent_ return_file_contents $filename]"
	    set argv [list -ctg $catalog]
	    set page [$self create_collaborator_mashlet $argv]
	    set type "x-mash/x-script"
    } elseif { $url == "/asplayback" } {
	    mtrace trcNet "-> Request for assisted playback received."
	    set header "START_DESCR\n"
	    append header "file: [$agent_ return_full_path $filename]\n"
	    append header "server: $play_server_\n"
	    append header "END_DESCR\n"
	    set catalog "$header [$agent_ return_file_contents $filename]"
	    set megafor [$self get_option megafor]
	    set argv [list -ctg $catalog -usemega -unicast $megafor]
	    set page [$self create_collaborator_mashlet $argv]
	    set type "x-mash/x-script"
    }

    if { $page != {} } {
	    set reply(headers) [list content-type $type]
	    set reply(data)    $page
	    set reply(status)  $status
	    return 1
    } else {
	    return 0
    }
}

# Previously, this caused the catalog file to be opened, re-read and re-parsed
# each time a sort_compare operation came.  Very bad!  For now, just sort
# based on alpabetization of directory names.  Eventually, probably want
# some sort of hierarchical structure kept in a cache?
HTTP_Agent/Play_Agent private sort_compare_ { filename1 filename2 } {

    $self instvar list_ agent_
    array set agent_array $list_

	return [string compare $filename1 $filename2]

    #set prog1 [$agent_ return_program $filename1]
    #set prog2 [$agent_ return_program $filename2]

    #return [string compare \
	#    [string tolower [[$prog1 base] set session_name_]] \
	#    [string tolower [[$prog2 base] set session_name_]]]
}
