# static_agent.tcl --
#
#       FIXME: This file needs a description here.
#
# Copyright (c) 1998-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
#  @(#) $Header: /usr/mash/src/repository/mash/mash-1/tcl/applications/pathfinder/static_agent.tcl,v 1.8 2002/02/03 04:22:06 lim Exp $


import HTTP_Agent

#
# The HTTP_Agent/Static class is an HTTP-aware agent that can be
# used to disseminate static pages
#
Class HTTP_Agent/Static -superclass HTTP_Agent

HTTP_Agent/Static public init { } {
	$self next
	$self instvar html_dir_ content_types_

	# Initialize the html directory.
	#set html_dir_ ~/mash/tcl/applications/mash_server/html/
	set html_dir_ [$self get_option html_dir]

	# setup the extension to content-type mappings
	set content_types_(.html) text/html
	set content_types_(.htm)  text/html
	set content_types_(.gif)  image/gif
	set content_types_(.jpg)  image/jpeg
	set content_types_(.jpeg) image/jpeg
	set content_types_(.mash) x-mash/x-script
	set content_types_(.tcl)  application/x-tcl
}


#
# The handle_request method is called by the MASH_Server when an
# HTTP request is received.  This method checks for the existence
# of URLs in the HTML directory and returns the corresponding page.
#
HTTP_Agent/Static public handle_request { url key source reply_var } {
	upvar $reply_var reply
	$self instvar html_dir_ content_types_
	mtrace trcNet "-> HTTP_Agent/Static::handle_request called"

	if { [string index $url 0] == "/" } {
		set url [string range $url 1 end]
	}
	if {[string index $url 0] == "/" && [string range $url 0 1] != ".."} {
		# check this to ensure that we do not inadvertently give
		# access to our full filesystem thru this URL
		return 0
	}

	set filename [file join $html_dir_ $url]
	if [catch {set fd [open $filename]}] { return 0 }
	if [catch {fconfigure $fd -translation binary}] { return 0 }
	if [catch {set reply(data) [read $fd] }] {
		catch {close $fd}
		return 0
	}
	catch {close $fd}

	set ext [string tolower [file extension $filename]]
	if [info exists content_types_($ext)] {
		set reply(headers) [list content-type $content_types_($ext)]
	} else {
		set reply(headers) [list content-type text/plain]
	}

	set reply(status) 200
	return 1
}

