# powersw-cl.tcl --
#
#       FIXME: This file needs a description here.
#
# Copyright (c) 1996-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
# @(#) $Header: /usr/mash/src/repository/mash/mash-1/tcl/applications/powerswitch-client/powersw-cl.tcl,v 1.9 2002/02/03 04:22:18 lim Exp $


#
# UI for talking to an PowerSwitchServer
#
Class PowerSwitchUI
import CheckButton

#
# init method takes window and and address specificationx
#
PowerSwitchUI public init {w addrspec} {

    $self instvar al_ status_

    set status_(0) unknown
    set status_(1) unknown

    # if addrspec includes a name, turn it into IP addr
    set firstchar [string index $addrspec 0]
    if [string match \[a-zA-Z\] $firstchar] {
	set n [lindex [split $addrspec "/"] 0]
	set p [lindex [split $addrspec "/"] 1]
        set s [gethostbyname $n]
        if { $s == "" } {
            puts "cannot find address for '$n'"
            exit
        }
        set addrspec $s/$p
    }

    set al_ [new ALM/PowerSw/Client $addrspec $self]

    $self build_gui $w
    update
    # force an update
    $al_ announce refresh_settings
    update
    $self refresh_ui
}

#
# destructor method
#
PowerSwitchUI public destroy {} {
    $self instvar al_
    delete $al_
    eval [list $self] next
}

PowerSwitchUI public print_status {} {
    $self instvar status_

    puts "0: $status_(0)"
    puts "1: $status_(1)"
    puts ""
}

PowerSwitchUI private build_gui {w} {
    $self instvar al_ status_ w_ btns_

    set w_ $w
    # build bottom informational label
    set il $w.infolabel
    frame $il -relief groove
    label $il.l -text "Power Ctrl"
    pack $il -side bottom -fill x -expand 1
    pack $il.l -in $il -side bottom

    set btns_(0) [new CheckButton $w.0 \
	    -command "$self invoke_button 0" -text "ON-AIR sign"]
    set btns_(1) [new CheckButton $w.1 \
	    -command "$self invoke_button 1" -text "lamp"]
    pack $w.0 $w.1 -side top

    bind . <q> exit
}


PowerSwitchUI private invoke_button {num} {

    $self instvar status_ al_ btns_

    if {[$btns_($num) get_val] == 0} {
	$al_ announce "set_power $num off"
    } else {
	$al_ announce "set_power $num on"
    }
}

PowerSwitchUI private refresh_ui {} {
    $self instvar status_ w_

    foreach i {0 1} {
	if {$status_($i) == "on"} {
	    $w_.$i select
	} else {
	    $w_.$i deselect
	}
    }
}


#--------------------------------------------------


import AnnounceListenManager

#
# PowerSwitch interface
#
Class ALM/PowerSw/Client -superclass AnnounceListenManager


ALM/PowerSw/Client public init {addrspec parent {mtu 1500}} {
    eval [list $self] next $addrspec $mtu

    $self instvar parent_
    set parent_ $parent
    $self ttl 16
}

#
# receive (only) state updates of the form
# "0 <on|off|unknown> 1 <on|off|unknown>" ...
#
ALM/PowerSw/Client private recv_announcement {addr port data size} {
    #puts "Msg: $addr/$port\[$size\]: $data"
    $self instvar parent_

    # filter other client's msgs
    switch [lindex $data 0] {
	"set_power" {return}
	"refresh_settings" {return}
    }

    $parent_ array set status_ $data
    $parent_ refresh_ui
}

