# app-recorder.tcl --
#
#       FIXME: This file needs a description here.
#
# Copyright (c) 1997-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
# @(#) $Header: /usr/mash/src/repository/mash/mash-1/tcl/applications/recorder/app-recorder.tcl,v 1.8 2002/02/03 04:22:24 lim Exp $


import Application RecorderUI/Input SDPParser SessionCatalog ArchiveSession/Record/RTP ArchiveSession/Record/SRM

import RecorderApi

# This class implements policy for the recorder application
# Status: Beta

Class Application/Recorder -superclass Application

Application/Recorder instproc init {argv} {
    $self next recorder
    $self instvar options_
    $self instvar api_ apip_

    set options_ [$self options]
    $self init_resources $options_
    wm withdraw .
    $self set input_ui_ [RecorderUI/Input .input_ui]
    $self set protonames_(RTP/AVP) RTP

    $self parse_args $argv

    set api_ [new RecorderApi $self $apip_]
}


Application/Recorder instproc init_resources o {
    $self instvar apip_

    set apip_ 6909

    # FIXME - it doesn't look like these calls to add_default do anything
    $o add_default drop 0
    $o add_default debug 0
    $o add_default rtPlay 0
    $o add_default record 0
    $o add_default uid none
    $o add_default trace none
    $o add_default delayParams default

    $o add_default defaultTTL 31
}


Application/Recorder instproc destroy { } {
    $self instvar input_ui_ status_ui_ catalog_
	set error ""

	if [info exists input_ui_ ] { destroy $input_ui_  }
	if [info exists status_ui_] { destroy $status_ui_ }
	if [info exists catalog_] { delete $catalog_ }
	$self next
}


Application/Recorder instproc parse_args { argv } {
	$self instvar no_input_ input_ui_ sdp_ apip_
	set no_input_ 0

	set len [llength $argv]
	set idx 0
	while { $idx < $len } {
		set option [lindex $argv $idx]
		incr idx
		switch -exact -- $option {
			-directory {
				if { $idx >= $len } {
					error "missing argument for -directory"
				}
				$input_ui_ set_directory [lindex $argv $idx]
				incr idx
			}

			-sessionid {
				if { $idx >= $len } {
					error "missing argument for -sessionid"
				}
				$input_ui_ set_session_id [lindex $argv $idx]
				incr idx
			}

			-catalog {
				if { $idx >= $len } {
					error "missing argument for\
							-catalog"
				}
				$input_ui_ set_catalog_filename \
						[lindex $argv $idx]
				incr idx
			}

			-add {
				if { $idx >= $len } {
					error "missing argument for -add"
				}
				set arg [lindex $argv $idx]
				if { [llength $arg] != 3 } {
					error "invalid argument to -add: $arg.\
							must be	\"<protocol>\
							<media> <addr>\""
				}
				$input_ui_ add_direct [lindex $arg 0] \
						[lindex $arg 1] [lindex $arg 2]
				incr idx
			}

			-noinput {
				set no_input_ 1
			}

			-sdp {
				if { $idx >= $len } {
					error "missing argument for\
							-sdp"
				}
				set sdp_ [lindex $argv $idx]
				$self handle_sdp
				incr idx
			}


			-apip {
				if { $idx >= $len } {
					error "missing argument for -apip"
				}
				set apip_ [lindex $argv $idx]
				incr idx
			}

			default {
				$self usage "Invalid argument \"$option\""
			}
		}
	}
}


Application/Recorder instproc usage { error } {
	puts "recorder: $error"
	puts ""
	puts "Usage: recorder \[options\]"
	puts "\t-add \"<protocol> <media> <address>\": add this session to"
	puts "\t                                       the record list"
	puts "\t\t\t<protocol>: SRM or RTP"
	puts "\t\t\t<media>:    mediaboard, video, audio, etc."
	puts "\t\t\t<address>:  <multicast group>/<port number>"
	puts "\t-directory <dirname>: store all files in this directory"
	puts "\t-sessionid <id>: used as a prefix for all files generated in"
	puts "\t                 this session"
	puts "\t-catalog <file>: name of the catalog file to be created"
	puts "\t                    this session"
	puts "\t-noinput: do not pop up the initial input dialog"
    	puts "\t-apip <api port>: port to run API server on"
	puts "\t-sdp <announcement>/-: if argument is '-', read standard input"
	puts "\t                       for an SDP announcement\n"

	exit -1
}


# This procedure allows the recorder to be started by handing it an sdp
# announcement.  The handle_sdp procedure then parses it, and starts
# recording with the correct parameters

Application/Recorder instproc handle_sdp { } {
	$self instvar sdp_ input_ui_ protonames_

	if { $sdp_=="-" } {
		# read the whole SDP announcement in

		set sdp_ ""
		while { [gets stdin line] > 0} {
			if { [string length $line] > 0 } {
				append sdp_ "$line\n"
			}
		}
	}
	set sdp_ [string trim $sdp_]

	puts stderr "SDP announcement is:\n$sdp_------------\n"
	set parser [new SDPParser]
	set messages [$parser parse $sdp_]
	if { [llength $messages]==0 } {
		error "invalid SDP announcement"
	}

	foreach message $messages {
		foreach media [$message set allmedia_] {
			set proto [$media set proto_]
			if [info exists protonames_($proto)] {
				set proto $protonames_($proto)
			}

			set mediatype [$media set mediatype_]
			if { [Class info instances \
					ArchiveSession/Record/$proto]=="" } {
				puts stderr "Cannot find recorder for protocol\
						$proto:$mediatype; ignoring..."
				continue
			}

			set caddr [split [$media set caddr_] "/"]
			set addr [lindex $caddr 0]/[$media set port_]
			if { [llength $caddr] > 1 } {
				append addr /none/[lindex $caddr 1]
			}
			$input_ui_ add_direct $proto $mediatype $addr
		}
	}
}


Application/Recorder instproc run { } {
	$self instvar no_input_ input_ui_ catalog_

	while { 1 } {
		if { !$no_input_ } {
			if { [$input_ui_ invoke]=="" } {
				return 0
			}
		}

		set error [$self check]
		if { $error!="" } {
			$self invoke_error $error
			continue
		}

		if { ![info exists catalog_] } {
			set catalog_ [new SessionCatalog]
		}
		set catalog_filename [$input_ui_ get_catalog_filename]
		if { $catalog_filename!="" } {
			if [catch { $catalog_ open $catalog_filename "w"} \
					error] {
				$self invoke_error "$error (while trying to\
						open catalog file)"
				continue
			}
		}
		break
	}

	if { ![$catalog_ is_opened] } {
		delete $catalog_
		unset catalog_
	}

	$self record
	return 1
}


Application/Recorder instproc invoke_error { error } {
	$self instvar no_input_
	if { $no_input_ } {
		error $error
	}

	Dialog transient MessageBox -image Icons(warning) \
			-text $error
}


Application/Recorder instproc check { } {
	$self instvar input_ui_

	if { ![file isdirectory [$input_ui_ get_directory]] } {
		return "invalid directory: [$input_ui_ get_directory]"
	}

	if { [$input_ui_ subwidget listbox info numelems] <= 0 } {
		return "must have at least one session to record"
	}

	return ""
}


Application/Recorder instproc record { } {
	$self instvar input_ui_ status_ui_ catalog_ sdp_

	if { [info exists catalog_] && [info exists sdp_] } {
		$catalog_ write_sdp $sdp_
	}

	set directory [$input_ui_ get_directory]
	set catalog_filename [$input_ui_ get_catalog_filename]
	if { [file dirname $catalog_filename]==$directory } {
		set name [file tail $catalog_filename]
	} else {
		set name $catalog_filename
	}

	set status_ui_ [RecorderUI/Status .status_ui \
			-closecmd "delete $self; exit"]
	$status_ui_ subwidget session_id insert end [$input_ui_ get_session_id]
	$status_ui_ subwidget directory  insert end $directory
	$status_ui_ subwidget catalog    insert end $name
	$status_ui_ subwidget session_id configure -state disabled
	$status_ui_ subwidget directory  configure -state disabled
	$status_ui_ subwidget catalog    configure -state disabled

	foreach id [$input_ui_ subwidget listbox info all] {
		$self create_session $id
	}

	$status_ui_ invoke
}


Application/Recorder instproc create_session { id } {
	$self instvar input_ui_ status_ui_ catalog_
	set session_ui [$status_ui_ add [$input_ui_ subwidget listbox \
			info value -id $id]]
	set id [split $id "+"]
	set protocol [lindex $id 0]
	set session [new ArchiveSession/Record/$protocol [lindex $id 1] \
			[lindex $id 2]]
	if { [info exists catalog_] } {
		$session catalog $catalog_
	}
	$session save_in [$input_ui_ get_directory]
	$session session_id [$input_ui_ get_session_id]
	$session attach_observer $session_ui
	$session_ui attach_session $session
}


Application/Recorder instproc destroy_session { session } {
}

