# ui-dcthumbnailvideo.tcl --
#
#       Stuff for starting video decoding for thumbnail and drag/drop
#
# Copyright (c) 2000-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

import DcVideoWidget
import CDcUIThumbnail

Class CDcUIThumbnail/Video -superclass CDcUIThumbnail

CDcUIThumbnail/Video public init { appDc uiMain winFrame } {
    $self next $appDc $uiMain $winFrame

    $self instvar m_source
    $self instvar m_service
    $self instvar m_iSourceId
    $self instvar m_dragNDrop

    # intialize some variables
    set m_source 0
    set m_service 0
    set m_iSourceId "not a number"
    set m_dragNDrop 0
}


CDcUIThumbnail/Video public destroy { } {
    $self next 
}


CDcUIThumbnail/Video public StartService { service } {
    $self instvar m_service

    # store away the service
    set m_service $service
}

CDcUIThumbnail/Video public StartVideo { src } {
    $self instvar m_winFrame
    $self instvar m_uiMain
    $self instvar m_dragNDrop
    $self instvar m_source
    $self instvar m_iSourceId

    set m_source $src
    set m_iSourceId [$src srcid]

    # create the frame for the thumbnail
    expr srand($m_iSourceId)
    set r [expr int(rand() * 4096)]
    set g [expr int(rand() * 4096)]
    set b [expr int(rand() * 4096)]
    set color [format "#%03x%03x%03x" $r $g $b]

    frame $m_winFrame.thumb -relief raised -borderwidth 3 -background $color
    pack $m_winFrame.thumb -side top

    # create the new thumbnail window
    $self instvar m_vwThumbnail

    set m_vwThumbnail [new DcVideoWidget $m_winFrame.thumb.video 80 60]

    $m_vwThumbnail set is_slow_ 1
    pack $m_winFrame.thumb.video -side top -fill both -expand 1

    # attach it to the source
    $m_vwThumbnail attach-decoder $m_source [$m_uiMain set m_ColorModel] 0

    # create and deal with the drag n drop object
    set m_dragNDrop [new DragNDrop $m_winFrame.thumb.video \
	    "$self DropThumbnail"]

    # now create the source id text
    label $m_winFrame.thumb.title -text $m_iSourceId
    pack $m_winFrame.thumb.title -side top -fill x
}


CDcUIThumbnail/Video public StopVideo { } {
    $self instvar m_vwThumbnail
    $self instvar m_dragNDrop
    $self instvar m_source

    $m_vwThumbnail detach-decoder $m_source
    delete $m_vwThumbnail 
    delete $m_dragNDrop
}


CDcUIThumbnail/Video public GetVideoWidget { } {
    $self instvar m_vwThumbnail
    return $m_vwThumbnail 
}

CDcUIThumbnail/Video public DropThumbnail { dragNDrop x y } {
    $self instvar m_uiMain

    #first get the preview frame
    set uiPreviewFrame [$m_uiMain set m_uiPreviewFrame]
    set uiBroadcastFrame [$m_uiMain set m_uiBroadcastFrame]

    # first test if it was meant for preview window
    if { [$uiPreviewFrame DropThumbnail $dragNDrop $self $x $y] } {
	return
    }

    # then it might be fore the broadcast window
    if { [$uiBroadcastFrame DropThumbnail $dragNDrop $self $x $y] } {
	return
    }

    # otherwise just zoom back to the original position
    $dragNDrop zoom_back

}

#
# Returns the Source/RTP object associated with this thumbnail video.
CDcUIThumbnail/Video public GetSource { } {
    $self instvar m_source
    return $m_source
}
