# ui.tcl --
#
#       FIXME: This file needs a description here.
#
# Copyright (c) 1997-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


import ScrolledListbox DropDown UIBook ImageTextButton


proc bind_all { keys script } {
	foreach key $keys {
		bind . $key $script
	}
}


Class HandoffClientUI


WidgetClass BSEntry -superclass ListLabelItem -default {
	{ *selectBackground WidgetDefault(-background) }
	{ *selectForeground WidgetDefault(-foreground) }
	{ *selectRelief     flat }
	{ *Label*font       {Helvetica 10} }
	{ *padY             0 }
	{ .borderWidth      1 }
}


BSEntry instproc config_value { option args } {
	$self instvar value_
	if { [llength $args]==0 } {
		return $value_
	} else {
		set value_ [lindex $args 0]
		$self subwidget bs_name configure -text [lindex $value_ 1]
		$self subwidget bs_lastheard configure \
				-textvariable [lindex $value_ 2]
	}
}


BSEntry instproc create_root_widget { path } {
	frame $path -class [$self info class]
}


BSEntry instproc build_widget { path } {
	label $path.bs_name -anchor w -padx 10
	label $path.bs_lastheard -padx 10 -width 8
	pack $path.bs_name -side left -fill both -expand 1
	pack $path.bs_lastheard -side left -fill y
}


BSEntry instproc config_select { value } {
	$self instvar config_
	if { $value } {
		$self config_selectbackground $config_(-selectbackground)
		$self config_selectforeground $config_(-selectforeground)
		if { !$config_(-highlight) } {
			$self widget_proc configure \
					-relief $config_(-selectrelief)
		}
	} else {
		$self config_normalbackground $config_(-normalbackground)
		$self config_normalforeground $config_(-normalforeground)
		if { !$config_(-highlight) } {
			$self widget_proc configure \
					-relief $config_(-normalrelief)
		}
	}
}


BSEntry instproc config_normalbackground { value } {
	if { ![$self set config_(-select)] } {
		$self subwidget bs_name      configure -bg $value
		$self subwidget bs_lastheard configure -bg $value
	}
}


BSEntry instproc config_normalforeground { value } {
	if { ![$self set config_(-select)] } {
		$self subwidget bs_name      configure -fg $value
		$self subwidget bs_lastheard configure -fg $value
	}
}


BSEntry instproc config_selectbackground { value } {
	if { [$self set config_(-select)] } {
		$self subwidget bs_name      configure -bg $value
		$self subwidget bs_lastheard configure -bg $value
	}
}


BSEntry instproc config_selectforeground { value } {
	if { [$self set config_(-select)] } {
		$self subwidget bs_name      configure -fg $value
		$self subwidget bs_lastheard configure -fg $value
	}
}



WidgetClass DropDown/BSList -superclass DropDown -default {
	{ *Menubutton.borderWidth 1 }
	{ *Menubutton.highlightThickness 0 }
	{ *Menubutton.padX 0 }
	{ *Menubutton.padY 0 }
	{ *Menu.font {Helvetica 10} }
	{ *BSEntry.highlightThickness 0 }
	{ *BSEntry.takeFocus 0 }
	{ *BSEntry.borderWidth 2 }
	{ *BSEntry.relief groove }
	{ *BSEntry.selectRelief groove }
	{ *BSEntry.normalRelief groove }
	{ *BSEntry.padY 0 }
}


DropDown/BSList instproc build_widget { path } {
	BSEntry $path.entry
	pack $path.entry -side left -fill both -expand 1

	$self next $path
	pack configure $path.button -side right -fill y -expand 0
}


DropDown/BSList instproc insert_item { index value } {
	$self subwidget entry configure -value $value
	$self subwidget menu insert $index command -label [lindex $value 1] \
			-command "[list $self] set_var [list $value]"
}


DropDown/BSList instproc var_trace { args } {
	upvar #0 [$self set var_] global_var

	global foo
	if [info exists foo] {
		puts "inside var_trace '$args' '$global_var'"
	}
	$self subwidget entry configure -value $global_var
}


HandoffClientUI instproc init { path } {
	$self next

	# name to addr mappings for default basestations
	$self instvar dns_
	set dns_(wl,ajanta)        208.1.90.227
	set dns_(wl,brig)          208.1.90.231
	set dns_(wl,ketch)         208.1.90.234
	set dns_(wl,carthage)      208.1.90.226
	set dns_(wl,yacht)         208.1.90.233
	set dns_(wl,cruiser)       208.1.90.229
	set dns_(wl,giza)          208.1.90.228
	set dns_(wl,dreadnaught)   208.1.90.235

	set dns_(eth,ajanta)       208.1.90.35
	set dns_(eth,brig)         208.1.90.39
	set dns_(eth,ketch)        208.1.90.42
	set dns_(eth,carthage)     208.1.90.34
	set dns_(eth,yacht)        208.1.90.41
	set dns_(eth,cruiser)      208.1.90.37
	set dns_(eth,giza)         208.1.90.36
	set dns_(eth,dreadnaught)  208.1.90.43

	$self create_ui $path
}


HandoffClientUI instproc create_ui { path } {
	$self instvar agent_

	if { [winfo toplevel $path]==$path } {
		wm title $path "Handoff Controller"
	}

	bind $path <Destroy> "if \{ \"$path\" == \"%W\" \} \
			\{$self destroy_win\}"
	if { $path=="." } { set path "" }
	$self set path_ $path

	# create the main frame

	frame $path.main
	DropDown/BSList $path.dropdown -variable [$self tkvarname curr_bs_]
	button $path.showhide -image Icons(down) -bd 0 -padx 0 -pady 0 \
			-activebackground [WidgetClass widget_default \
			-background] -command "$self show"
	pack $path.dropdown -fill x -expand 1 -pady 1 -padx 1 -side left \
			-in $path.main
	pack $path.showhide -fill y -side left -in $path.main
	pack $path.main -fill x

	# create the other frame
	frame $path.other
	$self create_book $path.book
	frame $path.buttons
	ImageTextButton $path.exit -image Icons(cross) -text Exit -underline 1\
			-options { { image.pady 0 } { text.pady 0 } } -bd 1 \
			-command "$self exit"
	ImageTextButton $path.ping -image Icons(browse) -text Ping \
			-underline 0 -bd 1 -command "$self ping" \
			-options { { image.pady 0 } { text.pady 0 } }
	label $path.logo -image Icons(cal) -padx 4 -pady 0
	bind_all "<Key-x> <Key-X> <Meta-x> <Meta-X>" "+$path.exit invoke"
	bind_all "<Key-q> <Key-Q> <Meta-q> <Meta-Q>" "+$path.exit invoke"
	bind_all "<Key-p> <Key-P> <Meta-p> <Meta-P>" "+$path.ping invoke"
	bind_all "<Key-l> <Key-L> <Meta-l> <Meta-L>" \
			"+$path.book configure -toppage $path.book.log"
	bind_all "<Key-s> <Key-S> <Meta-s> <Meta-S>" \
			"+$path.book configure -toppage $path.book.status"

	pack $path.logo -side left -anchor w -fill y -in $path.buttons
	pack $path.exit $path.ping -padx 5 -side right -anchor e -fill y \
			-in $path.buttons
	pack $path.book -fill both -expand 1 -side top -in $path.other
	pack $path.buttons -fill x -side bottom -in $path.other

	$self instvar bs_list_
	set bs_list_ [concat [$self get_option basestations] \
			[$self get_option morebs]]
	foreach entry $bs_list_ {
		set bs_name  [lindex $entry 0]
		set bs_descr [lindex $entry 1]
		if { [string trim $bs_descr]=={} } { set bs_descr $bs_name }
		set bs_statusvar [$self tkvarname bs_status_($bs_name)]
		$path.dropdown insert end \
				[list $bs_name $bs_descr $bs_statusvar]
		$path.book.status.list insert end "-id $bs_name \
				[list $bs_name $bs_descr $bs_statusvar]"
	}

	$self tkvar curr_bs_
	trace variable curr_bs_ w "$self switch_bs"
}


HandoffClientUI instproc create_book { path } {
	UIBook $path

	# create the status page
	set status [frame $path.status]
	$self tkvar dummy
	set dummy "Last heard"
	BSEntry $status.label -value "dummy Base-station\
			[$self tkvarname dummy]" -options \
			{ { bs_name.font {Helvetica 10 bold} } \
			{ bs_lastheard.font {Helvetica 10 bold} } }
	ScrolledListbox $status.list -browsecmd "$self browse" \
			-itemclass BSEntry -bd 2 -relief groove \
			-scrollbar vertical -options \
			{ { bbox.width 175 } { bbox.height 150 } \
			{ vscroll.width 10 } { vscroll.borderwidth 1 } }
	pack $status.label -fill x -padx 5
	pack $status.list  -fill both
	$path add $status text "-text Status"

	# create the log page
	set log [ScrolledText $path.log]
	$log configure -scrollbar both -options \
			{ { text.width 35 } { text.height 15 } \
			{ text.borderwidth 1 } { text.font {Helvetica 8} } \
			{ text.state disabled } { text.wrap none } \
			{ vscroll.width 10 } { vscroll.borderwidth 1 } \
			{ hscroll.width 10 } { hscroll.borderwidth 1 } }
	$path add $log text "-text Log"
	$path configure -toppage $status
}


HandoffClientUI instproc destroy_win { } {
	$self proc log { args } {
	}

	$self cancel_ping
	exit
}


HandoffClientUI instproc exit { } {
	$self instvar path_
	if { [$path_.ping cget -text] != "Ping" } {
		$self cancel_ping
	}
	exit
}


HandoffClientUI instproc set_default { addr } {
	$self instvar path_
	$self tkvar curr_bs_
	if { $addr!={} } {
		set bs_name [$self lookup_host $addr]
		if { ![catch {set bs [$path_.book.status.list info value \
				-id $bs_name]}] } {
			# this succeeded
			set curr_bs_ $bs
			return
		}
	}

	set curr_bs_ {unknown unknown {}}
}


HandoffClientUI instproc ping { } {
	$self instvar ping_chan_
	if [info exists ping_chan_] {
		$self log "Ping already in progress (pid [pid $chan])"
		return
	}

	set spec [$self get_option gatewayaddr]
	set addr [lindex [split $spec "/"] 0]
	set ping_chan_ [[System instance] start_ping $addr]
	fileevent $ping_chan_ readable "$self ping_output"

	$self instvar path_
	if { [[System instance] ping_needs_cancel] } {
		$path_.ping configure -text "Cancel ping" -underline 7 \
				-command "$self cancel_ping"
	} else {
		$path_.ping configure -state disabled
	}
}


HandoffClientUI instproc cancel_ping { } {
	$self instvar ping_chan_
	if [info exists ping_chan_] {
		[System instance] kill $ping_chan_
		#catch {close $ping_chan_}
		unset ping_chan_

		if [winfo exists .] {
			# just making sure that the root window hasn't yet
			# been destroyed

			$self ping_done
		}
	}
}


HandoffClientUI instproc ping_done { } {
	$self instvar path_
	if { [[System instance] ping_needs_cancel] } {
		$path_.ping configure -text "Ping" -underline 0 \
				-command "$self ping"
	} else {
		$path_.ping configure -state normal
	}
}


HandoffClientUI instproc ping_output { } {
	$self instvar ping_chan_
	if [info exists ping_chan_] {
		while { ![eof $ping_chan_] } {
			set data [read $ping_chan_ 256]
			if { [string length $data]==0 } break
			$self log $data -nonewline
		}

		if [eof $ping_chan_] {
			catch {close $ping_chan_}
			unset ping_chan_
			$self ping_done
		}
	}
}


HandoffClientUI instproc browse { bs_name } {
	$self tkvar curr_bs_
	$self instvar path_
	set curr_bs_ [$path_.book.status.list info value -id $bs_name]
}


HandoffClientUI instproc show { } {
	$self instvar path_
	pack $path_.other -fill both -expand 1 -padx 5 -pady 2
	$path_.showhide configure -image Icons(up) -command "$self hide"
}


HandoffClientUI instproc hide { } {
	$self instvar path_
	pack forget $path_.other
	$path_.showhide configure -image Icons(down) -command "$self show"
}


HandoffClientUI instproc attach { agent } {
	$self set agent_ $agent
	$self background_update
}


HandoffClientUI instproc switch_bs { args } {
	$self tkvar curr_bs_
	$self instvar agent_
	set bs_name [split [lindex $curr_bs_ 0] "/"]
	if { $bs_name!="unknown" } {
		set eth_name [lindex $bs_name 0]
		set wl_name  [lindex $bs_name 1]
		if { $wl_name=="" } { set wl_name $eth_name }

		$agent_ send_announcement [$self lookup_addr eth $eth_name] \
				[$self lookup_addr wl $wl_name]
	}
}


HandoffClientUI instproc background_update { } {
	$self tkvar bs_status_
	$self instvar bs_list_ agent_
	foreach entry $bs_list_ {
		set bs_name  [lindex $entry 0]
		set lastheard [$agent_ get_lastheard \
				[$self lookup_addr wl $bs_name]]
		set delay [expr [clock seconds] - $lastheard]

		if { $delay > 100 } {
			set bs_status_($bs_name) "none"
		} elseif { $delay > 10 } {
			set bs_status_($bs_name) "> $delay s."
		} else {
			set bs_status_($bs_name) "$delay s."
		}
	}

	after 2000 "$self background_update"
}


HandoffClientUI instproc log { msg {nonewline {}} } {
	if { $nonewline!={} && $nonewline!="-nonewline" } {
		error "invalid argument $nonewline"
	}

	$self instvar path_
	set text $path_.book.log.text
	$text configure -state normal
	if { $nonewline=={} } {
		$text insert end "$msg\n"
	} else {
		$text insert end "$msg"
	}

	$text yview end
	set totalLines [lindex [split [$text index end] .] 0]
	set maxLines [$self get_option maxlogsize]
	if { $totalLines > $maxLines } {
		$text delete 1.0 [expr $totalLines - $maxLines].0
	}

	$text configure -state disabled
}


HandoffClientUI instproc lookup_addr { interface name } {
	# lookup the addresses for the set of default machines
	# actually returns -wl addrs!
	$self instvar dns_
	if [info exists dns_($interface,$name)] {
		return $dns_($interface,$name)
	} else {
		return $name
	}
}


HandoffClientUI instproc lookup_host { addr } {
	$self instvar dns_

	# search the array for this IP address
	set id [array startsearch dns_]
	while { [array anymore dns_ $id] } {
		set elem [array nextelement dns_ $id]
		if { $dns_($elem)==$addr } {
			# found the entry
			set name [lindex [split $elem ","] 1]
			if { $name!="" } {
				array donesearch dns_ $id
				return $name
			}
		}
	}

	return $addr
}
