# agent-hm.tcl --
#
#       FIXME: This file needs a description here.
#
# Copyright (c) 1997-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
# @(#) $Header: /usr/mash/src/repository/mash/mash-1/tcl/hm/agent-hm.tcl,v 1.64 2002/02/03 04:27:05 lim Exp $ (UCB)


import Timer AnnounceListenManager/AS/HM ServiceCreator ServiceCreator/MeGa \
    CoordinationBus MeGa AnnounceListenManager/AS/Platform

#-
# Class: 
#   HMAgent
# Description:
#   Host Manager Agent, part of the AS1 framework
# Members:
#   maxports_ --
#     Maximum port number to assign to services.
#
#   minport_ --
#     Minimum port number to assign to services.
# 
#   uniqport_ --
#     Last unique port number assigned to a service.
# 
#   uniqid_ --
#     A unique id used to create temporary filename for downloaded
#     servlets. Initialized to 0 and is incremented by 1 everytime
#     a temp file is created.
# 
#   app_ --
#     The HM Application.
#
#   cbchannel_ --
#     Channel ID for coordination bus.
#
#   logfd_ --
#     File descriptor for a log file.  The log file is created 
#     by the application.
#
#   creators_ -- 
#     An array of ServiceCreator object for various services.
#     FIXME: we should not hardcode available services in hm.
#     It should be discovered by reading config files.
# 
#   al_ --
#     An array of announce/listen manager.
#-
Class HMAgent -superclass Timer

#-
# Class: 
#   HMAgent
# Description:
#   Host Manager Agent, part of the AS1 framework
#-
HMAgent instproc init { app logfd } {

    $self next

    $self instvar maxports_ minport_ uniqport_ app_ cbchannel_ logfd_

    $self instvar creators_
    foreach service {
        MeGa Generic Mars MediaPad Aries Device 
        FXTemp FXForwardBackEnd FXForwardFrontEnd
        } {
        set creators_($service) [new ServiceCreator/$service $self]
    }

    $self set cbchannel_ 3
    $self set app_ $app
    $self set logfd_ $logfd
    $self set uniqid_ 0
    $self set maxports_ [$self get_option maxPorts]
    $self set minport_ [$self get_option minPort]
    $self set uniqport_ $minport_

    $self log "Start"

    $self init_scripturls

    set f [$app get_option megaConfFile]
    if [file exists $f] {
        $self log "Reading config file $f."
        $self parse_conffile $f
    } 
   
    set megaspec [$self get_option megaCtrl]
    set bw [$self get_option megaCtrlBW]

    $self instvar al_

    # FIXME I'm commenting this out since there is some *really*
    #strange bug in that the spawning rsh code does not work -- i.e., the
    #rsh doesn't return if we have one too many network channels open.
    #This may be a bug in tcl/otcl, but for now, we just comment this out.

    set al_(generic) [new AnnounceListenManager/AS/HM $self $megaspec $bw]

    # FIXME Should be subclassed.
    foreach m { audio video sdp mb } {
        set spec [MeGa ctrlchan $m $megaspec]
        set al_($m) [new AnnounceListenManager/AS/HM $self $spec $bw]
    }
    # FIXME
    set spec [MeGa ctrlchan hm $megaspec]
    set al_(hm) [new AnnounceListenManager/AS/HM $self $spec $bw]

    if { [$self get_option loadBalance] != "" } {
        $al_(hm) start
        $self read_hmhosts
        $self init_load_check
    } elseif { [$self get_option targetNum] != "" } {
        $al_(hm) start
        $self set trgtnum_ [$self get_option targetNum]
        if { [$self get_option glunix] == "" } {
            $self read_hmhosts
        }
        HMAgent instproc timeout {} { $self target_check }
        $self randomize yes
        set a [$self get_option checkFactor]
        $self msched [expr $a * [$self get_option checkInterval]]
    } else {
        # Modified so that hm's always announce, even if there's only 1
        $al_(hm) start

    }
    # Added by Angie, announce our contact addr on a standard global
    # channel.  Default is no.
    if {[$self get_option allow_distrib] == "yes"} {
        set gspec [$self get_option glob_chan]
        set al_(platform) \
            [new AnnounceListenManager/AS/Platform $self $gspec $bw $al_(hm)]
        $al_(platform) start
    }
    # end
}

HMAgent instproc init_scripturls {} {
    $self instvar scripturls_

    set scripturls_ {
        http://www-mash.cs.berkeley.edu/dist/as/scripts
        http://www.cs.berkeley.edu/~elan/as/scripts
    }
}


HMAgent instproc parse_conffile { f } {
    set fd [open $f r]
    if { $fd < 0 } {
        return
    }
    $self instvar conf_
    while { [gets $fd line] > 0 } {
        set kw [lindex $line 0]
        switch $kw {
        link {
            $self add_option link yes
            set conf_(gwctrl) [lindex $line 1]
            set conf_(clientctrl) [lindex $line 2]
        }
        leaf {
            set conf_(gwctrl) [lindex $line 1]
        }
        media {
            set mtype [lindex $line 1]
            set conf_($mtype,bw) [lindex $line 2]
            set conf_($mtype,ofmt) [lindex $line 3]
        }}
    }
    close $fd
}


HMAgent instproc target_check {} {
    $self instvar al_ trgtnum_
    set n [$al_(hm) hmnum]
    # count ourselves
    incr n

    set r [expr [random]/double(0x7fffffff)]
    if { $n < $trgtnum_ } {
        # set p [expr double($trgtnum_ - $n) / $trgtnum_]
        set p [expr double($trgtnum_ - $n) / $n]
        # p could be > 1, but this code is correct since we want
        # p = min(1, N/n - 1)
        if { $r < $p } {
            $self spawn
        }
    } elseif { $n > $trgtnum_ } {
        set p [expr double($n - $trgtnum_) / $n]
        if { $r < $p } {
            $self doexit
            return
        }
    }
    # want the max here probably...
    #   set t [$al_(hm) get_timer]
    #   $self msched [$t set interval_]
    $self msched [$self get_option checkInterval]
}

HMAgent instproc doexit {} {
    $self instvar al_
    $al_(hm) announce_death
#$self log "exit 0"
    exit 0
}

HMAgent instproc log msg {
    $self instvar logfd_
    if { [$self get_option noLog] != "" } {
        return
    }
    if { $msg == "" } {
        puts $logfd_ ""
    } else {
        puts $logfd_ "\[[$self pid]\] [lrange [gettimeofday ascii] 1 3] $msg"
    }
    flush $logfd_
}

HMAgent instproc pid {} {
    return [pid]
}

HMAgent instproc destroy {} {
    $self instvar al_
    foreach m { audio video sdp mb hm } {
        delete $al_($m)
    }

    $self next
}

HMAgent instproc uniqport {} {
    # Do this for now...
    $self instvar uniqport_ portmap_ maxports_ minport_

    # Increment so that each request has a new port number
    incr uniqport_ 4
    set uniqport_ [expr ($uniqport_ % $maxports_) + $minport_]
        while { [info exists portmap_($uniqport_)] } {
        incr uniqport_ 4
        set uniqport_ [expr ($uniqport_ % $maxports_) + $minport_]
    }
    return $uniqport_
}

HMAgent instproc pick_mcastaddr {} {
    # FIXME
    set r1 [expr ([random]%250)+2]
    set r2 [expr ([random]%250)+2]

    return 224.3.$r1.$r2
}

HMAgent instproc launch { srv_name srv_loc srv_inst msg } {

    if { [$self pending_launches] >= [$self get_option maxPending] } {
        $self log "BACKLOG [$self pending_launches]"
        $self cancel_timer $srv_inst
        return
    }
    set load [HMAgent get_load]
    set hiload [$self get_option highLoad]
    $self log "LAUNCH load=$load $hiload"
    if { [$self get_option noLoad] == "" &&  $load >= $hiload } {
        $self cancel_timer $srv_inst
        return
    }

    $self instvar creators_
    set creator $creators_($srv_name)
    set h [$creator create_handler $srv_inst $msg]

    $h set gwctrl_ [$self get_option megaCtrl]
    if { [$self get_option link] == "yes" } {
        $self instvar conf_
        $h set link_ 1
        $h set gwctrl_ $conf_(gwctrl)
        $h set bw_ $conf_($mtype,bw)
        $h set ofmt_ $conf_($mtype,ofmt)

        set a [split $conf_(clientctrl) /]
        if [in_multicast [lindex $a 0]] {
            $h set clientctrl_ $conf_(clientctrl)
            $h set rportspec_ 0
        } else {
            set baseport [$self uniqport]
            set addr [lindex $a 0]
                set ports [split [lindex $a 1] :]
            set sport [lindex $ports 0]
                set rport [lindex $ports 1]
            if { $rport == "*" } {
                set rport [expr $baseport + 2]
            }
            $h set clientctrl_ $addr/$sport:$rport/1
            $h set rportspec_ $baseport:$rport
        }
    }

    set script [$self get_script $srv_name $srv_loc]
    if { $script == "" || [$h exec $script] < 0} {
        delete $h
        $self cancel_timer $srv_inst
        return 0
    } else {
        lappend handlers_ $h
    }
    $self log "announce_launch $srv_inst"
    $self instvar al_
    $al_(hm) announce_launch $srv_inst
    $self set launched_($srv_inst) 1
    # after 10000 "$self cancel_timer $srv_inst"
    return 1
}

# to autoload the ::http namespace
::http::formatQuery sdsds

HMAgent instproc get_script { name srv } {
    set o [split $srv :]
    $self instvar scriptfiles_
    # Check if we already have it
    if [info exists scriptfiles_($srv)] {
        return $scriptfiles_($srv)
    }
    $self log "get_script $name $srv"
    switch [lindex $o 0] {
    static {
        set path [$self get_option execPath]
        set n $path/[lindex $o 1]
        if [file isfile $n] {
            set scriptfiles_($srv) $n
            return $n
        }
        return ""
    }
    http {
        set d [$self get_option scriptDir]
        if ![file isdirectory $d] {
            file mkdir $d
        }
        $self instvar uniqid_
        set fname $d/as-$uniqid_.mash
        incr uniqid_
        set fd [open $fname w+]
        set t [::http::geturl $srv -channel $fd]
        close $fd
        set code [lindex [::http::code $t] 1]
        if { $code == "200" } {
            $self log "got script from $srv"
            set scriptfiles_($srv) $fname
            ::http::reset $t
            return $fname
        } else {
            $self log "can't get script from $srv."
            ::http::reset $t
            return ""
        }
    }
    urn {
        set n [lindex $o 1]
        # try static first, then url.
        set s [$self get_script $name static:$n]
        if { $s != "" } {
            $self log "got $name/$srv from static:$n: $s"
            set scriptfiles_($srv) $s
            return $s
        }
        $self instvar scripturls_
        foreach url $scripturls_ {
            set s [$self get_script $name $url/$n]
            if { $s != "" } {
                $self log "got $name/$srv from $url: $s"
                set scriptfiles_($srv) $s
                return $s
            }
        }

    }
    }
    return ""
}

HMAgent instproc unregister { aspec msg } {
    $self instvar handlers_
    if ![info exists handlers_] {
        return
    }
    set i 0
    # FIXME
    set pid [lindex [split $aspec @] 0]
    foreach h $handlers_ {
        if { [$h set pid_] == $pid } {
            delete $h
            set handlers_ [lreplace $handlers_ $i $i]
            return
        }
        incr i
    }
}

HMAgent instproc pending_timer tid {
    $self instvar tid_
    return [info exists tid_($tid)]
}

HMAgent instproc pending_launches {} {
    $self instvar launched_
    return [llength [array names launched_]]
}

HMAgent instproc cancel_timer tid {
    $self instvar tid_ launched_
    if [info exists launched_($tid)] {
        unset launched_($tid)
    }
    if { [info exists tid_($tid)] } {
        $self log "cancelled timer $tid"
        after cancel $tid_($tid)
        unset tid_($tid)
    }
}

HMAgent instproc sched_launch { srv_name srv_loc srv_inst msg } {
    $self instvar al_
    set numhm [$al_(hm) hmnum]
    set T [expr $numhm * 2000]
    set max [$self get_option maxWait]
    if { $T > $max } {
        set $T $max
    }
    # FIXME bias T by load.

    # set lambda [$self get_option lambda]
    # set r [HMAgent exp_timer $lambda $T]
    set r [HMAgent uniform_timer $T]
    $self log "timer $srv_name $srv_inst $r"

    set tid [after $r "$self launch $srv_name $srv_loc $srv_inst {$msg}"]
    $self instvar tid_
    set tid_($srv_inst) $tid
}

#
# Exponential launch timer
# F(x) = 1/(exp(lambda) - 1) * (exp(lambda/T * x) - 1)
#
# => x = T/lambda log((exp(lambda) - 1) F(x) + 1)
#
HMAgent proc exp_timer { lambda T } {
    set r [expr [random]/double(0x7fffffff)]
    set o [expr ($T/$lambda) * log((exp($lambda) - 1)*$r + 1)]
    return [expr int($o+0.5)]
}

HMAgent proc uniform_timer { T } {
    set r [expr [random]/double(0x7fffffff)]
    set o [expr $r*$T]
    return [expr int($o+0.5)]
}

HMAgent instproc suppress_timer tid {
    $self instvar tid_ launched_
    $self log "suppress timer $tid"
    if { [info exists tid_($tid)] && ![info exists launched_($tid)] } {
        after cancel $tid_($tid)
        unset tid_($tid)
    }
}

HMAgent instproc close_cb cb {
    set c [$cb set channel_]

    $self instvar chanmap_
    incr chanmap_($c) -1
    if { $chanmap_($c) <= 0 } {
        delete $cb
        unset chanmap_($c)
    }
}

HMAgent instproc open_cb { handler } {
    $self instvar cbchannel_ chanmap_
    set cb [new CoordinationBus -channel $cbchannel_]
    set chanmap_($cbchannel_) 1

    # FIXME
    incr cbchannel_

    return $cb
}

HMAgent instproc read_hmhosts {} {
    $self instvar hmhosts_ low_ high_ app_
    #global env
    #set f $env(HMHOSTFILE)
    # FIX THIS

    set path [$self get_option execPath]

    set f "$path/hmhosts"
    if { $f == "" } {
        $self log "hm: warning: no host file - disabling load_check"
        return
    }

    set fd [open $f r]
    if { $fd <  0 } {
        $self log  "hm: problems opening $f"
        return
    }

    while { [gets $fd line] > 0 } {
        if { [intoa [lookup_host_addr $line]] != [localaddr] } {
            lappend hmhosts_ $line
        }
    }
    close $fd
#   $self log hmhosts=$hmhosts_
}

HMAgent instproc init_load_check {} {

    set low_ 0
    set high_ 0

    set t [$self get_option checkInterval]
    after $t "$self load_check"
}

HMAgent instproc load_check {} {
    $self instvar app_ low_ high_ al_

    set load [$self get_load]
    set nsamples [$self get_option loadSamples]
    if { $load > [$self get_option highLoad] } {
        incr high_
        if { $high_ >= $nsamples } {
#$self log "$self spawn"
            if { [$self spawn] != 0 } {
#$self log "shed_load"
                $self shed_load
            }
        }
    } elseif { $load < [$self get_option lowLoad] } {
        incr low_
        if { $low_ >= $nsamples } {
            # Don't die if the number of hm's is at the minimum.
            set minhm [$self get_option minHmNum]
            set hmnum [$al_(hm) hmnum]
            # count ourselves
            incr hmnum
            if { $hmnum > $minhm } {
#$self log "$self die"
                $self die
                return
            }
        }
    } else {
        set low_ 0
        set high_ 0
    }

    set t [$self get_option checkInterval]
    after $t "$self load_check"
}

#HMAgent instproc get_load {} {
#   set v [catch {open "|vmstat cpu"} fd]
#   if { $v != 0 } {
#       return 0
#   }
#   # Want last field of line #4
#   gets $fd
#   gets $fd
#   set l [gets $fd]
#   close $fd
#   set n [llength $l]
#   return [expr 100-[lindex $l [expr $n-1]]]
#}

HMAgent proc get_load {} {
    set v [catch {open "|uptime"} fd]
    if { $v != 0 } {
        return 0
    }
    set l [gets $fd]
    close $fd
    # Format:
    # FIXMEX load averages: 0.00, 0.00, 0.00
    set n [llength $l]
    set avg [string trim [lindex $l [expr $n - 3]] ,]
    return $avg
}

HMAgent instproc spawn {} {
    $self instvar al_ hmhosts_ app_

    # build hmhosts_ - hmlist
        set hmlist [$al_(hm) hmaddrs]

    if { [$self get_option glunix] != "" } {
        set tlist [eval exec "glustat -s l -l"]
    } else {
        set tlist $hmhosts_
    }
    # remove any local entries we may have
    set i [lsearch -exact $tlist [localaddr]]
    set tlist [lreplace $tlist $i $i]

    foreach h $hmlist {
        set i [lsearch -exact $tlist $h]
        set tlist [lreplace $tlist $i $i]
    }
#$self log "hmlist=$hmlist"
#$self log "hmhosts=$hmhosts_"
#$self log "tlist=$tlist"
    set n [llength $tlist]
    if { $n == 0 } {
        # no hosts to spawn to
        return 0
    }
    if { [$self get_option glunix] != "" } {
        # glustat already sorted by load.
        set r 0
    } else {
        set r [expr [random] % $n]
    }
    set shost [lindex $tlist $r]

    $self dospawn $shost

    return 1
}

HMAgent instproc dospawn { shost } {
    $self instvar app_ al_
    set path [$self get_option execPath]
    set argv [$self get_option execArgs]
    set cmd [$self get_option execCmd]

    $self log "eval exec $cmd $shost $path/smash $path/hm $argv >& /dev/null &"
    if { [catch "eval exec $cmd $shost $path/smash $path/hm $argv >& /dev/null &" t] != 0 } {
        $self log "catch error: $t"
    }
}

HMAgent instproc shed_load {} {
    $self instvar handlers_
    foreach h $handlers_ {
        set pid [$h set pid_]
        # Shed 50% of the load randomly.
        set r [expr [random]/double(0x7fffffff)]
        if { $r < 0.5 } {
            $self log "exec kill -9 $pid"
            catch "eval exec kill -9 $pid"
        }
    }
}

HMAgent instproc die {} {
    $self instvar al_ dying_ app_

    set t [$self get_option deathInterval]
    set minwait [$self get_option minDeathWait]
    set r [expr ([random] % $t) + $minwait]
    set dying_ [after $r "$self really_die"]
}

HMAgent instproc really_die {} {
    $self instvar app_ al_ dying_ low_ high_

    $al_(hm) announce_death
    set minhm [$self get_option minHmNum]
    set hmnum [$al_(hm) hmnum]
    # count ourselves
    incr hmnum
    # one last check
    if { $hmnum > $minhm && \
         [$self get_load] < [$self get_option lowLoad] } {
        $self log "exit 0"
            $self doexit
    }
    # get back in the mix!
    unset dying_
    set low_ 0
    set high_ 0
    $self load_check
}

HMAgent instproc recv_death {} {
    $self instvar dying_ low_ high_

    if ![info exists dying_] {
        return
    }

    # Someone else is dying, we get a reprieve...
    after cancel $dying_
    unset dying_
    set low_ 0
    set high_ 0
    $self load_check
}
