# al-megafor.tcl --
#
#       FIXME: This file needs a description here.
#
# Copyright (c) 1997-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
# @(#) $Header: /usr/mash/src/repository/mash/mash-1/tcl/megafor/al-megafor.tcl,v 1.16 2002/02/03 04:27:42 lim Exp $

import AnnounceListenManager/AS Timer/Adaptive/ConstBW

# AnnounceListenManager for soft state gateway, a generic forwarder for
# announce/listen traffic, used in AS1 so that clients without multicast can
# connect to the system.
# Author: Elan Amir
# Status: alpha
Class AnnounceListenManager/AS/SSG -superclass AnnounceListenManager/AS

# An agent creates a manager and passes itself as "agent"
AnnounceListenManager/AS/SSG instproc init { agent spec bw {srv_inst {}}} {
	$self next $spec $bw ssg
	$self set agent_ $agent
	$self instvar srv_inst_ newtb_ oldtb_

	set f [$self get_option newTBFrac]
	set newtb_ [new TokenBucket/SSG $self [expr $bw*$f]]
	$newtb_ start
	set oldtb_ [new TokenBucket/SSG $self [expr $bw*(1-$f)]]
	$oldtb_ start
	set srv_inst_ $srv_inst
}

AnnounceListenManager/AS/SSG public destroy {} {
	$self instvar newtb_ oldtb_

	delete $newtb_
	delete $oldtb_
	$self next
}

# If a death message arrives, throw it out.  Otherwise, pass the message to the agent
AnnounceListenManager/AS/SSG instproc recv_msg { atype aspec addr srv_name srv_loc srv_inst ssg_port msg } {
	if { $srv_name == "DEATH" } {
		return
	}
	$self instvar agent_
	$agent_ recv_msg $self $atype $aspec $addr $srv_name $srv_loc $srv_inst $ssg_port "$msg"
}

AnnounceListenManager/AS/SSG instproc register args {
}

AnnounceListenManager/AS/SSG instproc unregister { atype aspec addr srv_name srv_inst msg } {
	$self instvar agent_
	eval $agent_ unregister $aspec
}

#
# We enqueue messages from the gateways here.  Since the gateway messages
# never change, a unique identifier for the message is the agent specification
# (aspec).  Thus we can identify if we have seen a given message easily by
# keying on aspec.
#
AnnounceListenManager/AS/SSG instproc enqueue { aspec msgtext } {
	$self instvar newtb_ oldtb_ q_

	if {![info exists q_($aspec)] || $q_($aspec) != $msgtext} {
		# new message
		$newtb_ add $msgtext
	} else {
		$oldtb_ add $msgtext
	}
	set q_($aspec) $msgtext
}

AnnounceListenManager/AS/SSG instproc remove_agent { aspec } {
	$self instvar q_
	if [info exists q_($aspec)] {
		unset q_($aspec)
	}
}

# A TokenBucket for use with a soft state gateway
# Author: Elan Amir
Class TokenBucket/SSG -superclass Timer/Adaptive/ConstBW

TokenBucket/SSG public init { al bw } {
	$self next $bw

	$self instvar bw_ q_ qlen_ al_ nsrcs_
	set q_ {}
	set qlen_ 8
	set al_ $al
	$self update_nsrcs 1
}

TokenBucket/SSG private timeout {} {
	$self instvar al_ q_
	if { $q_ != "" } {
		set len [$al_ announce [lindex $q_ 0]]
		$self sample_size $len
		set q_ [lrange $q_ 1 end]
	}
}

TokenBucket/SSG public add { msg } {
	$self instvar q_ qlen_
	if { [llength $q_] > $qlen_ } {
		return
	}
	# FIXME Do we want the aspec as well?
	lappend q_ $msg
}
