# agent-rtcp.tcl --
#
#       FIXME: This file needs a description here.
#
# Copyright (c) 1998-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

import MediaAgent

Class RTCPAgent -superclass MediaAgent

RTCPAgent public init ab {

    $self next
    $self instvar session_;

    set session_ [$self create_session];

    $session_ sm $self;

    if {$ab != ""} {
	$self reset $ab
    }
}

RTCPAgent public destroy {} {
    $self instvar session_ network_;

    delete $session_;
    delete $network_;
    $self next;
}

RTCPAgent public reset_spec spec {
    set ab [new AddressBlock $spec]
    $self reset $ab
    delete $ab
}

#
# Reset the address specifier of the underlying session in question.
# This allows the network objects to be dynamically reconfigured to
# facilitate higher-level control protocols that might instruct an
# application to switch multicast sessions or speak to a different
# unicast destination. FIXME should only reset the piece that matters.
#
RTCPAgent public reset ab {
    $self instvar network_ session_ sources_

    if [info exists network_] {
	delete $network_
    }
    set network_ [new NetworkManager $ab $session_ $self]

    #FIXME
    $self app_loopback 1
    $self net_loopback [$self get_option loopback]

    set key [$self get_option sessionKey]
    if { $key != "" } {
	$network_ install-key $key
    }

    # FIXME Eventually use 'attach' mechanism.
    catch {[Application instance] reset $ab}
}

#
# Return true iff an underlying network object has been
# created and attached to this RTCP agent.
#
RTCPAgent public have_network {} {
    $self instvar network_
    return [info exists network_]
}

#
# Return the network object that underlies the RTCP session,
# or return "none" if it does not yet exist.
#
RTCPAgent public network {} {
    $self instvar network_
    if ![info exists network_] {
	return none
    }
    return [$network_ data-net 0]
}

#
# Return the network address of the underlying
# communication session, or the string "none"
# if the underlying network object hasn't yet
# been created.
#
RTCPAgent public session-addr {} {
    $self instvar network_
    if ![info exists network_] {
	return none
    }
    return [[$self network] addr]
}

#
# Return the network port number of the underlying
# communication session, or the string "none"
# if the underlying network object hasn't yet
# been created.  FIXME why do we have three port methods?
#
RTCPAgent public session-port {} {
    $self instvar network_
    if ![info exists network_] {
	return none
    }
    return [[$self network] port]
}

#
# Return the inbound port number of the underlying
# communication session, or the string "none"
# if the underlying network object hasn't yet
# been created.
#
RTCPAgent public session-rport {} {
    $self instvar network_
    if ![info exists network_] {
	return none
    }
    return [[$self network] rport]
}

#
# Return the outbound port number of the underlying
# communication session, or the string "none"
# if the underlying network object hasn't yet
# been created.
#
RTCPAgent public session-sport {} {
    $self instvar network_
    if ![info exists network_] {
	return none
    }
    return [[$self network] sport]
}

#
# Return the time-to-live values used by the underlying
# communication session, or the string "none"
# if the underlying network object hasn't yet
# been created.  This value is undefined if the
# underlying session is not a multicast address.
#
RTCPAgent public session-ttl {} {
    $self instvar network_
    if ![info exists network_] {
	return none
    }
    return [[$self network] ttl]
}

#
# Turn off encryption.
#
RTCPAgent public crypt_clear {} {
    if [info exists network_] {
	$network_ crypt_clear
    }
}

RTCPAgent public create_session {} {
    return [new Session/RTCP];
}

RTCPAgent public set_maxchannel n {}

RTCPAgent public net_loopback enable {
	$self instvar network_
	$network_ loopback $enable
}

RTCPAgent public app_loopback enable {
	$self instvar session_
	$session_ set loopback_ $enable
}

