# agent-forward.tcl --
#
#       FIXME: This file needs a description here.
#
# Copyright (c) 1999-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

import VideoAgent

Class NullVideoAgent -superclass VideoAgent

NullVideoAgent instproc create_decoder src {
    set d [new Module/VideoDecoder/Null];
    return $d;
}

Class FAgent -superclass VideoAgent

FAgent instproc init {app src_spec dest_spec} {
    $self next $app $src_spec;

    $self instvar dest_spec_;

    set dest_spec_ $dest_spec;

}

FAgent instproc create_decoder src {
    $self instvar myhandler_ dest_spec_;
    $self instvar xmitters_ xmit_agents_
    $self instvar id_map_

    set new_agent [new NullVideoAgent $myhandler_ $dest_spec_]
    [$new_agent get_transmitter] set loopback_ 0;

    set new_xmitter [new SynchTransmitter];
    $new_xmitter set srcid_ [$new_agent get_local_srcid];
    $new_xmitter reset

    $new_xmitter target [$new_agent get_transmitter];

    set xmitters_($src) $new_xmitter;
    set xmit_agents_($src) $new_agent;

    set id_map_([$src srcid]) [$new_agent get_local_srcid];

    $src proc trigger_sr {args} "catch {$self trigger_sr $src}"

    $self instvar cb_store_
    if {[info exists cb_store_([$src srcid])]} {
	eval $cb_store_([$src srcid])
	unset cb_store_([$src srcid])
    }

    return $new_xmitter;
}

FAgent instproc trigger_sr src {
    $self instvar xmit_agents_;

    if {![info exists xmit_agents_($src)]} {
	return;
    }

    set agent $xmit_agents_($src);

    set in_layer [lindex [$src set layers_] 0];
    set out_layer [lindex [[$agent set local_] set layers_] 0];

    $out_layer set ref_mts_ [$in_layer set mts_];
    $out_layer set ref_ntp_sec_ [$in_layer set ntp_ts_sec_];
    $out_layer set ref_ntp_fsec_ [$in_layer set ntp_ts_fsec_];
}

FAgent instproc translate_srcid srcid {
    $self instvar id_map_;

    if {[info exists id_map_($srcid)]} {
	return $id_map_($srcid);
    }
    return "";
}

FAgent instproc install_src_callback {srcid cb} {
    $self instvar cb_store_;

    foreach s [array names xmit_agents_] {
	if {[$s srcid] == $srcid} {
	    # Found the desired source id. Call cb.
	    eval $cb;
	    return
	}
    }
    # Haven't seen this source yet. Store callback.
    set cb_store_($srcid) $cb;
}

FAgent instproc deactivate src {
    $self instvar xmitters_ xmit_agents_;

    $self next $src;
    # xmitter already destroyed by above.

    delete $xmit_agents_($src);
    unset xmitters_($src)
    unset xmit_agents_($src);

    unset id_map_([$src srcid]);
}
