# ui-Redirector.tcl --
#
#       Code for creating the UI for the Redirector.
#
# This file has the main ui component of the tgw application. Also, it contains
# many of the slightly modified superclasses to make things work... This is the
# main file with all the code in it.
#
# Copyright (c) 2000-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

import TopLevelWindow OutgoingSession

Class RedirUI -superclass TopLevelWindow -configuration { }

RedirUI instproc init { mainUI } {
    $self next .redirUI
    $self instvar ui_ 
    set ui_ $mainUI
}

RedirUI instproc build w {
    $self instvar ui_ 
    $self create-window $w "Redirection Info"
    wm withdraw $w

    global forwardVideo forwardAudio inputtedVideoDestAddr inputtedAudioSourceAddr inputtedAudioDestAddr

    frame $w.top
    checkbutton $w.top.sendVideo -text "Redirect Video" -variable forwardVideo
    grid $w.top.sendVideo
    label $w.top.videoDestLabel -anchor c -text "Destination Addr:"
    entry $w.top.videoDest -textvariable inputtedVideoDestAddr -relief sunken
    grid $w.top.videoDestLabel $w.top.videoDest -stick news
#    frame $w.middle
#    checkbutton $w.middle.sendAudio -text "Redirect Audio" -variable forwardAudio
#    grid $w.middle.sendAudio
#    label $w.middle.audioSourceLabel -anchor c -text "Source Addr:"
#    entry $w.middle.audioSource -textvariable inputtedAudioSourceAddr -relief sunken
#    grid $w.middle.audioSourceLabel $w.middle.audioSource -stick news
#    label $w.middle.audioDestLabel -anchor c -text "Destination Addr:"
#    entry $w.middle.audioDest -textvariable inputtedAudioDestAddr -relief sunken
#    grid $w.middle.audioDestLabel $w.middle.audioDest -stick news
    frame $w.bottom
    button $w.bottom.ok -text "OK" -relief raised \
	    -font [$self get_option smallfont] -highlightthickness 1 \
	    -command "$self callNewRedirector"
    button $w.bottom.cancel -text "Cancel" -relief raised \
	    -font [$self get_option smallfont] -highlightthickness 1 \
	    -command "$self toggle"
    grid $w.bottom.ok $w.bottom.cancel -stick news
#    pack $w.top $w.middle $w.bottom
    pack $w.top $w.bottom
}

RedirUI instproc toggle { } {
    global forwardVideo forwardAudio inputtedVideoDestAddr inputtedAudioSourceAddr inputtedAudioDestAddr
    set forwardVideo 0
    set forwardAudio 0
    set inputtedVideoDestAddr ""
    set inputtedAudioSourceAddr ""
    set inputtedAudioDestAddr ""
    $self next
}

RedirUI instproc callNewRedirector { } {
    $self instvar ui_
    global forwardVideo forwardAudio inputtedVideoDestAddr inputtedAudioSourceAddr inputtedAudioDestAddr
    $ui_ newRedirSession $forwardVideo $forwardAudio $inputtedVideoDestAddr $inputtedAudioSourceAddr $inputtedAudioDestAddr
    $self toggle
}

Class OutgoingRedir -superclass OutgoingSession

OutgoingRedir instproc init { fwVid fwAud vidRedir vidDest audRedir audDest } {
    $self instvar fwVid_ fwAud_ vidRedir_ vidDest_ audRedir_ audDest_
    $self setFormat "Redirection"
    set fwVid_ $fwVid
    set fwAud_ $fwAud
    set vidRedir_ $vidRedir
    set vidDest_ $vidDest
    set audRedir_ $audRedir
    set audDest_ $audDest
}

OutgoingRedir instproc makeUI { w ui src rownum } {
    $self instvar fwVid_ fwAud_ vidDest_ audDest_ vidRedir_ audRedir_
    new OutgoingRedirTransmitBox $w $src $fwVid_ $fwAud_ $vidDest_ $audDest_ $vidRedir_ $audRedir_
}

Class OutgoingRedirTransmitBox

OutgoingRedirTransmitBox instproc init { w src fwVid fwAud vidDest audDest vidRedir audRedir } {    
    $self instvar w_ src_ fwVid_ fwAud_ vidDest_ audDest_ vidRedir_ audRedir_
    set w_ $w
    set src_ $src
    set fwVid_ $fwVid
    set fwAud_ $fwAud
    set vidDest_ $vidDest
    set audDest_ $audDest
    set vidRedir_ $vidRedir
    set audRedir_ $audRedir

    label $w.first -anchor c -text Redirect -font [$self get_option smallfont] -pady 0 -borderwidth 0 -width 25
    grid $w.first
    if { $fwVid_ == 1 } {
#	if { $rownum == 1 } {
#	    set temp "Video to: $vidDest_"
#	    label $w.second -anchor w -text $temp -font [$self get_option smallfont] -pady 0 -borderwidth 0
#	    grid $w.second
#	}

	frame $w.third
	button $w.third.start -text Start -relief raised -font [$self get_option smallfont] -highlightthickness 1 -command "$self startRedir"
	button $w.third.stop -text Stop -relief raised -font [$self get_option smallfont] -highlightthickness 1 -command "$self stopRedir" -state disabled
	pack $w.third.start $w.third.stop -side left
	grid $w.third
    }

#    if { $fwAud_ == $rownum == 1 } {
#	set temp "Audio to: $audDest_"
#	label $w.forth -anchor w -text $temp -font [$self get_option smallfont] -pady 0 -borderwidth 0
#	grid $w.forth

#	frame $w.fifth
#	button $w.fifth.start -text Start -relief raised -font [$self get_option smallfont] -highlightthickness 1 -command "$self startAudioRedir"
#	button $w.fifth.stop -text Stop -relief raised -font [$self get_option smallfont] -highlightthickness 1 -command "$self stopAudioRedir" -state disabled
#	pack $w.fifth.start $w.fifth.stop -side left
#	grid $w.fifth
#    }
#    pack $w -side left 
}

OutgoingRedirTransmitBox instproc startRedir { } {
    $self instvar w_ vidRedir_ src_
    $w_.third.start configure -state disabled
    $w_.third.stop configure -state normal
    $vidRedir_ add-source [$src_ srcid]
}

OutgoingRedirTransmitBox instproc stopRedir { } {
    $self instvar w_ vidRedir_ src_
    $w_.third.stop configure -state disabled
    $w_.third.start configure -state normal
    $vidRedir_ remove-source [$src_ srcid]
}

OutgoingRedirTransmitBox instproc startAudioRedir { } {
    $self instvar w_ audRedir_
    $w_.fifth.start configure -state disabled
    $w_.fifth.stop configure -state normal
    $audRedir_ add-all-sources
}

OutgoingRedirTransmitBox instproc stopAudioRedir { } {
    $self instvar w_ audRedir_
    $w_.fifth.stop configure -state disabled
    $w_.fifth.start configure -state normal
    $audRedir_ remove-all-sources
}
