# ui-book.tcl --
#
#       FIXME: This file needs a description here.
#
# Copyright (c) 1997-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


import WidgetClass


WidgetClass UIBook -configspec {
	{ -toppage topPage TopPage {} config_top_page }
	{ -geometry geometry Geometry {} config_geometry }
	{ -usepack usePack UsePack 0 config_usepack }
}


UIBook instproc build_widget { path } {
	$self instvar max_label_height_ label_x_ current_page_ geometry_ \
			usePack_

	canvas $path.canvas -borderwidth 0 -highlightthickness 0 \
			-yscrollincrement 1 -width 4 -height 4
	$path.canvas xview moveto 0
	$path.canvas yview moveto 0
	pack $path.canvas -fill both -expand 1

	set max_label_height_ 0
	set label_x_ 4
	set current_page_ ""
	set geometry_ ""
	set usePack_ 0

	$self recalculate_3d
	bind $path.canvas <Configure> "+$self draw_border_ %w %h"
}


UIBook instproc config_top_page { option args } {
	if { [llength $args]==0 } {
		return [$self set current_page_]
	} else {
		$self page::bring_to_top [lindex $args 0]
	}
}


UIBook instproc config_geometry { option args } {
	if { [llength $args]==0 } {
		return [$self set geometry_]
	} else {
		$self instvar geometry_
		set geometry_ [lindex $args 0]
		if { $geometry_ != {} } {
			pack propagate [$self subwidget canvas] 0
			$self adjust_ "" $geometry_
		}
	}
}


UIBook instproc config_usepack { option args } {
	if { [llength $args]==0 } {
		return [$self set usePack_]
	} else {
		$self instvar usePack_
		set usePack [lindex $args 0]
		if { $usePack == $usePack_ } return

		set top [$self cget -toppage]
		if { $top != {} } { $self page::hide $top }
		set usePack_ $usePack
		if $usePack_ { pack propagate [$self subwidget canvas] 0 }
		if { $top != {} } { $self page::show $top }
	}
}


UIBook instproc add { page label_item label_options { hotkeys {} } } {
	$self next
	$self instvar page_ label_x_ max_label_height_

	# line1_ label_ frame_ label_x1_ label_x2_ label_height_

	# create the label
	set canvas [$self subwidget canvas]
	set page_($page,label) [eval $canvas create $label_item 0 0 -anchor se\
			$label_options]

	# configure the label
	set bbox [$canvas bbox $page_($page,label)]
	set width [expr [lindex $bbox 2] - [lindex $bbox 0] + 15]
	set height [expr [lindex $bbox 3] - [lindex $bbox 1] + 6]

	set x1 $label_x_
	set y1 "-$height"
	set x2 [expr $x1 + $width - 1]
	set y2 -1
	set page_($page,label_x1) $x1
	set page_($page,label_x2) $x2
	set page_($page,label_height) $height

	$canvas itemconfigure $page_($page,label) -anchor s
	$canvas coords $page_($page,label) [expr ($x1+$x2)/2] [expr $y2-1]

	$self page::hide_label $page
	$canvas bind $page_($page,label) <ButtonPress-1> \
			"$self page::bring_to_top $page"
	$canvas bind $page_($page,label) <Enter> \
			"+$canvas itemconfigure $page_($page,label) -fill \
			[WidgetClass widget_default -selectcolor]"
	$canvas bind $page_($page,label) <Leave> \
			"+$canvas itemconfigure $page_($page,label)\
			-fill [WidgetClass widget_default -foreground]"
	$canvas bind $page_($page,label) <Enter> \
			"+$canvas configure -cursor hand2"
	$canvas bind $page_($page,label) <Leave> \
			"+$canvas configure -cursor {}"

	bind $page <Configure> "+$self adjust_ $page"

	set label_x_ [expr $x2+1]
	if { $page_($page,label_height) > $max_label_height_ } {
		set diff [expr - ($page_($page,label_height) - \
				$max_label_height_)]
		$canvas yview scroll $diff units
		set max_label_height_ $page_($page,label_height)
	}

	if { $hotkeys!={} } {
		foreach hotkey $hotkeys {
			bind [winfo toplevel $canvas] $hotkey \
					"$self page::bring_to_top $page"
		}
	}
}


UIBook instproc page::bring_to_top { page } {
	$self instvar current_page_
	if { $current_page_==$page } { return }
	if { $current_page_!={} } { $self page::hide $current_page_ }
	set current_page_ $page
	if { $page!={} } { $self page::show $page }
}


UIBook instproc page::show { page } {
	$self instvar usePack_
	if $usePack_ {
		$self instvar max_label_height_
		pack $page -padx 5 -pady [expr $max_label_height_ + 5] \
				-in [$self subwidget canvas] -fill both \
				-expand 1
	} else {
		$self set current_id_ [$self subwidget canvas create window \
				3 3 -anchor nw -window $page]
	}
	$self adjust_ $page
	$self page::show_label $page
	set canv [$self subwidget canvas]
	after idle "$self draw_border_ \[winfo width $canv\] \
			\[winfo height $canv\]"
}


UIBook instproc page::hide { page } {
	$self instvar usePack_
	if $usePack_ {
		pack forget $page
	} else {
		$self instvar current_id_
		$self subwidget canvas delete $current_id_
		unset current_id_
	}

	$self page::hide_label $page
}


UIBook instproc page::hide_label { page } {
	$self instvar page_ bgDark_ bgLight_
	#$self instvar line1_ line2_ label_ label_x1_ label_x2_ label_height_\
			#book_
	set canvas [$self subwidget canvas]

	if { [info exists page_($page,line1)] } {
		$canvas delete $page_($page,line1)
		$canvas delete $page_($page,line2)
	}

	set x1 $page_($page,label_x1)
	set y1 "-$page_($page,label_height)"
	set x2 $page_($page,label_x2)
	set y2 -1
	set page_($page,line1) [$canvas create line $x1 [expr $y2+1] \
			[expr $x1+1] $y2 \
			[expr $x1+5] [expr $y1+2] [expr $x1+6] [expr $y1+1] \
			[expr $x2-6] [expr $y1+1] -fill $bgLight_]
	set page_($page,line2) [$canvas create line [expr $x2-6] [expr $y1+1]\
			[expr $x2-5] [expr $y1+2] [expr $x2-1] $y2 \
			$x2 [expr $y2+1] -fill $bgDark_]

	$canvas coords $page_($page,label) [expr ($x1+$x2)/2] [expr $y2 - 1]
}


UIBook instproc page::show_label { page } {
	$self instvar page_ bgDark_ bgLight_
	#$self instvar line1_ line2_ label_ label_x1_ label_x2_ label_height_\
			#book_
	set canvas [$self subwidget canvas]

	if { [info exists page_($page,line1)] } {
		$canvas delete $page_($page,line1)
		$canvas delete $page_($page,line2)
	}

	set x1 $page_($page,label_x1)
	set y1 "-$page_($page,label_height)"
	set x2 $page_($page,label_x2)
	set y2 -1
	set page_($page,line1) [$canvas create line [expr $x1-1] [expr $y2+1]\
			$x1 $y2 [expr $x1+4] [expr $y1+1] \
			[expr $x1+5] [expr $y1] \
			[expr $x2-5] [expr $y1] -fill $bgLight_]
	set page_($page,line2) [$canvas create line [expr $x2-5] [expr $y1] \
			[expr $x2-4] [expr $y1+1] $x2 $y2 \
			[expr $x2+1] [expr $y2+1] -fill $bgDark_]
	$canvas coords $page_($page,label) [expr ($x1+$x2)/2] [expr $y2 - 2]
}


UIBook instproc adjust_ { page {geometry {}} } {
	$self instvar current_page_ page_

	# update
	$self instvar label_x_ main_id_ max_label_height_

	if { $geometry == {} } {
		$self instvar geometry_
		if { $geometry_ != {} } return
		set page_width  [winfo width  $page]
		set page_height [winfo height $page]
	} else {
		set geometry [split $geometry x]
		set page_width  [lindex $geometry 0]
		set page_height [lindex $geometry 1]
	}

	set new_width  [expr $page_width  + 16]
	set new_height [expr $page_height + 16 + $max_label_height_]
	if { $label_x_ > $new_width } {
		set new_width [expr $label_x_+4]
	}

	$self subwidget canvas configure -width $new_width -height $new_height
}


UIBook instproc draw_border_ { width height } {
	$self instvar border1_ border2_ border3_ max_label_height_ \
			current_page_ page_ bgDark_ bgLight_

	if { $current_page_=={} } return
	set page $current_page_

	set canvas [$self subwidget canvas]
	if { [info exists border1_] } {
		# delete the original border
		$canvas delete $border1_
		$canvas delete $border2_
		$canvas delete $border3_
	}

	set x1 $page_($page,label_x1)
	set x2 $page_($page,label_x2)
	set y1 0
	set y2 [expr $height - $max_label_height_ - 1]
	set x_end [expr $width - 1]
	set border1_ [$canvas create line $x1 $y1 0 $y1 0 $y2 -fill $bgLight_]
	set border2_ [$canvas create line 0 $y2 $x_end $y2 $x_end $y1 \
			-fill $bgDark_]
	set border3_ [$canvas create line $x_end $y1 $x2 $y1 -fill $bgLight_]
}


UIBook public recalculate_3d {} {
	$self instvar bgDark_ bgLight_
	set rgb [winfo rgb . [$self subwidget canvas cget -bg]]
	set r [lindex $rgb 0]
	set g [lindex $rgb 1]
	set b [lindex $rgb 2]

	set dr [expr $r*3/5]
	set dg [expr $g*3/5]
	set db [expr $b*3/5]

	set l1 [expr $r*7/5]
	if {$l1 > 65535} {
		set lr 65535
	} else {
		set l2 [expr (65535+$r)/2]
		if {$l1 > $l2} { set lr $l1 } else { set lr $l2 }
	}

	set l1 [expr $g*7/5]
	if {$l1 > 65535} {
		set lg 65535
	} else {
		set l2 [expr (65535+$g)/2]
		if {$l1 > $l2} { set lg $l1 } else { set lg $l2 }
	}

	set l1 [expr $b*7/5]
	if {$l1 > 65535} {
		set lb 65535
	} else {
		set l2 [expr (65535+$b)/2]
		if {$l1 > $l2} { set lb $l1 } else { set lb $l2 }
	}

	set bgDark_  [format "#%04x%04x%04x" $dr $dg $db]
	set bgLight_ [format "#%04x%04x%04x" $lr $lg $lb]
}


proc set_var__ { object variable args } {
    if { [llength $args]==1 } {
	$object set $variable $args
    }
    return [$object set $variable]
}


Class UIBook__
UIBook__ instproc init { path } {
    $self next
    $self instvar canvas_ main_ main_id_ max_label_height_ label_x_ \
	    current_page_
    set canvas_ [canvas $path -borderwidth 0 -highlightthickness 0 \
	    -yscrollincrement 1 -width 4 -height 4]
    $canvas_ xview moveto 0
    $canvas_ yview moveto 0
    bind $canvas_ <Destroy> "+delete $self"
    set main_ [frame $path.frame]
    set main_id_ [$canvas_ create window 2 2 -anchor nw -window $main_]
    set max_label_height_ 0
    set label_x_ 4
    set current_page_ ""
    #set pages_ ""
}


UIBook__ instproc adjust { page } {
    $self instvar current_page_
    # update
    $self instvar label_x_ main_id_ max_label_height_ canvas_
    set label_height [$page label_height]
    set frame [$page frame]

    set page_width  [winfo width  $frame]
    set page_height [winfo height $frame]
    set new_width  [expr $page_width  + 14]
    set new_height [expr $page_height + 14 + $max_label_height_]
    if { $label_x_ > $new_width } { set new_width [expr $label_x_+4] }

    #set current_width  [$canvas_ cget -width ]
    #set current_height [$canvas_ cget -height]

    #if {$new_width > $current_width } { set current_width  $new_width  }
    #if {$new_height> $current_height} { set current_height $new_height }

    $canvas_ configure -width $new_width -height $new_height
    $self draw_border $page
}


UIBook__ instproc canvas { args } {
    eval set_var [list $self] canvas_ $args
}


UIBook__ instproc main_frame { args } {
    eval set_var [list $self] main_ $args
}


UIBook__ instproc label_x { args } {
    eval set_var [list $self] label_x_ $args
}


UIBook__ instproc label_height { args } {
    eval set_var [list $self] max_label_height_ $args
}


UIBook__ instproc current_page { args } {
    eval set_var [list $self] current_page_ $args
}


#UIBook__ instproc new_page { page } {
#    $self instvar pages_
#    lappend pages_ $page
#}


UIBook__ instproc draw_border { page } {
    $self instvar border1_ border2_ border3_ canvas_ max_label_height_
    if { [info exists border1_] } {
	# delete the original border
	$canvas_ delete $border1_
	$canvas_ delete $border2_
	$canvas_ delete $border3_
    }

    set x1 [$page label_x1]
    set x2 [$page label_x2]
    set y1 0
    set y2 [expr [$canvas_ cget -height] - $max_label_height_ - 1]
    set x_end [expr [$canvas_ cget -width]-1]
    set border1_ [$canvas_ create line $x1 $y1 0 $y1 0 $y2 -fill #F0F0F0]
    set border2_ [$canvas_ create line 0 $y2 $x_end $y2 $x_end $y1 \
	    -fill #828282]
    set border3_ [$canvas_ create line $x_end $y1 $x2 $y1 -fill #F0F0F0]
}


Class UIPage__
UIPage__ instproc init { book label_item label_options { hotkeys {} } } {
    $self next
    $self instvar book_ line1_ label_ frame_ label_x1_ label_x2_ label_height_
    set book_ $book
    set canvas_ [$book_ canvas]
    set label_ [eval $canvas_ create $label_item 0 0 -anchor se $label_options]
    set bbox [$canvas_ bbox $label_]
    set width_  [expr [lindex $bbox 2] - [lindex $bbox 0] + 15]
    set height_ [expr [lindex $bbox 3] - [lindex $bbox 1] + 6]

    set x1 [$book_ label_x]
    set y1 "-$height_"
    set x2 [expr $x1 + $width_ - 1]
    set y2 -1
    set label_x1_ $x1
    set label_x2_ $x2
    set label_height_ $height_

    $canvas_ itemconfigure $label_ -anchor s
    $canvas_ coords $label_ [expr ($x1+$x2)/2] [expr $y2-1]

    $self hide_label
    $canvas_ bind $label_ <ButtonPress-1> "$self bring_to_top"
    $canvas_ bind $label_ <Enter> "+$canvas_ itemconfigure $label_ -fill blue"
    $canvas_ bind $label_ <Leave> "+$canvas_ itemconfigure $label_ -fill black"
    $canvas_ bind $label_ <Enter> "+$canvas_ configure -cursor hand2"
    $canvas_ bind $label_ <Leave> "+$canvas_ configure -cursor {}"

    set frame_ [frame [$book_ main_frame].$self]
    bind $frame_ <Configure> "+$book_ adjust $self"
    bind $frame_ <Destroy> "+delete $self"
    #$self build $frame_

    $book_ label_x [expr $x2+1]
    set max [$book_ label_height]
    set canvas [$book canvas]
    if { $label_height_ > $max } {
	set diff [expr - ($label_height_ - $max)]
	$canvas yview scroll $diff units
	$book_ label_height $label_height_
    }

    if { $hotkeys!={} } {
	foreach hotkey $hotkeys {
	    bind [winfo toplevel $canvas_] $hotkey "$self bring_to_top"
	}
    }
}


UIPage__ instproc bring_to_top { } {
    $self instvar book_
    set current [$book_ current_page]
    if { $current==$self } { return }
    if { $current!={} } { $current hide }
    $book_ current_page $self
    $self show
}


UIPage__ instproc show { } {
    $self instvar frame_ book_
    pack $frame_ -expand true -fill both -padx 5 -pady 5
    $book_ adjust $self
    $self show_label
}


UIPage__ instproc hide { } {
    $self instvar frame_
    pack forget $frame_
    $self hide_label
}


UIPage__ instproc hide_label { } {
    $self instvar line1_ line2_ label_ label_x1_ label_x2_ label_height_ book_
    set canvas_ [$book_ canvas]

    if { [info exists line1_] } {
	$canvas_ delete $line1_
	$canvas_ delete $line2_
    }

    set x1 $label_x1_
    set y1 "-$label_height_"
    set x2 $label_x2_
    set y2 -1
    set line1_ [$canvas_ create line $x1 [expr $y2+1] [expr $x1+1] $y2 \
	    [expr $x1+5] [expr $y1+2] [expr $x1+6] [expr $y1+1] \
	    [expr $x2-6] [expr $y1+1] -fill #F0F0F0]
    set line2_ [$canvas_ create line [expr $x2-6] [expr $y1+1] \
	    [expr $x2-5] [expr $y1+2] [expr $x2-1] $y2 $x2 [expr $y2+1] \
	    -fill #828282]

    $canvas_ coords $label_ [expr ($x1+$x2)/2] [expr $y2 - 1]
}


UIPage__ instproc show_label { } {
    $self instvar line1_ line2_ label_ label_x1_ label_x2_ label_height_ book_
    set canvas_ [$book_ canvas]

    if { [info exists line1_] } {
	$canvas_ delete $line1_
	$canvas_ delete $line2_
    }

    set x1 $label_x1_
    set y1 "-$label_height_"
    set x2 $label_x2_
    set y2 -1
    set line1_ [$canvas_ create line [expr $x1-1] [expr $y2+1] $x1 $y2 \
	    [expr $x1+4] [expr $y1+1] [expr $x1+5] [expr $y1] \
	    [expr $x2-5] [expr $y1] -fill #F0F0F0]
    set line2_ [$canvas_ create line [expr $x2-5] [expr $y1] \
	    [expr $x2-4] [expr $y1+1] $x2 $y2 [expr $x2+1] [expr $y2+1] \
	    -fill #828282]
    $canvas_ coords $label_ [expr ($x1+$x2)/2] [expr $y2 - 2]
}


UIPage__ instproc label_x1 { args } {
    eval set_var [list $self] label_x1_ $args
}


UIPage__ instproc label_x2 { args } {
    eval set_var [list $self] label_x2_ $args
}


UIPage__ instproc label_height { args } {
    eval set_var [list $self] label_height_ $args
}


UIPage__ instproc frame { args } {
    eval set_var [list $self] frame_ $args
}


#set book [new UIBook__ .frame]
#Class P1 -superclass UIPage__
#P1 instproc build { path } {
#    label $path.l -text "Yatin"
#    entry $path.e
#    pack $path.l $path.e -side top
#}

#
#Class P2 -superclass UIPage__
#P2 instproc build { path } {
#    label $path.l -text "Yatin"
#    entry $path.e
#    pack $path.l $path.e -side left
#    label $path.l2 -text "Chawathe"
#    entry $path.e2
#    pack $path.l2 $path.e2 -side left
#}


#set p1 [new P1 $book "Test"]
#set p2 [new P2 $book "Foobar"]
#$p1 build [$p1 frame]
#$p2 build [$p2 frame]
#pack .frame -padx 10 -pady 10
#$p1 bring_to_top
