# migs.desc.tcl --
#
#       An example Broadcast Description file.  This one is used for the
#       BMRC MIG Seminar
#
# Copyright (c) 2000-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

Import enable

import BroadcastDescription_RvcStream BroadcastDescription_ReplayStream \
       BroadcastDescription_RealNetworksStream BroadcastDescription_Rule \
       BroadcastDescription_StreamStatus

namespace eval BroadcastSpecification {
    variable startButton
    variable endButton
    variable main
    variable presentation
    variable realNetworks
    variable checkIDs
    variable rules
    variable uiBuilt 0
    variable stateArray
    variable projector
    variable mainDisplay
    variable presentationDisplay
    variable realNetworksDisplay
}

# FIXME - this should be fixed to allow reset and restart

proc BroadcastSpecification::cleanUp {} {
    $BroadcastSpecification::main destroy
    $BroadcastSpecification::presentation destroy
    $BroadcastSpecification::realNetworks destroy
    $BroadcastSpecification::mainDisplay destroy
    $BroadcastSpecification::presentationDisplay destroy
    $BroadcastSpecification::realNetworksDisplay destroy
    $BroadcastSpecification::projector destroy
}


#
# this function is called by the framework before the timer is started
#
proc BroadcastSpecification::broadcastSpecification {base} {
    # use this for the system clock
    #  BroadcastDescription::broadcastClock

    # build UI

    # add frames for labels showing current state of Real Networks
    set curFrame $base.views
    frame $curFrame
    pack $curFrame -side top -fill x

    frame $curFrame.main
    pack $curFrame.main -side top -fill x
    frame $curFrame.presentation
    pack $curFrame.presentation -side top -fill x
    frame $curFrame.real
    pack $curFrame.real -side top -fill x

    # add buttons
    set curFrame $base.buttons
    frame $curFrame
    pack $curFrame -side top -fill x

    set curFrame $base.buttons.start
    frame $curFrame
    pack $curFrame -side top -fill x
    set BroadcastSpecification::startButton [button $curFrame.start -text "Start" -command "BroadcastSpecification::startPush" -state normal]
    pack $curFrame.start -side left -fill x -expand true

    set curFrame $base.buttons.end
    frame $curFrame
    pack $curFrame -side top -fill x
    set BroadcastSpecification::endButton [button $curFrame.end -text "End" -command "BroadcastSpecification::endPush" -state disabled]
    pack $curFrame.end -side left -fill x -expand true

    # insert padding frames so when checking/unchecking rules, don't
    #  accidentally hit "end"
    set curFrame $base.spacer
    frame $curFrame -height 40
    pack $curFrame -side top -fill x
    pack propagate $curFrame false
#    label $curFrame.msg -text "This space intentionally left blank"
#    pack $curFrame.msg -side top -fill y -expand true

    # make frame for rule checkbuttons
    set rulesBase $base.rules
    frame $rulesBase
    pack $rulesBase -side top -fill x

    #### test stuff ####
    #button $base.query -text "Query" -command "BroadcastSpecification::query"
    #pack $base.query -side top

    # init stuff
    set BroadcastSpecification::main [new BroadcastDescription_RvcStream main htsr.bmrc.berkeley.edu]
    set BroadcastSpecification::presentation [new BroadcastDescription_RvcStream presentation htsr2.bmrc.berkeley.edu]
    set BroadcastSpecification::realNetworks [new BroadcastDescription_RealNetworksStream real]
    set BroadcastSpecification::projector [new BroadcastDescription_Projector]
    # create the status objects so the current source of streams is shown
    set BroadcastSpecification::mainDisplay [new BroadcastDescription_StreamStatus $BroadcastSpecification::main $base.views.main]
    set BroadcastSpecification::presentationDisplay [new BroadcastDescription_StreamStatus $BroadcastSpecification::presentation $base.views.presentation]
    set BroadcastSpecification::realNetworksDisplay [new BroadcastDescription_StreamStatus $BroadcastSpecification::realNetworks $base.views.real]

    # FIXME - this stuff below hasn't been implemented yet
    #set replay [new BroadcastDescription_ReplayStream media0.bmrc.berkeley.edu]
    #set roomAudio [new BroadcastDescription_RoomAudio]

    # get some shorter handles to the objects
    set main $BroadcastSpecification::main
    set presentation $BroadcastSpecification::presentation
    set realNetworks $BroadcastSpecification::realNetworks
    set projector $BroadcastSpecification::projector
    set mainDisplay $BroadcastSpecification::mainDisplay
    set presentationDisplay $BroadcastSpecification::presentationDisplay
    set realNetworksDisplay $BroadcastSpecification::realNetworksDisplay

    # set up the state machine
    set BroadcastSpecification::stateArray(index) 0
    set BroadcastSpecification::stateArray(numStates) 3
    set BroadcastSpecification::stateArray(0) wideCamera
    set BroadcastSpecification::stateArray(1) wideCamera
    set BroadcastSpecification::stateArray(2) audienceCamera

    # define the rules

#    set check "\$BroadcastDescription::broadcastClock < 3"
#    set cmd "puts stdout \"clock is \$BroadcastDescription::broadcastClock\""
#    BroadcastDescription_when $check $cmd

    # this rule handles the case where the director changes the presentation
    #   stream to be the laptop or something else during the title segment,
    #   before the lecture starts
    set description "real follows presenation"
    set check "(\[$realNetworks source\] != \[$presentation source\])"
    set cmd "$realNetworks source \[$presentation source\]"
    set BroadcastSpecification::rules(realFollowsPresentation) [new BroadcastDescription_Rule $rulesBase $description $check $cmd 0]

    set description "real follows main"
    set check "(\[$realNetworks source\] != \[$main source\])"
    set cmd "$realNetworks source \[$main source\]"
    set BroadcastSpecification::rules(realFollowsMain) [new BroadcastDescription_Rule $rulesBase $description $check $cmd 0]

    set description "presentation follows projector"
    set check "(\[$projector source\] != \[$presentation source\])"
    set cmd "$presentation source \[$projector source\]"
    set BroadcastSpecification::rules(presentationFollowsProjector) [new BroadcastDescription_Rule $rulesBase $description $check $cmd 0]

    set time 120
    set check "(\[$main duration\] > $time) && (\[$main source\] == \"speakerCamera\")"
    set cmd "BroadcastSpecification::goNextState"
    set description "if speaker > $time\nswitch to next"
    set BroadcastSpecification::rules(speakerTimeout) [new BroadcastDescription_Rule $rulesBase $description $check $cmd 0]

    set time 30
    set check "(\[$main duration\] > $time) && (\[$main source\] == \"wideCamera\")"
    set cmd "$main source speakerCamera"
    set description "if wide > $time\nswitch to speaker"
    set BroadcastSpecification::rules(wideTimeout) [new BroadcastDescription_Rule $rulesBase $description $check $cmd 0]

    set time 30
    set check "(\[$main duration\] > $time) && (\[$main source\] == \"audienceCamera\")"
    set cmd "$main source speakerCamera"
    set description "if audience > $time \nswitch to speaker"
    set BroadcastSpecification::rules(audienceTimeout) [new BroadcastDescription_Rule $rulesBase $description $check $cmd 0]


    # initial actions
    $main source speakerCamera
    # FIXME - this may not be the right thing to do, they may be using their
    #   laptop, do we rely on the director to change manually or should we
    #   read what is being sent to the projector and switch to that?
    #
    # the problem is that right now there is no way to know if the projector
    #   is taking the RGB or video input
    #
    # for now we use what the projector is showing, and assume it's showing
    #   an RGB input
    $presentation source [$projector source]
    $realNetworks source [$projector source]
    $presentation broadcast true
    $realNetworks broadcast true

    $BroadcastSpecification::rules(presentationFollowsProjector) enable
    $BroadcastSpecification::rules(realFollowsPresentation) enable
}

proc BroadcastSpecification::startPush {} {
    $BroadcastSpecification::startButton configure -state disabled
    $BroadcastSpecification::endButton configure -state normal

    # turn off the rule that has Real follow the presentation source
    $BroadcastSpecification::rules(realFollowsPresentation) disable
    $BroadcastSpecification::rules(speakerTimeout) enable
    $BroadcastSpecification::rules(wideTimeout) enable
    $BroadcastSpecification::rules(audienceTimeout) enable
    $BroadcastSpecification::rules(realFollowsMain) enable

    $BroadcastDescription::405Control onAir_turnOn
    $BroadcastDescription::RecorderControl record

    $BroadcastSpecification::main source speakerCamera
    $BroadcastDescription::405Control camera_fadeIn speaker
    $BroadcastSpecification::main broadcast true
    $BroadcastSpecification::presentation broadcast true
    $BroadcastSpecification::realNetworks broadcast true

    # FIXME - this is not the best way to do it; we would like to specify a
    #   rule that says 180 sec after the start button is pushed, do this
    after 180000 "BroadcastSpecification::oneMinuteTrigger"
}

proc BroadcastSpecification::endPush {} {
    $BroadcastSpecification::startButton configure -state disabled
    $BroadcastSpecification::endButton configure -state disabled

    # disable all the rules except the real follower
    foreach index [array names BroadcastSpecification::rules] {
	if {$index != "realFollowsMain"} {
	    $BroadcastSpecification::rules($index) disable
	}
    }
    $BroadcastDescription::VdControl disableQM
    # fade out on speaker
    $BroadcastSpecification::main source speakerCamera
    $BroadcastDescription::405Control camera_fadeOut speaker

    # wait for the fade to complete
    after 5000 "BroadcastSpecification::closing"
}

proc BroadcastSpecification::closing {} {
    $BroadcastDescription::RecorderControl stop
    $BroadcastSpecification::main broadcast false
    $BroadcastSpecification::presentation broadcast false
    $BroadcastSpecification::realNetworks broadcast false
    $BroadcastDescription::405Control onAir_turnOff
    $BroadcastSpecification::rules(realFollowsMain) disable

    # reset the state of the camera so other people won't be confused
    $BroadcastDescription::405Control camera_fadeIn speaker
}

proc BroadcastSpecification::query {} {
    set speakerClock [$BroadcastSpecification::main duration]
    set speakerSource [$BroadcastSpecification::main source]
    set presentationClock [$BroadcastSpecification::presentation duration]
    set presentationSource [$BroadcastSpecification::presentation source]
    set realNetworksClock [$BroadcastSpecification::realNetworks duration]
    set realNetworksSource [$BroadcastSpecification::realNetworks source]

    puts stdout "main"
    puts stdout "\tduration=$speakerClock"
    puts stdout "\tsource=$speakerSource"
    puts stdout "presentation"
    puts stdout "\tduration=$presentationClock"
    puts stdout "\tsource=$presentationSource"
    puts stdout "realNetworks"
    puts stdout "\tduration=$realNetworksClock"
    puts stdout "\tsource=$realNetworksSource"
}

proc BroadcastSpecification::getNextState {} {
    set index $BroadcastSpecification::stateArray(index)
    set nextIndex [expr $index + 1]
    if {$nextIndex == $BroadcastSpecification::stateArray(numStates)} {
	set nextIndex 0
    }
    set BroadcastSpecification::stateArray(index) $nextIndex

    return $BroadcastSpecification::stateArray($index)
}

proc BroadcastSpecification::goNextState {} {
    set nextState [BroadcastSpecification::getNextState]
    if {$nextState == "audienceCamera"} {
	BroadcastSpecification::audienceSweep
    }
    $BroadcastSpecification::main source $nextState
}

proc BroadcastSpecification::audienceSweep {} {
    set vcc_ [$BroadcastDescription::405Control getVcc3Client "audience"]
    $vcc_ doNoWait vcc3_sweep 2 340 -170 -430 -59 1000

}

# this is called one minute after the start button is pushed
proc BroadcastSpecification::oneMinuteTrigger {} {
    # FIXME - we should tell the QM which host to switch
    $BroadcastDescription::VdControl enableQM
}

