#!/usr/sww/bin/perl

# docompares.pl --
#
#       FIXME: This file needs a description here.
#
# Copyright (c) 2001-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

if(!defined($baseDir=$ARGV[0]))
{
    print("Usage: docompares <base directory> <label> [<range file>]\n");
    exit;
}
if(!defined($label=$ARGV[1]))
{
    print("Usage: docompares <base directory> <label> [<range file>]\n");
    exit;
}
if(!defined($rangeFile=$ARGV[2]))
{
    $rangeFile = "ranges.txt";
}

# defaults
$histSize = 50;
$timeSlice = 250;

# directories
$dataDir = "./work/$baseDir/data";
$resultsDir = "./results/$baseDir/$label";
$tmpDir = "./tmp";

system("mkdir ./results/$baseDir");
system("mkdir ./results/$baseDir/$label");

# commands
$compareCmd = "./compare.pl";

# get the ranges we want
open(INFILE, $rangeFile);
$val = <INFILE>;
chomp($val);
@speakerThresholds = split(/ /, $val);
$val = <INFILE>;
chomp($val);
@leftThresholds = split(/ /, $val);
$val = <INFILE>;
chomp($val);
@centerThresholds = split(/ /, $val);
$val = <INFILE>;
chomp($val);
@rightThresholds = split(/ /, $val);
$sizeST = $#speakerThresholds + 1;
$sizeLT = $#leftThresholds + 1;
$sizeCT = $#centerThresholds + 1;
$sizeRT = $#rightThresholds + 1;
close(INFILE);

for($w = 0; $w < $sizeST; $w++)
{
    $st = $speakerThresholds[$w];
    for($x = 0; $x < $sizeLT; $x++)
    {
	$lt = $leftThresholds[$x];
	for($y = 0; $y < $sizeCT; $y++)
	{
	    $ct = $centerThresholds[$y];
	    for($z = 0; $z < $sizeRT; $z++)
	    {
		$rt = $rightThresholds[$z];

		# actual stuff
		$tag = "$st.$lt.$ct.$rt.$histSize.$timeSlice";
		print("$tag\n");
		system "$compareCmd $baseDir $st $lt $ct $rt $histSize $timeSlice > /dev/null";
		system("mkdir $resultsDir/$tag");
		system "mv ./results/analyze.* $resultsDir/$tag/.";
		system "mv ./results/graph.* $resultsDir/$tag/.";
	    }
	}
    }
}

