# handler.tcl --
#
#       Video Handler for VideoAgent and VideoPipeline
#
# Copyright (c) 1998-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
#  @(#) $Header: /usr/mash/src/repository/mash/mash-1/tcl/video/handler.tcl,v 1.12 2002/02/03 04:40:08 lim Exp $


import Session/Scuba/Vic VideoAgent VideoPipeline AddressBlock

#
# This class serves as a higher level component for setting up a
# VideoAgent and VideoPipeline, with SCUBA if desired.
#
Class VideoHandler

#
# Given the video <i>spec</i>, create a VideoAgent and VideoPipeline.
# SCUBA will be used if the options database has "useScuba".
#
VideoHandler public init { spec {callback {}} } {
	$self instvar agent_ vpipe_ localbw_

	set agent_ [new VideoAgent $self $spec $callback]
	set vpipe_ [new VideoPipeline $agent_]

	set localbw_ [$self get_option videoSessionBW]
	if { $localbw_ == "" } {
		set localbw_ [$self get_option maxVideoSessionBW]
	}
	$agent_ sessionbw $localbw_

	if { [$self get_option useScuba] != "" } {
		$self init_scuba $spec
	}
}

#
# Accessor function: retrieve VideoAgent.
#
VideoHandler public agent {} {
	return [$self set agent_]
}

#
# Accessor function: retrieve VideoPipeline
#
VideoHandler public vpipe {} {
	return [$self set vpipe_]
}

#
# Initialize the scuba announce/listen protocol for reflecting receiver
# interest back the sources in a multicast session.  Derives the scuba
# control channel from the session address specification.
#
VideoHandler private init_scuba { spec } {
	$self instvar scuba_sess_ localbw_
	$self instvar vpipe_ agent_

	set rtpsess [$agent_ set session_]
	$rtpsess rtcp-thumbnail 1

	if { $spec != "" } {
		set ab [new AddressBlock $spec]
	} else {
		set ab ""
	}

	set scuba_sess_ [new Session/Scuba/Vic $rtpsess $agent_ $ab $vpipe_]
	if { $ab != "" } {
		delete $ab
	}

	$scuba_sess_ sessionbw $localbw_

	$agent_ attach $scuba_sess_
}

#
VideoHandler instproc reset { ab } {
	$self instvar scuba_sess_
	if { [$self get_option useScuba] != "" } {
		$scuba_sess_ reset $ab
	}
}

