/*
 * tg-app.cc --
 *
 *      FIXME: This file needs a description here.
 *
 * Copyright (c) 1998-2002 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * A. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * B. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * C. Neither the names of the copyright holders nor the names of its
 *    contributors may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS
 * IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */


#include "tg-app.h"

/* $Header: /usr/mash/src/repository/mash/mash-1/tgmb/client/tg-app.cc,v 1.5 2002/02/03 04:17:39 lim Exp $ */

Word   TG_NetworkApplication::AppNetRefnum = 0;
SDWord TG_NetworkApplication::AppNetTimeout= 1000;
SWord  errno = 0;


Boolean
TG_FldSetText(FieldPtr fld, CharPtr val, ULong len)
{
	if (len == (ULong)-1) {
		len = StrLen(val);
	}

	VoidHand txthand = MemHandleNew(len+1);
	if (txthand) {
		CharPtr txtptr = (CharPtr) MemHandleLock(txthand);
		if (txtptr) {
			txtptr[0] = '\0';
			if (val) MemMove(txtptr, val, len);
			txtptr[len] = '\0';
		}
		else {
			MemHandleUnlock(txthand);
			MemHandleFree(txthand);
			return false;
		}

		MemHandleUnlock(txthand);
		FldFreeMemory(fld);
		FldSetTextHandle(fld, (Handle)txthand);
	}
	else {
		return false;
	}
	return true;
}


Boolean
TG_FldSetText(FieldPtr fld, ULong val)
{
	char valStr[16];
	StrPrintF(valStr, "%lu", val);
	return TG_FldSetText(fld, valStr);
}


DWord
TG_Application::Run()
{
	DWord retval;
	if ( (retval = Init())!=0 ) return retval;
	if ( (retval = EventLoop())!=0 ) return retval;
	if ( (retval = Cleanup())!=0 ) return retval;
	return 0;
}


DWord
TG_Application::EventLoop()
{
	Word errW;
	DWord err;
	EventType ev;
	do {
		if (!EvtEventAvail()) {
			err = ServiceIdle();
			if (err) return err;
		}
		EvtGetEvent(&ev, timeout_);
		if (! SysHandleEvent (&ev))
			if (! MenuHandleEvent (NULL, &ev, &errW))
				if (! HandleEvent(&ev))
					FrmDispatchEvent (&ev);
	} while (ev.eType != appStopEvent);
	return 0;
}


TG_NetworkApplication::TG_NetworkApplication(Word selectEventType,
					     Word timerEventType)
	: TG_Application(), maxSocketID_(0), netLibOpen_(false),
	  selectEventType_(selectEventType), timerEventType_(timerEventType),
	  lastTimerId_(0), error_("")
{
    EvtLoopTimeout(200);
    netFDZero(&readFDs_);
}


DWord
TG_NetworkApplication::Init()
{
    Err err;

    err = SysLibFind("Net.lib", &AppNetRefnum);
    ErrFatalDisplayIf(err, "You do not have the required Network Library.");

    Error("You do not have the required Network Library.");
    return err;
}


DWord
TG_NetworkApplication::Cleanup()
{
	if (netLibOpen_)
		return NetLibClose();
	return 0;
}


DWord
TG_NetworkApplication::NetLibOpen()
{
	Word iferr;
	Byte allup;

	/* Open the net library */
	errno = ::NetLibOpen(AppNetRefnum, &iferr);
	if ((errno && errno != netErrAlreadyOpen) || iferr) {
		if (!errno || errno == netErrAlreadyOpen) {
			::NetLibClose(AppNetRefnum, false);
			Error("NetLibOpen failed");
			return netErrNotOpen;
		}
		Error("NetLibOpen failed");
		return errno;
	}
	errno = NetLibConnectionRefresh(AppNetRefnum, true, &allup, &iferr);
	if (errno || !allup) {
		::NetLibClose(AppNetRefnum, false);
		Error("NetLibConnectionRefresh failed");
		return ((errno) ? errno : netErrNotOpen);
	}

	netLibOpen_ = true;
	return 0;
}


DWord
TG_NetworkApplication::NetLibClose()
{
    errno = ::NetLibClose(AppNetRefnum, false);
    if (errno) {
	    Error("NetLibClose failed");
    }
    else {
	    netLibOpen_ = false;
    }
    return errno;
}


DWord
TG_NetworkApplication::ConnectionRefresh() {
	Boolean allup;
	Word    iferr;
	Err     err;
	err = NetLibConnectionRefresh(AppNetRefnum,true,&allup,&iferr);

	if (err || !allup) {
		Error("NetLibConnectionRefresh failed");
		return err ? err : netErrNotOpen;
	}

	return 0;
}


Word
TG_NetworkApplication::RegisterTimer(ULong after_ms, VoidPtr clientData)
{
	for (Word i=0; i<MAX_TIMERS; i++) {
		if (timers_[i].timeout==0) {
			// this slot is empty
			timers_[i].timeout = TimGetTicks() +
				(after_ms * sysTicksPerSecond)/1000;
			timers_[i].id = lastTimerId_++;
			timers_[i].clientData = clientData;
			return i;
		}
	}
	return (Word)-1;
}


void
TG_NetworkApplication::UnregisterTimer(Word id)
{
	Word i;
	for (i=0; i<MAX_TIMERS; i++) {
		if (timers_[i].id==id) break;
	}

	for (i++; i<MAX_TIMERS; i++) {
		if (timers_[i].timeout==0) break;
		timers_[i-1] = timers_[i];
	}
	timers_[i-1].timeout = 0;
	timers_[i-1].id = 0;
	timers_[i-1].clientData = NULL;
}


DWord
TG_NetworkApplication::PollNetwork()
{
	NetFDSetType readFDs;
	NetSocketRef i;
	SWord retval;
	long timeout;

	if (maxSocketID_==0) return 0;

	netFDZero(&readFDs);
	(void) memcpy(&readFDs, &readFDs_, sizeof(readFDs));
	netFDSet(sysFileDescStdIn, &readFDs);

#if OLD
	// Now, don't select at all until the system is quiet. This should be
	// fair -- if two things are sending, neither will get starved because
	// when the select does eventually fire, it will put both on the queue.
	// So both will have to be serviced before either can be again, because
	// select events are the only way to get serviced.
	if (EvtEventAvail()) return 0;

	// If there is an event waiting, don't block on select
	timeout = EvtEventAvail() ? 0 : AppNetTimeout;
#endif
	timeout = AppNetTimeout;
	ULong now = TimGetTicks();
	if (timers_[0].timeout!=0 && long(timers_[0].timeout - now) < timeout)
		timeout = timers_[0].timeout - now;

	if (timeout > 0) {
		retval = NetLibSelect(AppNetRefnum, maxSocketID_+1, &readFDs,
				      NULL, NULL, timeout, &errno);
	} else retval = 0;
	if (retval < 0) {
		Error("Select error");
		return errno;
	} else if (retval > 0) {
		// we have an event pending
		// first check if there is a stdin event (i.e. pen event)
		// and give it priority over the socket events
		// This ensures that the pen input does not get blocked
		// if the socket is constantly receiving data

		if (netFDIsSet(sysFileDescStdIn, &readFDs)) {
			return 0;
		}

		EvtNetSelect evt;

		for (i=sysFileDescStdIn+1; i <= maxSocketID_; i++) {
 			if (netFDIsSet(i, &readFDs)) {
				memset(&evt, 0, sizeof(evt));
				evt.sock = i;
				evt.clientData = clientData_[i];
				TG_AddUsrUniqueEventToQueue(selectEventType_,
							    (DWord) i,
							    &evt,
							    sizeof(evt));
			}
		}
	} else {
		// a timer might have expired
		if (timers_[0].timeout!=0 &&
		    TimGetTicks() >= timers_[0].timeout) {
			EvtTimeout evt;
			evt.timerId = timers_[0].id;
			evt.clientData = timers_[0].clientData;
			TG_AddUsrUniqueEventToQueue(timerEventType_,
						    (DWord)evt.timerId,
						    &evt, sizeof(evt));

			// remove this timer from the list
			Word i;
			for (i=1; i<MAX_TIMERS; i++) {
				if (timers_[i].timeout==0) break;
				timers_[i-1] = timers_[i];
			}
			timers_[i-1].timeout = 0;
			timers_[i-1].id = 0;
			timers_[i-1].clientData = NULL;
		}
	}

	return 0;
}


/*
 * TG_NetworkApplication::Connect
 *
 * On error, sets the internal variable `error_' to a descriptive message
 * and returns -1. Otherwise, it returns a new NetSocketRef.
 */
NetSocketRef
TG_NetworkApplication::Connect(const char *addrStr, NetSocketTypeEnum type)
{
    CharPtr host;
    const char *port;
    int len;
    NetSocketRef sock;

    /* Parse the port number out of addr_str */
    port = addrStr;
    while(*port && *port != ':' && *port != '/') ++port;
    if (port==addrStr || (*port != ':' && *port != '/')) {
	Error("Bad format for connection string");
	return -1;
    }

    len = port-addrStr-1;
    host = (CharPtr) MemPtrNew(len+1);
    if (! host) {
	    Error("Could not allocate memory");
	    return -1;
    }
    StrNCopy(host, addrStr, len);
    host[len] = '\0';
    sock = Connect(host, StrAToI(port), type);
    MemPtrFree(host);
    return sock;
}


NetSocketRef
TG_NetworkApplication::Connect(const char *host, UShort port,
			       NetSocketTypeEnum type)
{
	NetSocketRef cursock;

	NetHostInfoBufPtr h;
	NetHostInfoPtr hres;

	NetSocketAddrINType sockaddr;

	Err err;
	ULong **addrp;


	cursock = NetLibSocketOpen(AppNetRefnum, netSocketAddrINET, type,
				   0, AppNetTimeout, &errno);

	if (cursock < 0) {
		Error("SocketOpen failed");
		return -1;
	}

	if (type==netSocketTypeDatagram) {
		// if this is a UDP socket, them bind it!
		sockaddr.family = AF_INET;
		sockaddr.port = 0;
		sockaddr.addr = INADDR_ANY;
		if (NetLibSocketBind(AppNetRefnum, cursock,
				     (NetSocketAddrType*)&sockaddr,
				     sizeof(sockaddr), AppNetTimeout*3,
				     &err) < 0) {
			Error("NetLibSocketBind failed");
			return(-1);
		}
	}

	h = (NetHostInfoBufPtr)MemPtrNew(sizeof(NetHostInfoBufType));
	hres = NetLibGetHostByName(AppNetRefnum, (CharPtr)host, h,
				   AppNetTimeout*3, &errno);

	if (!hres) {
		Error("Bad hostname");
		return -1;
	}

	sockaddr.family = AF_INET;
	sockaddr.port = htons(port);
	sockaddr.addr = INADDR_ANY;
	for (addrp = (ULong **)h->hostInfo.addrListP; *addrp; ++addrp) {
		ULong a = htonl(**addrp);
		if (a != INADDR_ANY) {
			sockaddr.addr = a;
			break;
		}
	}
	MemPtrFree(h);

	err = NetLibSocketConnect(AppNetRefnum, cursock,
				  (NetSocketAddrType*)&sockaddr,
				  sizeof(NetSocketAddrType), AppNetTimeout,
				  &errno);
	if (err) {
		Error("NetLibSocketConnect failed");
		NetLibSocketClose(AppNetRefnum, cursock, AppNetTimeout,&errno);
		return -1;
	}

	return cursock;
}


DWord
TG_NetworkApplication::Disconnect(NetSocketRef sock)
{
    if (NetLibSocketClose(AppNetRefnum, sock, AppNetTimeout, &errno)) {
	    Error("NetLibSocketClose failed");
    }
    UnregisterSocket(sock);
    return errno;
}

Err
TG_NetworkApplication::Send(NetSocketRef sock, VoidPtr buf, Word len)
{
	SWord status = 1;
	Word sent = 0;
	while (sent < len) {
		status = NetLibSend(AppNetRefnum, sock, buf+sent, len-sent,
				    0x0, NULL, 0, AppNetTimeout, &errno);
		if (status > 0) sent += status;
		else break;
	}

	if (status == 0) {
		Error("EOF encountered");
		errno = netErrSocketClosedByRemote;
	}
	return errno;
}

SWord
TG_NetworkApplication::Receive(NetSocketRef sock, VoidPtr buf, Word size)
{
	SWord bytes;

	bytes = NetLibReceive(AppNetRefnum, sock, buf, size,
			       0x0, NULL, NULL, AppNetTimeout, &errno);
	if (bytes < 0) {
		Error("NetLibReceive failed");
	}

	return bytes;
}


SWord
TG_NetworkApplication::DmReceive(NetSocketRef sock, VoidPtr buf, Word offset,
				 Word size)
{
	SWord bytes;

	bytes = NetLibDmReceive(AppNetRefnum, sock, buf, offset, size,
				 0x0, NULL, NULL, AppNetTimeout, &errno);
	if (bytes < 0) {
		Error("NetLibDmReceive failed");
	}

	return bytes;
}


DWord
TG_NetworkApplication::GetLocalIP()
{
	Word index=0, instance, len=sizeof(DWord);
	DWord creator, ip;
	while (NetLibIFGet(AppNetRefnum, index++, &creator,
			   &instance)!=netErrInvalidInterface) {
		if (creator==netIFCreatorPPP) {
			if (NetLibIFSettingGet(AppNetRefnum, creator, instance,
					       netIFSettingActualIPAddr,
					       &ip, &len)==0)
				return ip;
		}
	}
	return 0;
}
