/*
 * tgmb-cmd.h --
 *
 *      FIXME: This file needs a description here.
 *
 * Copyright (c) 1998-2002 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * A. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * B. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * C. Neither the names of the copyright holders nor the names of its
 *    contributors may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS
 * IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 *  @(#) $Header: /usr/mash/src/repository/mash/mash-1/tgmb/client/tgmb-cmd.h,v 1.4 2002/02/03 04:17:39 lim Exp $
 */

#ifndef MASH_TGMB_CMD_H
#define MASH_TGMB_CMD_H

#define TGMB_CLIENT
#include "tgmb-enum.h"
#include "win-2bit.h"
#include "tgmb-defs.h"

class TGMB_Book;
class TGMB_Command {
public:
	TGMB_Command(TGMB_Book *b) : currentType_(CanvObjType_Line),
		handle_(NULL), points_(NULL), nPoints_(0), size_(0), book_(b) {
			handle_ = MemHandleNew(25 * sizeof(PointType));
			size_ = 25 * sizeof(PointType);

			cxt_.outlineClr = 0x00;
			cxt_.fillClr = 0x00;
			cxt_.fill = 0;
			cxt_.font = stdFont;
			cxt_.width= 1;
			width_ = 2; /* at zoom level of 33%, this gives us
				       cxt_.width of 1 */
			arrowType_ = ArrowLast;
	}
	~TGMB_Command() { MemHandleFree(handle_); }
	void Draw(WindowType *window);
	void GetBoundingBox(AbsRectType *bbox);
	void SwitchType(CanvObjType newType);
	void SwitchPage();
	void SwitchZoom(DWord z);
	Boolean Start(SWord x, SWord y, AbsRectType *clip);
	Boolean Move(SWord x, SWord y, AbsRectType *clip);
	Boolean End(SWord x, SWord y, AbsRectType *clip);
	Boolean KeyPress(char key, AbsRectType *clip);
	Boolean IsActive() { return Boolean(nPoints_ > 0); }

	void ToForm(FormPtr frm);
	void FromForm(FormPtr frm);

	Word GetItemType() {
		switch(currentType_) {
		case CanvObjType_Line:
		case CanvObjType_Arrow: return PgItemLine;
		case CanvObjType_Rect: return PgItemRect;
		case CanvObjType_Oval: return PgItemOval;
		case CanvObjType_Text: return PgItemText;
		default: return (Word)-1;
		}
	}
private:
	void CreateAndSendCommand();
	void SendCommand(TGMB_ObjectId id);
	void Clear();
	void EndText();
	Boolean InsertPoint_(SWord x, SWord y);
	Boolean Grow_();
	void SecondPoint_(SWord x, SWord y);

	CanvObjType currentType_;
	VoidHand handle_;
	PointType *points_;
	Word nPoints_, size_;
	Win2_Context cxt_;
	Word width_;
	ArrowType arrowType_;

	TGMB_Book *book_;
	friend class TGMB_Book;
};


#endif /* #ifdef MASH_TGMB_CMD_H */
