/*
 * tgmb-conn.cc --
 *
 *      FIXME: This file needs a description here.
 *
 * Copyright (c) 1998-2002 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * A. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * B. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * C. Neither the names of the copyright holders nor the names of its
 *    contributors may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS
 * IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#include <Pilot.h>
#include "tgmb-app.h"
#include "tgmb-conn.h"


Word TGMB_Connection::evtBytesReceived_ = firstUserEvent;
Word TGMB_Connection::evtChunkReceived_ = firstUserEvent-1;


void
TGMB_Socket::GetAddress(NetIPAddr *local,  Word *lport,
			NetIPAddr *remote, Word *rport)
{
	Err err;
	NetSocketAddrType sockaddr, rem_sockaddr;
	SWord sockaddr_len = sizeof(sockaddr);
	SWord rem_sockaddr_len = sizeof(rem_sockaddr);
	SWord status = NetLibSocketAddr(TG_NetworkApplication::AppNetRefnum,
					sock_,
					&sockaddr,
					&sockaddr_len,
					&rem_sockaddr,
					&rem_sockaddr_len,
					-1,
					&err);
	if (status != 0) {
		if (local)  *local  = 0;
		if (remote) *remote = 0;

		if (lport) *lport = 0;
		if (rport) *rport = 0;
	} else {
		NetSocketAddrINType *in = (NetSocketAddrINType*)&sockaddr;
		NetSocketAddrINType *rin= (NetSocketAddrINType*)&rem_sockaddr;
		if (local)  *local  = in->addr;
		if (remote) *remote = rin->addr;
		if (lport)  *lport  = in->port;
		if (rport)  *rport  = rin->port;
	}
}


void
TGMB_Socket::Reset()
{
	sock_ = -1;
}


Boolean
TGMB_Socket::Connect(const char *host, UShort port, NetSocketTypeEnum type)
{
	if (APP->NetLibOpened()==false) {
		if (APP->NetLibOpen()!=0) {
			TGMB_Application::ErrorDialog("Cannot open Net "
						      "Library");
			return false;
		}
	}

	Disconnect();

	APP->ConnectionRefresh();
	sock_ = APP->Connect(host, port, type);
	if (sock_ >= 0) {
		APP->RegisterSocket(sock_, this);
		return true;
	}
	else return false;
}


Boolean
TGMB_Socket::Disconnect()
{
	Boolean retval=true;
	if (sock_ >= 0) {
		APP->UnregisterSocket(sock_);
		retval = (APP->Disconnect(sock_) == 0);
		sock_ = -1;
	}

	Reset();
	return retval;
}


void
TGMB_Connection::Reset()
{
	TGMB_Socket::Reset();
	db_ = APP->ScratchDB();
	nextRequest_ = 1;
	state_ = connReadingHdr;
	readSoFar_ = 0;
	Err err = DestroyChunk(&chunk_);
	ErrFatalDisplayIf(err, "Problem while destroying chunk");
}


void
TGMB_Connection::Error()
{
	NotifyBytesReceived(0);
	Disconnect();
}


void
TGMB_Connection::NotifyBytesReceived(DWord numberOfBytes)
{
	EvtBytesReceived evtBytesReceived;
	evtBytesReceived.bytes = numberOfBytes;
	evtBytesReceived.conn  = this;
	TG_AddUsrEventToQueue(evtBytesReceived_, &evtBytesReceived,
			      sizeof(evtBytesReceived));
}


VoidHand
TGMB_Connection::NewDmHandle(DWord size, ULong &id)
{
	Err err;
	UInt at = 0;

	VoidHand handle = DmNewRecord(db_, &at, size);
	if (!handle) return handle;

	err = DmRecordInfo(db_, at, NULL, &id, NULL);
	ErrFatalDisplayIf(err, __FILE__ ": Error finding data record");
	return handle;
}


//
// TGMB_Connection::CreateNewChunk
//
// Initializes a chunk to hold data, or something.
//
// Args:
//  chunk - A pointer to a chunk struct to fill in
//  hdrBuf - Pointer to a filled-in WingManHeader to use for this chunk
//
Boolean
TGMB_Connection::CreateNewChunk(Chunk *chunk, VoidPtr hdrBuf)
{
	// construct the header

	MemMove(&chunk->hdr.version, hdrBuf, 4);
	chunk->hdr.version = NetNToHL(chunk->hdr.version);

	MemMove(&chunk->hdr.requestID, hdrBuf+4, 4);
	chunk->hdr.requestID = NetNToHL(chunk->hdr.requestID);

	MemMove(&chunk->hdr.metadataSize, hdrBuf+8, 4);
	chunk->hdr.metadataSize = NetNToHL(chunk->hdr.metadataSize);

	MemMove(&chunk->hdr.dataSize, hdrBuf+12, 4);
	chunk->hdr.dataSize = NetNToHL(chunk->hdr.dataSize);

	MemMove(&chunk->hdr.comp, hdrBuf+16, 4);
	chunk->hdr.comp = NetNToHL(chunk->hdr.comp);


	// now create the metadata database record
	if (chunk->hdr.metadataSize <= 0) {
		chunk->metadataHandle = 0;
		chunk->metadataID     = 0;
	} else {
		chunk->metadataHandle = NewDmHandle(chunk->hdr.metadataSize,
						     chunk->metadataID);
		if (!chunk->metadataHandle) {
			chunk->metadataID = 0;
			return false;
		}
	}

	// now create the data database record
	if (chunk->hdr.dataSize <= 0) {
		chunk->dataHandle = 0;
		chunk->dataID     = 0;
	} else {
		chunk->dataHandle = NewDmHandle(chunk->hdr.dataSize,
						 chunk->dataID);
		if (!chunk->dataHandle) {
			chunk->dataID = 0;
			return false;
		}
	}

	return true;
}


Err
TGMB_Connection::DestroyChunk(Chunk *chunk)
{
	UInt index;
	Err  err;

	if (chunk->hdr.metadataSize && chunk->metadataHandle!=0) {
		err = DmFindRecordByID(db_, chunk->metadataID, &index);
		if (err) return err;
		err = DmRemoveRecord(db_, index);
		if (err) return err;
		chunk->metadataHandle = 0;
	}

	if (chunk->hdr.dataSize && chunk->dataHandle!=0) {
		err = DmFindRecordByID(db_, chunk->dataID, &index);
		if (err) return err;
		err = DmRemoveRecord(db_, index);
		if (err) return err;
		chunk->dataHandle = 0;
	}

	MemSet(chunk, sizeof(Chunk), 0);
	return 0;
}


Err
TGMB_Connection::DestroyChunk(VoidHand chunkHandle)
{
	Chunk *chunk;
	Err   err;

	chunk = (Chunk*) MemHandleLock(chunkHandle);
	if (!chunk) return -1;
	err = DestroyChunk(chunk);
	if (err) return err;
	err = MemHandleUnlock(chunkHandle);
	if (err) return err;
	err = MemHandleFree(chunkHandle);
	if (err) return err;

	return 0;
}


void
TGMB_Connection::NotifyChunkReceived()
{
	// first create a new dynamic handle for the chunk object
	VoidHand chunkHandle = MemHandleNew(sizeof(Chunk));
	if (!chunkHandle) {
		Error();
		return;
	}

	Chunk *chunk = (Chunk*) MemHandleLock(chunkHandle);
	if (!chunk) {
		MemHandleFree(chunkHandle);
		Error();
		return;
	}
	*chunk = chunk_;
	MemHandleUnlock(chunkHandle);

	// now reset the internal chunk object
	chunk_.Reset();

	EvtChunkReceived evtChunkReceived;
	evtChunkReceived.chunkHandle = chunkHandle;
	evtChunkReceived.conn = this;

	TG_AddUsrEventToQueue(evtChunkReceived_, &evtChunkReceived,
			      sizeof(evtChunkReceived));
}


void
TGMB_Connection::Receive()
{
	VoidHand handle=0;
	VoidPtr  ptr=NULL;
	DWord    size=0, already=0;
	SWord    bytesRead=0;

	switch (state_) {
	case connReadingHdr:
		handle  = 0;
		ptr     = recvHdrBuf_;
		size    = sizeof_WingmanHdr;
		already = 0;
		break;

	case connReadingMetadata:
		handle  = chunk_.metadataHandle;
		size    = chunk_.hdr.metadataSize;
		already = sizeof_WingmanHdr;
		break;

	case connReadingData:
		handle  = chunk_.dataHandle;
		size    = chunk_.hdr.dataSize;
		already = sizeof_WingmanHdr + chunk_.hdr.metadataSize;
		break;
	}

	if (handle!=0) {
		ptr = MemHandleLock(handle);
		if (ptr==NULL) {
			Error();
			return;
		}

		bytesRead = APP->DmReceive(sock_, ptr, readSoFar_,
					   size-readSoFar_);
		MemHandleUnlock(handle);

	} else {
		bytesRead = APP->Receive(sock_, ptr + readSoFar_,
					 size-readSoFar_);
	}

	if (bytesRead <= 0) {
		Error();
		return;
	}

	readSoFar_ += bytesRead;
	NotifyBytesReceived(already + readSoFar_);

	if (readSoFar_ >= size) {
		// we've got all the bytes in this state; let's move the
		// state machine to the next state

		readSoFar_ = 0;

		switch (state_) {
		case connReadingHdr:
			// we should allocate database records for the new
			// chunk
			if (CreateNewChunk(&chunk_, ptr) != true) {
				Error();
				return;
			}

			if (chunk_.hdr.metadataSize > 0) {
				state_ = connReadingMetadata;
			} else if (chunk_.hdr.dataSize > 0) {
				state_ = connReadingData;
			} else {
				// we are done!
				NotifyChunkReceived();
			}
			break;

		case connReadingMetadata:
			if (chunk_.hdr.dataSize > 0) {
				state_ = connReadingData;
			} else {
				// we are done!
				NotifyChunkReceived();
				state_ = connReadingHdr;
			}
			break;

		case connReadingData:
			// we are done!
			NotifyChunkReceived();
			state_ = connReadingHdr;
			break;
		}
	}
}


Err
TGMB_Connection::Send(Chunk *chunk)
{
	DWord tmp;
	char hdrBuf[sizeof_WingmanHdr];
	Err err;
	VoidPtr ptr;

	// send the header
	tmp = NetHToNL(chunk->hdr.version);
	MemMove(hdrBuf+ 0, (CharPtr) &tmp, 4);
	tmp = NetHToNL(chunk->hdr.requestID);
	MemMove(hdrBuf+ 4, (CharPtr) &tmp, 4);
	tmp = NetHToNL(chunk->hdr.metadataSize);
	MemMove(hdrBuf+ 8, (CharPtr) &tmp, 4);
	tmp = NetHToNL(chunk->hdr.dataSize);
	MemMove(hdrBuf+12, (CharPtr) &tmp, 4);
	tmp = NetHToNL(chunk->hdr.comp);
	MemMove(hdrBuf+16, (CharPtr) &tmp, 4);

	//APP->ConnectionRefresh();
	err = APP->Send(sock_, hdrBuf, sizeof_WingmanHdr);
	if (err) return err;

	// send the metadata
	if (chunk->hdr.metadataSize > 0) {
		if (chunk->metadataHandle==0) {
			return (Err) -1;
		}
		ptr = MemHandleLock(chunk->metadataHandle);
		if (!ptr) {
			return (Err) -1;
		}
		err = APP->Send(sock_, ptr, chunk->hdr.metadataSize);
		if (err) {
			MemHandleUnlock(chunk->metadataHandle);
			return err;
		}
		err = MemHandleUnlock(chunk->metadataHandle);
		if (err) return err;
	}

	// send the data
	if (chunk->hdr.dataSize > 0) {
		if (chunk->dataHandle==0) {
			return (Err) -1;
		}
		ptr = MemHandleLock(chunk->dataHandle);
		if (!ptr) {
			return (Err) -1;
		}
		err = APP->Send(sock_, ptr, chunk->hdr.dataSize);
		if (err) {
			MemHandleUnlock(chunk->dataHandle);
			return err;
		}
		err = MemHandleUnlock(chunk->dataHandle);
		if (err) return err;
	}

	return 0;
}





void *
Chunk::CreateAndLock(VoidHand &handle, ULong size)
{
	handle = MemHandleNew(size);
	if (!handle) {
		return NULL;
	}
	return MemHandleLock(handle);
}


Word
Chunk::InsertFrag(void *dest, Word descr, Word value)
{
	Word buf[3] = { descr, sizeof(Word), value };
	MemMove(dest, buf, sizeof(buf));
	return sizeof(buf);
}


//
// Returns: Total size constructed
//
// Args:
//  destVoidPtr: Ptr to buffer to hold data
//  descr: fragment type
//  Repeat:
//    ptr: pointer to piece of data for the fragment
//    len: length of that pointer
//  Until ptr == ENDFRAG
//
// IMPORTANT NOTE: Remember to send in the correct types!!! That means you
// probably want to cast all lengths to type Word, because otherwise they'll
// probably be Longs (due to sizeof() calls). It also means you **MUST**
// use ENDFRAG to end the fragment, not NULL, because sizeof(NULL) == 2.
//
Word
Chunk::InsertAnyFrag(void *destVoidPtr, Word descr, ...)
{
	char *dest = (char*) destVoidPtr, *sizePtr;
	VoidPtr ptr;
	Word len;
	Word fragSize;
	va_list argList;
	va_start(argList, descr);

	// Write the frag type
	MemMove(dest, &descr, sizeof(Word));
	sizePtr = dest + sizeof(Word);
	dest += sizeof(Word[2]);
	fragSize = 0;

	while ( (ptr = va_arg(argList, VoidPtr)) != ENDFRAG ) {
		len = va_arg(argList, Word);
		MemMove(dest, ptr, len);
		dest += len;
		fragSize += len;
	}

	// Write the frag size
	MemMove(sizePtr, &fragSize, sizeof(Word));
	fragSize += fragSize % 2;
	return fragSize + sizeof(Word[2]);
}


VoidPtr
Chunk::GetFrag(void *data, Word &descr, VoidPtr &ptr, Word &size)
{
	MemMove(&descr, data, sizeof(Word));
	MemMove(&size, data+sizeof(Word), sizeof(Word));
	ptr = data + 2*sizeof(Word);
	return ptr + size + size % 2;
}




#if 0
//
// Returns: Total size constructed
//
// Args:
//  dest - Ptr to buffer to hold data
//  N - number of fields
//  Repeat N times
//    field - field type
//    Repeat
//        ptr - pointer to data for the field
//        len - length of that pointer
//    Until ptr == ENDFIELD
//
// IMPORTANT NOTE: Remember to send in the correct types!!! That means you
// probably want to cast all lengths to type Word, because otherwise they'll
// probably be Longs (due to sizeof() calls). It also means you **MUST**
// use ENDFIELD to end each field, not NULL, because sizeof(NULL) == 2.
//
Word TGMB_WriteFields(VoidPtr dest, Word N, ...)
{
	Word field;
	VoidPtr ptr;
	Word len;

	BytePtr fieldPtr = BytePtr(dest);
	Word fsize;
	Word size = 0;

	va_list argList;
	va_start(argList, N);

	while (N--) {
		fsize = 0;
		field = va_arg(argList, Word);
		// Write the field type
		MemMove(fieldPtr, &field, sizeof(Word));

		BytePtr valPtr = fieldPtr + sizeof(Word[2]);
		while (1) {
			ptr = va_arg(argList, VoidPtr);
			if (ptr == NULL) break;
			len = va_arg(argList, Word);

			MemMove(valPtr, ptr, len);
			valPtr += len;
			fsize += len;
		}

		// Write the field size
		MemMove(fieldPtr + sizeof(Word), &fsize, sizeof(Word));

		// Advance
		fieldPtr += sizeof(Word[2]) + fsize + fsize % 2;
		size += sizeof(Word[2]) + fsize + fsize % 2;
	}

	va_end(argList);

	return size;
}

Word TGMB_WriteWordField(VoidPtr dest, Word field, Word value)
{
	Word buf[3] = { field, sizeof(Word), value };
	MemMove(dest, buf, sizeof(buf));
	return sizeof(buf);
}



#endif
