/*
 * tgmb-more-app.cc --
 *
 *      FIXME: This file needs a description here.
 *
 * Copyright (c) 1998-2002 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * A. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * B. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * C. Neither the names of the copyright holders nor the names of its
 *    contributors may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS
 * IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */


#ifndef lint
static const char *rcsid = "@(#) $Header: /usr/mash/src/repository/mash/mash-1/tgmb/client/tgmb-more-app.cc,v 1.4 2002/02/03 04:17:39 lim Exp $";
#endif


#include "tgmb-app.h"
#include "tgmb-resource.h"


void
TGMB_Application::ErrorDialog(const CharPtr formatStr, ...)
{
	FormPtr frm;
	const int sizeofErrorStr = 250;

       	SndPlaySystemSound(sndError);
	frm = FrmInitForm(Frm_ErrorForm);

	/* set the text field */
	FieldPtr fld = (FieldPtr)
		FrmGetObjectPtr(frm, FrmGetObjectIndex(frm, EF_ErrorMsgFld));
	VoidHand txtHand = MemHandleNew(sizeofErrorStr);
	if (txtHand) {
		CharPtr txtPtr = (CharPtr) MemHandleLock(txtHand);
		if (txtPtr) {
			va_list argList;
			va_start(argList, formatStr);
			StrVPrintF(txtPtr, formatStr, argList);
			va_end(argList);
			MemHandleUnlock(txtHand);
		}
		FldFreeMemory(fld);
		FldSetTextHandle(fld, (Handle)txtHand);
	}

	FrmDoDialog(frm);
	FrmDeleteForm(frm);
}



/* Main entry point; it is unlikely you will need to change this except to
   handle other launch command codes */
DWord
PilotMain(Word cmd, Ptr /*cmdPBP*/, Word /*launchFlags*/)
{
	if (cmd == sysAppLaunchCmdNormalLaunch) {
		TGMB_Application appInstance;
		DWord retval = appInstance.Run();
		return retval;
	} else {
		return sysErrParamErr;
	}
}

TGMB_Application::TGMB_Application()
	: TG_NetworkApplication(usrNetSelect, usrTimeout)
{
	globalAppInstance_ = this;

	TGMB_Connection::evtBytesReceived_ = usrTGMBBytesReceived;
	TGMB_Connection::evtChunkReceived_ = usrTGMBChunkReceived;
}


TGMB_Application::~TGMB_Application()
{
}


TGMB_Socket::~TGMB_Socket()
{
	Disconnect();
}


TGMB_Connection::~TGMB_Connection()
{
}
