/*
 * win-2bit.h --
 *
 *      FIXME: This file needs a description here.
 *
 * Copyright (c) 1998-2002 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * A. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * B. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * C. Neither the names of the copyright holders nor the names of its
 *    contributors may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS
 * IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 *  @(#) $Header: /usr/mash/src/repository/mash/mash-1/tgmb/client/win-2bit.h,v 1.4 2002/02/03 04:17:39 lim Exp $
 */

#ifndef MASH_WIN_2BIT_H
#define MASH_WIN_2BIT_H

#include <Pilot.h>


#ifdef __cplusplus
extern "C" {
#endif

typedef struct Win2_Context {
	WindowType *window;
	Byte width;
	Byte fillClr;
	Byte outlineClr;
	Boolean fill;
	FontID font;
} Win2_Context;


void Win2_Plot(Win2_Context *cxt, SWord x, SWord y);
void Win2_DrawLine(Win2_Context *cxt, SWord x1, SWord y1, SWord x2, SWord y2);
void Win2_DrawRectangle(Win2_Context *cxt,SWord x1,SWord y1,SWord x2,SWord y2);
void Win2_DrawOval(Win2_Context *cxt, SWord x1, SWord y1, SWord x2, SWord y2);
void Win2_DrawText(Win2_Context *cxt, SWord x, SWord y, const char *string);
void Win2_DrawBitmap(Win2_Context *cxt, SWord x, SWord y, BitmapPtr image);
void Win2_CopyOnscreenRectangle(AbsRectType *bbox, SWord destX, SWord destY,
				ScrOperation mode);
void Win2_CopyRectangle(WindowType *srcW, WindowType *destW, AbsRectType *bbox,
			SWord destX, SWord destY, ScrOperation mode);
void Win2_GrayoutRectangle(Win2_Context *cxt, SWord x1, SWord y1, SWord x2,
			   SWord y2);
/*void Win2_InvertRectangle(WindowType *w, SWord x1, SWord y1,SWord x2,
  SWord y2);*/
WindowType *Win2_CreateOffscreenWindow(SWord width, SWord height, DmOpenRef db,
				       WordPtr errPtr);
void Win2_DeleteWindow(WindowType *w, Boolean erase);
WindowType *Win2_GetOnscreenWindow();
void Win2_GetTextBBox(Win2_Context *cxt, SWord *w, SWord *h,
		      const char *string);

void Win2_Enable(DWord appType, DmOpenRef db);
void Win2_Disable(void);

#ifdef __cplusplus
}
#endif


#endif /* #ifdef MASH_TG_DRAW_H */
