/*
 * tcpchan.h --
 *
 *      FIXME: This file needs a description here.
 *
 * Copyright (c) 1998-2002 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * A. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * B. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * C. Neither the names of the copyright holders nor the names of its
 *    contributors may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS
 * IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef mash_tcpchan_h
#define mash_tcpchan_h

#include "config.h"
#include "iohandler.h"
#include "tk.h"

SRMv2_class TCPServerHandler;
SRMv2_class TCPClientHandler;

class SRMv2_TCPServerChannel  {
public:	
	SRMv2_TCPServerChannel();
	~SRMv2_TCPServerChannel();
	int recv(u_char* buf, int len, u_int32_t&, u_int16_t&);
	void send(const u_char* buf, int len);
	void reset(void);
	inline int sock() { return sock_; }
	inline void handler(SRMv2_TCPServerHandler* h) { handler_ = h; }
private:
	int opensock(u_int16_t port) const;
	int connsock_;
	int sock_;
	u_int32_t fromaddr_;
	u_int16_t fromport_;
	int concurrent_;
	int parent_;
	SRMv2_TCPServerHandler* handler_;
};

class SRMv2_TCPClientChannel {
public:	
	SRMv2_TCPClientChannel();
	~SRMv2_TCPClientChannel();
	int recv(u_char* buf, int len);
	void send(const u_char* buf, int len);
	inline int sock() { return sock_; }
	inline void handler(SRMv2_TCPClientHandler* h) { handler_ = h; }
	void closesock();

private:
	int opensock(u_int32_t addr, u_int16_t port) const;
	int sock_;
	SRMv2_TCPClientHandler* handler_;
};

class SRMv2_TCPClientHandler;
class SRMv2_TCPServerHandler;
	
class SRMv2_TCPClientManager {
public:
	virtual void recv(SRMv2_TCPClientHandler*) = 0;
};

class SRMv2_TCPServerManager {
public:
	virtual void recv(SRMv2_TCPServerHandler*) = 0;
};

class SRMv2_TCPClientHandler : public SRMv2_IOHandler {
public:
	inline SRMv2_TCPClientHandler() : manager_(0), chan_(0) {}
	virtual void dispatch(int) {
		manager_->recv(this);
	}
	inline SRMv2_TCPClientChannel* chan() const { return (chan_); }
	void reset(void) {
		chan(0);
	}
	virtual void chan(SRMv2_TCPClientChannel *c) {
		unlink();
		chan_ = c;
		if (c != 0) {
			c->handler(this);
			link(c->sock(), TCL_READABLE);
		}
	}
	inline int recv(u_char* bp, int len) {
		return (chan_->recv(bp, len));
	}
	inline void send(u_char* bp, int len) {
		chan_->send(bp, len);
	}
	inline void manager(TCPClientManager* sm) { manager_ = sm; }

protected:
	SRMv2_TCPClientManager* manager_;
	SRMv2_TCPClientChannel* chan_;
};

class SRMv2_TCPServerHandler : public SRMv2_IOHandler {
public:
	inline SRMv2_TCPServerHandler() : manager_(0), chan_(0) {}
	virtual void dispatch(int) {
		manager_->recv(this);
	}
	inline SRMv2_TCPServerChannel* chan() const { return (chan_); }
	void reset(void) {
		unlink();
		chan_->reset();
		link(chan_->sock(), TCL_READABLE);
	}
	virtual void chan(SRMv2_TCPServerChannel *c) {
		unlink();
		chan_ = c;
		if (c != 0) {
			c->handler(this);
			link(c->sock(), TCL_READABLE);
		}
	}
	inline int recv(u_char* bp, int len, u_int32_t& addr, 
			u_int16_t& port) {
		return(chan_->recv(bp, len, addr, port));
	}
	inline void send(u_char* bp, int len) {
		chan_->send(bp, len);
	}
	inline void manager(SRMv2_TCPServerManager* sm) { manager_ = sm; }
protected:
	SRMv2_TCPServerManager* manager_;
	SRMv2_TCPServerChannel* chan_;
};

#endif /* mash_tcpchan_h */
