/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.io.PrintStream;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.TimeZone;
import oracle.jdbc.OracleOCIFailover;
import oracle.jdbc.OracleSavepoint;
import oracle.jdbc.dbaccess.DBAccess;
import oracle.jdbc.dbaccess.DBConversion;
import oracle.jdbc.dbaccess.DBError;
import oracle.jdbc.driver.ByteArrayKey;
import oracle.jdbc.driver.ClientDataSupport;
import oracle.jdbc.driver.LRUStatementCache;
import oracle.jdbc.driver.OracleCallableStatement;
import oracle.jdbc.driver.OracleCloseCallback;
import oracle.jdbc.driver.OracleDatabaseMetaData;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.driver.OraclePreparedStatement;
import oracle.jdbc.driver.OracleSql;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.ResultSetUtil;
import oracle.jdbc.oracore.Util;
import oracle.jdbc.pool.OraclePooledConnection;
import oracle.sql.BfileDBAccess;
import oracle.sql.BlobDBAccess;
import oracle.sql.ClobDBAccess;
import oracle.sql.LobDBAccessImpl;

public class OracleConnection
implements oracle.jdbc.internal.OracleConnection,
ClientDataSupport {
    private static String dll_string = "dll";
    private String url;
    private String user;
    private String password;
    protected String database;
    private boolean auto_commit;
    private String protocol;
    public DBAccess db_access;
    public DBConversion conversion;
    public LobDBAccessImpl lob_dbaccess;
    public boolean XA_wants_error;
    public boolean UsingXA;
    public int m_txn_mode = 0;
    public static final int GLOBAL_TXN = 2;
    public static final int LOCAL_TXN = 1;
    public static final int NO_TXN = 0;
    private byte[] fdo;
    private Boolean big_endian;
    Hashtable statement_table;
    protected boolean closed;
    private boolean m_clientIdSet = false;
    private String m_clientId = null;
    int default_batch;
    int default_row_prefetch;
    boolean report_remarks;
    boolean include_synonyms = false;
    boolean restrict_getTables = false;
    boolean m_accumulateBatchResult = true;
    int dataSizeScale = 1;
    private int trans_level;
    Map map;
    Map m_javaObjectMap;
    Hashtable descriptorCache;
    OracleStatement statement_holding_line;
    oracle.jdbc.OracleDatabaseMetaData m_dbMetaData = null;
    private boolean physicalStatus;
    private boolean logicalHandle;
    private OraclePooledConnection m_opc = null;
    private OracleConnection m_opc_oc = null;
    static int DEFAULT_ROW_PREFETCH = 10;
    private OracleSql m_osql = null;
    SQLWarning m_warning = null;
    boolean m_readOnly = false;
    private long m_startTime = 0L;
    private LRUStatementCache statementCache = null;
    boolean m_stmtClearMetaData = false;
    boolean m_process_escapes = true;
    boolean m_defaultAutoRefetch = true;
    private OracleCloseCallback m_occ = null;
    private Object m_privData = null;
    boolean defaultFixedString = false;
    private Statement m_svptStmt = null;
    private static final String svptPrefix = "ORACLE_SVPT_";
    oracle.jdbc.OracleConnection wrapper = null;
    Properties connectionProperties = null;
    private static boolean m_traceEnabled = false;
    static final int BINARYSTREAM = 0;
    static final int ASCIISTREAM = 1;
    static final int UNICODESTREAM = 2;
    static final int EOJ_NON = 0;
    static final int EOJ_B_TO_A = 1;
    static final int EOJ_B_TO_U = 2;
    static final int EOJ_A_TO_U = 3;
    static final int EOJ_8_TO_A = 4;
    static final int EOJ_8_TO_U = 5;
    static final int EOJ_U_TO_A = 6;
    static final int ASCII_CHARSET = 0;
    static final int NLS_CHARSET = 1;
    public static final int CHAR_TO_ASCII = 0;
    public static final int CHAR_TO_UNICODE = 1;
    public static final int RAW_TO_ASCII = 2;
    public static final int RAW_TO_UNICODE = 3;
    public static final int UNICODE_TO_CHAR = 4;
    public static final int ASCII_TO_CHAR = 5;
    public static final int NONE = 6;
    public static final int JAVACHAR_TO_CHAR = 7;
    public static final int RAW_TO_JAVACHAR = 8;
    public static final int CHAR_TO_JAVACHAR = 9;
    private Hashtable m_clientData;
    private String m_sessionTimeZone = null;
    private Calendar m_dbTzCalendar = null;

    public OracleConnection(DBAccess dBAccess, String string, String string2, String string3, String string4, Properties properties) throws SQLException {
        String string5 = null;
        String string6 = null;
        boolean bl = true;
        if (properties != null) {
            string5 = (String)properties.get("protocol");
            String string7 = properties.getProperty("processEscapes");
            if (string7 != null && string7.equalsIgnoreCase("false")) {
                this.m_process_escapes = false;
            }
            this.connectionProperties = (Properties)properties.clone();
            this.connectionProperties.remove("password");
        }
        this.initialize(string, string2, string5, dBAccess, null, null, null, string4);
        this.logicalHandle = false;
        try {
            this.needLine();
            this.conversion = this.db_access.logon(string2, string3, string4, properties);
            this.m_warning = DBError.addSqlWarning(this.m_warning, this.db_access.getWarnings());
            if (properties == null || properties.getProperty("connection_pool") != "connection_pool") {
                this.default_row_prefetch = this.db_access.getDefaultPrefetch();
                if (properties != null && (string6 = properties.getProperty("autoCommit")) != null && string6.equalsIgnoreCase("false")) {
                    bl = false;
                }
                this.setAutoCommit(bl);
                this.db_access.initNls(this);
            }
        }
        catch (IOException iOException) {
            DBError.throwSqlException(iOException);
        }
        catch (SQLException sQLException) {
            try {
                this.db_access.logoff();
            }
            catch (IOException iOException) {
            }
            catch (SQLException sQLException2) {
                // empty catch block
            }
            throw sQLException;
        }
        this.m_txn_mode = 0;
    }

    public OracleConnection(OraclePooledConnection oraclePooledConnection, OracleConnection oracleConnection, boolean bl) throws SQLException {
        this.initialize(oracleConnection.url, oracleConnection.user, oracleConnection.protocol, oracleConnection.db_access, oracleConnection.descriptorCache, oracleConnection.map, oracleConnection.m_javaObjectMap, null);
        this.logicalHandle = true;
        if (oracleConnection.trans_level == 8) {
            this.setTransactionIsolation(2);
        }
        this.m_opc = oraclePooledConnection;
        this.m_opc_oc = oracleConnection;
        this.conversion = oracleConnection.conversion;
        this.setAutoCommit(bl);
        if ((this.getProtocolType().equals("oci") || this.getProtocolType().equals("oci8")) && this.pingDatabase(0) != 0) {
            throw new SQLException("Connection Closed");
        }
        this.m_txn_mode = 0;
    }

    public Properties getProperties() {
        return this.connectionProperties;
    }

    public synchronized Connection _getPC() {
        if (this.logicalHandle) {
            return this.m_opc_oc;
        }
        return null;
    }

    public synchronized oracle.jdbc.internal.OracleConnection getPhysicalConnection() {
        return this;
    }

    public synchronized boolean isLogicalConnection() {
        return this.logicalHandle;
    }

    private void initialize(String string, String string2, String string3, DBAccess dBAccess, Hashtable hashtable, Map map, Map map2, String string4) throws SQLException {
        this.initClientDataSupport();
        this.statementCache = null;
        this.m_stmtClearMetaData = false;
        this.database = string4;
        this.url = string;
        this.user = string2 != null ? string2.toUpperCase() : string2;
        this.db_access = dBAccess;
        this.protocol = string3;
        this.physicalStatus = true;
        this.default_row_prefetch = DEFAULT_ROW_PREFETCH;
        this.default_batch = 1;
        this.statement_table = new Hashtable(10);
        this.descriptorCache = hashtable != null ? hashtable : new Hashtable(10);
        this.map = map;
        this.m_javaObjectMap = map2 != null ? map2 : new Hashtable(10);
        this.closed = false;
        this.trans_level = 2;
        this.XA_wants_error = false;
        this.UsingXA = false;
        this.fdo = null;
        this.big_endian = null;
        this.m_occ = null;
        this.m_privData = null;
        this.m_clientIdSet = false;
        this.m_clientId = null;
    }

    public synchronized void setPhysicalStatus(boolean bl) {
        this.physicalStatus = bl;
    }

    private void checkPhyiscalStatus() throws SQLException {
        if (!this.physicalStatus) {
            DBError.throwSqlException(73);
        }
    }

    public synchronized Statement createStatement() throws SQLException {
        return this.privateCreateStatement(-1, -1);
    }

    public synchronized Statement createStatement(int n, int n2) throws SQLException {
        return this.privateCreateStatement(n, n2);
    }

    private Statement privateCreateStatement(int n, int n2) throws SQLException {
        this.checkPhyiscalStatus();
        if (this.closed) {
            DBError.throwSqlException(8);
        }
        OracleStatement oracleStatement = null;
        oracleStatement = n != -1 || n2 != -1 ? new OracleStatement(this, 1, this.default_row_prefetch, n, n2) : new OracleStatement(this, 1, this.default_row_prefetch);
        return oracleStatement;
    }

    public synchronized PreparedStatement prepareStatement(String string) throws SQLException {
        return this.privatePrepareStatement(string, null, -1, -1);
    }

    public synchronized PreparedStatement prepareStatementWithKey(String string) throws SQLException {
        this.checkPhyiscalStatus();
        if (this.closed) {
            DBError.throwSqlException(8);
        }
        if (string != null && !this.isStatementCacheInitialized()) {
            DBError.throwSqlException(95);
        }
        if (string == null) {
            return null;
        }
        return this.privatePrepareStatement(null, string, -1, -1);
    }

    public synchronized PreparedStatement prepareStatement(String string, int n, int n2) throws SQLException {
        return this.privatePrepareStatement(string, null, n, n2);
    }

    private PreparedStatement privatePrepareStatement(String string, String string2, int n, int n2) throws SQLException {
        if (string2 == null && string == null || string == "") {
            DBError.throwSqlException(104);
        }
        this.checkPhyiscalStatus();
        if (this.closed) {
            DBError.throwSqlException(8);
        }
        PreparedStatement preparedStatement = null;
        if (this.logicalHandle && this.m_opc.isStatementCacheInitialized()) {
            preparedStatement = this.m_opc_oc.privatePrepareStatement(string, string2, n, n2);
        } else {
            int n3 = OracleStatement.DEFAULT_RSET_TYPE;
            if (n != -1 || n2 != -1) {
                n3 = ResultSetUtil.getRsetTypeCode(n, n2);
            }
            if (this.statementCache != null) {
                preparedStatement = string2 != null ? (OraclePreparedStatement)this.statementCache.searchExplicitCache(string2) : (OraclePreparedStatement)this.statementCache.searchImplicitCache(string, 1, n3);
            }
            if ((this.statementCache == null || string2 == null) && preparedStatement == null) {
                preparedStatement = n != -1 || n2 != -1 ? new OraclePreparedStatement(this, string, this.default_batch, this.default_row_prefetch, n, n2) : new OraclePreparedStatement(this, string, this.default_batch, this.default_row_prefetch);
            }
        }
        return preparedStatement;
    }

    public synchronized CallableStatement prepareCall(String string) throws SQLException {
        return this.privatePrepareCall(string, null, -1, -1);
    }

    public synchronized CallableStatement prepareCall(String string, int n, int n2) throws SQLException {
        return this.privatePrepareCall(string, null, n, n2);
    }

    public synchronized CallableStatement prepareCallWithKey(String string) throws SQLException {
        this.checkPhyiscalStatus();
        if (this.closed) {
            DBError.throwSqlException(8);
        }
        if (string != null && !this.isStatementCacheInitialized()) {
            DBError.throwSqlException(95);
        }
        if (string == null) {
            return null;
        }
        return this.privatePrepareCall(null, string, -1, -1);
    }

    private CallableStatement privatePrepareCall(String string, String string2, int n, int n2) throws SQLException {
        if (string2 == null && string == null || string == "") {
            DBError.throwSqlException(104);
        }
        this.checkPhyiscalStatus();
        if (this.closed) {
            DBError.throwSqlException(8);
        }
        CallableStatement callableStatement = null;
        if (this.logicalHandle && this.m_opc.isStatementCacheInitialized()) {
            callableStatement = this.m_opc_oc.privatePrepareCall(string, string2, n, n2);
        } else {
            int n3 = OracleStatement.DEFAULT_RSET_TYPE;
            if (n != -1 || n2 != -1) {
                n3 = ResultSetUtil.getRsetTypeCode(n, n2);
            }
            if (this.statementCache != null) {
                callableStatement = string2 != null ? (OracleCallableStatement)this.statementCache.searchExplicitCache(string2) : (OracleCallableStatement)this.statementCache.searchImplicitCache(string, 2, n3);
            }
            if ((this.statementCache == null || string2 == null) & callableStatement == null) {
                callableStatement = n != -1 || n2 != -1 ? new OracleCallableStatement(this, string, 1, this.default_row_prefetch, n, n2) : new OracleCallableStatement(this, string, 1, this.default_row_prefetch);
            }
        }
        return callableStatement;
    }

    public String nativeSQL(String string) throws SQLException {
        if (this.m_osql == null) {
            this.m_osql = new OracleSql();
        }
        String string2 = this.m_osql.parse(string);
        return string2;
    }

    public synchronized void setAutoCommit(boolean bl) throws SQLException {
        this.checkPhyiscalStatus();
        if (bl) {
            this.disallowGlobalTxnMode(116);
        }
        if (this.closed) {
            DBError.throwSqlException(8);
        }
        try {
            this.needLine();
            this.db_access.setAutoCommit(bl);
        }
        catch (IOException iOException) {
            DBError.throwSqlException(iOException);
        }
        this.auto_commit = bl;
        if (bl) {
            this.switchTxnMode(1, 0);
        }
    }

    public synchronized boolean getAutoCommit() throws SQLException {
        return this.auto_commit;
    }

    public void cancel() throws SQLException {
        Enumeration enumeration = this.statement_table.elements();
        while (enumeration != null && enumeration.hasMoreElements()) {
            OracleStatement oracleStatement = (OracleStatement)enumeration.nextElement();
            if (oracleStatement == null) continue;
            try {
                oracleStatement.cancel();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    public synchronized void commit() throws SQLException {
        this.checkPhyiscalStatus();
        this.disallowGlobalTxnMode(114);
        if (this.closed) {
            DBError.throwSqlException(8);
        }
        Enumeration enumeration = this.statement_table.elements();
        while (enumeration.hasMoreElements()) {
            OracleStatement oracleStatement = (OracleStatement)enumeration.nextElement();
            oracleStatement.sendBatch();
        }
        try {
            this.needLine();
            this.db_access.commit();
        }
        catch (IOException iOException) {
            DBError.throwSqlException(iOException);
        }
        this.enterTxnMode(0);
    }

    public synchronized void rollback() throws SQLException {
        this.checkPhyiscalStatus();
        this.disallowGlobalTxnMode(115);
        if (this.closed) {
            DBError.throwSqlException(8);
        }
        try {
            this.needLine();
            this.db_access.rollback();
        }
        catch (IOException iOException) {
            DBError.throwSqlException(iOException);
        }
        this.enterTxnMode(0);
    }

    public synchronized void close() throws SQLException {
        if (this.closed) {
            return;
        }
        if (this.m_occ != null) {
            this.m_occ.beforeClose(this, this.m_privData);
        }
        this.close_statements();
        this.closed = true;
        if (this.logicalHandle) {
            this.logicalClose();
            if (this.m_occ != null) {
                this.m_occ.afterClose(this.m_privData);
            }
            return;
        }
        try {
            this.needLine();
            this.db_access.logoff();
            this.cleanup();
        }
        catch (IOException iOException) {
            DBError.throwSqlException(iOException);
        }
        if (this.m_occ != null) {
            this.m_occ.afterClose(this.m_privData);
        }
    }

    public synchronized boolean isClosed() throws SQLException {
        return this.closed;
    }

    private void cleanup() {
        this.fdo = null;
        this.db_access = null;
        this.conversion = null;
        this.statement_table = null;
        this.descriptorCache = null;
        this.map = null;
        this.m_javaObjectMap = null;
        this.statement_holding_line = null;
        this.m_opc = null;
        this.m_osql = null;
    }

    public synchronized DatabaseMetaData getMetaData() throws SQLException {
        if (this.closed) {
            DBError.throwSqlException(8);
        }
        if (this.m_dbMetaData == null) {
            this.m_dbMetaData = new OracleDatabaseMetaData(this);
        }
        return this.m_dbMetaData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setReadOnly(boolean bl) throws SQLException {
        block3: {
            Statement statement = null;
            try {
                String string = null;
                string = bl ? "SET TRANSACTION READ ONLY" : "SET TRANSACTION READ WRITE";
                statement = this.prepareStatement(string);
                statement.execute();
                Object var5_4 = null;
                if (statement == null) break block3;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                if (statement != null) {
                    statement.close();
                }
                throw throwable;
            }
            statement.close();
        }
        this.m_readOnly = bl;
    }

    public boolean isReadOnly() throws SQLException {
        return this.m_readOnly;
    }

    public void setCatalog(String string) throws SQLException {
    }

    public String getCatalog() throws SQLException {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setTransactionIsolation(int n) throws SQLException {
        this.checkPhyiscalStatus();
        OracleStatement oracleStatement = (OracleStatement)this.createStatement();
        try {
            switch (n) {
                case 2: {
                    oracleStatement.execute("ALTER SESSION SET ISOLATION_LEVEL = READ COMMITTED");
                    this.trans_level = 2;
                    break;
                }
                case 8: {
                    oracleStatement.execute("ALTER SESSION SET ISOLATION_LEVEL = SERIALIZABLE");
                    this.trans_level = 8;
                    break;
                }
                default: {
                    DBError.throwSqlException(30);
                }
            }
            Object var4_3 = null;
            if (this.logicalHandle) {
                this.m_opc_oc.trans_level = this.trans_level;
            }
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (this.logicalHandle) {
                this.m_opc_oc.trans_level = this.trans_level;
            }
            oracleStatement.close();
            throw throwable;
        }
        oracleStatement.close();
    }

    public int getTransactionIsolation() throws SQLException {
        return this.trans_level;
    }

    public synchronized void setAutoClose(boolean bl) throws SQLException {
        if (!bl) {
            DBError.throwSqlException(31);
        }
    }

    public boolean getAutoClose() throws SQLException {
        return true;
    }

    public SQLWarning getWarnings() throws SQLException {
        this.m_warning = this.db_access.getWarnings();
        return this.m_warning;
    }

    public void clearWarnings() throws SQLException {
        this.m_warning = null;
    }

    public void trace(String string) {
        PrintStream printStream = DriverManager.getLogStream();
        if (printStream == null) {
            if (m_traceEnabled) {
                OracleLog.setLogStream(null);
            }
            m_traceEnabled = false;
        } else {
            if (!m_traceEnabled) {
                OracleLog.setLogStream(printStream);
            }
            m_traceEnabled = true;
        }
    }

    public synchronized void setDefaultRowPrefetch(int n) throws SQLException {
        if (n <= 0) {
            DBError.throwSqlException(20);
        }
        this.default_row_prefetch = n;
    }

    public synchronized int getDefaultRowPrefetch() {
        return this.default_row_prefetch;
    }

    public synchronized void setDefaultExecuteBatch(int n) throws SQLException {
        if (n <= 0) {
            DBError.throwSqlException(42);
        }
        this.default_batch = n;
    }

    public synchronized int getDefaultExecuteBatch() {
        return this.default_batch;
    }

    public synchronized void setRemarksReporting(boolean bl) {
        this.report_remarks = bl;
    }

    public synchronized boolean getRemarksReporting() {
        return this.report_remarks;
    }

    public void setIncludeSynonyms(boolean bl) {
        this.include_synonyms = bl;
    }

    public boolean getIncludeSynonyms() {
        return this.include_synonyms;
    }

    public void setRestrictGetTables(boolean bl) {
        this.restrict_getTables = bl;
    }

    public boolean getRestrictGetTables() {
        return this.restrict_getTables;
    }

    public void setDefaultFixedString(boolean bl) {
        this.defaultFixedString = bl;
    }

    public boolean getDefaultFixedString() {
        return this.defaultFixedString;
    }

    public synchronized void setDataSizeUnits(String string) throws SQLException {
        if (string.equalsIgnoreCase("ClientBytes")) {
            this.dataSizeScale = 1;
        } else if (string.equalsIgnoreCase("ServerBytes")) {
            this.dataSizeScale = this.db_access.getNlsRatio();
        } else {
            DBError.throwSqlException(68);
        }
    }

    synchronized void add_statement(Statement statement) {
        this.statement_table.put(statement, statement);
    }

    synchronized void remove_statement(Statement statement) {
        this.statement_table.remove(statement);
    }

    public synchronized void close_statements() throws SQLException {
        if (this.isStatementCacheInitialized() && !this.logicalHandle) {
            this.statementCache.close();
            this.statementCache = null;
            this.m_stmtClearMetaData = true;
        } else {
            OracleStatement oracleStatement;
            Enumeration enumeration = this.statement_table.elements();
            while (enumeration.hasMoreElements()) {
                oracleStatement = (OracleStatement)enumeration.nextElement();
                if (oracleStatement == null || !oracleStatement.serverCursor) continue;
                oracleStatement.close();
                this.remove_statement(oracleStatement);
                oracleStatement = null;
            }
            enumeration = this.statement_table.elements();
            while (enumeration.hasMoreElements()) {
                oracleStatement = (OracleStatement)enumeration.nextElement();
                if (oracleStatement == null) continue;
                oracleStatement.close();
                oracleStatement = null;
            }
        }
    }

    public synchronized void needLine() throws SQLException {
        if (this.statement_holding_line != null) {
            this.statement_holding_line.freeLine();
        }
    }

    public synchronized void holdLine(oracle.jdbc.internal.OracleStatement oracleStatement) {
        this.holdLine((OracleStatement)oracleStatement);
    }

    public synchronized void holdLine(OracleStatement oracleStatement) {
        this.statement_holding_line = oracleStatement;
    }

    public synchronized void releaseLine() {
        this.releaseLineForCancel();
    }

    void releaseLineForCancel() {
        this.statement_holding_line = null;
    }

    public synchronized void startup(String string, int n) throws SQLException {
        if (this.closed) {
            DBError.throwSqlException(8);
        }
        this.db_access.startup(string, n);
    }

    public synchronized void shutdown(int n) throws SQLException {
        if (this.closed) {
            DBError.throwSqlException(8);
        }
        this.db_access.shutdown(n);
    }

    public synchronized void archive(int n, int n2, String string) throws SQLException {
        if (this.closed) {
            DBError.throwSqlException(8);
        }
        this.db_access.archive(n, n2, string);
    }

    public synchronized void registerSQLType(String string, String string2) throws SQLException {
        if (string == null || string2 == null) {
            DBError.throwSqlException(68);
        }
        try {
            this.registerSQLType(string, Class.forName(string2));
        }
        catch (ClassNotFoundException classNotFoundException) {
            DBError.throwSqlException(1, "Class not found: " + string2);
        }
    }

    public synchronized void registerSQLType(String string, Class clazz) throws SQLException {
        if (string == null || clazz == null) {
            DBError.throwSqlException(68);
        }
        this.ensureClassMapExists();
        this.map.put(string, clazz);
        this.map.put(clazz.getName(), string);
    }

    private void ensureClassMapExists() {
        if (this.map == null) {
            this.initializeClassMap();
        }
    }

    private void initializeClassMap() {
        Hashtable hashtable = new Hashtable(10);
        this.addDefaultClassMapEntriesTo(hashtable);
        this.map = hashtable;
    }

    public synchronized String getSQLType(Object object) throws SQLException {
        if (object != null && this.map != null) {
            String string = object.getClass().getName();
            return (String)this.map.get(string);
        }
        return null;
    }

    public synchronized Object getJavaObject(String string) throws SQLException {
        Object var2_2 = null;
        try {
            if (string != null && this.map != null) {
                Class clazz = (Class)this.map.get(string);
                var2_2 = clazz.newInstance();
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
        catch (InstantiationException instantiationException) {
            instantiationException.printStackTrace();
        }
        return var2_2;
    }

    public synchronized void putDescriptor(String string, Object object) throws SQLException {
        if (string != null && object != null) {
            if (this.descriptorCache == null) {
                this.descriptorCache = new Hashtable(10);
            }
            this.descriptorCache.put(string, object);
        } else {
            DBError.throwSqlException(68);
        }
    }

    public synchronized Object getDescriptor(String string) {
        Object var2_2 = null;
        if (string != null && this.descriptorCache != null) {
            var2_2 = this.descriptorCache.get(string);
        }
        return var2_2;
    }

    public synchronized void removeDecriptor(String string) {
        this.removeDescriptor(string);
    }

    public synchronized void removeDescriptor(String string) {
        if (string != null && this.descriptorCache != null) {
            this.descriptorCache.remove(string);
        }
    }

    public synchronized void removeAllDescriptor() {
        if (this.descriptorCache != null) {
            this.descriptorCache.clear();
        }
    }

    public int numberOfDescriptorCacheEntries() {
        if (this.descriptorCache != null) {
            return this.descriptorCache.size();
        }
        return 0;
    }

    public synchronized void putDescriptor(byte[] byArray, Object object) throws SQLException {
        if (byArray != null && object != null) {
            if (this.descriptorCache == null) {
                this.descriptorCache = new Hashtable(10);
            }
            this.descriptorCache.put(new ByteArrayKey(byArray), object);
        } else {
            DBError.throwSqlException(68);
        }
    }

    public synchronized Object getDescriptor(byte[] byArray) {
        Object var2_2 = null;
        if (byArray != null && this.descriptorCache != null) {
            var2_2 = this.descriptorCache.get(new ByteArrayKey(byArray));
        }
        return var2_2;
    }

    public synchronized void removeDecriptor(byte[] byArray) {
        if (byArray != null && this.descriptorCache != null) {
            this.descriptorCache.remove(new ByteArrayKey(byArray));
        }
    }

    public short getJdbcCsId() throws SQLException {
        if (this.conversion == null) {
            DBError.throwSqlException(65);
        }
        return this.conversion.getAccessCharSet();
    }

    public short getDbCsId() throws SQLException {
        if (this.conversion == null) {
            DBError.throwSqlException(65);
        }
        return this.conversion.getDbCharSet();
    }

    public short getNCsId() throws SQLException {
        if (this.conversion == null) {
            DBError.throwSqlException(65);
        }
        return this.conversion.getNCharSet();
    }

    public synchronized short getStructAttrCsId() throws SQLException {
        return this.getDbCsId();
    }

    public synchronized short getStructAttrNCsId() throws SQLException {
        return this.getNCsId();
    }

    public synchronized Map getTypeMap() {
        this.ensureClassMapExists();
        return this.map;
    }

    public synchronized void setTypeMap(Map map) {
        this.addDefaultClassMapEntriesTo(map);
        this.map = map;
    }

    private void addDefaultClassMapEntriesTo(Map map) {
        if (map != null) {
            this.addClassMapEntry("SYS.XMLTYPE", "oracle.xdb.XMLTypeFactory", map);
        }
    }

    private void addClassMapEntry(String string, String string2, Map map) {
        if (OracleConnection.containsKey(map, string)) {
            return;
        }
        try {
            Class clazz = this.safelyGetClassForName(string2);
            map.put(string, clazz);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    private static boolean containsKey(Map map, Object object) {
        return map.get(object) != null;
    }

    public synchronized void setUsingXAFlag(boolean bl) {
        this.UsingXA = bl;
    }

    public synchronized boolean getUsingXAFlag() {
        return this.UsingXA;
    }

    public synchronized void setXAErrorFlag(boolean bl) {
        this.XA_wants_error = bl;
    }

    public synchronized boolean getXAErrorFlag() {
        return this.XA_wants_error;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void initUserName() throws SQLException {
        if (this.user != null) {
            return;
        }
        this.checkPhyiscalStatus();
        Statement statement = this.createStatement();
        ((OracleStatement)statement).setRowPrefetch(1);
        try {
            ResultSet resultSet = statement.executeQuery("select USER from dual");
            if (resultSet.next()) {
                this.user = resultSet.getString(1);
            }
            resultSet.close();
            resultSet = null;
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            statement.close();
            statement = null;
            throw throwable;
        }
        statement.close();
        statement = null;
    }

    public synchronized String getUserName() throws SQLException {
        if (this.user == null) {
            this.initUserName();
        }
        return this.user;
    }

    public DBAccess getDBAccess() {
        return this.db_access;
    }

    public Properties getDBAccessProperties() throws SQLException {
        if (this.db_access == null) {
            return null;
        }
        return this.db_access.getDBAccessProperties();
    }

    public synchronized void logicalClose() throws SQLException {
        if (this.m_opc != null && this.physicalStatus) {
            this.m_opc.logicalClose();
        }
        this.setPhysicalStatus(false);
        if (this.m_clientIdSet) {
            this.clearClientIdentifier(this.m_clientId);
        }
        this.m_startTime = 0L;
    }

    public synchronized void setStartTime(long l) throws SQLException {
        if (l <= 0L) {
            DBError.throwSqlException(68);
        } else {
            this.m_startTime = l;
        }
    }

    public synchronized long getStartTime() throws SQLException {
        return this.m_startTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized byte[] getFDO(boolean bl) throws SQLException {
        if (this.fdo == null && bl) {
            CallableStatement callableStatement;
            block4: {
                callableStatement = null;
                try {
                    this.checkPhyiscalStatus();
                    callableStatement = this.prepareCall("begin ? := dbms_pickler.get_format (?); end;");
                    callableStatement.registerOutParameter(1, 2);
                    callableStatement.registerOutParameter(2, -4);
                    callableStatement.execute();
                    this.fdo = callableStatement.getBytes(2);
                    Object var4_3 = null;
                    if (callableStatement == null) break block4;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    if (callableStatement != null) {
                        callableStatement.close();
                    }
                    callableStatement = null;
                    throw throwable;
                }
                callableStatement.close();
            }
            callableStatement = null;
            {
            }
        }
        return this.fdo;
    }

    public synchronized void setFDO(byte[] byArray) throws SQLException {
        this.fdo = byArray;
    }

    public synchronized boolean getBigEndian() throws SQLException {
        if (this.big_endian == null) {
            int[] nArray = Util.toJavaUnsignedBytes(this.getFDO(true));
            int n = nArray[6 + nArray[5] + nArray[6] + 5];
            int n2 = n & 0x10;
            if (n2 < 0) {
                n2 += 256;
            }
            this.big_endian = n2 > 0 ? new Boolean(true) : new Boolean(false);
        }
        return this.big_endian;
    }

    public void setHoldability(int n) throws SQLException {
        DBError.throwUnsupportedFeatureSqlException();
    }

    public int getHoldability() throws SQLException {
        DBError.throwUnsupportedFeatureSqlException();
        return 0;
    }

    public synchronized Savepoint setSavepoint() throws SQLException {
        return this.oracleSetSavepoint();
    }

    public synchronized Savepoint setSavepoint(String string) throws SQLException {
        return this.oracleSetSavepoint(string);
    }

    public synchronized void rollback(Savepoint savepoint) throws SQLException {
        this.disallowGlobalTxnMode(122);
        if (this.auto_commit) {
            DBError.throwSqlException(121);
        }
        if (this.m_svptStmt == null) {
            this.m_svptStmt = this.createStatement();
        }
        String string = null;
        try {
            string = savepoint.getSavepointName();
        }
        catch (SQLException sQLException) {
            string = svptPrefix + savepoint.getSavepointId();
        }
        this.m_svptStmt.executeUpdate("ROLLBACK TO " + string);
    }

    public synchronized void releaseSavepoint(Savepoint savepoint) throws SQLException {
        DBError.throwUnsupportedFeatureSqlException();
    }

    public Statement createStatement(int n, int n2, int n3) throws SQLException {
        DBError.throwUnsupportedFeatureSqlException();
        return null;
    }

    public PreparedStatement prepareStatement(String string, int n, int n2, int n3) throws SQLException {
        DBError.throwUnsupportedFeatureSqlException();
        return null;
    }

    public CallableStatement prepareCall(String string, int n, int n2, int n3) throws SQLException {
        DBError.throwUnsupportedFeatureSqlException();
        return null;
    }

    public PreparedStatement prepareStatement(String string, int n) throws SQLException {
        DBError.throwUnsupportedFeatureSqlException();
        return null;
    }

    public PreparedStatement prepareStatement(String string, int[] nArray) throws SQLException {
        DBError.throwUnsupportedFeatureSqlException();
        return null;
    }

    public PreparedStatement prepareStatement(String string, String[] stringArray) throws SQLException {
        DBError.throwUnsupportedFeatureSqlException();
        return null;
    }

    public synchronized OracleSavepoint oracleSetSavepoint() throws SQLException {
        this.disallowGlobalTxnMode(117);
        if (this.auto_commit) {
            DBError.throwSqlException(120);
        }
        if (this.m_svptStmt == null) {
            this.m_svptStmt = this.createStatement();
        }
        oracle.jdbc.driver.OracleSavepoint oracleSavepoint = new oracle.jdbc.driver.OracleSavepoint();
        String string = "SAVEPOINT ORACLE_SVPT_" + oracleSavepoint.getSavepointId();
        this.m_svptStmt.executeUpdate(string);
        return oracleSavepoint;
    }

    public synchronized OracleSavepoint oracleSetSavepoint(String string) throws SQLException {
        this.disallowGlobalTxnMode(117);
        if (this.auto_commit) {
            DBError.throwSqlException(120);
        }
        if (this.m_svptStmt == null) {
            this.m_svptStmt = this.createStatement();
        }
        oracle.jdbc.driver.OracleSavepoint oracleSavepoint = new oracle.jdbc.driver.OracleSavepoint(string);
        String string2 = "SAVEPOINT " + oracleSavepoint.getSavepointName();
        this.m_svptStmt.executeUpdate(string2);
        return oracleSavepoint;
    }

    public synchronized void oracleRollback(OracleSavepoint oracleSavepoint) throws SQLException {
        this.disallowGlobalTxnMode(115);
        if (this.auto_commit) {
            DBError.throwSqlException(121);
        }
        if (this.m_svptStmt == null) {
            this.m_svptStmt = this.createStatement();
        }
        String string = null;
        try {
            string = oracleSavepoint.getSavepointName();
        }
        catch (SQLException sQLException) {
            string = svptPrefix + oracleSavepoint.getSavepointId();
        }
        this.m_svptStmt.executeUpdate("ROLLBACK TO " + string);
    }

    public synchronized void oracleReleaseSavepoint(OracleSavepoint oracleSavepoint) throws SQLException {
        DBError.throwUnsupportedFeatureSqlException();
    }

    void switchTxnMode(int n, int n2) {
        if (this.logicalHandle) {
            if (this.m_opc_oc.m_txn_mode == n) {
                this.m_opc_oc.m_txn_mode = n2;
            }
        } else if (this.m_txn_mode == n) {
            this.m_txn_mode = n2;
        }
    }

    private void enterTxnMode(int n) {
        if (this.logicalHandle) {
            this.m_opc_oc.m_txn_mode = n;
        } else {
            this.m_txn_mode = n;
        }
    }

    private void disallowGlobalTxnMode(int n) throws SQLException {
        if (this.m_txn_mode == 2 || this.logicalHandle && this.m_opc_oc.m_txn_mode == 2) {
            DBError.throwSqlException(n);
        }
    }

    private void initClientDataSupport() {
        this.m_clientData = null;
    }

    public synchronized Object getClientData(Object object) {
        if (this.m_clientData == null) {
            return null;
        }
        return this.m_clientData.get(object);
    }

    public synchronized Object setClientData(Object object, Object object2) {
        if (this.m_clientData == null) {
            this.m_clientData = new Hashtable();
        }
        return this.m_clientData.put(object, object2);
    }

    public synchronized Object removeClientData(Object object) {
        if (this.m_clientData == null) {
            return null;
        }
        return this.m_clientData.remove(object);
    }

    public synchronized BlobDBAccess createBlobDBAccess() throws SQLException {
        if (this.lob_dbaccess == null) {
            this.lob_dbaccess = new LobDBAccessImpl(this);
        }
        return this.lob_dbaccess;
    }

    public synchronized ClobDBAccess createClobDBAccess() throws SQLException {
        if (this.lob_dbaccess == null) {
            this.lob_dbaccess = new LobDBAccessImpl(this);
        }
        return this.lob_dbaccess;
    }

    public synchronized BfileDBAccess createBfileDBAccess() throws SQLException {
        if (this.lob_dbaccess == null) {
            this.lob_dbaccess = new LobDBAccessImpl(this);
        }
        return this.lob_dbaccess;
    }

    public void printState() {
        try {
            short s = this.getJdbcCsId();
            short s2 = this.getDbCsId();
            short s3 = this.getStructAttrCsId();
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
    }

    public String getProtocolType() {
        return this.protocol;
    }

    public String getURL() {
        return this.url;
    }

    public synchronized void setStmtCacheSize(int n) throws SQLException {
        this.setStatementCacheSize(n);
        this.setImplicitCachingEnabled(true);
        this.setExplicitCachingEnabled(true);
    }

    public synchronized void setStmtCacheSize(int n, boolean bl) throws SQLException {
        this.setStatementCacheSize(n);
        this.setImplicitCachingEnabled(true);
        this.setExplicitCachingEnabled(true);
        this.m_stmtClearMetaData = bl;
    }

    public synchronized int getStmtCacheSize() {
        int n = 0;
        try {
            n = this.getStatementCacheSize();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        if (n == -1) {
            n = 0;
        }
        return n;
    }

    public synchronized void setStatementCacheSize(int n) throws SQLException {
        if (this.logicalHandle) {
            DBError.throwSqlException(96);
        }
        if (this.statementCache == null) {
            this.statementCache = new LRUStatementCache(n);
        } else {
            this.statementCache.resize(n);
        }
    }

    public synchronized int getStatementCacheSize() throws SQLException {
        if (this.logicalHandle) {
            return this.m_opc.getStatementCacheSize();
        }
        if (this.statementCache == null) {
            return -1;
        }
        return this.statementCache.getCacheSize();
    }

    public synchronized void setImplicitCachingEnabled(boolean bl) throws SQLException {
        if (this.statementCache == null) {
            this.statementCache = new LRUStatementCache(0);
        }
        this.statementCache.setImplicitCachingEnabled(bl);
    }

    public synchronized boolean getImplicitCachingEnabled() throws SQLException {
        if (this.statementCache == null) {
            return false;
        }
        return this.statementCache.getImplicitCachingEnabled();
    }

    public synchronized void setExplicitCachingEnabled(boolean bl) throws SQLException {
        if (this.statementCache == null) {
            this.statementCache = new LRUStatementCache(0);
        }
        this.statementCache.setExplicitCachingEnabled(bl);
    }

    public synchronized boolean getExplicitCachingEnabled() throws SQLException {
        if (this.statementCache == null) {
            return false;
        }
        return this.statementCache.getExplicitCachingEnabled();
    }

    public synchronized void purgeImplicitCache() throws SQLException {
        if (this.statementCache != null) {
            this.statementCache.purgeImplicitCache();
        }
    }

    public synchronized void purgeExplicitCache() throws SQLException {
        if (this.statementCache != null) {
            this.statementCache.purgeExplicitCache();
        }
    }

    public synchronized PreparedStatement getStatementWithKey(String string) throws SQLException {
        if (this.statementCache != null) {
            OracleStatement oracleStatement = this.statementCache.searchExplicitCache(string);
            if (oracleStatement == null || oracleStatement.statementType == 1) {
                return (PreparedStatement)((Object)oracleStatement);
            }
            DBError.throwSqlException(125);
            return null;
        }
        return null;
    }

    public synchronized CallableStatement getCallWithKey(String string) throws SQLException {
        if (this.statementCache != null) {
            OracleStatement oracleStatement = this.statementCache.searchExplicitCache(string);
            if (oracleStatement == null || oracleStatement.statementType == 2) {
                return (CallableStatement)((Object)oracleStatement);
            }
            DBError.throwSqlException(125);
            return null;
        }
        return null;
    }

    public synchronized void cacheImplicitStatement(OraclePreparedStatement oraclePreparedStatement, String string, int n, int n2) throws SQLException {
        if (this.statementCache == null) {
            DBError.throwSqlException(95);
        } else {
            this.statementCache.addToImplicitCache(oraclePreparedStatement, string, n, n2);
        }
    }

    public synchronized void cacheExplicitStatement(OraclePreparedStatement oraclePreparedStatement, String string) throws SQLException {
        if (this.statementCache == null) {
            DBError.throwSqlException(95);
        } else {
            this.statementCache.addToExplicitCache(oraclePreparedStatement, string);
        }
    }

    public synchronized boolean isStatementCacheInitialized() {
        if (this.logicalHandle) {
            return this.m_opc.isStatementCacheInitialized();
        }
        if (this.statementCache == null) {
            return false;
        }
        return this.statementCache.getCacheSize() != 0;
    }

    public void setDefaultAutoRefetch(boolean bl) throws SQLException {
        this.m_defaultAutoRefetch = bl;
    }

    public boolean getDefaultAutoRefetch() throws SQLException {
        return this.m_defaultAutoRefetch;
    }

    public synchronized void registerTAFCallback(OracleOCIFailover oracleOCIFailover, Object object) throws SQLException {
        if (this.db_access != null) {
            this.db_access.registerTAFCallback(this, oracleOCIFailover, object);
        }
    }

    public String getDatabaseProductVersion() throws SQLException {
        int[] nArray = new int[1];
        try {
            this.needLine();
            byte[] byArray = this.db_access.getVersion();
            return this.conversion.CharBytesToString(byArray, byArray.length);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public synchronized boolean getReportRemarks() {
        return this.report_remarks;
    }

    public synchronized short getVersionNumber() throws SQLException {
        return this.db_access.getVersionNumber();
    }

    public synchronized void registerCloseCallback(OracleCloseCallback oracleCloseCallback, Object object) {
        this.m_occ = oracleCloseCallback;
        this.m_privData = object;
    }

    public void setCreateStatementAsRefCursor(boolean bl) {
        this.db_access.setCreateStatementAsRefCursor(bl);
    }

    public boolean getCreateStatementAsRefCursor() {
        return this.db_access.getCreateStatementAsRefCursor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int pingDatabase(int n) throws SQLException {
        int n2;
        block8: {
            if (this.closed) {
                return -1;
            }
            Statement statement = null;
            n2 = this.m_txn_mode;
            try {
                try {
                    statement = this.createStatement();
                    ((OracleStatement)statement).defineColumnType(1, 12, 1);
                    statement.executeQuery("SELECT 'x' FROM DUAL");
                }
                catch (SQLException sQLException) {
                    int n3 = -1;
                    Object var7_5 = null;
                    if (statement != null) {
                        statement.close();
                    }
                    this.switchTxnMode(1, n2);
                    return n3;
                }
                Object var7_4 = null;
                if (statement == null) break block8;
            }
            catch (Throwable throwable) {
                Object var7_6 = null;
                if (statement != null) {
                    statement.close();
                }
                this.switchTxnMode(1, n2);
                throw throwable;
            }
            statement.close();
        }
        this.switchTxnMode(1, n2);
        return 0;
    }

    public synchronized Map getJavaObjectTypeMap() {
        return this.m_javaObjectMap;
    }

    public synchronized void setJavaObjectTypeMap(Map map) {
        this.m_javaObjectMap = map;
    }

    public void clearClientIdentifier(String string) throws SQLException {
        if (this.m_clientIdSet) {
            this.db_access.clearClientIdentifier(this, string);
        }
    }

    public void setClientIdentifier(String string) throws SQLException {
        this.m_clientIdSet = true;
        this.m_clientId = string;
        this.db_access.setClientIdentifier(this, string);
    }

    public void assertComplete() throws SQLException {
    }

    public boolean getSynchronousMode() {
        return true;
    }

    public void setSynchronousMode(boolean bl) {
    }

    public void registerApiDescription(String string, short s, short s2, String string2) {
    }

    public Object openJoltConnection(String string, short s, short s2) {
        return null;
    }

    public void setSessionTimeZone(String string) throws SQLException {
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            statement = this.prepareStatement("ALTER SESSION SET TIME_ZONE = '" + string + "'");
            statement.executeUpdate();
            statement = this.prepareStatement("SELECT DBTIMEZONE FROM DUAL");
            resultSet = statement.executeQuery();
            resultSet.next();
            String string2 = resultSet.getString(1);
            this.setDbTzCalendar(string2);
            Object var6_6 = null;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            statement.close();
            throw throwable;
        }
        statement.close();
        this.m_sessionTimeZone = string;
    }

    public String getSessionTimeZone() {
        return this.m_sessionTimeZone;
    }

    private void setDbTzCalendar(String string) {
        long l = TimeZone.getTimeZone(string).getRawOffset() - 28800000;
        TimeZone timeZone = TimeZone.getDefault();
        timeZone.setRawOffset((int)l);
        this.m_dbTzCalendar = new GregorianCalendar(timeZone);
    }

    public Calendar getDbTzCalendar() {
        return this.m_dbTzCalendar;
    }

    public void setAccumulateBatchResult(boolean bl) {
        this.m_accumulateBatchResult = bl;
    }

    public boolean isAccumulateBatchResult() {
        return this.m_accumulateBatchResult;
    }

    public Class classForNameAndSchema(String string, String string2) throws ClassNotFoundException {
        return this.db_access.classForNameAndSchema(string, string2);
    }

    public Class safelyGetClassForName(String string) throws ClassNotFoundException {
        return this.db_access.safelyGetClassForName(string);
    }

    public static OracleConnection unwrapCompletely(oracle.jdbc.OracleConnection oracleConnection) {
        oracle.jdbc.OracleConnection oracleConnection2;
        oracle.jdbc.OracleConnection oracleConnection3 = oracleConnection2 = oracleConnection;
        while (oracleConnection3 != null) {
            oracleConnection2 = oracleConnection3;
            oracleConnection3 = oracleConnection2.unwrap();
        }
        return (OracleConnection)oracleConnection2;
    }

    public void setWrapper(oracle.jdbc.OracleConnection oracleConnection) {
        this.wrapper = oracleConnection;
    }

    public oracle.jdbc.OracleConnection unwrap() {
        return null;
    }

    public oracle.jdbc.OracleConnection getWrapper() {
        if (this.wrapper != null) {
            return this.wrapper;
        }
        return this;
    }

    public static oracle.jdbc.internal.OracleConnection physicalConnectionWithin(Connection connection) {
        OracleConnection oracleConnection = null;
        if (connection != null) {
            oracleConnection = OracleConnection.unwrapCompletely((oracle.jdbc.OracleConnection)connection);
        }
        return oracleConnection;
    }
}

