/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.jdbc.log;

import com.mysql.jdbc.Util;
import com.mysql.jdbc.log.Log;
import com.mysql.jdbc.profiler.ProfilerEvent;
import java.util.Date;

public class StandardLogger
implements Log {
    private static final int FATAL = 0;
    private static final int ERROR = 1;
    private static final int WARN = 2;
    private static final int INFO = 3;
    private static final int DEBUG = 4;
    private static final int TRACE = 5;
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private static final int LINE_SEPARATOR_LENGTH = LINE_SEPARATOR.length();

    public StandardLogger(String name) {
    }

    public boolean isDebugEnabled() {
        return true;
    }

    public boolean isErrorEnabled() {
        return true;
    }

    public boolean isFatalEnabled() {
        return true;
    }

    public boolean isInfoEnabled() {
        return true;
    }

    public boolean isTraceEnabled() {
        return true;
    }

    public boolean isWarnEnabled() {
        return true;
    }

    public void logDebug(Object message) {
        this.logInternal(4, message, null);
    }

    public void logDebug(Object message, Throwable exception) {
        this.logInternal(4, message, exception);
    }

    public void logError(Object message) {
        this.logInternal(1, message, null);
    }

    public void logError(Object message, Throwable exception) {
        this.logInternal(1, message, exception);
    }

    public void logFatal(Object message) {
        this.logInternal(0, message, null);
    }

    public void logFatal(Object message, Throwable exception) {
        this.logInternal(0, message, exception);
    }

    public void logInfo(Object message) {
        this.logInternal(3, message, null);
    }

    public void logInfo(Object message, Throwable exception) {
        this.logInternal(3, message, exception);
    }

    public void logTrace(Object message) {
        this.logInternal(5, message, null);
    }

    public void logTrace(Object message, Throwable exception) {
        this.logInternal(5, message, exception);
    }

    public void logWarn(Object message) {
        this.logInternal(2, message, null);
    }

    public void logWarn(Object message, Throwable exception) {
        this.logInternal(2, message, exception);
    }

    private String findCallingClassAndMethod(Throwable t) {
        String stackTraceAsString = Util.stackTraceToString(t);
        String callingClassAndMethod = "Caller information not available";
        int endInternalMethods = stackTraceAsString.lastIndexOf("com.mysql.jdbc");
        if (endInternalMethods != -1) {
            int endOfLine = -1;
            int compliancePackage = stackTraceAsString.indexOf("com.mysql.jdbc.compliance", endInternalMethods);
            endOfLine = compliancePackage != -1 ? compliancePackage - LINE_SEPARATOR_LENGTH : stackTraceAsString.indexOf(LINE_SEPARATOR, endInternalMethods);
            if (endOfLine != -1) {
                int nextEndOfLine = stackTraceAsString.indexOf(LINE_SEPARATOR, endOfLine + LINE_SEPARATOR_LENGTH);
                callingClassAndMethod = nextEndOfLine != -1 ? stackTraceAsString.substring(endOfLine + LINE_SEPARATOR_LENGTH, nextEndOfLine) : stackTraceAsString.substring(endOfLine + LINE_SEPARATOR_LENGTH);
            }
        }
        if (!callingClassAndMethod.startsWith("at ")) {
            return "at " + callingClassAndMethod;
        }
        return callingClassAndMethod;
    }

    private void logInternal(int level, Object msg, Throwable exception) {
        StringBuffer msgBuf = new StringBuffer();
        msgBuf.append(new Date().toString());
        msgBuf.append(" ");
        switch (level) {
            case 0: {
                msgBuf.append("FATAL: ");
                break;
            }
            case 1: {
                msgBuf.append("ERROR: ");
                break;
            }
            case 2: {
                msgBuf.append("WARN: ");
                break;
            }
            case 3: {
                msgBuf.append("INFO: ");
                break;
            }
            case 4: {
                msgBuf.append("DEBUG: ");
                break;
            }
            case 5: {
                msgBuf.append("TRACE: ");
            }
        }
        if (msg instanceof ProfilerEvent) {
            ProfilerEvent evt = (ProfilerEvent)msg;
            Throwable locationException = evt.getEventCreationPoint();
            if (locationException == null) {
                locationException = new Throwable();
            }
            msgBuf.append("Profiler Event: [");
            switch (evt.getEventType()) {
                case 4: {
                    msgBuf.append("EXECUTE");
                    break;
                }
                case 5: {
                    msgBuf.append("FETCH");
                    break;
                }
                case 1: {
                    msgBuf.append("CONSTRUCT");
                    break;
                }
                case 2: {
                    msgBuf.append("PREPARE");
                    break;
                }
                case 3: {
                    msgBuf.append("QUERY");
                    break;
                }
                case 0: {
                    msgBuf.append("WARN");
                    break;
                }
                default: {
                    msgBuf.append("UNKNOWN");
                }
            }
            msgBuf.append("] ");
            msgBuf.append(this.findCallingClassAndMethod(locationException));
            msgBuf.append(" duration: ");
            msgBuf.append(evt.getEventDurationMillis());
            msgBuf.append(" ms, connection-id: ");
            msgBuf.append(evt.getConnectionId());
            msgBuf.append(", statement-id: ");
            msgBuf.append(evt.getStatementId());
            msgBuf.append(", resultset-id: ");
            msgBuf.append(evt.getResultSetId());
            String evtMessage = evt.getMessage();
            if (evtMessage != null) {
                msgBuf.append(", message: ");
                msgBuf.append(evtMessage);
            }
        } else {
            Throwable locationException = new Throwable();
            msgBuf.append(this.findCallingClassAndMethod(locationException));
            msgBuf.append(" ");
            if (msg != null) {
                msgBuf.append(String.valueOf(msg));
            }
        }
        if (exception != null) {
            msgBuf.append(LINE_SEPARATOR);
            msgBuf.append(LINE_SEPARATOR);
            msgBuf.append("EXCEPTION STACK TRACE:");
            msgBuf.append(LINE_SEPARATOR);
            msgBuf.append(LINE_SEPARATOR);
            msgBuf.append(Util.stackTraceToString(exception));
        }
        String messageAsString = msgBuf.toString();
        System.err.println(messageAsString);
    }
}

