'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: controltools.inc,v $
'*
'*  $Revision: 1.13 $
'*
'*  last change: $Author: tbo $ $Date: 2005/09/07 19:06:58 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'* owner : marc.neumann@sun.com
'*
'* short description : Helper Routines for Form and Control Tests
'*
'***************************************************************************************
'*
' #1 fSwitchAutopilotOff
' #1 fSetControlProperty
' #1 fGetControlProperty
' #1 hDrawingWithSelection 
'*
'\**************************************************************************************


function fSwitchAutopilotOff(SwitchAutoOff as boolean)
    '/// turn the Control autopilots off or on
    '/// <u>parameter:</u>
    '/// <b>SwitchAutoOff:</b> If true the autopilot is turned off, if the parameter is false the autopilot is turned on
                
    '/// open a new document
    printlog "open a new document"
    gApplication = "Writer"
	call hNewDocument
    Kontext "DocumentWriter"       
	DocumentWriter.TypeKeys "tt_doc" , true
	sleep(1)
    Kontext "Toolbar"
        call hToolbarSelect("FormControls",true)
  	Kontext "FormControls"   	
    '/// insert a group box to activate autopilot button
   	ListBox.Click
   	sleep(1)      
    call hDrawingWithSelection ( 50, 50, 60, 60 )
	sleep(2)
    '/// check if auto pilot dialog is available
    Kontext "AutoPilotListComboBox"
    if AutoPilotListComboBox.Exists(3) then
        Kontext "AutoPilotListComboBox"
        AutoPilotListComboBox.Cancel
        sleep(2)
        if SwitchAutoOff = true then
            Kontext "FormControls" 
            printlog "switch autopilot off"   	
            UseWizards.Click
            sleep(2)
        else 
            printlog "let autopilot on"
        endif
    else
        if SwitchAutoOff = false then
            Kontext "FormControls" 
            printlog "switch autopilot on"   	
            UseWizards.Click
            sleep(2)
        else 
            printlog "let autopilot off"
        endif
    endif 	
    hCloseDocument
end function
'--------------------------------------------------------------------------------------
function fSetControlProperty(sControlType, sPropertyName, sPropertyValue as string)
  	'/// set the property of a control via the control property browser    
    '/// <u>parameter:</u>
    '/// <b>sControlType:</b> The name of the control type f.e. TextBox
    '/// <b>sPropertyName:</b> The name of the control property f.e. DefaultValue
    '/// <b>sPropertyValue:</b> The value of the control property    
    
    ' switch to the General Page
    Kontext "ControlPropertiesDialog"
        ControlPropertiesTabControl.setPage TabGeneralControl 

    Kontext "TabGeneralControl"	
    if TabGeneralControl.exists(3) then        
        printlog "Set Property '" + sPropertyName + "' to the value '" + sPropertyValue + "' for a '" + sControlType + "' control."   
        ' A - C
                
                if sPropertyName = "Accuracy" then
                    Accuracy.setText(sPropertyValue)
                elseif sPropertyName = "Align" then        
                    Align.select(Cint(sPropertyValue))
                elseif sPropertyName = "AdditionalInfo" then
                    Information.setText(sPropertyValue)
                elseif sPropertyName = "AutoComplete" then
                    AutoComplete.select(Cint(sPropertyValue))
                elseif sPropertyName = "Background" then
                    Background.select(Cint(sPropertyValue))
                elseif sPropertyName = "Border" then
                    Border.select(Cint(sPropertyValue))
                elseif sPropertyName = "BorderColor" then
                    BorderColor.select(Cint(sPropertyValue))
                elseif sPropertyName = "ButtonType" then
                    ButtonType.select(Cint(sPropertyValue))
                elseif sPropertyName = "BlockIncrement" then
                    BlockIncrement.setText(sPropertyValue)
                elseif sPropertyName = "CellBound" then
                    Kontext "ControlPropertiesDialog"
                        ControlPropertiesTabControl.setPage TabDataControl
                    Kontext "TabDataControl"
                        CellBound.setText(sPropertyValue)
                    Kontext "ControlPropertiesDialog"
                        ControlPropertiesTabControl.setPage TabGeneralControl
                elseif sPropertyName = "CellRange" then
                    Kontext "ControlPropertiesDialog"
                        ControlPropertiesTabControl.setPage TabDataControl
                    Kontext "TabDataControl"
                        CellRange.setText(sPropertyValue)
                    Kontext "ControlPropertiesDialog"
                        ControlPropertiesTabControl.setPage TabGeneralControl
                elseif sPropertyName = "CurrSymPosition" then
                    CurrSymPosition.select(Cint(sPropertyValue))
                elseif sPropertyName = "CurrencySymbol" then
                    CurrencySymbol.setText(sPropertyValue)
            
        'D - F
        
                elseif sPropertyName = "DateMax" then
                    DateMax.setText(sPropertyValue)
                elseif sPropertyName = "DateMin" then
                    DateMin.setText(sPropertyValue)
                elseif sPropertyName = "DateFormat" then
                    DateFormat.select(Cint(sPropertyValue))
                elseif sPropertyName = "DefaultButton" then
                    DefaultButton.select(Cint(sPropertyValue))
                elseif sPropertyName = "DefaultSelection2" then
                    DefaultSelection2.setText(sPropertyValue)
                elseif sPropertyName = "DefaultState" then
                    DefaultState.select(Cint(sPropertyValue))
                elseif sPropertyName = "DefaultValue" then                    
                    sleep(1)
                    TabGeneralControl.TypeKeys "<TAB>" , 10 , true
                    sleep(1)
                    TabGeneralControl.TypeKeys sPropertyValue , true                    
                    sleep(1)
                    TabGeneralControl.TypeKeys "<RETURN>" , true
                    sleep(1)
                elseif sPropertyName = "Delay" then
                    Delay.setText(sPropertyValue)
                elseif sPropertyName = "DropDown" then
                    DropDown.select(Cint(sPropertyValue))
                elseif sPropertyName = "Enabled" then
                    Enabled.select(Cint(sPropertyValue))
                elseif sPropertyName = "EditMask" then
                    EditMask.setText(sPropertyValue)    
                elseif sPropertyName = "FilteringSorting" then
                    FilteringSorting.select(Cint(sPropertyValue))
                elseif sPropertyName = "Frame" then
                    Frame.select(Cint(sPropertyValue))
        
        'G - L
        
                elseif sPropertyName = "Graphics" then
                    Graphics.setText(sPropertyValue)  
                elseif sPropertyName = "GraphicsAlignment" then
                    GraphicsAlignment.select(Cint(sPropertyValue))
                elseif sPropertyName = "HelpText" then
                    HelpText.setText(sPropertyValue)
                elseif sPropertyName = "HelpURL" then
                    HelpURL.setText(sPropertyValue)
                elseif sPropertyName = "HiddenValue" then
                    HiddenValue.setText(sPropertyValue)
                elseif sPropertyName = "HideSelection" then
                    HideSelection.select(Cint(sPropertyValue))
                elseif sPropertyName = "IconSize" then
                    IconSize.select(Cint(sPropertyValue))
                elseif sPropertyName = "LineCount" then
                     LineCount.setText(sPropertyValue) 
                elseif sPropertyName = "LineIncrement" then
                    LineIncrement.setText(sPropertyValue)
                elseif sPropertyName = "LiteralMask" then
                    LiteralMask.setText(sPropertyValue)
                elseif sPropertyName = "ListEntries" then
                    ListEntries.setText(sPropertyValue)
            
        'M - O
         
                elseif sPropertyName = "MaxTextLen" then
                     MaxTextLen.setText(sPropertyValue)
                elseif sPropertyName = "MultiLine" then
                    qaerrorlog "The Property MultiLine doesn't exists anymore."
                    qaerrorlog "Please use TextType instead. This property will be removed soon."
                    TextType.select(Cint(sPropertyValue))
                elseif sPropertyName = "MultiLine2" then
                    MultiLine.select(Cint(sPropertyValue))
                elseif sPropertyName = "Multiselection" then
                    Multiselection.select(Cint(sPropertyValue))
                elseif sPropertyName = "NameText" then
                    NameText.setText(sPropertyValue)
                elseif sPropertyName = "Navigation" then
                    Navigation.select(Cint(sPropertyValue))
                elseif sPropertyName = "NavigationBar" then
                    NavigationBar.select(Cint(sPropertyValue))            
                elseif sPropertyName = "Orientation" then
                    Orientation.select(Cint(sPropertyValue))
                elseif sPropertyName = "Order" then
                    Order.setText(sPropertyValue)
            
        'P - R
        
                elseif sPropertyName = "Password" then
                    Password.setText(sPropertyValue)
                elseif sPropertyName = "ReferenceValue" then
                    Kontext "ControlPropertiesDialog"
                        ControlPropertiesTabControl.setPage TabDataControl
                    Kontext "TabDataControl"
                        ReferenceValue.setText(sPropertyValue)
                    Kontext "ControlPropertiesDialog"
                        ControlPropertiesTabControl.setPage TabGeneralControl
                elseif sPropertyName = "Repeat" then
                    Repeat.select(Cint(sPropertyValue))
                elseif sPropertyName = "Printable" then
                    Printable.select(Cint(sPropertyValue))
                elseif sPropertyName = "Positioning" then
                    Positioning.select(Cint(sPropertyValue))
                elseif sPropertyName = "RecordActions" then
                    RecordActions.select(Cint(sPropertyValue))    
                elseif sPropertyName = "RecordMarker" then
                    RecordMarker.select(Cint(sPropertyValue))
                elseif sPropertyName = "ReferenceValueOff" then
                    Kontext "ControlPropertiesDialog"
                        ControlPropertiesTabControl.setPage TabDataControl
                    Kontext "TabDataControl"
                        ReferenceValueOff.setText(sPropertyValue)
                    Kontext "ControlPropertiesDialog"
                        ControlPropertiesTabControl.setPage TabGeneralControl
                elseif sPropertyName = "Readonly" then
                    Readonly.select(Cint(sPropertyValue))    
                elseif sPropertyName = "RowHeight" then
                    RowHeight.setText(sPropertyValue)
            
        'S
        
                elseif sPropertyName = "Scale" then
                    Scale.select(Cint(sPropertyValue))
                elseif sPropertyName = "Spin" then            
                    Spin.select(CInt(sPropertyValue))
                elseif sPropertyName = "StrictFormat" then            
                    StrictFormat.select(CInt(sPropertyValue))
                elseif sPropertyName = "Scrollbars" then
                    Scrollbars.select(Cint(sPropertyValue))
                elseif sPropertyName = "SymbolColor" then
                    SymbolColor.select(Cint(sPropertyValue))        
                elseif sPropertyName = "TextType" then
                    TextType.select(Cint(sPropertyValue))
                elseif sPropertyName = "ScrollValueMin" then
                    ScrollValueMin.setText(sPropertyValue) 
                elseif sPropertyName = "ScrollValueMax" then
                    ScrollValueMax.setText(sPropertyValue)
                elseif sPropertyName = "ScrollValueDefault" then
                    ScrollValueDefault.setText(sPropertyValue)        
        
        'T - U
        
                elseif sPropertyName = "TabOrder" then            
                    Order.setText(sPropertyValue)
                elseif sPropertyName = "TabStop" then            
                    TabStop.select(Cint(sPropertyValue))
                elseif sPropertyName = "TakeFocus" then            
                    TakeFocus.select(Cint(sPropertyValue))
                elseif sPropertyName = "TextType" then            
                    TextType.select(Cint(sPropertyValue))
                elseif sPropertyName = "ThousandSeperator" then            
                    ThousandSeperator.select(CInt(sPropertyValue))
                elseif sPropertyName = "TimeFormat" then
                    TimeFormat.select(Cint(sPropertyValue))
                elseif sPropertyName = "TimeMax" then
                    TimeMax.setText(sPropertyValue)
                elseif sPropertyName = "TimeMin" then
                    TimeMin.setText(sPropertyValue)
                elseif sPropertyName = "ToggleProp" then
                    ToggleProp.select(Cint(sPropertyValue))
                elseif sPropertyName = "TriState" then
                    TriState.select(Cint(sPropertyValue))
                elseif sPropertyName = "URL" then        
                    URL.setText(sPropertyValue)
            
        'V - Z
        
                elseif sPropertyName = "VisibleSize" then
                    VisibleSize.setText(sPropertyValue)
                elseif sPropertyName = "ValueMin" then
                    if sControlType = "FormattedField" then
                        EffectiveMin.setText(sPropertyValue)
                    else
                        ValueMin.setText(sPropertyValue)
                    endif
                elseif sPropertyName = "ValueMax" then
                    if sControltype = "FormattedField" then
                        EffectiveMax.setText(sPropertyValue)
                    else
                        ValueMax.setText(sPropertyValue)
                    endif
                elseif sPropertyName = "ValueStep" then
                    ValueStep.setText(sPropertyValue)
        '        
                else
                    warnlog "The property " + sPropertyName + " doesn't exists in the function fSetControlProperty."
                    warnlog "Please add it to the function in base/tools/controltools.inc."          
                endif
        
        'need additional return
        TabGeneralControl.TypeKeys "<RETURN>"
    else
        warnlog "The control property browser doesn't exists."
    endif
    
end function
'--------------------------------------------------------------------------------------
function fGetControlProperty(sControlType,sPropertyName)
	'/// get the property of a control from the control property browser    
    '/// <u>parameter:</u>
    '/// <b>sControlType:</b> The name of the control type f.e. TextBox
    '/// <b>sPropertyName:</b> The name of the control property f.e. DefaultValue
            
    Dim sReturn as String

    ' switch to the General Page
    Kontext "ControlPropertiesDialog"
        ControlPropertiesTabControl.setPage TabGeneralControl

    Kontext "TabGeneralControl"	
    if TabGeneralControl.exists(3) then
        
    ' A - C
        
        if sPropertyName = "Accuracy" then
            sReturn = Accuracy.getSelIndex
        elseif sPropertyName = "AdditionalInfo" then
            sReturn = Information.getText
        elseif sPropertyName = "Align" then
            sReturn = Align.getSelIndex 
        elseif sPropertyName = "AutoComplete" then
            sReturn = AutoComplete.getSelIndex   
        elseif sPropertyName = "Background" then
            sReturn = Background.getSelIndex
        elseif sPropertyName = "BlockIncrement" then
            sReturn = BlockIncrement.getText
        elseif sPropertyName = "Border" then
            sReturn = Border.getSelIndex
        elseif sPropertyName = "BorderColor" then
            sReturn = BorderColor.getSelIndex
        elseif sPropertyName = "ButtonType" then
            sReturn = ButtonType.getSelIndex
        elseif sPropertyName = "CellBound" then
            Kontext "ControlPropertiesDialog"
                ControlPropertiesTabControl.setPage TabDataControl
            Kontext "TabDataControl"                
                sReturn = CellBound.getText()                
            Kontext "ControlPropertiesDialog"
                ControlPropertiesTabControl.setPage TabGeneralControl
        elseif sPropertyName = "CellRange" then
            Kontext "ControlPropertiesDialog"
                ControlPropertiesTabControl.setPage TabDataControl
            Kontext "TabDataControl"                
                sReturn = CellRange.getText()                
            Kontext "ControlPropertiesDialog"
                ControlPropertiesTabControl.setPage TabGeneralControl
        elseif sPropertyName = "CurrSymPosition" then
            sReturn = CurrSymPosition.getSelIndex
        elseif sPropertyName = "CurrencySymbol" then
            sReturn = CurrencySymbol.getText
            
    'D - F
            
        elseif sPropertyName = "DateMax" then
            sReturn = DateMax.getText
        elseif sPropertyName = "DateMin" then
            sReturn = DateMin.getText    
        elseif sPropertyName = "DateFormat" then
            sReturn = DateFormat.getSelIndex
        elseif sPropertyName = "DefaultButton" then
            sReturn = DefaultButton.getSelIndex
        elseif sPropertyName = "Delay" then
            sReturn = Delay.getText
        elseif sPropertyName = "DefaultState" then
            sReturn = DefaultState.getSelIndex
        elseif sPropertyName = "DefaultSelection2" then
            sReturn = DefaultSelection2.getText
        elseif sPropertyName = "DefaultValue" then
            sReturn = DefaultValue.getText
        elseif sPropertyName = "DropDown" then
            sReturn = DropDown.getSelIndex
        elseif sPropertyName = "EditMask" then
            sReturn = EditMask.getText
        elseif sPropertyName = "Enabled" then
            sReturn = Enabled.getSelIndex
        elseif sPropertyName = "FilteringSorting" then
            sReturn = FilteringSorting.getSelIndex
        elseif sPropertyName = "Formatkey" then
            sReturn = Formatkey.getText
        elseif sPropertyName = "Frame" then
            sReturn = Frame.getSelIndex
            
    'G - L
            
        elseif sPropertyName = "Graphics" then
            sReturn = Graphics.getSelText
        elseif sPropertyName = "GraphicsAlignment" then  
            sReturn = GraphicsAlignment.getSelIndex
        elseif sPropertyName = "HelpText" then
            sReturn = HelpText.getText
        elseif sPropertyName = "HelpURL" then
            sReturn = HelpURL.getText
        elseif sPropertyName = "HiddenValue" then
            sReturn = HiddenValue.getText 
        elseif sPropertyName = "HideSelection" then
            sReturn = HideSelection.getSelIndex            
        elseif sPropertyName = "IconSize" then
            sReturn = IconSize.getSelIndex
        elseif sPropertyName = "LineCount" then
            sReturn = LineCount.getText
        elseif sPropertyName = "LineIncrement" then
            sReturn = LineIncrement.getText
        elseif sPropertyName = "LiteralMask" then
            sReturn = LiteralMask.getText
        elseif sPropertyName = "ListEntries" then  
            sReturn = ListEntries.getText
        
    'M - O
        
        elseif sPropertyName = "MaxTextLen" then
            sReturn = MaxTextLen.getText
        elseif sPropertyName = "MultiLine" then
            sReturn = MultiLine.getSelIndex
        elseif sPropertyName = "MultiLine2" then
            sReturn = MultiLine.getSelIndex
        elseif sPropertyName = "Multiselection" then
            sReturn = Multiselection.getSelIndex
        elseif sPropertyName = "NameText" then
            sReturn = NameText.getText
        elseif sPropertyName = "Navigation" then
            sReturn = Navigation.getSelIndex
        elseif sPropertyName = "NavigationBar" then
            sReturn = NavigationBar.getSelIndex
        elseif sPropertyName = "Order" then
            sReturn = Order.getText
        elseif sPropertyName = "Orientation" then
            sReturn = Orientation.getSelIndex        
         
    'P - R
        
        elseif sPropertyName = "Password" then
            sReturn = Password.getText
        elseif sPropertyName = "Positioning" then
            sReturn = Positioning.getSelIndex
        elseif sPropertyName = "Printable" then
            sReturn = Printable.getSelIndex
        elseif sPropertyName = "Readonly" then
            sReturn = Readonly.getSelIndex
        elseif sPropertyName = "RecordActions" then
            sReturn = RecordActions.getSelIndex
        elseif sPropertyName = "RecordMarker" then
            sReturn = RecordMarker.getSelIndex
        elseif sPropertyName = "ReferenceValue" then
            Kontext "ControlPropertiesDialog"
                ControlPropertiesTabControl.setPage TabDataControl
            Kontext "TabDataControl"
                sReturn = ReferenceValue.getText
            Kontext "ControlPropertiesDialog"
                ControlPropertiesTabControl.setPage TabGeneralControl
        elseif sPropertyName = "Repeat" then
            sReturn = Repeat.getSelIndex  
        elseif sPropertyName = "RowHeight" then
            sReturn = RowHeight.getText
    
    'S
        
        elseif sPropertyName = "Scale" then
            sReturn = Scale.getSelIndex
        elseif sPropertyName = "Scrollbars" then
            sReturn = Scrollbars.getSelIndex
        elseif sPropertyName = "ScrollValueDefault" then
            sReturn = ScrollValueDefault.getText
        elseif sPropertyName = "ScrollValueMax" then
            sReturn = ScrollValueMax.getText
        elseif sPropertyName = "ScrollValueMin" then
            sReturn = ScrollValueMin.getText
        elseif sPropertyName = "Spin" then
            sReturn = Spin.getSelIndex
        elseif sPropertyName = "StrictFormat" then
            sReturn = StrictFormat.getSelIndex
        elseif sPropertyName = "SymbolColor" then
            sReturn = SymbolColor.getSelIndex
        
    'T - U
        
        elseif sPropertyName = "TabStop" then
            sReturn = TabStop.getSelIndex
        elseif sPropertyName = "TakeFocus" then
            sReturn = TakeFocus.getSelIndex
        elseif sPropertyName = "TextType" then            
            sReturn = TextType.getSelIndex
        elseif sPropertyName = "ThousandSeperator" then
            sReturn = ThousandSeperator.getSelIndex
        elseif sPropertyName = "TimeFormat" then
            sReturn = TimeFormat.getSelIndex
        elseif sPropertyName = "TimeMax" then
            sReturn = TimeMax.getText
        elseif sPropertyName = "TimeMin" then
            sReturn = TimeMin.getText
        elseif sPropertyName = "ToggleProp" then  
            sReturn = ToggleProp.getSelIndex
        elseif sPropertyName = "TriState" then
            sReturn = TriState.getSelIndex
    
    'V - Z
    
        elseif sPropertyName = "ValueMin" then
            if sControlType = "FormattedField" then
                sReturn = EffectiveMin.getText
            else
                sReturn = ValueMin.getText
            endif
        elseif sPropertyName = "ValueMax" then
            if sControltype = "FormattedField" then
                sReturn = EffectiveMax.getText
            else
                sReturn = ValueMax.getText
            endif
        elseif sPropertyName = "VisibleSize" then
            sReturn = VisibleSize.getText
        elseif sPropertyName = "ValueStep" then
            sReturn = ValueStep.getText
            
        endif
    else
        warnlog "The control property browser doesn't exists."
    endif
    fGetControlProperty = sReturn
end function
'--------------------------------------------------------------------------------------
sub hDrawingWithSelection ( iStartX, iStartY, iEndX, iEndY )
    '/// move the mouse with pressed mouse button      
    '/// <u>parameter:</u>
    '/// <b>iStartX:</b> The x start coordinate
    '/// <b>iStartY:</b> The y start coordinate
    '/// <b>iEndX:</b> The x end coordinate
    '/// <b>iEndY:</b> The x end coordinate

   select case gApplication

      case "CALC"        : Kontext "DocumentCalc"
                            DocumentCalc.MouseDown ( iStartX, iStartY )
                            DocumentCalc.MouseMove ( iEndX, iEndY )
                            DocumentCalc.MouseUp ( iEndX, iEndY )

      case "WRITER"      : Kontext "DocumentWriter"
                            DocumentWriter.MouseDown ( iStartX, iStartY )
                            DocumentWriter.MouseMove ( iEndX, iEndY )
                            DocumentWriter.MouseUp ( iEndX, iEndY )

      case "HTMLDOKUMENT": Kontext "DocumentWriterWeb"
                            DocumentWriterWeb.MouseDown ( iStartX, iStartY )
                            DocumentWriterWeb.MouseMove ( iEndX, iEndY )
                            DocumentWriterWeb.MouseUp ( iEndX, iEndY )

      case "GLOBALDOC"   : Kontext "DocumentMasterDoc"
                            DocumentMasterDoc.MouseDown ( iStartX, iStartY )
                            DocumentMasterDoc.MouseMove ( iEndX, iEndY )
                            DocumentMasterDoc.MouseUp ( iEndX, iEndY )

      case "IMPRESS"	 : Kontext "DocumentImpress"
                            DocumentImpress.MouseDown ( iStartX, iStartY )
                            DocumentImpress.MouseMove ( iEndX, iEndY )
                            DocumentImpress.MouseUp ( iEndX, iEndY )

      case "DRAW"        : Kontext "DocumentDraw"
                            DocumentDraw.MouseDown ( iStartX, iStartY )
                            DocumentDraw.MouseMove ( iEndX, iEndY )
                            DocumentDraw.MouseUp ( iEndX, iEndY )

   end select
end sub
