'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: fkt_test.inc,v $
'*
'*  $Revision: 1.4 $
'*
'*  last change: $Author: tbo $ $Date: 2005/09/27 14:58:43 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'* owner : peter.junge@Sun.COM
'*
'* short description : Test for all 'classical SO 5.2' functions
'*
'************************************************************************
'*
' #1 fkt_test         ' initial routine
' #1 tAllFunctions    ' Check if all functions deliver correct results
' #1 tInsertFunction  ' Create one function with the autopilot
'*
'\***********************************************************************

sub fkt_test

Printlog Chr(13) + "--------- fkt_test ---------"

        call tAllFunctions
        call tInsertFunction

End Sub

'****************************************************************************************************************

testcase tAllFunctions
'/// This testcase load the documents: (gTesttoolpath & "input\calc\functions\functions.sxc"),
'/// (gTesttoolpath & "input\calc\functions\addin_german.sdc"), (gTesttoolpath & "input\calc\functions\addin_other.sdc")
'/// which contains the results from all functions in starcalc. ///
'/// This results are compare with reference values ///

    Dim i as integer
    Dim function_file, cell as string

    function_file = convertpath(gTesttoolpath & "calc\special\input\functions.sxc")

    Call hDateioeffnen function_file
    Kontext
    If active.exists(2) then active.Yes
    Printlog "Execute hard Recalc..."
    DocumentCalc.typekeys "<MOD1 SHIFT F9>"
    Printlog "... and look, if all values are zero"
    Kontext
    cgotocell ("D1")
    i = 0

    For i = 2 to 261
        if i = 29 AND iSystemsprache <> 01 then
	   QAErrorLog "Cell D29 will only be tested on locales en_US"
	   i = i + 1
	end if
        cell = "D" & i
        call checkcellwert(cell, 0)
    next i

    printlog " There has been " + i + " functions checked"
    Call hCloseDocument
endcase
    
testcase tAddinOld

    Dim addin_german, addin_other, cell as string

    addin_german = convertpath(gTesttoolpath & "calc\special\input\addin_german.sdc")
    addin_other = convertpath(gTesttoolpath & "calc\special\input\addin_other.sdc")

    printlog "* Checking the addins *"

    If iSystemSprache <> 49 then
        hDateiOeffnen addin_other
    else
        hDateiOeffnen addin_german
    end if

    Printlog "Execute hard recalc ..."
    Kontext "DocumentCalc"
    Sleep 2
    DocumentCalc.typekeys "<MOD1 SHIFT F9>"
    Printlog "... and look, if the values are zero"
    Kontext
    For i = 2 to 9
                cell = "D" & i
                call checkcellwert(cell, 0)
    Next i
    call hCloseDocument

    printlog "*** End functiontest ***"


endcase
'
'---------------------------------------------------------------------------
'
testcase tInsertFunction
'/// This testcase checks if the function "coth(1,2)" has as result '1,2'. ///
'/// The function is created with the formula autopilot. ///

     dim FktBereich : dim FktName : dim decimalTestString
     printlog "* Insert Function"
     Call  hNewDocument
     decimalTestString = "1" & getDecimalSeperator & "2"
     Kontext "RechenleisteCalc"
       if not RechenleisteCalc.isvisible then
          Warnlog "The FormularBar wasn't visible"
          ViewToolbarsFormulaBar
       end if

    InsertFunction
    Kontext "FunktionsAutoPilot"
    select case iSprache
        case 01   : FktBereich = 8 : FktName = "COTH" 'Englisch(US)
        case 03   : FktBereich = 8 : FktName = "COTH" 'Portugisich
        case 31   : FktBereich = 8 : FktName = "COTH" 'Holländisch
        case 33   : FktBereich = 8 : FktName = "COTH" 'Französisch
        case 34   : FktBereich = 8 : FktName = "COTH" 'Spanisch
        case 39   : FktBereich = 8 : FktName = "COTH" 'Italienisch
        case 45   : FktBereich = 8 : FktName = "COTH" 'Dänisch
        case 46   : FktBereich = 8 : FktName = "COTH" 'Schwedisch
        case 48   : FktBereich = 8 : FktName = "COTH" 'Polnisch
        case 49   : FktBereich = 8 : FktName = "COTHYP" 'Deutsch
        case 55   : FktBereich = 8 : FktName = "COTH" 'Portuguese/Brazil
        case 81   : FktBereich = 8 : FktName = "COTH" 'Japanese
        case 82   : FktBereich = 8 : FktName = "COTH" 'Korean
        case 86   : FktBereich = 8 : FktName = "COTH" 'Chinese simple
        case 88   : FktBereich = 8 : FktName = "COTH" 'Chinese traditional
        case else : QAErrorLog "No Case for Language Code " & iSprache & " defined"  : goto endsub
    end select
        
        printlog "Systemlanguage :" & iSystemsprache
    Kategorie.select FktBereich
    Funktion.select FktName
    weiter.click
    kontext "FunktionsAutoPilot"
    Funktionsbutton1.click
    Kontext "FunktionsAutoPilot"
    Kategorie.select FktBereich
    Funktion.select FktName
    weiter.click
    kontext "FunktionsAutoPilot"
    Editfeld1.settext decimalTestString
    FunktionsAutoPilot.Ok
        if cZellwert ("A1") = decimalTestString then
        Printlog "Functionresult with the autopilot OK"
        else
            Warnlog "Autopilot doesn't work"
        end if
    call cgotocell ("A1")
    InsertFunction
    Kontext "FunktionsAutoPilot"
    if FunktionsAutoPilot.exists then
        if Editfeld1.gettext = FktName & "(" & decimalTestString & ")" then
                Weiter.Click
            if Editfeld1.gettext = decimalTestString then
                Printlog " The function autopilot shows the correct nested formula"
                FunktionsAutoPilot.Ok
            else
                Warnlog " The second editfield of the nested formula has false contents "
                FunktionsAutoPilot.Cancel
            end if
        else
                Warnlog " The editfield has a false content"
                FunktionsAutoPilot.Cancel
        end if
    else
        Warnlog " Autopilot hasn't started"
    end if
        Call hCloseDocument

endcase
'
'---------------------------------------------------------------------------
'
