'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: keyboardaccessibility5.inc,v $
'*
'*  $Revision: 1.10 $
'*
'*  last change: $Author: pj $ $Date: 2005/12/29 13:52:32 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'* owner : hercule.li@sun.com
'*
'* short description : Keyboard Accessibility -- 5
'*
'************************************************************************
'*
' #1 tPageFields_1
' #1 tPageFields_2
' #1 tPageFields_3
' #1 tFieldOptions_1
' #1 tTableOptions_1
' #1 tTableOptions_2
' #1 tTableOptions_3
' #1 tTableOptions_4
' #1 tGrouping_1
' #1 tGrouping_2
' #1 tGrouping_3
' #1 tGrouping_4
' #0 fDragDataToField
'*
'\***********************************************************************

sub C_Keyboard_Accessibility_5

   printLog Chr(13) + "=== Keyboard_Accessibility 5 ==="

   printLog Chr(13) + "-- test DatePilot  -- Page Fields"
      Call tPageFields_1    'General test
      Call tPageFields_2    'Change in listbox
      Call tPageFields_3    'Save and reload
      Call tFieldOptions_1  'Options
      Call tTableOptions_1  'Add filter (check) default
      Call tTableOptions_2  'Add filter (Uncheck)
     'Call tTableOptions_3  'Enable drill to details (check) default
     'Call tTableOptions_4  'Enable drill to details (Uncheck)
      Call tGrouping_1      'Intervals test
      Call tGrouping_2      'UnGroup
      Call tGrouping_3      'Star/End manually - number
      Call tGrouping_4      'Star/End manually - date

end sub

'-------------------------------------------------------------------------

testcase tPageFields_1

  Dim testFile as String
  Dim sAll     as String

  testFile = "pageFields.sxc"

  select case iSprache
      case 01   :  sAll = "- all -"      ' English (USA)
'      case 33   :  sAll = ""      ' French
'      case 34   :  sAll = ""      ' Spanish
'      case 39   :  sAll = ""      ' Italian
'      case 46   :  sAll = ""      ' Swedish
'      case 49   :  sAll = ""      ' German
'      case 55   :  sAll = ""      ' Portuguese
      case 81   :  sAll = "- すべて -"      ' Japanese
      case 82   :  sAll = "- 모두 -"      ' Korean
      case 86   :  sAll = "- 全部 -"      ' Chinese (simplified)
      case 88   :  sAll = "- 全部 -"      ' Chinese (traditional)
      case else :                 ' Fallback
         QAErrorLog "Now, the test does not support for the language " +iSprache
         goto endsub
  end select

  printLog "General test"
  '/// General test

   call hNewDocument

   '/// Open test file datapilot.sxc
    Call hDateiOeffnen ( gTesttoolPath + "calc\special\input\keyboardaccessibility\" + testFile )

    '/// DataPilot/Start , check current selection
     DataDataPilotStart
     Kontext "QuelleAuswaehlen"
       AktuelleSelektion.Check
     QuelleAuswaehlen.OK
     Sleep 2

      '/// Drop PRODUCTS to page fields, AREA to column fields, SALESMAN to row fields and the years to data fields
       Kontext "Datenpilot"
         Sleep 2
         Call fDragDataToField()
       Datenpilot.OK
       Sleep 2

     '/// In B22 check if the listbox is set to -all-
      if cZellwert("B22") <> sAll then Warnlog "B24 isn't correct !"

   Call hCloseDocument

endcase

'-------------------------------------------------------------------------

testcase tPageFields_2

  printLog "Change from listbox"
  '/// Change from listbox

  qaErrorLog "#i37098# Can't access listbox with keyboard ."

endcase

'-------------------------------------------------------------------------

testcase tPageFields_3

  Dim testFile , saveAsFile as String

  testFile   = "pageFields.sxc"
  saveAsFile =  ConvertPath (gOfficePath + "user\work\pageFields.sxc" )

  if hFileExists ( saveAsFile ) then app.kill ( saveAsFile )

  printLog "Save and reload"
  '/// Save and reload

  qaErrorLog "#i37098# Can't access listbox with keyboard ."
  goto NOTest
   call hNewDocument

   '/// Open test file datapilot.sxc
    Call hDateiOeffnen ( gTesttoolPath + "calc\special\input\keyboardaccessibility\" + testFile )

    '/// DataPilot/Start , check current selection
     DataDataPilotStart
     Kontext "QuelleAuswaehlen"
       AktuelleSelektion.Check
     QuelleAuswaehlen.OK
     Sleep 2

      '/// Drop PRODUCTS to page fields, AREA to column fields, SALESMAN to row fields and the years to data fields
       Kontext "Datenpilot"
         Sleep 2
         Call fDragDataToField()
       Datenpilot.OK
       Sleep 2

      '/// goto cell A21 - Filter
       Call cgotocell("A21")

      '/// Context menu -- Filter
       DocumentCalc.OpenContextMenu
       Call hMenuSelectNr(3)
       Sleep 2
       Kontext "PivotFilter"
       Sleep 2
         FieldName1.Select "Salesman"
         Value1.Select "Bush"
       PivotFilter.OK

     '/// Check if DVD is still in the listbox -- Should NOT , A26 should be Bush
      '.....
      if cZellwert("A26") <> "Bush" then Warnlog "A26 isn't correct !"

     '/// Save the document to another file
      Call hSpeichernUnterKill(saveAsFile)
      Sleep 2

  '/// Close the saved file
   Call hCloseDocument
   Sleep 2

    printLog "Reload the test file"
   '/// Re-open the saved file
    Call hDateiOeffnen (saveAsFile)

   '/// Check if DVD is still in the listbox -- Should NOT
      '.....
    if cZellwert("A26") <> "Bush" then Warnlog "A26 isn't correct !"

   Call hCloseDocument
   if hFileExists ( saveAsFile ) then app.kill ( saveAsFile )
NOTest:
endcase

'-------------------------------------------------------------------------

testcase tFieldOptions_1

  Dim testFile , saveAsFile as String

  testFile   = "pageFields.sxc"
  saveAsFile =  ConvertPath (gOfficePath + "user\work\pageFields.sxc" )

  if hFileExists ( saveAsFile ) then app.kill ( saveAsFile )

  printLog "Options"
  '/// Options

   call hNewDocument

   '/// Open test file datapilot.sxc
    Call hDateiOeffnen ( gTesttoolPath + "calc\special\input\keyboardaccessibility\" + testFile )

     '/// DataPilot/Start , check current selection
     DataDataPilotStart
     Kontext "QuelleAuswaehlen"
       AktuelleSelektion.Check
     QuelleAuswaehlen.OK
     Sleep 2

     '/// Drop PRODUCTS to page fields, AREA to column fields, SALESMAN to row fields and the years to data fields
       Kontext "Datenpilot"
         Sleep 2
         Call fDragDataToField()

     '/// Set focus to 2000 , then press Options
         Datenpilot.typekeys "<Tab>" , 8 , TRUE
         Datenpilot.typekeys "<Up>"  , 2 , TRUE
         Sleep 2
         Optionen.Click

         Kontext "DataFieldsFunctionDlg"
           FunctionList.Select 3  'Average
         DataFieldsFunctionDlg.OK

       Kontext "Datenpilot"
       Datenpilot.OK
       Sleep 2

       if cZellwert("F41") <> "200000" then Warnlog "F41 isn't correct !"
       if cZellwert("F42") <> "492000" then Warnlog "F42 isn't correct !"

     '/// Save the document to another file
      Call hSpeichernUnterKill(saveAsFile)
      Sleep 2

   '/// Close the saved file
    Call hCloseDocument
    Sleep 2

    printLog "reload"
   '/// Re-open the saved file
    Call hDateiOeffnen (saveAsFile)

   '/// Check if the datapilot is still alive with all entries.
    if cZellwert("F41") <> "200000" then Warnlog "F41 isn't correct !"
    if cZellwert("F42") <> "492000" then Warnlog "F42 isn't correct !"

   Call hCloseDocument
   if hFileExists ( saveAsFile ) then app.kill ( saveAsFile )

endcase

'-------------------------------------------------------------------------

testcase tTableOptions_1

  Dim testFile as String
  Dim sFilter  as String

  testFile = "pageFields.sxc"
  select case iSprache
      case 01   :  sFilter = "Filter"      ' English (USA)
      case 33   :  sFilter = "Filtre"      ' French
      case 34   :  sFilter = "Filtro"      ' Spanish
      case 39   :  sFilter = "Filtro"      ' Italian
      case 46   :  sFilter = "Filter?"     ' Swedish
      case 49   :  sFilter = "Filter"      ' German
      case 55   :  sFilter = "Filtro"      ' Portuguese
      case 81   :  sFilter = "フィルター"   ' Japanese
      case 82   :  sFilter = "여과기"      ' Korean
      case 86   :  sFilter = "筛选"         ' Chinese (simplified)
      case 88   :  sFilter = "過濾"        ' Chinese (traditional)
      case else :                            ' Fallback
         QAErrorLog "Now, the test does not support for the language " +iSprache
  end select

  printLog "Add filter (check) default"
  '/// Add filter (check) default

   call hNewDocument

   '/// Open test file datapilot.sxc
    Call hDateiOeffnen ( gTesttoolPath + "calc\special\input\keyboardaccessibility\" + testFile )

    '/// DataPilot/Start , check current selection
     DataDataPilotStart
     Kontext "QuelleAuswaehlen"
       AktuelleSelektion.Check
     QuelleAuswaehlen.OK
     Sleep 2

      '/// Drop PRODUCTS to page fields, AREA to column fields, SALESMAN to row fields and the years to data fields
       Kontext "Datenpilot"
         Sleep 2
         Call fDragDataToField()
       Datenpilot.OK
       Sleep 2

    '/// Check if there is filter field on top of the created data pilot table.
     if cZellwert("A21") <> sFilter then Warnlog "A21 isn't correct !"

   Call hCloseDocument

endcase

'-------------------------------------------------------------------------

testcase tTableOptions_2

  Dim testFile as String

  testFile = "pageFields.sxc"

  printLog "Add filter (Uncheck)"
  '/// Add filter (Uncheck)

   call hNewDocument

   '/// Open test file datapilot.sxc
    Call hDateiOeffnen ( gTesttoolPath + "calc\special\input\keyboardaccessibility\" + testFile )

    '/// DataPilot/Start , check current selection
     DataDataPilotStart
     Kontext "QuelleAuswaehlen"
       AktuelleSelektion.Check
     QuelleAuswaehlen.OK
     Sleep 2

      '/// Drop PRODUCTS to page fields, AREA to column fields, SALESMAN to row fields and the years to data fields
       Kontext "Datenpilot"
         Sleep 2
         Call fDragDataToField()

        '///Press more , then Uncheck 'Add FILTER'
         Zusaetze.Click
         Sleep 2
         AddFilter.UnCheck
       Datenpilot.OK
       Sleep 2

    '/// Check if there is no filter field on top of the created data pilot table.
     if cZellwert("A21") <> "Products" then Warnlog "A21 isn't correct !"

   Call hCloseDocument

endcase

'-------------------------------------------------------------------------

testcase tTableOptions_3

  Dim testFile as String

  testFile = "pageFields.sxc"

  printLog "Enable drill to details (check) default"
  '/// Enable drill to details (check) default

   call hNewDocument

   '/// Open test file datapilot.sxc
    Call hDateiOeffnen ( gTesttoolPath + "calc\special\input\keyboardaccessibility\" + testFile )

    '/// DataPilot/Start , check current selection
     DataDataPilotStart
     Kontext "QuelleAuswaehlen"
       AktuelleSelektion.Check
     QuelleAuswaehlen.OK
     Sleep 2

      '/// Drop PRODUCTS to page fields, AREA to column fields, SALESMAN to row fields and the years to data fields
       Kontext "Datenpilot"
         Sleep 2
         Call fDragDataToField()
       Datenpilot.OK
       Sleep 2

      '......

     if cZellwert("A21") <> "Products" then Warnlog "A21 isn't correct !"

   Call hCloseDocument

endcase

'-------------------------------------------------------------------------

testcase tTableOptions_4

  Dim testFile as String

  testFile = "pageFields.sxc"

  printLog "Enable drill to details (Uncheck)"
  '/// Enable drill to details (Uncheck)

   call hNewDocument

   '/// Open test file datapilot.sxc
    Call hDateiOeffnen ( gTesttoolPath + "calc\special\input\keyboardaccessibility\" + testFile )

    '/// DataPilot/Start , check current selection
     DataDataPilotStart
     Kontext "QuelleAuswaehlen"
       AktuelleSelektion.Check
     QuelleAuswaehlen.OK
     Sleep 2

      '/// Drop PRODUCTS to page fields, AREA to column fields, SALESMAN to row fields and the years to data fields
       Kontext "Datenpilot"
         Sleep 2
         Call fDragDataToField()

        '///Press more , then Uncheck 'Enable Drill To Details'
         Zusaetze.Click
         Sleep 2
         EnableDrillToDetails.UnCheck
       Datenpilot.OK
       Sleep 2

        '......

   Call hCloseDocument

endcase

'-------------------------------------------------------------------------

testcase tGrouping_1

  Dim testFile               as String
  Dim sQuarter , sJan , sDec as String

  testFile = "group.sxc"

  select case iSystemSprache
      case 01  :  sQuarter = "Q1"
                  sJan     = "Jan"
                  sDec     = "Dec"
      case 33  :  sQuarter = "Q1"
                  sJan     = "Jan"
                  sDec     = "Dec"
      case 34  :  sQuarter = "Q1"
                  sJan     = "Jan"
                  sDec     = "Dec"
      case 39  :  sQuarter = "Q1"
                  sJan     = "Jan"
                  sDec     = "Dec"
      case 46  :  sQuarter = "Q1"
                  sJan     = "Jan"
                  sDec     = "Dec"
      case 49  :  sQuarter = "Q1"
                  sJan     = "Jan"
                  sDec     = "Dez"
      case 55  :  sQuarter = "Q1"
                  sJan     = "Jan"
                  sDec     = "Dec"
      case 81  :  sQuarter = "Q1"
                  sJan     = "Jan"
                  sDec     = "Dec"
      case 82  :  sQuarter = "Q1"
                  sJan     = "Jan"
                  sDec     = "Dec"
      case 86  :  sQuarter = "1季"
                  sJan     = "一月"
                  sDec     = "十二月"
      case 88  :  sQuarter = "1季"
                  sJan     = "一月"
                  sDec     = "十二月"
      case else:  QAErrorLog  "The test does not support the language " + iSystemSprache
                  Goto endsub
  end select

  printLog "Intervals test"
  '/// Intervals test

   call hNewDocument

   '/// Open test file datapilot.sxc
    Call hDateiOeffnen ( gTesttoolPath + "calc\special\input\keyboardaccessibility\" + testFile )

    '/// DataPilot/Start , check current selection
     DataDataPilotStart
     Kontext "QuelleAuswaehlen"
       AktuelleSelektion.Check
     QuelleAuswaehlen.OK
     Sleep 2

      '/// Drop Type to page fields , date to row fields, city number and seller to column fields and revenue to datafields.
       Kontext "Datenpilot"
         Sleep 2
         Datenpilot.typekeys "<Down>" , 2 , TRUE
         Sleep 2
         Call  fDataPilotPageSelection()
         Datenpilot.typekeys "<Up>"   , 2 , TRUE
         Sleep 2
         Call  fDataPilotRowSelection()
         Datenpilot.typekeys "<Down>" ,     TRUE
         Sleep 2
         Call  fDataPilotColumnSelection()
         Datenpilot.typekeys "<Up>"   , 4 , TRUE
         Sleep 2
         Call  fDataPilotColumnSelection()
         Datenpilot.typekeys "<Down>" , 3 , TRUE
         Sleep 2
         Call  fDataPilotColumnSelection()
         Call  fDataPilotDataSelection()
       Datenpilot.OK
       Sleep 2

    '/// Select A55
     Call cgotocell("A55")
     Sleep 2

    '/// Data /Outline /Group , check Month , Qualter and Year
     DataOutlineGroup
     Kontext "GroupingDlg"
       Intervals.Check
       IntervalsList.TypeKeys "<Down>" , 4 , TRUE
       IntervalsList.Check
       IntervalsList.TypeKeys "<Down>" ,     TRUE
       IntervalsList.Check
       IntervalsList.TypeKeys "<Down>" ,     TRUE
       IntervalsList.Check
     GroupingDlg.OK

     if cZellwert("A52") <> "2004"   then Warnlog "A52 isn't correct ! Get:" & cZellwert("A52")
     if cZellwert("A64") <> "2005"   then Warnlog "A64 isn't correct ! Get:" & cZellwert("A64")
     if cZellwert("B52") <> sQuarter  then Warnlog "B52 isn't correct ! Get:" & cZellwert("B52")
     if cZellwert("C52") <> sJan      then Warnlog "C52 isn't correct ! Get:" & cZellwert("C52")
     if cZellwert("C63") <> sDec      then Warnlog "C63 isn't correct ! Get:" & cZellwert("C63")

   Call hCloseDocument

endcase

'-------------------------------------------------------------------------

testcase tGrouping_2

  Dim testFile , sA52 as String

  testFile = "group.sxc"

  printLog "UnGroup"
  '/// UnGroup

   call hNewDocument

   '/// Open test file datapilot.sxc
    Call hDateiOeffnen ( gTesttoolPath + "calc\special\input\keyboardaccessibility\" + testFile )

    '/// DataPilot/Start , check current selection
     DataDataPilotStart
     Kontext "QuelleAuswaehlen"
       AktuelleSelektion.Check
     QuelleAuswaehlen.OK
     Sleep 2

      '/// Drop Type to page fields , date to row fields, city number and seller to column fields and revenue to datafields.
       Kontext "Datenpilot"
         Sleep 2
         Datenpilot.typekeys "<Down>" , 2 , TRUE
         Call  fDataPilotPageSelection()
         Datenpilot.typekeys "<Up>"   , 2 , TRUE
         Call  fDataPilotRowSelection()
         Datenpilot.typekeys "<Down>" ,     TRUE
         Call  fDataPilotColumnSelection()
         Datenpilot.typekeys "<Up>"   , 4 , TRUE
         Call  fDataPilotColumnSelection()
         Datenpilot.typekeys "<Down>" , 3 , TRUE
         Call  fDataPilotColumnSelection()
         Call  fDataPilotDataSelection()
         Sleep 2
       Datenpilot.OK
       Sleep 2

     sA52 = cZellwert("A52")

    '/// Select A55
     Call cgotocell("A55")
     Sleep 2

    '/// Data /Outline /Group , check Month , Qualter and Year
     DataOutlineGroup
     Kontext "GroupingDlg"
       Intervals.Check
       IntervalsList.TypeKeys "<Down>" , 4 , TRUE
       IntervalsList.Check
       IntervalsList.TypeKeys "<Down>" ,     TRUE
       IntervalsList.Check
       IntervalsList.TypeKeys "<Down>" ,     TRUE
       IntervalsList.Check
     GroupingDlg.OK

     if cZellwert("A52") = "2004" then
        '/// Data /Outline /UnGroup
         DataOutlineUngroup
         Sleep 2
         if cZellwert("A52") <> sA52 then Warnlog "A52 isn't correct !"
     else
         Warnlog "Something wrong in Group test !"
     end if

   Call hCloseDocument

endcase

'-------------------------------------------------------------------------

testcase tGrouping_3

  Dim testFile as String

  testFile = "group.sxc"

  printLog "Star/End manually - number"
  '/// Star/End manually - number

   call hNewDocument

   '/// Open test file datapilot.sxc
    Call hDateiOeffnen ( gTesttoolPath + "calc\special\input\keyboardaccessibility\" + testFile )

    '/// DataPilot/Start , check current selection
     DataDataPilotStart
     Kontext "QuelleAuswaehlen"
       AktuelleSelektion.Check
     QuelleAuswaehlen.OK
     Sleep 2

      '/// Drop Type to page fields , date to row fields, city number and seller to column fields and revenue to datafields.
       Kontext "Datenpilot"
         Sleep 2
         Datenpilot.typekeys "<Down>" , 2 , TRUE
         Sleep 2
         Call  fDataPilotPageSelection()
         Datenpilot.typekeys "<Up>"   , 2 , TRUE
         Sleep 2
         Call  fDataPilotRowSelection()
         Datenpilot.typekeys "<Down>" ,     TRUE
         Sleep 2
         Call  fDataPilotColumnSelection()
         Datenpilot.typekeys "<Up>"   , 4 , TRUE
         Sleep 2
         Call  fDataPilotColumnSelection()
         Datenpilot.typekeys "<Down>" , 3 , TRUE
         Sleep 2
         Call  fDataPilotColumnSelection()
         Call  fDataPilotDataSelection()
         Sleep 2
       Datenpilot.OK
       Sleep 2

    '/// Select B50
     Call cgotocell("B50")
     Sleep 2

    '/// Data /Outline /Group , check "Start Manual" and "End Manual"
    '/// + Set 0 at start and 1 at end , set 0.1 at group by
     DataOutlineGroup
     Kontext "GroupingNumDlg"
       ManualStart.Check
       StartContent.SetText "0"
       ManualEnd.Check
       EndContent.SetText "1"
       GroupBy.SetText "0.1"
       Sleep 2
     GroupingNumDlg.OK

'     if cZellwert("B50") <> "0-0.1"    then Warnlog "B50 isn't correct !"
     if cZellwert("B51") <> "Robinson" then Warnlog "B51 isn't correct !"
'     if cZellwert("I50") <> "0.2-0.3"  then Warnlog "#i41505# I50 isn't correct !"
     if cZellwert("I51") <> "Elvis"    then Warnlog "I51 isn't correct !"

   Call hCloseDocument

endcase

'-------------------------------------------------------------------------

testcase tGrouping_4

  Dim testFile as String

  testFile = "group.sxc"

  printLog "Star/End manually - date"
  '/// Star/End manually - date

  qaErrorLog "#i36822# This is date format problem in Calc."

endcase

'-------------------------------------------------------------------------

'*********************************
'Drag some data to the fields
'*********************************
function fDragDataToField()

    Call  fDataPilotPageSelection()
    Sleep 2
    Call  fDataPilotColumnSelection()
    Sleep 2
    Call  fDataPilotRowSelection()
    Sleep 2
    Call  fDataPilotDataSelection()
    Sleep 2
    Call  fDataPilotDataSelection()
    Sleep 2
    Call  fDataPilotDataSelection()
    Sleep 2

end function


