'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: c_tool_filters.inc,v $
'*
'*  $Revision: 1.8 $
'*
'*  last change: $Author: tbo $ $Date: 2005/09/07 19:07:34 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'* owner : peter.junge@sun.com
'*
'* short description : Tools for Calc filter names
'*
'************************************************************************
'*
' #1 fLoadCalcFilters
' #1 fWriteCalcFilterFile
'*
'\***********************************************************************

global gCalcFilterOOo2 as STRING
global gCalcFilterOOo2Template as STRING
global gCalcFilterOOo1 as STRING
global gCalcFilterOOo1Template as STRING
global gCalcFilterDIF as STRING
global gCalcFilterDBF as STRING
global gCalcFilterExcelXP as STRING
global gCalcFilterExcelXPTemplate as STRING
global gCalcFilterExcel95 as STRING
global gCalcFilterExcel95Template as STRING
global gCalcFilterExcel5 as STRING
global gCalcFilterExcel5Template as STRING
global gCalcFilterSO5 as STRING
global gCalcFilterSO5Template as STRING
global gCalcFilterSO4 as STRING
global gCalcFilterSO4Template as STRING
global gCalcFilterSO3 as STRING
global gCalcFilterSO3Template as STRING
global gCalcFilterSYLK as STRING
global gCalcFilterCSV as STRING
global gCalcFilterHTML as STRING
global gCalcFilterExcelXML as STRING
global gCalcFilterPocketExcel as STRING

function fLoadCalcFilters() as BOOLEAN
'///<u><b>Load language and product dependent names for important Calc filters</b></u>///
'///<ul>
'///<li>Determine filter file name</li>///
   dim sCalcFilterFile as STRING
       sCalcFilterFile = convertpath( gTesttoolPath & "calc\tools\filters\" & gProductName & "CalcFilter" & iSprache & ".txt")
       
   dim sFilterList(30) as String
       sFilterList( 0 ) = "0"
       
'///<li>Check if filter file exists</li>///
   if ( dir( sCalcFilterFile ) = "" ) then
      Warnlog( "fLoadCalcFilters(): The file for Calc filter names is missing, please create the list with ..\calc\tools\getCalcFilterNames.bas!" )
      '///<li>(Return FALSE if it doesn't)</li>///
      fLoadCalcFilters = FALSE
   else
      '///<li>If file exists read the list ...</li>///
      ListRead ( sFilterList(), sCalcFilterFile, "utf8" )

      '///<li>... and assign filter name strings to according variables</li>///
      gCalcFilterOOo2             = hGetValueForKeyAsString( sFilterList() , "calc8" )
      gCalcFilterOOo2Template     = hGetValueForKeyAsString( sFilterList() , "calc8t" )
      gCalcFilterOOo1             = hGetValueForKeyAsString( sFilterList() , "calc6" )
      gCalcFilterOOo1Template     = hGetValueForKeyAsString( sFilterList() , "calc6t" )
      gCalcFilterDIF              = hGetValueForKeyAsString( sFilterList() , "dif" )
      gCalcFilterDBF              = hGetValueForKeyAsString( sFilterList() , "dbf" )
      gCalcFilterExcelXP          = hGetValueForKeyAsString( sFilterList() , "xls97" )
      gCalcFilterExcelXPTemplate  = hGetValueForKeyAsString( sFilterList() , "xls97t" )
      gCalcFilterExcel95          = hGetValueForKeyAsString( sFilterList() , "xls95" )
      gCalcFilterExcel95Template  = hGetValueForKeyAsString( sFilterList() , "xls95t" )
      gCalcFilterExcel5           = hGetValueForKeyAsString( sFilterList() , "xls5" )
      gCalcFilterExcel5Template   = hGetValueForKeyAsString( sFilterList() , "xls5t" )
      gCalcFilterSO5              = hGetValueForKeyAsString( sFilterList() , "calc5" )
      gCalcFilterSO5Template      = hGetValueForKeyAsString( sFilterList() , "calc5t" )
      gCalcFilterSO4              = hGetValueForKeyAsString( sFilterList() , "calc4" )
      gCalcFilterSO4Template      = hGetValueForKeyAsString( sFilterList() , "calc4t" )
      gCalcFilterSO3              = hGetValueForKeyAsString( sFilterList() , "calc3" )
      gCalcFilterSO3Template      = hGetValueForKeyAsString( sFilterList() , "calc3t" )
      gCalcFilterSYLK             = hGetValueForKeyAsString( sFilterList() , "sylk" )
      gCalcFilterCSV              = hGetValueForKeyAsString( sFilterList() , "csv" )
      gCalcFilterHTML             = hGetValueForKeyAsString( sFilterList() , "html" )
      gCalcFilterExcelXML         = hGetValueForKeyAsString( sFilterList() , "msxml" )
      gCalcFilterPocketExcel      = hGetValueForKeyAsString( sFilterList() , "pocket" )
      fLoadCalcFilters = TRUE
   end if
   
'///</ul>
end function
'
'-----------------------------------------------------------
'
sub sWriteCalcFilterFile
'///<u><b>Write language and product dependent names for important Calc filters to a file</b></u>///
'///<ul>
'///<li>Define filter file name</li>///
    Dim sTargetFile as string
        sTargetFile = convertpath( gOfficePath & "user\work\" & gProductName & "CalcFilter" & iSprache & ".txt")
    Dim sFilterList( 23 ) as string
        sFilterList( 0 ) = "23"
    
    Dim iFileTypes as integer
    Dim iCurrentFileType as integer
    
    Dim cFilter as string    
    Dim sFileTypeSuffix as string
    Dim bNoXlsFilterFound AS BOOLEAN
    Dim bNoXltFilterFound AS BOOLEAN
    Dim bNoSdcFilterFound AS BOOLEAN
    Dim bNoVorFilterFound AS BOOLEAN
       
    
        '///<li>Open new document</li>///
        call hNewDocument()
        '///<li>Invoke File::Save as ...</li>///
        FileSaveAs
        Kontext "SpeichernDlg"
        '///<li>Determine number of available filter names</li>///
        iFileTypes = DateiTyp.getItemCount()
        
        '///<li>Loop through all filter names ...</li>///
        for iCurrentFileType = 1 to iFileTypes
            sleep(1)
            DateiTyp.select( iCurrentFileType )
            cFilter = DateiTyp.getSelText( 1 )
            'print cFilter
            sFileTypeSuffix = right(cFilter, 6)
            'set some flags
            bNoXlsFilterFound = TRUE
            bNoXltFilterFound = TRUE
            bNoSdcFilterFound = TRUE
            bNoVorFilterFound = TRUE
            
            '///<li>... and find desired filters by unique string particles</li>///
            '///<li>When found assign a key to the filter name</li>///
            select case sFileTypeSuffix
                   case "(.ods)" : sFilterList( 1 ) = "calc8=" & cFilter
                   case "(.ots)" : sFilterList( 2 ) = "calc8t=" & cFilter
                   case "(.sxc)" : sFilterList( 3 ) = "calc6=" & cFilter
                   case "(.stc)" : sFilterList( 4 ) = "calc6t=" & cFilter
                   case "(.dif)" : sFilterList( 5 ) = "dif=" & cFilter
                   case "(.dbf)" : sFilterList( 6 ) = "dbf=" & cFilter
                   case "(.xls)" 
                        if instr( cFilter, "XP" ) then
                            sFilterList( 7 ) = "xls97=" & cFilter
                            bNoXlsFilterFound = FALSE
                        endif
                        if instr( cFilter, "95" ) then
                            sFilterList( 9 ) = "xls95=" & cFilter
                            bNoXlsFilterFound = FALSE
                        endif
                        if instr( cFilter, "5.0" ) then
                            sFilterList( 11 ) = "xls5=" & cFilter
                            bNoXlsFilterFound = FALSE
                        endif
                        if bNoXlsFilterFound then 
                           warnlog "Unexpected item for XLS filters! -> Check this out!"
                        endif
                   case "(.xlt)" 
                        if instr( cFilter, "XP" ) then
                            sFilterList( 8 ) = "xls97t=" & cFilter
                            bNoXltFilterFound = FALSE
                        endif
                        if instr( cFilter, "95" ) then
                            sFilterList( 10 ) = "xls95t=" & cFilter
                            bNoXltFilterFound = FALSE
                        endif
                        if instr( cFilter, "5.0" ) then
                            sFilterList( 12 ) = "xls5t=" & cFilter
                            bNoXltFilterFound = FALSE
                        endif
                        if bNoXltFilterFound then 
                           warnlog "Unexpected item for XLT filters! -> Check this out!"
                        endif
                   case "(.sdc)"
                        if instr( cFilter, "5.0" ) then
                            sFilterList( 13 ) = "calc5=" & cFilter
                            bNoSdcFilterFound = FALSE
                        endif
                        if instr( cFilter, "4.0" ) then
                            sFilterList( 15 ) = "calc4=" & cFilter
                            bNoSdcFilterFound = FALSE
                        endif
                        if instr( cFilter, "3.0" ) then
                            sFilterList( 17 ) = "calc3=" & cFilter
                            bNoSdcFilterFound = FALSE
                        endif
                        if bNoSdcFilterFound then 
                           warnlog "Unexpected item for SDC filters! -> Check this out!"
                        endif
                   case "(.vor)"
                        if instr( cFilter, "5.0" ) then
                            sFilterList( 14 ) = "calc5t=" & cFilter
                            bNoVorFilterFound = FALSE
                        endif
                        if instr( cFilter, "4.0" ) then
                            sFilterList( 16 ) = "calc4t=" & cFilter
                            bNoVorFilterFound = FALSE
                        endif
                        if instr( cFilter, "3.0" ) then
                            sFilterList( 18 ) = "calc3t=" & cFilter
                            bNoVorFilterFound = FALSE
                        endif
                        if bNoVorFilterFound then 
                           warnlog "Unexpected item for VOR filters! -> Check this out!"
                        endif
                   case "(.slk)" : sFilterList( 19 ) = "sylk=" & cFilter
                   case "(.csv)" : sFilterList( 20 ) = "csv=" & cFilter
                   case ".html)" : sFilterList( 21 ) = "html=" & cFilter
                   case "(.xml)" : sFilterList( 22 ) = "msxml=" & cFilter
                   case "(.pxl)" : sFilterList( 23 ) = "pocket=" & cFilter
                   case else
                        warnlog "Unexpected end of reading the filter name. Maybe new filter included!?"
            end select
            
        next iCurrentFileType
        '///<li>Cancel dialog after the work is done</li>///
        SpeichernDlg.Cancel()
        '///<li>Close Calc document</li>///
        call hCloseDocument()
        
    
    '///<li>Print results in LOG file</li>///
    hListprint( sFilterList() , "Filterlist" )
    
    '///<li>Write results to output file</li>///
    listwrite( sFilterList() , sTargetFile , "UTF8" )
    
    '///<li>Inform user what to do</li>///
    warnlog ( "How to proceed:" )
    printlog( "Your new reference file has been copied to " & sTargetFile )
    printlog( "Please verify its content (DONT TAKE ANYTHING FOR GRANTED)" )
    printlog( "and copy the file to the appropriate place in your local CVS " )
    printlog( "workspace (...\calc\tools\filters\" )
    printlog( "Don't forget to check it into CVS after having tested it." )
    
'///</ul>
end sub

'
'-----------------------------------------------------------
'
function fGetCalcFiltername ( sFilterType as STRING, _
                              optional bWithExtension as BOOLEAN, _
                              optional bDetectMismatch as BOOLEAN ) as STRING
'///<u><b>Determine calc UI Filternames</b></u>///
'///This function can return the UI String for all calc filters///
'///+ 'sFilterType'(required): A keyword to refer which filter name should be returned/// 
'///+ (see 'select case' statement below)///
'///+ 'bWithExtension'(optinal): Should the default extension (e.g. '.ods') be appended///
'///+ (default is 'TRUE')///
'///+ 'bDetectMismatch'(optinal): Should the filter name be checked against archived references///
'///+ (see files in 'qatesttool/calc/tools/filters/')///
'///+ (default is 'FALSE')///
'///***********///
'///<u><b>Step-by-Step</b></u>///
'///<ul>
    dim sFilterNameKey as STRING
    dim sFilterTypeKey as STRING
    dim sFilterName as STRING
    dim sExtNames(20)
    dim sUIFileFormat AS STRING
    dim sReferenceFilterName AS STRING
    
    '///<li>Check if 'bWithExtension' is missing</li>///
    if ( ismissing ( bWithExtension )) then
    '///<li>If yes, assign default value 'TRUE'</li>///
        bWithExtension = TRUE
    endif  
    '///<li>Check if 'bDetectMismatch' is missing</li>///
    if ( ismissing ( bDetectMismatch )) then
    '///<li>If yes, assign default value 'FALSE'</li>///
        bDetectMismatch = FALSE
    endif
    '///<li>Check 'sFilterType' for keyword 'default'</li>///
    '///<li><b>IDEA: If a new default filter is introduced, only change this assigment</b></li>///
    '///<li><b>(e.g. 'sFilterType = "calc9")</b></li>///
    if ( lcase ( sFilterType )) = "default" then
        sFilterType = "calc8"
    endif
    '///<li>Translate keyword for 'sFilterType' to parameters for functions<br>'hGetUIFiltername()' and 'hGetFilternameExtension()'in 'qatesttool/global/tools/inc/t_tools1.inc'</li>///
    select case lcase ( sFilterType )
           case "dif"    : sFilterNameKey = "DIF"
                           sFilterTypeKey = "calc_DIF"
           case "html"   : sFilterNameKey = "HTML (StarCalc)"
                           sFilterTypeKey = "writer_web_HTML"
           case "lotus"  : sFilterNameKey = "Lotus"
                           sFilterTypeKey = "calc_Lotus"
           case "xls4"   : sFilterNameKey = "MS Excel 4.0"
                           sFilterTypeKey = "calc_MS_Excel_40"
           case "xls4t"  : sFilterNameKey = "MS Excel 4.0 Vorlage/Template"
                           sFilterTypeKey = "calc_MS_Excel_40_VorlageTemplate"
           case "xls5"   : sFilterNameKey = "MS Excel 5.0/95"
                           sFilterTypeKey = "calc_MS_Excel_5095"
           case "xls5t"  : sFilterNameKey = "MS Excel 5.0/95 Vorlage/Template"
                           sFilterTypeKey = "calc_MS_Excel_5095_VorlageTemplate"
           case "xls95"  : sFilterNameKey = "MS Excel 95"
                           sFilterTypeKey = "calc_MS_Excel_95"
           case "xls95t" : sFilterNameKey = "MS Excel 95 Vorlage/Template"
                           sFilterTypeKey = "calc_MS_Excel_95_VorlageTemplate"
           case "xls97"  : sFilterNameKey = "MS Excel 97"
                           sFilterTypeKey = "calc_MS_Excel_97"
           case "xls97t" : sFilterNameKey = "MS Excel 97 Vorlage/Template"
                           sFilterTypeKey = "calc_MS_Excel_97_VorlageTemplate"
           case "rtf"    : sFilterNameKey = "Rich Text Format (StarCalc)"
                           sFilterTypeKey = "writer_Rich_Text_Format"
           case "sylk"   : sFilterNameKey = "SYLK"
                           sFilterTypeKey = "calc_SYLK"
           case "calc1"  : sFilterNameKey = "StarCalc 1.0"
                           sFilterTypeKey = "calc_StarCalc_10"
           case "calc3"  : sFilterNameKey = "StarCalc 3.0"
                           sFilterTypeKey = "calc_StarCalc_30"
           case "calc3t" : sFilterNameKey = "StarCalc 3.0 Vorlage/Template"
                           sFilterTypeKey = "calc_StarCalc_30_VorlageTemplate"
           case "calc4"  : sFilterNameKey = "StarCalc 4.0"
                           sFilterTypeKey = "calc_StarCalc_40"
           case "calc4t" : sFilterNameKey = "StarCalc 4.0 Vorlage/Template"
                           sFilterTypeKey = "calc_StarCalc_40_VorlageTemplate"
           case "calc5"  : sFilterNameKey = "StarCalc 5.0"
                           sFilterTypeKey = "calc_StarCalc_50"
           case "calc5t" : sFilterNameKey = "StarCalc 5.0 Vorlage/Template"
                           sFilterTypeKey = "calc_StarCalc_50_VorlageTemplate"
           case "calc6"  : sFilterNameKey = "StarOffice XML (Calc)"
                           sFilterTypeKey = "calc_StarOffice_XML_Calc"
           case "csv"    : sFilterNameKey = "Text - txt - csv (StarCalc)"
                           sFilterTypeKey = "calc_Text_txt_csv_StarCalc"
           case "query"  : sFilterNameKey = "calc_HTML_WebQuery"
                           sFilterTypeKey = "writer_web_HTML"
           case "calc6t" : sFilterNameKey = "calc_StarOffice_XML_Calc_Template"
                           sFilterTypeKey = "calc_StarOffice_XML_Calc_Template"
           case "pdf"    : sFilterNameKey = "calc_pdf_Export"
                           sFilterTypeKey = "pdf_Portable_Document_Format"
           case "dbf"    : sFilterNameKey = "dBase"
                           sFilterTypeKey = "calc_dBase"
           case "calc8"  : sFilterNameKey = "calc8"
                           sFilterTypeKey = "calc8"
           case "calc8t" : sFilterNameKey = "calc8_template"
                           sFilterTypeKey = "calc8_template"
           case "msxml"  : sFilterNameKey = "MS Excel 2003 XML"
                           sFilterTypeKey = "calc_MS_Excel_2003_XML"
           case else       
                           warnlog "Unknown filter key -> Fallback to current default filter name"
                           sFilterNameKey = "calc8"
                           sFilterTypeKey = "calc8"
    end select
    '///<li>Determine the desired strings for filtername and extension</li>///
    sFilterName = hGetUIFiltername( sFilterNameKey )
    sExtNames() = hGetFilternameExtension( sFilterTypeKey )
    '///<li>Composite both strings to obtain UI filter name</li>///
    sUIFileFormat = sFilterName & " (." & sExtNames(0) & ")"
    
    '///<li>Assign return value for function depending on 'bWithExtension'</li>///
    if bWithExtension then
        fGetCalcFiltername = sUIFileFormat
    else
        fGetCalcFiltername = sFilterName
    endif
    '///<li>If 'bDetectMismatch' is TRUE check composite string aginst archived filter name</li>///
    if bDetectMismatch then
        select case lcase ( sFilterType )
               case "calc8"   : sReferenceFilterName = gCalcFilterOOo2
               case "calc8t"  : sReferenceFilterName = gCalcFilterOOo2Template
               case "calc6"   : sReferenceFilterName = gCalcFilterOOo1
               case "calc6t"  : sReferenceFilterName = gCalcFilterOOo1Template
               case "dif"     : sReferenceFilterName = gCalcFilterDIF
               case "dbf"     : sReferenceFilterName = gCalcFilterDBF
               case "xls97"   : sReferenceFilterName = gCalcFilterExcelXP
               case "xls97t"  : sReferenceFilterName = gCalcFilterExcelXPTemplate
               case "xls95"   : sReferenceFilterName = gCalcFilterExcel95
               case "xls95t"  : sReferenceFilterName = gCalcFilterExcel95Template
               case "xls5"    : sReferenceFilterName = gCalcFilterExcel5
               case "xls5t"   : sReferenceFilterName = gCalcFilterExcel5Template
               case "calc5"   : sReferenceFilterName = gCalcFilterSO5
               case "calc5t"  : sReferenceFilterName = gCalcFilterSO5Template
               case "calc4"   : sReferenceFilterName = gCalcFilterSO4
               case "calc4t"  : sReferenceFilterName = gCalcFilterSO4Template
               case "calc3"   : sReferenceFilterName = gCalcFilterSO3
               case "calc3t"  : sReferenceFilterName = gCalcFilterSO3Template
               case "sylk"    : sReferenceFilterName = gCalcFilterSYLK
               case "csv"     : sReferenceFilterName = gCalcFilterCSV
               case "html"    : sReferenceFilterName = gCalcFilterHTML
               case "msxml"   : sReferenceFilterName = gCalcFilterExcelXML
               case else 
                    qaErrorLog "Filter name mismatch detection isn't implemented yet for: " & sUIFileFormat
                    sReferenceFilterName = "NONE"
        end select
        
        if sReferenceFilterName <> "NONE" then
            if sReferenceFilterName = sUIFileFormat then
                printlog "The determined filter name matches the archived filter name."
            else
                warnlog "The determined filter name doesn't match the archived filter name -> Check this out!"
            endif
        endif
    endif
'///</ul>
end function

