'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: c_tool_l10n_mnomics.inc,v $
'*
'*  $Revision: 1.2 $
'*
'*  last change: $Author: tbo $ $Date: 2005/09/07 19:07:34 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'* owner : hercule.li@sun.com
'*
'* short description : Tools for Keyboard Accessibility
'*
'************************************************************************
'*
' #1 fDataPilotRowSelection
' #1 fDataPilotColumnSelection
' #1 fDataPilotDataSelection
'*
'\***********************************************************************

function fDataPilotRowSelection()

fDataPilotRowSelection = TRUE

   select case iSprache
      case 01   :        ' English (USA)
         DataPilotSelection.typekeys "<MOD2 R>"
      case 33   :        ' French
         DataPilotSelection.typekeys "<MOD2 g>"
      case 34   :        ' Spanish
         DataPilotSelection.typekeys "<MOD2 l>"
      case 39   :        ' Italian
         DataPilotSelection.typekeys "<MOD2 R>"
      case 46   :        ' Swedish
         DataPilotSelection.typekeys "<MOD2 d>"
      case 49   :        ' German
         DataPilotSelection.typekeys "<MOD2 l>"
      case 55   :        ' Portuguese
         DataPilotSelection.typekeys "<MOD2 h>"
      case 81   :        ' Japanese
         DataPilotSelection.typekeys "<MOD2 B>"
      case 82   :        ' Korean
         DataPilotSelection.typekeys "<MOD2 B>"
      case 86   :        ' Chinese (simplified)
         DataPilotSelection.typekeys "<MOD2 B>"
      case 88   :        ' Chinese (traditional)
         DataPilotSelection.typekeys "<MOD2 B>"
      case else :        ' Fallback
         QAErrorLog "Now, the test does not support for the language " +iSprache
	 fDataPilotRowSelection = FALSE
   end select

end function

'----------------------------------------------------

function fDataPilotColumnSelection()

fDataPilotColumnSelection = TRUE

   select case iSprache
      case 01   :        ' English (USA)
         DataPilotSelection.typekeys "<MOD2 C>"
      case 33   :        ' French
         DataPilotSelection.typekeys "<MOD2 C>"
      case 34   :        ' Spanish
         DataPilotSelection.typekeys "<MOD2 C>"
      case 39   :        ' Italian
         DataPilotSelection.typekeys "<MOD2 C>"
      case 46   :        ' Swedish
         DataPilotSelection.typekeys "<MOD2 m>"
      case 49   :        ' German
         DataPilotSelection.typekeys "<MOD2 S>"
      case 55   :        ' Portuguese
         DataPilotSelection.typekeys "<MOD2 C>"
      case 81   :        ' Japanese
         DataPilotSelection.typekeys "<MOD2 A>"
      case 82   :        ' Korean
         DataPilotSelection.typekeys "<MOD2 A>"
      case 86   :        ' Chinese (simplified)
         DataPilotSelection.typekeys "<MOD2 A>"
      case 88   :        ' Chinese (traditional)
         DataPilotSelection.typekeys "<MOD2 A>"
      case else :        ' Fallback
         QAErrorLog "Now, the test does not support for the language " +iSprache
	 fDataPilotColumnSelection = FALSE
   end select

end function

'----------------------------------------------------

function fDataPilotDataSelection()

fDataPilotDataSelection = TRUE

   select case iSprache
      case 01   :        ' English (USA)
         DataPilotSelection.typekeys "<MOD2 D>"
      case 33   :        ' French
         DataPilotSelection.typekeys "<MOD2 D>"
      case 34   :        ' Spanish
         DataPilotSelection.typekeys "<MOD2 t>"
      case 39   :        ' Italian
         DataPilotSelection.typekeys "<MOD2 D>"
      case 46   :        ' Swedish
         DataPilotSelection.typekeys "<MOD2 t>"
      case 49   :        ' German
         DataPilotSelection.typekeys "<MOD2 D>"
      case 55   :        ' Portuguese
         DataPilotSelection.typekeys "<MOD2 D>"
      case 81   :        ' Japanese
         DataPilotSelection.typekeys "<MOD2 C>"
      case 82   :        ' Korean
         DataPilotSelection.typekeys "<MOD2 C>"
      case 86   :        ' Chinese (simplified)
         DataPilotSelection.typekeys "<MOD2 C>"
      case 88   :        ' Chinese (traditional)
         DataPilotSelection.typekeys "<MOD2 C>"
      case else :        ' Fallback
         QAErrorLog "Now, the test does not support for the language " +iSprache
	 fDataPilotDataSelection = FALSE
   end select

end function

'----------------------------------------------------

function fDataPilotPageSelection()

fDataPilotPageSelection = TRUE

   select case iSprache
      case 01   :        ' English (USA)
         DataPilotSelection.typekeys "<MOD2 P>"
      case else :        ' Fallback
         QAErrorLog "Now, the test does not support for the language " +iSprache
	 fDataPilotPageSelection = FALSE
   end select

end function
