'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: f_basic_1.inc,v $
'*
'*  $Revision: 1.11 $
'*
'*  last change: $Author: tbo $ $Date: 2005/09/07 19:07:57 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
' **
' ** owner : joerg.skottke@sun.com
' **
' ** short description : check macro-dialogs / BASIC-IDE ( 1. part )
' **
'*******************************************************************************
' **
' #1 tMakro_In_All_Apps               ' open BASIC-IDE in all Applications
' #1 tMakro_Dialog                    ' update-test for macro-dialog
' #1 tMakro_Names                     ' check naming convention for modules
' #1 tBasic_IDE_Breakpoint            ' working with breakpoints
' **
'\******************************************************************************


testcase tMakro_In_All_Apps
    Dim i as Integer
    Dim bBug as Boolean
    bBug = FALSE
    '///open tools/macro in all applications

    for i=1 to 7

        printlog( hNumericDoctype( i ) )

        '///<ul><li>open a new document</li>
        printlog Chr(13) + gApplication
        Call hNewDocument
        '///<li> tools/macro and insert a new module for this document</li>

        try
            CreateNewModuleForDoc
        catch
            warnlog "Tools/Macro not be activated => BUG!"
            FileClose
            sleep(1)
            goto endsub
        endcatch

        '///<li> close the BASIC-IDE</li>
        sleep(1)
        printlog "close the BASIC-IDE"
        FileClose                                         ' close the BASIC IDE
        sleep(1)

        kontext "navigator"
        if Navigator.Exists(5) then
            Navigator.Close
        endif
        '///<li> close the changed document ( a messagebox should warn you about changes, if not it is a bug! )</li>
        sleep(1)
        FileClose                                         ' close the document with new Basic
        sleep(1)
        printlog "close the changed document => a messagebox should warn you about changes!"

        kontext "messagebox"

        if MessageBox.Exists( 1 ) then
            MessageBox.No
        else
            warnlog "A new module is inserted for this document ( " + gApplication  + ", but no messagebox at closing the doc! => BUG"
        end if

    next i

    '///<li>in a math-document tools/macro must be disabled</li></ul>
endcase

'*******************************************************************************

testcase tMakro_Dialog
    '///test the macro related functions and dialogs
    Dim XLBFILE as String
    Dim iTemp as Integer
    Dim i as Integer
    XLBFILE = gTesttoolPath + "framework\basic\input\AppLibrary1\script.xlb"
    const ICWAIT as Integer = 1
    gApplication = "Writer"
    '///<ul><li>Open a new document</li>
    printlog( "Open a new document" )
    Call hNewDocument
    '///create a new module for the new document ( named TTModule )
    printlog " - create a new module "
    Call CreateNewModuleForDoc()
    '///<li>close the basic-IDE</li>
    printlog " - close the basic-IDE"

    kontext "macrobar"

    if MacroBar.Exists() then
        FileClose
    else
        warnlog( "The Macro-Document is not open!" )
        printlog( "Now the test runs in other errors!" )
    end if

    '///<li>tools / macro and select the new module</li>
    Call SelectTheLastModule ( FALSE, FALSE )
    printlog " - organize"
    '///<li>organize</li>
    Verwalten.Click()
    '///<li>activate TabModule on it 'New Module' / 'New Dialog'</li>
    printlog " - activate TabModule"

    kontext
    Active.SetPage( TabModule )

    kontext "tabmodule"
    '///<li>create a new module</li>
    printlog " - press 'new module'"
    NeuesModul.Click()
    '///<li>cancel the 'New Module' dialog</li>
    printlog( " - cancel the dialog" )

    kontext "neuesmodul"
    NeuesModul.Cancel()
    '///<li>create a 'New Dialog'</li>

    kontext
    active.setpage( TabDialogs )

    kontext "tabdialogs"
    printlog " - press 'new dialog'"
    NewDialog.Click()
    '///<li>cancel the dialog</li>
    printlog( " - cancel the dialog" )

    kontext "neuerdialog"
    NeuerDialog.Cancel()
    '///<li>activate TabLibrary on it 'New' / 'Password' / 'Delete' / 'Append' / 'Edit'</li>
    printlog " - select the libraries Tab"

    kontext
    Active.SetPage( TabBibliotheken )
    '///<li>press 'New' on the libraries tab</li>
    printlog " - press 'New' on the libraries tab"

    kontext "tabbibliotheken"
    Neu.Click()
    '///<li>close the dialog with 'OK'</li>
    printlog( " - close the dialog with 'OK'" )

    kontext "neuebibliothek"
    Call DialogTest (NeueBibliothek)
    NeueBibliothek.OK()
    printlog( " - get the number of items from the libraries-list" )

    kontext "tabbibliotheken"
    iTemp = Bibliotheksliste.getItemCount()
    printlog( " - Number of entries: " + iTemp )
    '///<li>Append a library by pressing 'Append'</li>
    printlog " - append a xlb-file"

    kontext "tabbibliotheken"
    Hinzufuegen.Click()
    '///<li>select a valid library and open it</li>
    printlog( " - Select 'AppLibrary1/script.xlb' from the files list" )

    kontext "oeffnendlg"
    Dateiname.SetText( ConvertPath ( XLBFILE ) )
    Oeffnen.Click()
    sleep(2)

    kontext "appendlibraries"
    Call DialogTest (AppendLibraries)
    '///<li>Make sure 'Insert as Reference' is unchecked</li>
    printlog( " - Ensure 'Insert as Reference' is unchecked" )

    kontext "appendlibraries"

    if ( InsertAsReference.IsChecked() = TRUE ) then
        InsertAsReference.UnCheck()
    end if

    '///<li>check 'Replace Existing Library'</li>
    printlog( " - check 'Replace existing library'" )

    if ( ReplaceExistingLibraries.IsChecked() = FALSE ) then
        ReplaceExistingLibraries.Check()
    end if

    '///<li>press 'OK' to append the library</li>
    printlog( " - press 'OK' to append the library" )

    kontext "appendlibraries"
    AppendLibraries.OK()
    sleep( ICWAIT )
    printlog( " - get the number of items from the libraries-list" )

    kontext "tabbibliotheken"
    iTemp = Bibliotheksliste.getItemCount()
    printlog( " - Number of entries: " + iTemp )
    printlog( " - select the first item" )
    Bibliotheksliste.TypeKeys( "<HOME>" )
    '///<li>Select 'AppLibrary1' and click 'Password'</li>
    printlog( " - List of registered libraries:" )

    for i = 1 to ( iTemp )
        printlog( "   Name: '" + Bibliotheksliste.getSelText() + "'" )

        if ( Bibliotheksliste.getSelText() = "AppLibrary1" ) then

            kontext "tabbibliotheken"
            printlog( " - set a password for AppLibrary1" )
            sleep( ICWAIT )
            i = 1000 ' break the loop

            if Passwort.IsEnabled then
                Passwort.Click()

                kontext "passwddlg"
                Call DialogTest ( PasswdDLG )
                PasswdDLG.Cancel()

                kontext "tabbibliotheken" 'back to library-dialog
            else
                warnlog( "Password is disabled for 'AppLibrary1'" )
            end if

        end if

        Bibliotheksliste.Typekeys( "<DOWN>" ) 'next item
    next i

    '///<li>delete the inserted library</li>
    printlog( " - delete 'AppLibrary1'" )

    kontext "tabbibliotheken"
    Loeschen.Click()
    '///<li>close the warning</li>
    printlog( " - close the warning" )

    kontext "active"
    if Active.Exists then
        Active.Yes()
    endif
    '///<li>after edit the Basic-IDE must be open</li>
    '///<li>close it</li>

    kontext "tabbibliotheken"
    printlog " - press 'edit' on 'Libraries'-tab"
    Bearbeiten.Click
    sleep( ICWAIT * 5 )

    kontext "macrobar"

    if MacroBar.Exists() then
        '///<li>Close the basic IDE</li>
        printlog " - close the basic-document"
        FileClose

        kontext "active"

        if Active.Exists ( 2 ) then
            warnlog "Unexpected dialog: '" + Active.getText () + "'"
            printlog "- The file should be saved without confirmation"
            Active.OK()

            kontext "filesaveas"
            Dateiname.setText( "dumbo" )
            Speichern.Click ()
        end if

    else
        warnlog("#i38978# The Macro-Document is not open!")
        printlog("Now the test runs in other errors!")
        call hCloseDocument()
        goto endsub
    end if

    '///tools / macro
    printlog( " - tools / macro" )
    ToolsMacro
    '///<li>go to the last macro in the list</li>
    printlog( " - select the last macro from the list" )

    kontext "makro"
    MakroAus.TypeKeys( "<PageDown><PageDown><PageDown><RIGHT><PAGEDOWN>" )
    '///<li>organize</li>
    printlog( " - press 'Organize'" )

    try
        '///<li>Assign the macro by pressing 'Assign'</li>
        printlog( " - Assign the macro" )
        Zuordnen.Click ()
    catch
        warnlog "The 'Assign'-Button is disabled. Perhaps Bugid #106853#"
        printlog " - The macro has not been added to the list."
    endcatch

    '///<li>activate all tapages and cancel the tabdialog</li>
    printlog " - activate all tabpages and cancel the tabdialog"

    kontext
    Active.SetPage( TabCustomizeMenu )
    sleep(1)
    Active.SetPage( TabCustomizeToolbars )
    sleep(1)
    Active.SetPage( TabCustomizeEvents )
    Active.SetPage( TabTastatur )
    sleep(1)
    
    kontext "tabtastatur"
    sleep(1)
    TabTastatur.Cancel()
    '///<li>run</li>
    printlog " - run"

    kontext "makro"
    Ausfuehren.Click()
    sleep(3)
    '///tools / macro
    printlog "tools / macro"
    ToolsMacro

    kontext "makro"
    MakroAus.TypeKeys "<PageDown>"
    '///<li>delete the new module</li>
    printlog "- delete the new module"
    Loeschen.Click
    '///<li>close the warning</li>
    printlog( " - close the warning" )

    kontext "active"
    Active.Yes
    '///<li>close the macro dialog</li>
    printlog( " - close the macro dialog" )

    kontext "makro"
    Makro.Close
    '///<li>Close the document</li></ul>
    printlog( "Close the document" )
    Call hCloseDocument
endcase

'*******************************************************************************

testcase tMakro_Names
    Dim i as Integer
    Dim sSeperator as String
    '///check the name conventions for modules
    '///<ul><li>open a new writer document</li>
    printlog "open a new writer-doc"
    gApplication = "Writer"
    Call hNewDocument
    '///<li>tools / macro => select the new document</li>
    Call SelectTheLastModule ( FALSE, FALSE )
    Neu.Click

    for i=1 to 13

        select case i
        case 1  : sSeperator = "-"
        case 2  : sSeperator = "."
        case 3  : sSeperator = ","
        case 4  : sSeperator = "+"
        case 5  : sSeperator = ":"
        case 6  : sSeperator = "!"
        case 7  : sSeperator = "$"
        case 8  : sSeperator = "("
        case 9  : sSeperator = ")"
        case 10 : sSeperator = "="
        case 11 : sSeperator = "?"
        case 12 : sSeperator = "*"
        case 13 : sSeperator = " "
        end select

        '///<li>click new and insert 'tt?module' with forbidden signes</li>
        '///<li>- tested forbidden signes are ( only one for each test name ) :</li>
        '///<li>- '-', '.', ',', '+', ':', '!', '$', '(', ')', '=', '?', '*', ' '</li>
        '///<li>=> '?' is not allowed => a messagebox must come up => OK</li>
        printlog "- insert 'tt" + sSeperator + "module' and click OK => warning box must come up => OK"

        kontext "neuesmodul"
        Modulname.SetText "tt" + sSeperator + "module"
        NeuesModul.OK

        kontext "active"

        if Active.Exists then
            Active.OK

            kontext "neuesmodul"
        else
            warnlog "tt" + sSeperator + "module can be created => BUG : '" + sSeperator + "' in module names are not allowed!"

            kontext "makro"
            if Makro.Exists then
                Macro.Close
            endif

            kontext "basicide"

            if EditWindow.Exists then
                Call hCloseDocument
            end if

            goto endsub                                                     ' if an error occured => testcase ends
        end if

    next i

    '///<li>close the naming dialog</li>

    kontext "neuesmodul"
    if NeuesModul.Exists then
        NeuesModul.Cancel
    endif
    '///<li>close the macro dialog</li>

    kontext "makro"
    if Makro.Exists then
        Makro.Close
    endif
    '///<li>close the last document</li></ul>
    Call hCloseDocument
endcase

'*******************************************************************************

testcase tBasic_IDE_Breakpoint
    Dim i as Integer, yJump as Integer
    Dim iMenuCountBrkPoint as integer
    Dim iCountOfBrkItems as integer
    Dim sBrkPoiListEntry as string
    '///Working with breakpoints
    '///Open a new Writer document
    printlog "open a new writer-doc"
    gApplication = "Writer"
    Call hNewDocument
    '///Create a new module for the new document named <i>TTModule</i>
    printlog "create a new module "
    Call CreateNewModuleForDoc
    '///Insert a short script (only one print-command)
    printlog "insert a short script"

    kontext "basicide"
    EditWindow.TypeKeys "<MOD1 a>"
    EditWindow.TypeKeys "<DELETE>"
    EditWindow.TypeKeys "'# This is a short testscript for automated testing!<return><return>"
    EditWindow.TypeKeys "sub main<RETURN><RETURN>"
    EditWindow.TypeKeys "print " & Chr (34) & "hallo" + Chr (34) & "<RETURN><RETURN>"
    EditWindow.TypeKeys "<HOME>end sub<RETURN>"
    '///Insert breakpoints with doubleclick
    printlog "insert breakpoints with doubleclick"
    '///<li>Try to insert a breakpoint at a documentation line  => no breakpoint</li>
    printlog "- set a breakpoint at documentation line  => no breakpoint"
    BreakPointsWindow.MouseDoubleClick ( 50, 2 )
    sleep(1)
    '///<li>try to insert a breakpoint at a code line  => breakpoint</li>
    printlog "- set a breakpoint at code line"

    for i=1 to 50
        EditWindow.MouseDoubleClick ( 2, 2*i )

        try
            EditCopy
        catch
            SetClipboard ( "" )
        endcatch


        if lcase ( GetClipboardText ) = "sub" then
            BreakPointsWindow.MouseDoubleClick ( 50, 2*i )
            yJump = 2*i
            i=50
        end if

    next i

    '///check the context menu of breakpoints ( in breakpoint window )
    printlog "check the context menu of breakpoints ( in breakpoint window )"
    '///<li>move the mouse over the breakpoint and open the context menu ( should be 2 entries )</li>
    BreakPointsWindow.MouseMove ( 50, yJump )
    BreakPointsWindow.OpenContextMenu TRUE
    iCountOfBrkItems = 0
    iCountOfBrkItems = hMenuItemGetCount

    if iCountOfBrkItems <> 2 then
        warnlog "Perhaps no breakpoint has been inserted or the mouse is not over the breakpoint => 2 entries are not in the context menu!"
        hMenuClose
    else
        printlog "- deactivate the breakpoint"
        '///<li>deactivate the breakpoint</li>
        printlog "- deactivate the breakpoint"
        hMenuSelectNr(1)
        sleep(1)
        printlog "- activate the breakpoint"
        '///<li>open the contextmenu again and activate the breakpoint</li>
        printlog "- activate the breakpoint"
        BreakPointsWindow.OpenContextMenu TRUE
        hMenuSelectNr(1)
        sleep(1)
        printlog "- open the breakpoint dialog"
        '///<li>open the contextmenu again and open the breakpoint dialog</li>
        printlog "- open the breakpoint-dialog ( properties in context menu ) and close it"
        BreakPointsWindow.OpenContextMenu TRUE
        hMenuSelectNr(2)
        sleep(1)

        kontext "breakpoints"
        Call DialogTest (Breakpoints)
        '///<li>check the number of breakpoints ( should be only one )</li>
        iCountOfBrkItems = 0
        iCountOfBrkItems = BreakpointsList.GetItemCount

        if iCountOfBrkItems <> 1 then
            warnlog "There is not 1 breakpoint, there are " & iCountOfBrkItems & " breakpoints! => bug!"
        else
            BreakpointsList.Select(1)
            sBrkPoiListEntry = BreakpointsList.GetSelText
            if Right (sBrkPoiListEntry , 1 ) <> 3 then
                warnlog "The breakpoint is not at line 3, it is on line " & Right (sBrkPoiListEntry , 1) & "!"
            endif
        end if

        Breakpoints.Cancel
        '///check if active and inactive breakpoint are shown correct in the dialog
        printlog "check if active and inactive breakpoints are shown correct in breakpoints dialog"

        kontext "basicide"
        BreakPointsWindow.MouseMove (50, yJump)
        BreakPointsWindow.OpenContextMenu TRUE
        '///<li>open the context menu over the breakpoint and uncheck 'active'</li>
        printlog "- inactive"
        hMenuSelectNr(1)
        sleep(1)
        '///<li>open the breakpoint properties and check if the 'Active'-checkbox is unchecked for this breakpoint</li>
        BreakPointsWindow.OpenContextMenu TRUE
        hMenuSelectNr(2)
        sleep(1)

        kontext "breakpoints"
        BreakpointsList.Select(1)
        if ActiveBox.IsChecked then
            warnlog "When a breakpoint is inactive and 'Active' is checked in breakpoints dialog => BUG!"
        endif
        Breakpoints.Cancel
        sleep(3)

        kontext "basicide"
        BreakPointsWindow.OpenContextMenu TRUE
        '///<li>open the context menu over the breakpoint and uncheck 'active'</li>
        printlog "- active"
        hMenuSelectNr(1)
        sleep(1)
        '///<li>open the breakpoint properties and check if the 'Active'-checkbox is checked for this breakpoint</li>
        BreakPointsWindow.OpenContextMenu TRUE
        hMenuSelectNr(2)
        sleep(1)

        kontext "breakpoints"
        BreakpointsList.Select(1)
        if ActiveBox.IsChecked <> TRUE then
            Warnlog "When a breakpoint is active and 'Active'-checkbox is unchecked in breakpoints dialog => BUG!"
        endif
        printlog "- delete the breakpoint"
        '///delete the breakpoint
        '///<li> press 'delete' and leave the dialog with 'OK'</li>
        Remove.Click
        Breakpoints.OK

        kontext "basicide"
        BreakPointsWindow.MouseMove (50, yJump)
        BreakPointsWindow.OpenContextMenu TRUE
        '///<li>open the context menu over the breakpoint and uncheck 'active'</li>
        iMenuCountBrkPoint = hMenuItemGetCount
        if hMenuItemGetCount <> 1 then
            Warnlog "Perhaps the breakpoint is not deleted, there is not 1 entry in the context menu, there are " & iMenuCountBrkPoint & " entries."
        endif
        hMenuClose
    end if

    '///insert breakpoints with breakpoints dialog ( at a code line )
    printlog "insert breakpoints with breakpoints dialog"
    '///<li>open context menu on breakpoints window</li>
    printlog "- open breakpoints dialog out of context menu"

    kontext "basicide"
    BreakPointsWindow.OpenContextMenu
    hMenuSelectNr(1)
    sleep(1)
    '///<li>insert a breakpoint only with the line number ( without # ), set 1 and check if 'new' is active and the breakpoint can be inserted</li>

    kontext "breakpoints"
    Call DialogTest ( Breakpoints )
    BreakpointsList.SetText "1"
    sleep(1)

    if NewButton.IsEnabled = FALSE then
        warnlog "Insert a breakpoint only with the line-number is impossible ( new is disabled ) => #101478"
    else
        NewButton.Click
        Breakpoints.OK

        kontext "basicide"
        BreakPointsWindow.OpenContextMenu
        hMenuSelectNr(1)
        sleep(1)

        kontext "breakpoints"
        BreakpointsList.SetText "# 1"

        if Remove.IsEnabled = FALSE then
            warnlog "The Breakpoint isn't set for line 1 => BUG"
        else
            Remove.Click
        end if

    end if

    '///<li>insert a breakpoint only with "# 5" and press new in the dialog</li>
    printlog "- create a new breakpoint (#5)"

    kontext "breakpoints"
    BreakpointsList.SetText "#5"
    NewButton.Click
    sleep(2)
    BreakpointsList.Select(1)

    if BreakpointsList.GetSelText <> "# 5" then
        sBrkPoiListEntry = 0
        sBrkPoiListEntry = BreakpointsList.GetSelText
        warnlog "The new breakpoint is not correct. Should '# 5'  is " & sBrkPoiListEntry & "   perhaps BugID:99372  => Test stops running!"
        Breakpoints.Cancel
        Call hCloseDocument
        Call hCloseDocument
        goto endsub
    else
        Breakpoints.OK
        yJump = findBreakpointLine ("print")
        BreakPointsWindow.MouseMove (50, yJump)
        BreakPointsWindow.OpenContextMenu TRUE

        if hMenuItemGetCount <> 2 then

            if bAsianLan = FALSE then
                warnlog "The breakpoint is not at the 5th line!"
            end if

            hMenuClose
            Call hCloseDocument
            Call hCloseDocument
            goto endsub
        else
            hMenuClose
        end if

    end if

    printlog "delete the breakpoints and close the dialog with 'cancel'"
    '///delete the breakpoint
    printlog "- open breakpoints dialog out of context menu"

    kontext "basicide"
    BreakPointsWindow.MouseMove(50, 2)
    BreakPointsWindow.OpenContextMenu TRUE
    hMenuSelectNr(1)
    sleep(1)
    '///<li>select the '# 5'-breakpoint and click on remove</li>
    printlog "- select the '# 5'-breakpoint and click remove"

    kontext "breakpoints"
    Call DialogTest (Breakpoints)
    BreakpointsList.SetText "# 5"
    sleep(1)
    Remove.Click
    '///<li>leave the dialog with 'Cancel' => all changes must be canceled => Breakpoint on line 5 must be active</li>
    printlog "- close the dialog with cancel and check if the breakpoint is not deleted"
    Breakpoints.Cancel
    sleep(1)
    '///<li>check if the breakpoint does exist</li>
    yJump = findBreakpointLine ( "print" )
    BreakPointsWindow.MouseMove ( 50, yJump )
    BreakPointsWindow.OpenContextMenu TRUE

    if hMenuItemGetCount <> 2 then
        warnlog "The breakpoint is deleted! Cancel does not cancel the changes in the dialog! => #99377"
        hMenuSelectNr(1)
    else
        hMenuSelectNr(2)
    end if

    printlog "delete the breakpoints"
    '///<li>delete the breakpoint</li>
    '///<li>select the '# 5'-breakpoint and click on remove</li>
    printlog "- select the '# 5'-breakpoint and click remove"

    kontext "breakpoints"
    Call DialogTest (Breakpoints)
    BreakpointsList.SetText "# 5"
    Remove.Click
    sleep(1)
    '///<li>leave the dialog with 'OK'</li>
    printlog "- close the dialog with OK and check if the breakpoint is deleted"
    Breakpoints.OK
    sleep(1)
    '///<li>check if the breakpoint is deleted</li>
    yJump = findBreakpointLine ( "print" )
    BreakPointsWindow.MouseMove ( 50, yJump )
    BreakPointsWindow.OpenContextMenu TRUE
    if hMenuItemGetCount <> 1 then
        Warnlog "The breakpoint is not deleted!"
    endif
    hMenuClose
    Call hCloseDocument
    Call hCloseDocument
endcase

