/* mapWindow.java
 * Copyright (C) 1996 by William Giel
 *
 * E-mail: rvdi@usa.nai.net
 * WWW: http://www.nai.net/~rvdi/home.htm
 *
 ***************************************************************************
 * Abstract
 * --------
 * Creates pop-up dialog with an image map on a particular projection
 * system from which the user can pick coordinates.
 ***************************************************************************
 * Permission to use, copy, modify, and distribute this software and its
 * documentation without fee for NON-COMMERCIAL purposes is hereby granted.
 * 
 * THE AUTHOR MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY
 * OF THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
 * TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
 * PARTICULAR PURPOSE, OR NON-INFRINGEMENT. THE AUTHOR SHALL NOT BE LIABLE
 * FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR
 * DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.
 ***************************************************************************/

import java.awt.*;

import dms;
import gwConst;
import wgCheckbox;

class commonData
{
	public static double latitude1;
	public static double longitude1;
	public static double latitude2;
	public static double longitude2;
	public static boolean fromPicked;
	public static boolean toPicked;
}



class MapImage extends Canvas 
{
	Image i, stickpinImage;
	int w=0;
	int h=0;

	boolean stickpin = false;
	int pinX,pinY;

	Dialog dialog;
	MapProjection mp;
	
	public MapImage(Dialog parent,Image image[], int width, int height,
						MapProjection proj)
	{
		i=image[0];
		stickpinImage=image[1];
		w=width;
		h=height;
		resize(w,h);
		dialog=parent;
		mp=proj;
	}

	void doPin(Point xy)
	{
		stickpin=true;
		pinX=xy.x;
		pinY=xy.y;
	}
		

	public void paint(Graphics g)
	{
		
		if(null != i)g.drawImage(i,0,0,this);
		if(stickpin && null != stickpinImage)
			g.drawImage(stickpinImage,pinX,pinY,this);
	}
	
	public boolean mouseDown(Event evt, int x, int y)
	{
			Event e = new Event(getParent(),gwConst.EVENT_MAP_PICK,
							new Point(x,y));
			
			postEvent(e);
			return true;
	}

}


public class MapWindow extends Dialog
{
	
	int iWidth=0;
	int iHeight=0;
	TextField lat1, long1,lat2,long2;

	commonData data;
	MapImage map;
	MapProjection mp;
	

	TextField parentLat1=null;
	TextField parentLong1=null;
	TextField parentLat2=null;
	TextField parentLong2=null;

	wgCheckbox from;
	wgCheckbox to;
	
	public MapWindow(Image image[])
	                    
	{
		super(new Frame(),true);
		initiallizeMapWindow(image);
		
	}

	public MapWindow(	Image image[],
	                    TextField tfLat1,
	                    TextField tfLong1,
	                    TextField tfLat2,
	                    TextField tfLong2)
	                    
	{
		super(new Frame(),true);
		initiallizeMapWindow(image);
		parentLat1=tfLat1;
		parentLong1=tfLong1;
		parentLat2=tfLat2;
		parentLong2=tfLong2;

	}	
		
	void initiallizeMapWindow(Image image[])
	{	

		int width=0;
		int height=0;

		addNotify();

	    if(null != image[0]){
			iWidth=image[0].getWidth(getParent());
			iHeight=image[0].getHeight(getParent());
	    }

	    width=iWidth+50;
        height=iHeight+12*gwConst.FONTHEIGHT;
        
		resize(width,height);

       	GridBagLayout gridbag=new GridBagLayout();
       	GridBagConstraints c=new GridBagConstraints();
        	
       	setFont(new Font(gwConst.FONTSTRING,Font.BOLD,gwConst.FONTHEIGHT));
       	setLayout(gridbag);
			
        setBackground(Color.lightGray);

        c.fill=GridBagConstraints.NONE;
        c.weightx=1.0;c.weighty=1.0;
        c.insets=new Insets(3,10,3,10);

        c.gridwidth=GridBagConstraints.REMAINDER;
        c.anchor=GridBagConstraints.CENTER;
 		map = new MapImage(this,image,iWidth,iHeight,mp);
       	gridbag.setConstraints(map,c);
       	add(map);		

        CheckboxGroup coords=new CheckboxGroup();
		from=new wgCheckbox(gwConst.SHORT_FROM, coords, true);
		to=new wgCheckbox(gwConst.SHORT_TO, coords, false); 

        c.insets=new Insets(0,10,3,0);
	
		c.gridwidth=1;
		c.anchor=GridBagConstraints.CENTER;
		gridbag.setConstraints(from,c);
        add(from);

        Label lbl=new Label(gwConst.LATITUDE);
        c.insets=new Insets(0,0,3,0);        
		c.gridwidth=1;
		c.anchor=GridBagConstraints.EAST;
		gridbag.setConstraints(lbl,c);
        add(lbl);

        
      	lat1=new TextField("",15);
		c.gridwidth=1;
		c.anchor=GridBagConstraints.EAST;
		gridbag.setConstraints(lat1,c);
        add(lat1);
        
      	lbl=new Label(gwConst.LONGITUDE);
		c.gridwidth=1;
		c.anchor=GridBagConstraints.EAST;
		gridbag.setConstraints(lbl,c);
        add(lbl);

        c.insets=new Insets(0,0,3,10);   
      	long1=new TextField("",15);
		c.gridwidth=GridBagConstraints.REMAINDER;
		c.anchor=GridBagConstraints.EAST;
		gridbag.setConstraints(long1,c);
        add(long1);

        c.insets=new Insets(0,10,3,0);
		c.gridwidth=1;
		c.anchor=GridBagConstraints.CENTER;
		gridbag.setConstraints(from,c);
        add(to);

         
      	lat2=new TextField("",15);
		c.gridwidth=2;
		c.anchor=GridBagConstraints.EAST;
		gridbag.setConstraints(lat2,c);
        add(lat2);

     
        c.insets=new Insets(0,0,3,10);     
      	long2=new TextField("",15);
		c.gridwidth=GridBagConstraints.REMAINDER;
		c.anchor=GridBagConstraints.EAST;
		gridbag.setConstraints(long2,c);
        add(long2);

        Panel p=new Panel();
		p.add(new Button(gwConst.OK));
		p.add(new Button(gwConst.CANCEL));
		c.gridwidth=GridBagConstraints.REMAINDER;
		c.anchor=GridBagConstraints.CENTER;
		gridbag.setConstraints(p,c);
        add(p);		
        
        lat1.setEditable(false);
        long1.setEditable(false);
        lat2.setEditable(false);
        long2.setEditable(false);

        lat1.setBackground(Color.white);
        long1.setBackground(Color.white);
        

        Dimension screenSize = getToolkit().getScreenSize();
        move((screenSize.width - width)/2+50,(screenSize.height - height)/2+50);

        setTitle("Pick your point(s)");
 	}

    public boolean action(Event e, Object arg)
    {
		if(arg.equals(gwConst.CANCEL))
        {
			hide();
			data.fromPicked=false;
			data.toPicked=false;
			return true;
        }
		if(arg.equals(gwConst.OK))
        {
        	if(data.fromPicked || data.toPicked){
				hide();

				if(data.fromPicked){
					if(null != parentLat1)
						parentLat1.setText(dms.decdeg2dms(data.latitude1,0,false));
					if(null != parentLong1)
						parentLong1.setText(dms.decdeg2dms(data.longitude1,0,false));
				}
			
				if(data.toPicked){
					if(null != parentLat2)
						parentLat2.setText(dms.decdeg2dms(data.latitude2,0,false));
					if(null != parentLong1)
						parentLong2.setText(dms.decdeg2dms(data.longitude2,0,false));
				}
			
				return true;
        	}
        }        	
		return false;  
    }

    void repaintFields()
    {
        if(from.getState()){
            lat2.setBackground(Color.lightGray);
            long2.setBackground(Color.lightGray);
            lat1.setBackground(Color.white);
            long1.setBackground(Color.white);
        }
        else{
            lat1.setBackground(Color.lightGray);
        	long1.setBackground(Color.lightGray);
        	lat2.setBackground(Color.white);
        	long2.setBackground(Color.white);
        }
        
        lat1.setText(lat1.getText());
        lat2.setText(lat2.getText());
        long1.setText(long1.getText());
        long2.setText(long2.getText());        
    }



    public boolean handleEvent(Event e)
    {
    	
        if (e.id == Event.WINDOW_DESTROY ||	(e.id == Event.KEY_PRESS && e.key==27)){
            hide();
            data.fromPicked=false;
            data.toPicked=false;
           
            return true;
        }
        
        if( e.id == wgCheckbox.CB_BUTTON){
            repaintFields();
        }

        if( e.id == gwConst.EVENT_MAP_PICK){

        	if(from.getState()){
        		
                geoPos latLong=mp.inverse(((Point)(e.arg)));
        	    
	        	data.latitude1  = latLong.latitude;
    	    	data.longitude1 = latLong.longitude;
        		  	
        		lat1.setText(dms.decdeg2dms(data.latitude1,0));
        		long1.setText(dms.decdeg2dms(data.longitude1,0));

        		if(null != parentLat1)
					parentLat1.setText(dms.decdeg2dms(data.latitude1,0,false));
				if(null != parentLong1)
	        		parentLong1.setText(dms.decdeg2dms(data.longitude1,0,false));        		

        		data.fromPicked=true;
        	}

        	else if(to.getState()){
        		
                geoPos latLong=mp.inverse(((Point)(e.arg)));
        	    
	        	data.latitude2  = latLong.latitude;
    	    	data.longitude2 = latLong.longitude;
        		  	
        		lat2.setText(dms.decdeg2dms(data.latitude2,0));
        		long2.setText(dms.decdeg2dms(data.longitude2,0));

        		if(null != parentLat2)
					parentLat2.setText(dms.decdeg2dms(data.latitude2,0,false));
				if(null != parentLong2)
	        		parentLong2.setText(dms.decdeg2dms(data.longitude2,0,false));
	        		
        		data.toPicked=true;
        	}        	
        	return true;
        }
        return super.handleEvent(e);
    }

    public void show(MapProjection proj)
    {
    	lat1.setText("");
    	long1.setText("");
    	lat2.setText("");
    	long2.setText("");
    	
    	data.fromPicked=false;
    	data.toPicked=false;

       	from.setState(true);
        to.setState(false);
        
        repaintFields();

        mp=proj;
    	
    	super.show();  
  		map.requestFocus();
    }

    public void show(MapProjection proj,double latitude, double longitude)
    {
    	lat1.setText("");
    	long1.setText("");
    	
        lat2.setText(dms.decdeg2dms(latitude,3));
        long2.setText(dms.decdeg2dms(longitude,3));

        data.latitude2=latitude;
        data.longitude2=longitude;
        
    	data.fromPicked=false;
    	data.toPicked=false;

    	mp=proj;
    	
    	map.doPin(mp.forward(new geoPos(latitude,longitude)));

       	from.setState(true);
        to.setState(false);
        
        repaintFields();
        
    	super.show();
    	map.requestFocus();
    }
}
	
		
