/* mapWindowMaker.java
 * Copyright (C) 1996 by William Giel
 *
 * E-mail: rvdi@usa.nai.net
 * WWW: http://www.nai.net/~rvdi/home.htm
 *
 ***************************************************************************
 * Abstract
 * --------
 * This unit creates a thread for preparing the map image pop-ups.
 ***************************************************************************
 * Permission to use, copy, modify, and distribute this software and its
 * documentation without fee for NON-COMMERCIAL purposes is hereby granted.
 * 
 * THE AUTHOR MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY
 * OF THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
 * TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
 * PARTICULAR PURPOSE, OR NON-INFRINGEMENT. THE AUTHOR SHALL NOT BE LIABLE
 * FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR
 * DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.
 ***************************************************************************/




import java.awt.*;
import java.applet.*;
import java.lang.*;
import java.net.*;

import Scroller;
import MapWindow;
import imageLoader;

public class mapWindowMaker extends Thread
{
	imageLoader ilMaps=null;
	MapWindow window = null;
	int index;
	Thread makerThread=null;
	TextField lat1,long1,lat2,long2;
	
	
	mapWindowMaker(imageLoader il, int imageIndex,
	    TextField la1, TextField lo1, TextField la2, TextField lo2)
	{
		ilMaps=il;
		index=imageIndex;
		lat1=la1;
		long1=lo1;
		lat2=la2;
		long2=lo2;
	}

	public void run()
	{
	   	Image temp[]    =   new Image[3];
	   	Image map[]     =   new Image[2];

		while(null != makerThread){

    	    if(null != ilMaps){
    		    temp=ilMaps.retrieveImages();
    	    }
        	if(null != temp){
    	   	    ilMaps.stop();
    	   	    map[0]=temp[index];
    	   	    map[1]=temp[0];
			    window=new MapWindow(map,lat1,long1,lat2,long2);
			    if(null != window)window.pack();
			    break;
    	    }
		}
	}

	MapWindow retrieveMapWindow()
	{
        return window;
	}

    public void start()
    {
        if(makerThread == null){
            makerThread = new Thread(this);
            makerThread.start();
        }
    }

    public void makerStop()
    {
        if(null != makerThread){
            makerThread.stop();
            makerThread=null;
        }
    }
}

