'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: help_compare_apps.inc,v $
'*
'*  $Revision: 1.5 $
'*
'*  last change: $Author: jsk $ $Date: 2006/01/19 12:59:30 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'* owner : joerg.skottke@sun.com
'*
'* short description : 
'*
'*******************************************************************************
' **
' #1 tCompareHelpApps   ' Check the seven entries from the HelpAbout Listbox
' **
'\******************************************************************************

testcase tCompareHelpApps()

    '///<h1>Compare the About-Items in the Help-Viewer against a reference</h1>
    '///<ul>
    
    ' file related variables
    dim sFileOut as string
    dim sFilein as string
    dim sFileName as string
    
    ' the array that holds the names of the applications
    dim aTopicsFromUI( 10 ) as string ' max index = 7 expected
    
    ' some incremant variables and temporary stuff
    dim iTopicsFromUI as integer
    dim iCurrentItem as integer
    dim sCurrentItem as string
    dim irc as integer
    
    ' define input and output paths, presetting variables
    sFileName = "help_apps" & iSprache & ".txt"
    sFileOut = hGetWorkFile( sFilename )
    sFileIn  = gTesttoolPath & "framework\help\input\help_apps"  
    sFileIn  = hGetInputPath( sFileIn , sFileName )
    if ( sFileIn = "" ) then
        warnlog( "Invalid path created, test aborts." )
        goto endsub
    endif
    
    aTopicsFromUI( 0 ) = "0"

    '///+<li>Open the Help</li>
    hOpenHelp()
    
    '///+<li>Switch to the Index-Tab</li>
    hSelectHelpTab( "index" )
    
    '///+<li>Retrieve the number of About-Items (Listbox, to the upper left)</li>
    iTopicsFromUI = HelpAbout.getItemCount()
    
    '///+<li>copy the strings from the ListBox into an array</li>
    for iCurrentItem = 1 to iTopicsFromUI
    
        HelpAbout.select( iCurrentItem )
        sCurrentItem = HelpAbout.getSelText()
        hListAppend( sCurrentItem, aTopicsFromUI() )
        
    next iCurrentItem
    
    call hCloseHelp()
    
    ' Compare the list against a reference or create a new list, if the 
    ' reference does not exist
    printlog( "" )
    printlog( "Beginning comparision" )
    
    '///+<li>Compare the array to the reference file</li>
    irc = hManageComparisionList( sFileIn, sFileOut, aTopicsFromUI() )
    if ( irc <> 0 ) then
	    warnlog( "Something went wrong, please review the log" )
    endif
    '///</ul>
    
endcase


