'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: install_tools.inc,v $
'*
'*  $Revision: 1.10 $
'*
'*  last change: $Author: tbo $ $Date: 2005/09/27 15:07:21 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'* owner : joerg.skottke@sun.com
'*
'* short description :
'*
'*******************************************************************************
' **
' #0 hQueryInstallParams     ' gets information about the current installation
' #0 hGetOSString            ' retrieve the name of the OS family
' #0 hGetSublistByPattern    ' moves items from one list to another by pattern
' #0 hCheckForMissingFiles   ' checks if files are missing
' #0 hCheckForAddedFiles     ' checks if files have been added
' #0 hCheckForChangedFiles   ' ckecks filesizes / 0-byte files
' #0 hApplyRules             ' tweaks the settings in hCheckForChangedFiles
' #0 logprint                ' wrapper for printlog/warnlog
' **
'\******************************************************************************

function hQueryInstallParams( sKey as string ) as string

   ' This function reads data from the file bootstrap.ini and returns the values
   ' to following keys as string. THEY ARE CASE SENSITIVE.

   ' 1. ProductName        ' e.g. 'OpenOffice.org'
   ' 2. ProductVersion     ' e.g. '8'
   ' 3. DefaultDestPath    ' e.g. 'OpenOffice.org' (folder in userinst)
   ' 4. Mode               ' /ALL_INST /NO_INTGR ...
   ' 5. Languages         ' String containing the installed languages

   ' since the file instdb.inf will probably always remain a plain ASCII file
   ' it is read using BASIC fileaccess methods.
   ' in case of an error the function returns the string "error"

   dim sInstdbLocation as string ' location of instdb.inf

   dim iFile as integer          ' get a filehandle
       iFile = FreeFile

   dim iCurrentLine as integer   ' counter for the line currently read
       iCurrentLine = 0

   dim sCurrentLine as string    ' content of the current line
   'dim sCurrentLine2 as string    ' content of the current line

   dim bKeyMatch as boolean      ' becomes true if key is found
       bKeyMatch = false

   hQueryInstallParams = "error" ' presetting, will be overwritten on success

   ' get the location of the file insfdb.inf, platform independent
   if ( gNetzInst = false ) then
      sInstdbLocation = gOfficePath() + "program/bootstrap.ini"
   else
      sInstdbLocation = gNetzOfficePath() + "program/bootstrap.ini"
   endif
   sInstdbLocation = convertpath( sInstdbLocation )

   ' open the file using BASIC methods
   open sInstdbLocation for input as iFile

   ' read sequencially through the file and try to match sKey
   while( ( NOT eof( #iFile )) AND ( bKeyMatch = false ))

      iCurrentLine = iCurrentLine + 1
      input #iFile, sCurrentLine

      if ( instr( sCurrentLine , sKey )  ) then
         'printlog( "Debug: Current line: " & sCurrentline )
         bKeyMatch = true
         endif
   wend

   ' close the currently opened file
   close #iFile

   ' issue a warning when the requested key could not be found
   if ( bKeyMatch = false ) then
      warnlog( "The requested Key could not be found: " & sKey )
   else
      ' print a message and strip everything except the value for sKey
      'printlog( "Debug: Key <" & sKey & "> at Line " & iCurrentline )
      hQueryInstallParams() = hGetValueForPairAsString( sCurrentLine )
   endif

end function

'*******************************************************************************

function hGetOSString() as string

   ' This function returns a identifier-string for the operating system the
   ' test runs on. This info is part of the location of the reference files.
   ' If the platform is unknown, the test will still run but store its data
   ' below the directory "Unknown OS"

   select case lcase( gPlatform )

      case "w2k"   : hGetOSString() = "windows"
      case "winxp" : hGetOSString() = "windows"
      case "lin"   : hGetOSString() = "linux"
      case "sol"   : hGetOSString() = "sparc"
      case "x86"   : hGetOSString() = "x86"
      case else    
          if ( gtSYSName = "WinXP" ) then
              hGetOSString() = "windows" 
          else
              hGetOSString() = "Unknown OS - fixme"
          endif
   end select

end function

'*******************************************************************************

function hGetSublistByPattern( lsFilelist() as string, _
                                lsSubList() as string, _
                                       sKey as string, _
                                  sLanguage as string ) as string

   ' This function takes an array and compares the strings in this array with a
   ' searchpattern. If the searchpattern is matched, the entries are moved
   ' to another array and the entry is deleted from the originating array.

   dim i as integer
   dim cSearchPattern as string
   dim cCurrentFile as string
   dim iFileItems as integer

   listalldelete( lsSubList() )

   i    = 0
   iFileItems = listcount( lsFileList() )

   ' Note: hGetI18NData uses hGetDataFileSection which returns a platform-
   '       dependent string (convertpath() has not been applied)
   cSearchPattern = hGetI18NData( sLanguage , sKey )
   cSearchPattern = convertpath( cSearchPattern )
   cSearchPattern = ucase( cSearchPattern )

   if ( cSearchPattern = "" ) then
      warnlog ( "Empty pattern (key without value in file)" )
      printlog( "Please add a value for the key <" & sKey & "> to i18n-file" )
   endif

   ' separate the languagedependent files from the list
   do while ( i <  iFileItems )

      i = i + 1
      cCurrentFile = ucase( lsFileList( i ) )

      ' if cSearchPattern is a substring of cCurrentfile, move it to the
      ' sublist
      if( instr( cCurrentFile  , cSearchPattern ) > 0 ) then
         iFileItems = listmoveitem( lsFileList() , lsSubList() , i )
         i = i - 1 ' a hit moves the index one up in the row.
      end if

   loop

   hGetSublistByPattern() = cSearchPattern

end function

'*******************************************************************************

function hCheckForMissingFiles( cRefFileList() as string ) as integer

   ' This function checks for missing files. This is done by running through
   ' all entries in the reference list and looking for each file in the
   ' current installation.
   ' If a file does not exist its name is printed to the log. A maximum of 20
   ' files will be displayed. Missing files are deleted from the ref-list.

   dim iRefFile as integer
   dim iErr as integer
   dim cRefFile as string

   iErr = 0
   iRefFile = 1

   printlog( "" )
   printlog( " * Searching for missing files" )
   printlog( "" )

   do while ( iRefFile <= listcount( cRefFileList() ) )

      ' the file we want to work with during this loop
      cRefFile = hGetKeyForPairAsString( cRefFileList( iRefFile ) )

      ' errorhandling.(debugging hGetKeyForPairAsString)
      if ( cRefFile = "" ) then
         printlog( "Debug: Invalid entry at pos " & iRefFile & " (ref-file) " )
      endif

      ' check if the file exists. if not, increase the errorcounter and
      ' remove it from the memory-mapped ref-list
      if ( app.dir( cRefFile ) = "" ) then

         iErr = iErr + 1

         ' print a message to the logfile, max 20 messages for this test
         if ( iErr < 20 ) then
            printlog( "    - " & hGetRelPath( OFFICEHOME , cRefFile )
         end if

         ' remove it from the ref-list (the following entries in the list
         ' move up by one, so no increment of the index for next loop
         listdelete( cRefFileList() , iRefFile )

      else

         iRefFile = iRefFile + 1

      end if

   loop

   if ( iErr >= 20 ) then printlog( "      ... and some more" )
   
   printlog( "    * " & iErr & " missing object(s)." )
   printlog( "" )

   hCheckForMissingFiles() = iErr

end function

'*******************************************************************************

function hCheckForAddedFiles( cCurFiles() as string ,_
                              cRefFiles() as string ) as integer

    ' This function compares the list of currently installed files to the
    ' files provided by the reference list. Each time an item of the ref-list
    ' is found in the current files list it is deleted. The files that remain
    ' in the current files list then must be those that are new
    ' cCurFiles() is modified

    dim iRefFile as integer
    dim iCurFile as integer
    dim iMaxFiles as integer
    dim iNewFiles as integer
    dim iThisFile as integer

    dim cRefFile as string

    printlog( "" )
    printlog( " * Searching for newly added files" )
    printlog( "" )

    for iRefFile = 1 to listcount( cRefFiles() )

        iMaxFiles = listcount( cCurFiles() )
        cRefFile = hGetKeyForPairAsString( cRefFiles( iRefFile ) )

        for iCurFile = 1 to iMaxFiles

            if ( cRefFile = cCurFiles( iCurFile ) ) then

               listdelete( cCurFiles() , iCurFile )  ' delete the item
               iCurFile = iMaxFiles + 1              ' break for ... next

            end if

        next iCurFile

    next iRefFile

    iNewFiles = listcount( cCurFiles() )

    for iThisFile = 1 to iNewFiles
        printlog( "    + " & hGetRelPath( OFFICEHOME , cCurFiles( iThisFile ) ))
    next iThisFile

    if ( iNewFiles >= 20 ) then printlog( "      ... and some more" )
    printlog( "" )
    printlog( "    * " & iNewFiles & " new object(s)." )
    printlog( "" )

    hCheckForAddedFiles() = iNewFiles

end function

'*******************************************************************************

function hCheckForChangedFiles( cRefFileList() as string ) as integer

   ' This function compares the sizes of the files listed in the reference-
   ' files. Directories and blank entries are skipped. Files are allowed a
   ' default tolerance of 10%, files like "readmes" and "licenses" are not
   ' allowed to change at all. The behavior of the comparision can be tweaked
   ' by specifying rules in rules.dat.

   dim iRefFile as integer
   dim iRefSize as long
   dim sRefFile as string

   dim iCurSize as long
   dim iMaxSize as long
   dim iMinSize as long
   dim iSizeErr as integer
   dim cRulesList( 50 ) as string
   dim datafile as string
   dim cSection as string

   dim fmin as single
   dim fmax as single

   printlog( "" )
   printlog( " * Checking filesizes..." )
   printlog( "" )

   datafile = convertpath( TESTHOME & "/rules.dat" )
   if( INSTTYPE = "\userinst\" or INSTTYPE = "\ooo-userinst\" ) then
      cSection = "user"
   else
      cSection = "system"
   endif

   hGetDataFileSection( datafile , _
                        cRulesList() , _
                        cSection , _
                        "    * Rules File" , _
                        "" )

   for iRefFile = 1 to listcount( cRefFileList() )

      sRefFile = cRefFileList( iRefFile ) ' copy the entire pair
      iRefSize = hGetValueForPairAsLong( sRefFile ) ' get the expected size

      ' skip directories
      if ( iRefSize > (-1) ) then

         sRefFile = hGetKeyForPairAsString( sRefFile ) ' get the filename
         iCurSize = hGetFileSizeAsLong( sRefFile )

         ' check whether to apply rules or to skip this file
         if ( hApplyRules( fmin, fmax, sRefFile, cRulesList() ) = true ) then

            iMinSize = iRefSize - int( fmin * iRefSize )
            iMaxSize = iRefSize + int( fmax * iRefSize )

            if ( iCurSize < iMinSize ) then ' file is smaller than expected

               if ( iCurSize <> 0 ) then
                  printlog( "    - " & hGetRelPath( OFFICEHOME , sRefFile ) )
               else
                  printlog( "    0 " & hGetRelPath( OFFICEHOME , sRefFile ) )
               end if

               iSizeErr = iSizeErr + 1

            elseif ( iCurSize > iMaxSize ) then ' file is bigger than expected

               printlog( "    + " & hGetRelPath( OFFICEHOME , sRefFile ) )

               iSizeErr = iSizeErr + 1

            end if ' file sizes

         end if ' skip by rule or change tolerance

      end if ' skip directories

   next iRefFile

   hCheckForChangedFiles() = iSizeErr
   printlog( "" )

end function

'*******************************************************************************

function hApplyRules( fmin as single, _
                      fmax as single, _
                      cFile as string, _
                      cRulesList() as string ) as boolean

   ' This function compares the Key from the file "rules.dat" to a file from
   ' the references list. In case there is a match, the Value for the Key will
   ' be compared to the keywords "fixed", "smaller", "larger" and "skip".
   ' The first three influence the tolerance to be used, "skip" means to
   ' ignore the file entirely.

   dim i as integer
   dim sKey as string
   dim sVal as string
   dim iErr as integer
   dim iRC as integer ' rulecount

   fmin = 0.1
   fmax = 0.1
   iErr = 0
   iRC  = listcount( cRulesList() )

   for i = 1 to iRC ' i = each item in the rules-list

      sKey =  hGetKeyForPairAsString( cRulesList( i ) )

      if ( instr( cFile , sKey ) > 0 ) then

         sVal = hGetValueForPairAsString( cRulesList( i ) )

         if ( sVal = "fixed" ) then ' do not allow changes in filesize
            iErr = iErr + 1
            i    = iRC + 1
            fmin = 0.0
            fmax = 0.0
            hApplyRules() = true
         endif

         if ( sVal = "smaller" ) then ' allow file to be smaller (very rare)
            iErr = iErr + 1
            i    = iRC + 1
            fmin = 0.5
            fmax = 0.0
            hApplyRules() = true
         endif

         if ( sVal = "larger" ) then ' allow file to be larger
            iErr = iErr + 1
            i    = iRC + 1
            fmin = 0.0
            fmax = 0.5
            hApplyRules() = true
         endif

         if ( sVal = "skip" ) then ' do not check this file at all
            iErr = iErr + 1
            i    = iRC + 1
            hApplyRules() = false
         endif

      endif

   next i

   ' it is not allowed to assign two rules to one file. If this happens, warn.
   if( iErr > 1 ) then warnlog( "Bad rule, more than one hit: " & sVal )

end function

'*******************************************************************************

function logprint( cItem as string, iErrors as integer ) as boolean

   ' This function prints a status to the errorlog. Just cosmetic.

   if ( iErrors > 0 ) then
      warnlog( cItem & " encountered " & iErrors & " errors." )
   else
      printlog( "     " & cItem & " encountered no errors." )
   end if

   logprint() = true

end function


