'encoding UTF-8  Do not remove or change this line!
'*************************************************************************
'*
'*  OpenOffice.org - a multi-platform office productivity suite
'*
'*  $RCSfile: opt_loadsave_msoffice.inc,v $
'*
'*  $Revision: 1.4 $
'*
'*  last change: $Author: tbo $ $Date: 2005/09/27 15:10:41 $
'*
'*  The Contents of this file are made available subject to
'*  the terms of GNU Lesser General Public License Version 2.1.
'*
'*
'*    GNU Lesser General Public License Version 2.1
'*    =============================================
'*    Copyright 2005 by Sun Microsystems, Inc.
'*    901 San Antonio Road, Palo Alto, CA 94303, USA
'*
'*    This library is free software; you can redistribute it and/or
'*    modify it under the terms of the GNU Lesser General Public
'*    License version 2.1, as published by the Free Software Foundation.
'*
'*    This library is distributed in the hope that it will be useful,
'*    but WITHOUT ANY WARRANTY; without even the implied warranty of
'*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'*    Lesser General Public License for more details.
'*
'*    You should have received a copy of the GNU Lesser General Public
'*    License along with this library; if not, write to the Free Software
'*    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
'*    MA  02111-1307  USA
'*
'/************************************************************************
'*
'*  owner : joerg.skottke@sun.com
'*
'*  short description : Test Load/Save MS-Office settings page
'*
'*******************************************************************************
'**
' #1 tLoadSaveMSOffice ' Test Load/Save MS-Office settings page
'**
'\******************************************************************************

testcase tLoadSaveMSOffice

   Dim lbSave1 ( 9 ) as Boolean
   Dim lbSave2 ( 9 ) as Boolean
   Dim i as Integer
'///!!!!This routine works only with default settings (all checkboxes are checked, or all boxes are unchecked)
   printlog "If you get errors in this test, please check the settings."
   printlog "This test can only run without an error, when all checkboxes are checked or all are unchecked."
'///check if all settings are saved in configuration ( Load & Save / Microsoft Office )


'///open a new document
   hNewDocument
'///+open tools / options / load & save / Microsoft Office
   ToolsOptions
   hToolsOptions ( "LoadSave", "MicrosoftOffice" )

'///save old settings ( only the state of the first checkbox can be saved )
 printlog " - save old settings"
   Auswahl.TypeKeys "<PageUp>"
   for i=1 to 4
      lbSave1(i) = Auswahl.IsChecked (1)
      lbSave2(i) = Auswahl.IsChecked (2)
      Auswahl.TypeKeys "<Down>"
   next i

'///inverted first checkbox for all entries
 
   Auswahl.TypeKeys "<PageUp>"
   for i=1 to 4
   
      printlog( " - invert setting: " + i )
   
      if lbSave1(i) = TRUE then
         if lbSave2(i) = FALSE then Auswahl.TypeKeys ("<Space>")               ' 2. checkboxes must be checked
         if lbSave2(i) = TRUE  then Auswahl.TypeKeys ("<Space><Space><Space>") ' 2. checkboxes must be unchecked
      else
         if lbSave2(i) = FALSE then Auswahl.TypeKeys ("<Space>")               ' 2. checkboxes must be checked
         if lbSave2(i) = TRUE  then Auswahl.TypeKeys ("<Space><Space><Space>") ' 2. checkboxes must be unchecked
      end if
      
      Auswahl.TypeKeys ("<Down>")
      
   next i

'///+close options dialog with OK
   Kontext "ExtrasOptionenDlg"
   ExtrasOptionenDlg.OK
   Sleep (3)

'///+close document
   hCloseDocument

'///exit and restart StarOffice
 printlog " - exit/restart StarOffice"
   ExitRestartTheOffice

'///check inverting
 printlog " - check inverting"
'///+open tools / options / load & save / Microsoft Office
   ToolsOptions
   hToolsOptions ( "LoadSave", "MicrosoftOffice" )

   Auswahl.TypeKeys( "<PageUp>" )
   for i=1 to 4
      if Auswahl.IsChecked(1) = lbSave1(i) then warnlog "Entry " + i + ": state of 1. checkbox isn't saved"
      if Auswahl.IsChecked(2) = lbSave2(i) then warnlog "Entry " + i + ": state of 2. checkbox isn't saved"
      Auswahl.TypeKeys( "<Down>" )
   next i

'///reset changes
 printlog " - reset to saved settings"
   Auswahl.TypeKeys "<PageUp>"
   for i=1 to 4

      if lbSave1(i) = TRUE then
         if lbSave2(i) = FALSE then Auswahl.TypeKeys ("<Space><Space><Space>") ' 2. checkboxes must be unchecked
         if lbSave2(i) = TRUE  then Auswahl.TypeKeys ("<Space>")               ' 2. checkboxes must be checked
      else
         if lbSave2(i) = FALSE then Auswahl.TypeKeys ("<Space><Space><Space>") ' 2. checkboxes must be unchecked
         if lbSave2(i) = TRUE  then Auswahl.TypeKeys ("<Space>")               ' 2. checkboxes must be checked
      end if
      
      Auswahl.TypeKeys ("<Down>")
      
   next i


'///+close options dialog with OK
   Kontext "ExtrasOptionenDlg"
   ExtrasOptionenDlg.OK
   Sleep (3)

'///check the reset
 printlog " - check default settings"
'///+open tools / options / load & save / Microsoft Office
   ToolsOptions
   hToolsOptions ( "LoadSave", "MicrosoftOffice" )

   for i=1 to 4
      if Auswahl.IsChecked(1) <> lbSave1(i) then warnlog "Entry " + i + ": state of 1. checkbox isn't saved"
      if Auswahl.IsChecked(2) <> lbSave2(i) then warnlog "Entry " + i + ": state of 2. checkbox isn't saved"
      Auswahl.TypeKeys "<Down>"
   next i

'///+close options dialog with OK
   Kontext "ExtrasOptionenDlg"
   ExtrasOptionenDlg.OK
   
endcase
